/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.util;

import java.util.Collections;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckFrameAnalyzer<V extends Value>
extends Analyzer<V> {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int currentLocals;

    CheckFrameAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
        this.interpreter = interpreter;
    }

    @Override
    protected void init(String owner, MethodNode method) throws AnalyzerException {
        this.insnList = method.instructions;
        this.currentLocals = Type.getArgumentsAndReturnSizes(method.desc) >> 2;
        Frame<V>[] frames = this.getFrames();
        Frame currentFrame = frames[0];
        this.expandFrames(owner, method, currentFrame);
        for (int insnIndex = 0; insnIndex < this.insnList.size(); ++insnIndex) {
            Frame oldFrame = frames[insnIndex];
            AbstractInsnNode insnNode = null;
            try {
                insnNode = method.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.checkFrame(insnIndex + 1, oldFrame, false);
                } else {
                    LabelNode label;
                    int i2;
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        if (insnOpcode == 168) {
                            throw new AnalyzerException(insnNode, "JSR instructions are unsupported");
                        }
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(jumpInsn.label);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        if (insnOpcode == 167) {
                            this.endControlFlow(insnIndex);
                        } else {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        }
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(lookupSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        for (i2 = 0; i2 < lookupSwitchInsn.labels.size(); ++i2) {
                            label = lookupSwitchInsn.labels.get(i2);
                            targetInsnIndex = this.insnList.indexOf(label);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(tableSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, tableSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        for (i2 = 0; i2 < tableSwitchInsn.labels.size(); ++i2) {
                            label = tableSwitchInsn.labels.get(i2);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            targetInsnIndex = this.insnList.indexOf(label);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else {
                        if (insnOpcode == 169) {
                            throw new AnalyzerException(insnNode, "RET instructions are unsupported");
                        }
                        if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        } else {
                            this.endControlFlow(insnIndex);
                        }
                    }
                }
                List<TryCatchBlockNode> insnHandlers = this.getHandlers(insnIndex);
                if (insnHandlers != null) {
                    for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                        Type catchType = tryCatchBlock.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlock.type);
                        Frame<V> handler = this.newFrame(oldFrame);
                        handler.clearStack();
                        handler.push(this.interpreter.newExceptionValue(tryCatchBlock, handler, catchType));
                        this.checkFrame(this.insnList.indexOf(tryCatchBlock.handler), handler, true);
                    }
                }
                if (this.hasNextJvmInsnOrFrame(insnIndex)) continue;
                break;
            }
            catch (AnalyzerException e2) {
                throw new AnalyzerException(e2.node, "Error at instruction " + insnIndex + ": " + e2.getMessage(), e2);
            }
            catch (RuntimeException e3) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insnIndex + ": " + e3.getMessage(), e3);
            }
        }
    }

    private void expandFrames(String owner, MethodNode method, Frame<V> initialFrame) throws AnalyzerException {
        int lastJvmOrFrameInsnIndex = -1;
        Frame<V> currentFrame = initialFrame;
        int currentInsnIndex = 0;
        for (AbstractInsnNode insnNode : method.instructions) {
            if (insnNode instanceof FrameNode) {
                try {
                    currentFrame = this.expandFrame(owner, currentFrame, (FrameNode)insnNode);
                }
                catch (AnalyzerException e2) {
                    throw new AnalyzerException(e2.node, "Error at instruction " + currentInsnIndex + ": " + e2.getMessage(), e2);
                }
                for (int index2 = lastJvmOrFrameInsnIndex + 1; index2 <= currentInsnIndex; ++index2) {
                    this.getFrames()[index2] = currentFrame;
                }
            }
            if (CheckFrameAnalyzer.isJvmInsnNode(insnNode) || insnNode instanceof FrameNode) {
                lastJvmOrFrameInsnIndex = currentInsnIndex;
            }
            ++currentInsnIndex;
        }
    }

    private Frame<V> expandFrame(String owner, Frame<V> previousFrame, FrameNode frameNode) throws AnalyzerException {
        Frame<V> frame = this.newFrame(previousFrame);
        List<Object> locals = frameNode.local == null ? Collections.emptyList() : frameNode.local;
        int currentLocal = this.currentLocals;
        switch (frameNode.type) {
            case -1: 
            case 0: {
                currentLocal = 0;
            }
            case 1: {
                for (Object type : locals) {
                    V value = this.newFrameValue(owner, frameNode, type);
                    if (currentLocal + value.getSize() > frame.getLocals()) {
                        throw new AnalyzerException(frameNode, "Cannot append more locals than maxLocals");
                    }
                    frame.setLocal(currentLocal++, value);
                    if (value.getSize() != 2) continue;
                    frame.setLocal(currentLocal++, this.interpreter.newValue(null));
                }
                break;
            }
            case 2: {
                for (Object unusedType : locals) {
                    if (currentLocal <= 0) {
                        throw new AnalyzerException(frameNode, "Cannot chop more locals than defined");
                    }
                    if (currentLocal > 1 && frame.getLocal(currentLocal - 2).getSize() == 2) {
                        currentLocal -= 2;
                        continue;
                    }
                    --currentLocal;
                }
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new AnalyzerException(frameNode, "Illegal frame type " + frameNode.type);
            }
        }
        this.currentLocals = currentLocal;
        while (currentLocal < frame.getLocals()) {
            frame.setLocal(currentLocal++, this.interpreter.newValue(null));
        }
        List<Object> stack = frameNode.stack == null ? Collections.emptyList() : frameNode.stack;
        frame.clearStack();
        for (Object type : stack) {
            frame.push(this.newFrameValue(owner, frameNode, type));
        }
        return frame;
    }

    private V newFrameValue(String owner, FrameNode frameNode, Object type) throws AnalyzerException {
        if (type == Opcodes.TOP) {
            return this.interpreter.newValue(null);
        }
        if (type == Opcodes.INTEGER) {
            return this.interpreter.newValue(Type.INT_TYPE);
        }
        if (type == Opcodes.FLOAT) {
            return this.interpreter.newValue(Type.FLOAT_TYPE);
        }
        if (type == Opcodes.LONG) {
            return this.interpreter.newValue(Type.LONG_TYPE);
        }
        if (type == Opcodes.DOUBLE) {
            return this.interpreter.newValue(Type.DOUBLE_TYPE);
        }
        if (type == Opcodes.NULL) {
            return this.interpreter.newOperation(new InsnNode(1));
        }
        if (type == Opcodes.UNINITIALIZED_THIS) {
            return this.interpreter.newValue(Type.getObjectType(owner));
        }
        if (type instanceof String) {
            return this.interpreter.newValue(Type.getObjectType((String)type));
        }
        if (type instanceof LabelNode) {
            AbstractInsnNode referencedNode;
            for (referencedNode = (LabelNode)type; referencedNode != null && !CheckFrameAnalyzer.isJvmInsnNode(referencedNode); referencedNode = referencedNode.getNext()) {
            }
            if (referencedNode == null || referencedNode.getOpcode() != 187) {
                throw new AnalyzerException(frameNode, "LabelNode does not designate a NEW instruction");
            }
            return this.interpreter.newValue(Type.getObjectType(((TypeInsnNode)referencedNode).desc));
        }
        throw new AnalyzerException(frameNode, "Illegal stack map frame value " + type);
    }

    private void checkFrame(int insnIndex, Frame<V> frame, boolean requireFrame) throws AnalyzerException {
        Frame oldFrame = this.getFrames()[insnIndex];
        if (oldFrame == null) {
            if (requireFrame) {
                throw new AnalyzerException(null, "Expected stack map frame at instruction " + insnIndex);
            }
            this.getFrames()[insnIndex] = this.newFrame(frame);
        } else {
            String error = this.checkMerge(frame, oldFrame);
            if (error != null) {
                throw new AnalyzerException(null, "Stack map frame incompatible with frame at instruction " + insnIndex + " (" + error + ")");
            }
        }
    }

    private String checkMerge(Frame<V> srcFrame, Frame<V> dstFrame) {
        int numLocals = srcFrame.getLocals();
        if (numLocals != dstFrame.getLocals()) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < numLocals; ++i2) {
            V v2 = this.interpreter.merge(srcFrame.getLocal(i2), dstFrame.getLocal(i2));
            if (v2.equals(dstFrame.getLocal(i2))) continue;
            return "incompatible types at local " + i2 + ": " + srcFrame.getLocal(i2) + " and " + dstFrame.getLocal(i2);
        }
        int numStack = srcFrame.getStackSize();
        if (numStack != dstFrame.getStackSize()) {
            return "incompatible stack heights";
        }
        for (int i3 = 0; i3 < numStack; ++i3) {
            V v3 = this.interpreter.merge(srcFrame.getStack(i3), dstFrame.getStack(i3));
            if (v3.equals(dstFrame.getStack(i3))) continue;
            return "incompatible types at stack item " + i3 + ": " + srcFrame.getStack(i3) + " and " + dstFrame.getStack(i3);
        }
        return null;
    }

    private void endControlFlow(int insnIndex) throws AnalyzerException {
        if (this.hasNextJvmInsnOrFrame(insnIndex) && this.getFrames()[insnIndex + 1] == null) {
            throw new AnalyzerException(null, "Expected stack map frame at instruction " + (insnIndex + 1));
        }
    }

    private boolean hasNextJvmInsnOrFrame(int insnIndex) {
        for (AbstractInsnNode insn = this.insnList.get(insnIndex).getNext(); insn != null; insn = insn.getNext()) {
            if (!CheckFrameAnalyzer.isJvmInsnNode(insn) && !(insn instanceof FrameNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJvmInsnNode(AbstractInsnNode insnNode) {
        return insnNode.getOpcode() >= 0;
    }
}

