/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp.interceptor;

import com.android.ddmlib.JdwpHandshake;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import com.android.ddmlib.internal.jdwp.interceptor.Interceptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class HandshakeInterceptor
implements Interceptor {
    private boolean mIsHandshakeSent = false;
    private boolean mIsExpectingHandshakeResponse = false;
    private final ByteBuffer mHandShakeResponse = ByteBuffer.allocate(JdwpHandshake.HANDSHAKE_LEN);
    private Set<JdwpProxyClient> mPendingClients = new HashSet<JdwpProxyClient>();

    public HandshakeInterceptor() {
        JdwpHandshake.putHandshake(this.mHandShakeResponse);
    }

    @Override
    public boolean filterToDevice(JdwpProxyClient from, byte[] bufferToSend, int length) throws IOException, TimeoutException {
        ByteBuffer buffer = ByteBuffer.wrap(bufferToSend, 0, length);
        buffer.position(length);
        if (JdwpHandshake.findHandshake(buffer) != 1) {
            return false;
        }
        if (this.mIsHandshakeSent && !this.mIsExpectingHandshakeResponse) {
            from.setHandshakeComplete();
            from.write(this.mHandShakeResponse.array(), this.mHandShakeResponse.position());
            return true;
        }
        if (this.mIsHandshakeSent) {
            this.mPendingClients.add(from);
            return true;
        }
        this.mIsHandshakeSent = true;
        this.mIsExpectingHandshakeResponse = true;
        this.mPendingClients.add(from);
        return false;
    }

    @Override
    public boolean filterToClient(JdwpProxyClient to, byte[] bufferToSend, int length) {
        if (this.mPendingClients.isEmpty()) {
            return !to.isHandshakeComplete();
        }
        ByteBuffer buffer = ByteBuffer.wrap(bufferToSend, 0, length);
        buffer.position(length);
        if (this.mIsExpectingHandshakeResponse && JdwpHandshake.findHandshake(buffer) == 1) {
            this.mIsExpectingHandshakeResponse = false;
            boolean filter = !this.mPendingClients.remove(to);
            to.setHandshakeComplete();
            return filter;
        }
        return false;
    }
}

