/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class DesugarAtomicReference {
    private DesugarAtomicReference() {
    }

    public static <V> V getAndUpdate(AtomicReference<V> atomic, UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.apply(prev))) {
        }
        return prev;
    }

    public static <V> V updateAndGet(AtomicReference<V> atomic, UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.apply(prev))) {
        }
        return (V)next;
    }

    public static <V> V getAndAccumulate(AtomicReference<V> atomic, V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.apply(prev, x))) {
        }
        return prev;
    }

    public static <V> V accumulateAndGet(AtomicReference<V> atomic, V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.apply(prev, x))) {
        }
        return (V)next;
    }
}

