/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

final class FileChannelLinesSpliterator
implements Spliterator<String> {
    static final Set<String> SUPPORTED_CHARSET_NAMES = new HashSet<String>();
    private final FileChannel fc;
    private final Charset cs;
    private int index;
    private final int fence;
    private ByteBuffer buffer;
    private BufferedReader reader;

    FileChannelLinesSpliterator(FileChannel fc, Charset cs, int index, int fence) {
        this.fc = fc;
        this.cs = cs;
        this.index = index;
        this.fence = fence;
    }

    private FileChannelLinesSpliterator(FileChannel fc, Charset cs, int index, int fence, ByteBuffer buffer) {
        this.fc = fc;
        this.buffer = buffer;
        this.cs = cs;
        this.index = index;
        this.fence = fence;
    }

    @Override
    public boolean tryAdvance(Consumer<? super String> action) {
        String line = this.readLine();
        if (line != null) {
            action.accept(line);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super String> action) {
        String line;
        while ((line = this.readLine()) != null) {
            action.accept(line);
        }
    }

    private BufferedReader getBufferedReader() {
        ReadableByteChannel rrbc = new ReadableByteChannel(){

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int bytesRead;
                int bytesToRead = FileChannelLinesSpliterator.this.fence - FileChannelLinesSpliterator.this.index;
                if (bytesToRead == 0) {
                    return -1;
                }
                if (bytesToRead < dst.remaining()) {
                    int oldLimit = dst.limit();
                    dst.limit(dst.position() + bytesToRead);
                    bytesRead = FileChannelLinesSpliterator.this.fc.read(dst, FileChannelLinesSpliterator.this.index);
                    dst.limit(oldLimit);
                } else {
                    bytesRead = FileChannelLinesSpliterator.this.fc.read(dst, FileChannelLinesSpliterator.this.index);
                }
                if (bytesRead == -1) {
                    FileChannelLinesSpliterator.this.index = FileChannelLinesSpliterator.this.fence;
                    return bytesRead;
                }
                FileChannelLinesSpliterator.this.index += bytesRead;
                return bytesRead;
            }

            @Override
            public boolean isOpen() {
                return FileChannelLinesSpliterator.this.fc.isOpen();
            }

            @Override
            public void close() throws IOException {
                FileChannelLinesSpliterator.this.fc.close();
            }
        };
        return new BufferedReader(Channels.newReader(rrbc, this.cs.newDecoder(), -1));
    }

    private String readLine() {
        if (this.reader == null) {
            this.reader = this.getBufferedReader();
            this.buffer = null;
        }
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ByteBuffer getMappedByteBuffer() {
        try {
            return this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fence);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Spliterator<String> trySplit() {
        FileChannelLinesSpliterator fileChannelLinesSpliterator;
        int hi;
        int lo;
        int mid;
        ByteBuffer b;
        block7: {
            byte c;
            block8: {
                block6: {
                    if (this.reader != null) {
                        return null;
                    }
                    b = this.buffer;
                    if (b == null) {
                        b = this.buffer = this.getMappedByteBuffer();
                    }
                    if ((c = b.get(mid = (lo = this.index) + (hi = this.fence) >>> 1)) != 10) break block6;
                    ++mid;
                    break block7;
                }
                if (c != 13) break block8;
                if (++mid >= hi || b.get(mid) != 10) break block7;
                ++mid;
                break block7;
            }
            int midL = mid - 1;
            int midR = mid + 1;
            mid = 0;
            while (midL > lo && midR < hi) {
                if ((c = b.get(midL--)) == 10 || c == 13) {
                    mid = midL + 2;
                    break;
                }
                if ((c = b.get(midR++)) != 10 && c != 13) continue;
                mid = midR;
                if (c != 13 || mid >= hi || b.get(mid) != 10) break;
                ++mid;
                break;
            }
        }
        if (mid > lo && mid < hi) {
            this.index = mid;
            FileChannelLinesSpliterator fileChannelLinesSpliterator2 = new FileChannelLinesSpliterator(this.fc, this.cs, lo, this.index, b);
            fileChannelLinesSpliterator = fileChannelLinesSpliterator2;
        } else {
            fileChannelLinesSpliterator = null;
        }
        return fileChannelLinesSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public long getExactSizeIfKnown() {
        return -1L;
    }

    @Override
    public int characteristics() {
        return 272;
    }

    static {
        SUPPORTED_CHARSET_NAMES.add("UTF-8");
        SUPPORTED_CHARSET_NAMES.add("ISO-8859-1");
        SUPPORTED_CHARSET_NAMES.add("US-ASCII");
    }
}

