/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import sun.misc.DesugarUnsafe;
import sun.nio.ch.IOUtil;

class EPoll {
    private static final DesugarUnsafe unsafe = DesugarUnsafe.getUnsafe();
    private static final int SIZEOF_EPOLLEVENT = EPoll.eventSize();
    private static final int OFFSETOF_EVENTS = EPoll.eventsOffset();
    private static final int OFFSETOF_FD = EPoll.dataOffset();
    static final int EPOLL_CTL_ADD = 1;
    static final int EPOLL_CTL_DEL = 2;
    static final int EPOLL_CTL_MOD = 3;
    static final int EPOLLIN = 1;
    static final int EPOLLOUT = 4;
    static final int EPOLLONESHOT = 0x40000000;

    private EPoll() {
    }

    static long allocatePollArray(int count) {
        return unsafe.allocateMemory(count * SIZEOF_EPOLLEVENT);
    }

    static void freePollArray(long address) {
        unsafe.freeMemory(address);
    }

    static long getEvent(long address, int i) {
        return address + (long)(SIZEOF_EPOLLEVENT * i);
    }

    static int getDescriptor(long eventAddress) {
        return unsafe.getInt(eventAddress + (long)OFFSETOF_FD);
    }

    static int getEvents(long eventAddress) {
        return unsafe.getInt(eventAddress + (long)OFFSETOF_EVENTS);
    }

    private static native int eventSize();

    private static native int eventsOffset();

    private static native int dataOffset();

    static native int create() throws IOException;

    static native int ctl(int var0, int var1, int var2, int var3);

    static native int wait(int var0, long var1, int var3, int var4) throws IOException;

    static {
        IOUtil.load();
    }
}

