/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

class SourceChannelImpl
extends Pipe.SourceChannel
implements SelChImpl {
    private static final NativeDispatcher nd = new FileDispatcherImpl();
    private final FileDescriptor fd;
    private final int fdVal;
    private final ReentrantLock readLock = new ReentrantLock();
    private final Object stateLock = new Object();
    private static final int ST_INUSE = 0;
    private static final int ST_CLOSING = 1;
    private static final int ST_KILLPENDING = 2;
    private static final int ST_KILLED = 3;
    private int state;
    private long thread;

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    SourceChannelImpl(SelectorProvider sp, FileDescriptor fd) {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        boolean blocking;
        assert (!this.isOpen());
        boolean interrupted = false;
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state < 1);
            this.state = 1;
            blocking = this.isBlocking();
        }
        if (blocking) {
            object = this.stateLock;
            synchronized (object) {
                assert (this.state == 1);
                long th = this.thread;
                if (th != 0L) {
                    nd.preClose(this.fd);
                    NativeThread.signal(th);
                    while (this.thread != 0L) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
        } else {
            this.readLock.lock();
            this.readLock.unlock();
        }
        object = this.stateLock;
        synchronized (object) {
            assert (this.state == 1);
            this.state = 2;
        }
        if (!this.isRegistered()) {
            this.kill();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.thread == 0L);
            if (this.state == 2) {
                this.state = 3;
                nd.close(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.readLock.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                IOUtil.configureBlocking(this.fd, block);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl ski) {
        int intOps = ski.nioInterestOps();
        int oldOps = ski.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            ski.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0) {
            newOps |= 1;
        }
        ski.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, ski.nioReadyOps(), ski);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, 0, ski);
    }

    @Override
    public int translateInterestOps(int ops) {
        int newOps = 0;
        if (ops == 1) {
            newOps |= Net.POLLIN;
        }
        return newOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRead(boolean blocking) throws ClosedChannelException {
        if (blocking) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (blocking) {
                this.thread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object = this.stateLock;
            synchronized (object) {
                this.thread = 0L;
                if (this.state == 1) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Objects.requireNonNull(dst);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginRead(blocking);
                while ((n = IOUtil.read(this.fd, dst, -1L, nd)) == -3 && this.isOpen()) {
                }
                this.endRead(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dsts.length);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginRead(blocking);
                while ((n = IOUtil.read(this.fd, dsts, offset, length, nd)) == -3L && this.isOpen()) {
                }
                this.endRead(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }
}

