/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.util.concurrent.ExecutionException;
import sun.misc.DesugarUnsafe;

abstract class Cancellable
implements Runnable {
    private static final DesugarUnsafe unsafe = DesugarUnsafe.getUnsafe();
    private final long pollingAddress;
    private final Object lock = new Object();
    private boolean completed;
    private Throwable exception;

    protected Cancellable() {
        this.pollingAddress = unsafe.allocateMemory(4L);
        unsafe.putIntVolatile(null, this.pollingAddress, 0);
    }

    protected long addressToPollForCancel() {
        return this.pollingAddress;
    }

    protected int cancelValue() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                unsafe.putIntVolatile(null, this.pollingAddress, this.cancelValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable exception() {
        Object object = this.lock;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.implRun();
        }
        catch (Throwable t) {
            Object object = this.lock;
            synchronized (object) {
                this.exception = t;
            }
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.completed = true;
                unsafe.freeMemory(this.pollingAddress);
            }
        }
    }

    abstract void implRun() throws Throwable;

    static void runInterruptibly(Cancellable task) throws ExecutionException {
        Throwable exc;
        Thread t = new Thread(null, task, "NIO-Task", 0L, false);
        t.start();
        boolean cancelledByInterrupt = false;
        while (t.isAlive()) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                cancelledByInterrupt = true;
                task.cancel();
            }
        }
        if (cancelledByInterrupt) {
            Thread.currentThread().interrupt();
        }
        if ((exc = task.exception()) != null) {
            throw new ExecutionException(exc);
        }
    }
}

