/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.DesugarFile;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixUriUtils {
    private static final long L_DIGIT = UnixUriUtils.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = UnixUriUtils.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = UnixUriUtils.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_MARK = UnixUriUtils.lowMask("-_.!~*'()");
    private static final long H_MARK = UnixUriUtils.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_PCHAR = L_UNRESERVED | UnixUriUtils.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | UnixUriUtils.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | UnixUriUtils.lowMask(";/");
    private static final long H_PATH = H_PCHAR | UnixUriUtils.highMask(";/");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UnixUriUtils() {
    }

    static Path fromUri(UnixFileSystem fs, URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        if (!uri.toString().startsWith("file:///")) {
            return DesugarFile.toPath(new File(uri));
        }
        String p = uri.getRawPath();
        int len = p.length();
        if (len == 0) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        if (p.endsWith("/") && len > 1) {
            --len;
        }
        byte[] result = new byte[len];
        int rlen = 0;
        int pos = 0;
        while (pos < len) {
            byte b;
            char c;
            if ((c = p.charAt(pos++)) == '%') {
                assert (pos + 2 <= len);
                char c1 = p.charAt(pos++);
                char c2 = p.charAt(pos++);
                b = (byte)(UnixUriUtils.decode(c1) << 4 | UnixUriUtils.decode(c2));
                if (b == 0) {
                    throw new IllegalArgumentException("Nul character not allowed");
                }
            } else {
                if (c == '\u0000' || c >= '\u0080') {
                    throw new IllegalArgumentException("Bad escape");
                }
                b = (byte)c;
            }
            result[rlen++] = b;
        }
        if (rlen != result.length) {
            result = Arrays.copyOf(result, rlen);
        }
        return new UnixPath(fs, result);
    }

    static URI toUri(UnixPath up) {
        byte[] path = up.toAbsolutePath().asByteArray();
        StringBuilder sb = new StringBuilder("file:///");
        assert (path[0] == 47);
        for (int i = 1; i < path.length; ++i) {
            char c = (char)(path[i] & 0xFF);
            if (UnixUriUtils.match(c, L_PATH, H_PATH)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            sb.append(hexDigits[c >> 4 & 0xF]);
            sb.append(hexDigits[c & 0xF]);
        }
        if (sb.charAt(sb.length() - 1) != '/') {
            try {
                up.checkRead();
                int mode = UnixNativeDispatcher.stat(up);
                if ((mode & 0xF000) == 16384) {
                    sb.append('/');
                }
            }
            catch (SecurityException mode) {
                // empty catch block
            }
        }
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new AssertionError();
    }
}

