/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

public class DesugarFileChannel {
    public static FileChannel openEmulatedFileChannel(Path path, Set<? extends OpenOption> openOptions, FileAttribute<?> ... attrs) throws IOException {
        DesugarFileChannel.validateOpenOptions(path, openOptions);
        RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), DesugarFileChannel.getFileAccessModeText(openOptions));
        if (openOptions.contains(StandardOpenOption.TRUNCATE_EXISTING) && openOptions.contains(StandardOpenOption.WRITE)) {
            randomAccessFile.setLength(0L);
        }
        if (!openOptions.contains(StandardOpenOption.APPEND) && !openOptions.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
            return randomAccessFile.getChannel();
        }
        return WrappedFileChannel.withExtraOptions(randomAccessFile.getChannel(), openOptions, path);
    }

    private static void validateOpenOptions(Path path, Set<? extends OpenOption> openOptions) throws IOException {
        for (OpenOption openOption : openOptions) {
            if (openOption != null) continue;
            throw new NullPointerException();
        }
        if (path.toFile().exists()) {
            if (openOptions.contains(StandardOpenOption.CREATE_NEW) && openOptions.contains(StandardOpenOption.WRITE)) {
                throw new FileAlreadyExistsException(path.toString());
            }
        } else if (!openOptions.contains(StandardOpenOption.CREATE) && !openOptions.contains(StandardOpenOption.CREATE_NEW)) {
            throw new NoSuchFileException(path.toString());
        }
        if (openOptions.contains(StandardOpenOption.READ) && openOptions.contains(StandardOpenOption.APPEND)) {
            throw new IllegalArgumentException("READ + APPEND not allowed");
        }
        if (openOptions.contains(StandardOpenOption.APPEND) && openOptions.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
    }

    private static String getFileAccessModeText(Set<? extends OpenOption> options) {
        if (!options.contains(StandardOpenOption.WRITE) && !options.contains(StandardOpenOption.APPEND)) {
            return "r";
        }
        if (options.contains(StandardOpenOption.SYNC)) {
            return "rws";
        }
        if (options.contains(StandardOpenOption.DSYNC)) {
            return "rwd";
        }
        return "rw";
    }

    public static FileChannel wrap(FileChannel raw) {
        return WrappedFileChannel.wrap(raw);
    }

    static class WrappedFileChannelFileLock
    extends FileLock {
        private final FileLock delegate;

        WrappedFileChannelFileLock(FileLock delegate, WrappedFileChannel wrappedFileChannel) {
            super(wrappedFileChannel, delegate.position(), delegate.size(), delegate.isShared());
            this.delegate = delegate;
        }

        @Override
        public boolean isValid() {
            return this.delegate.isValid();
        }

        @Override
        public void release() throws IOException {
            this.delegate.release();
        }
    }

    static class WrappedFileChannel
    extends FileChannel
    implements SeekableByteChannel {
        final FileChannel delegate;
        final boolean deleteOnClose;
        final boolean appendMode;
        final Path path;

        public static FileChannel wrap(FileChannel channel) {
            if (channel instanceof WrappedFileChannel) {
                return channel;
            }
            return new WrappedFileChannel(channel, false, false, null);
        }

        public static FileChannel withExtraOptions(FileChannel channel, Set<? extends OpenOption> options, Path path) {
            FileChannel raw = channel instanceof WrappedFileChannel ? ((WrappedFileChannel)channel).delegate : channel;
            return new WrappedFileChannel(raw, options.contains(StandardOpenOption.DELETE_ON_CLOSE), options.contains(StandardOpenOption.APPEND), path);
        }

        private WrappedFileChannel(FileChannel delegate, boolean deleteOnClose, boolean appendMode, Path path) {
            this.delegate = delegate;
            this.deleteOnClose = deleteOnClose;
            this.appendMode = appendMode;
            this.path = deleteOnClose ? path : null;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (this.appendMode) {
                return this.delegate.write(src, this.size());
            }
            return this.delegate.write(src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            return WrappedFileChannel.wrap(this.delegate.position(newPosition));
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            return WrappedFileChannel.wrap(this.delegate.truncate(size));
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.delegate.force(metaData);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return this.delegate.transferTo(position, count, target);
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            return this.delegate.transferFrom(src, position, count);
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.wrapLock(this.delegate.lock(position, size, shared));
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.wrapLock(this.delegate.tryLock(position, size, shared));
        }

        private FileLock wrapLock(FileLock lock) {
            if (lock == null) {
                return null;
            }
            return new WrappedFileChannelFileLock(lock, this);
        }

        @Override
        public void implCloseChannel() throws IOException {
            this.delegate.close();
            if (this.deleteOnClose) {
                this.path.toFile().delete();
            }
        }
    }
}

