/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.DateTimeException;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.util.Objects;

public final class DesugarIsoChronology {
    private static final long DAYS_0000_TO_1970 = 719528L;

    public static long epochSecond(IsoChronology receiver, int prolepticYear, int month, int dayOfMonth, int hour, int minute, int second, ZoneOffset zoneOffset) {
        int dom;
        ChronoField.YEAR.checkValidValue(prolepticYear);
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        Objects.requireNonNull(zoneOffset, "zoneOffset");
        if (dayOfMonth > 28 && dayOfMonth > (dom = DesugarIsoChronology.numberOfDaysOfMonth(prolepticYear, month))) {
            if (dayOfMonth == 29) {
                throw new DateTimeException("Invalid date 'February 29' as '" + prolepticYear + "' is not a leap year");
            }
            throw new DateTimeException("Invalid date '" + Month.of(month).name() + " " + dayOfMonth + "'");
        }
        long totalDays = 0L;
        int timeinSec = 0;
        totalDays += 365L * (long)prolepticYear;
        totalDays = prolepticYear >= 0 ? (totalDays += ((long)prolepticYear + 3L) / 4L - ((long)prolepticYear + 99L) / 100L + ((long)prolepticYear + 399L) / 400L) : (totalDays -= (long)(prolepticYear / -4 - prolepticYear / -100 + prolepticYear / -400));
        totalDays += (long)((367 * month - 362) / 12);
        totalDays += (long)(dayOfMonth - 1);
        if (month > 2) {
            --totalDays;
            if (!IsoChronology.INSTANCE.isLeapYear(prolepticYear)) {
                --totalDays;
            }
        }
        timeinSec = (hour * 60 + minute) * 60 + second;
        return Math.addExact(Math.multiplyExact(totalDays -= 719528L, 86400L), (long)(timeinSec - zoneOffset.getTotalSeconds()));
    }

    private static int numberOfDaysOfMonth(int year, int month) {
        int dom;
        switch (month) {
            case 2: {
                dom = IsoChronology.INSTANCE.isLeapYear(year) ? 29 : 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                dom = 30;
                break;
            }
            default: {
                dom = 31;
            }
        }
        return dom;
    }
}

