/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DesugarDateTimeTextProviderHelper {
    public static void fillWithStandaloneStyleMap(Map<TextStyle, Map<Long, String>> styleMapMap, DateFormatSymbols dateFormatSymbols, Locale loc) {
        int numMonth = dateFormatSymbols.getMonths().length;
        LinkedHashMap<Long, String> longStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> narrowStandAloneMap = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> shortStandAloneMap = new LinkedHashMap<Long, String>();
        String longMonth = "LLLL";
        String shortMonth = "LLL";
        for (int i = 1; i < numMonth; ++i) {
            String longName = DesugarDateTimeTextProviderHelper.computeStandaloneMonthName(i, longMonth, loc);
            longStandAloneMap.put(Long.valueOf(i), longName);
            narrowStandAloneMap.put(Long.valueOf(i), DesugarDateTimeTextProviderHelper.firstCodePoint(longName));
            String shortName = DesugarDateTimeTextProviderHelper.computeStandaloneMonthName(i, shortMonth, loc);
            shortStandAloneMap.put(Long.valueOf(i), shortName);
        }
        if (numMonth > 0) {
            longStandAloneMap.put(Long.valueOf(numMonth), "");
            narrowStandAloneMap.put(Long.valueOf(numMonth), "");
            shortStandAloneMap.put(Long.valueOf(numMonth), "");
            styleMapMap.put(TextStyle.FULL_STANDALONE, longStandAloneMap);
            styleMapMap.put(TextStyle.NARROW_STANDALONE, narrowStandAloneMap);
            styleMapMap.put(TextStyle.SHORT_STANDALONE, shortStandAloneMap);
        }
    }

    private static String computeStandaloneMonthName(int id, String standalonePattern, Locale loc) {
        TimeZone legacyUtc = TimeZone.getTimeZone("UTC");
        SimpleDateFormat writer = new SimpleDateFormat(standalonePattern, loc);
        writer.setTimeZone(legacyUtc);
        Calendar calendar = Calendar.getInstance();
        calendar.set(0, id, 0);
        Date legacy = calendar.getTime();
        return writer.format(legacy);
    }

    private static String firstCodePoint(String string) {
        return string.substring(0, Character.charCount(string.codePointAt(0)));
    }

    private DesugarDateTimeTextProviderHelper() {
    }
}

