/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.DesugarCollections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Collection<E>
extends Iterable<E> {
    public int size();

    public boolean isEmpty();

    public boolean contains(Object var1);

    @Override
    public Iterator<E> iterator();

    public Object[] toArray();

    public <T> T[] toArray(T[] var1);

    default public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.toArray(generator.apply(0));
    }

    public boolean add(E var1);

    public boolean remove(Object var1);

    public boolean containsAll(Collection<?> var1);

    public boolean addAll(Collection<? extends E> var1);

    public boolean removeAll(Collection<?> var1);

    default public boolean removeIf(Predicate<? super E> filter) {
        if (DesugarCollections.SYNCHRONIZED_COLLECTION.isInstance(this)) {
            return DesugarCollections.removeIf(this, filter);
        }
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<E> each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection<?> var1);

    public void clear();

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    default public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        for (E t : this) {
            action.accept(t);
        }
    }

    @Override
    default public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 0);
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }
}

