/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;

public class ForkJoinPool
extends AbstractExecutorService {
    static final int SWIDTH = 16;
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int SQMASK = 126;
    static final int UNSIGNALLED = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int QLOCK = 1;
    static final int OWNED = 1;
    static final int FIFO = 65536;
    static final int SHUTDOWN = 262144;
    static final int TERMINATED = 524288;
    static final int STOP = Integer.MIN_VALUE;
    static final int QUIET = 0x40000000;
    static final int DORMANT = -1073741824;
    static final int INITIAL_QUEUE_CAPACITY = 8192;
    static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
    static final int TOP_BOUND_SHIFT = 10;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int COMMON_PARALLELISM;
    private static final int COMMON_MAX_SPARES;
    private static int poolNumberSequence;
    private static final long DEFAULT_KEEPALIVE = 60000L;
    private static final long TIMEOUT_SLOP = 20L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int RC_SHIFT = 48;
    private static final long RC_UNIT = 0x1000000000000L;
    private static final long RC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    volatile long stealCount;
    final long keepAlive;
    int indexSeed;
    final int bounds;
    volatile int mode;
    WorkQueue[] workQueues;
    final String workerNamePrefix;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final Predicate<? super ForkJoinPool> saturate;
    volatile long ctl;
    private static final VarHandle CTL;
    private static final VarHandle MODE;
    static final VarHandle QA;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    static AccessControlContext contextWithPermissions(Permission ... perms) {
        Permissions permissions = new Permissions();
        for (Permission perm : perms) {
            permissions.add(perm);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    private void tryAddWorker(long c) {
        do {
            long nc = 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L;
            if (this.ctl != c || !CTL.compareAndSet(this, c, nc)) continue;
            this.createWorker();
            break;
        } while (((c = this.ctl) & 0x800000000000L) != 0L && (int)c == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread wt) {
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        int tid = 0;
        int idbits = this.mode & 0x10000;
        String prefix = this.workerNamePrefix;
        WorkQueue w = new WorkQueue(this, wt);
        if (prefix != null) {
            String string = prefix;
            synchronized (string) {
                int n;
                WorkQueue[] ws = this.workQueues;
                int s = this.indexSeed += -1640531527;
                idbits |= s & 0x3FFE0000;
                if (ws != null && (n = ws.length) > 1) {
                    WorkQueue q;
                    int m = n - 1;
                    tid = m & (s << 1 | 1);
                    int probes = n >>> 1;
                    while ((q = ws[tid]) != null && q.phase != 0x40000000) {
                        if (--probes == 0) {
                            tid = n | 1;
                            break;
                        }
                        tid = tid + 2 & m;
                    }
                    w.phase = w.id = tid | idbits;
                    if (tid < n) {
                        ws[tid] = w;
                    } else {
                        int an = n << 1;
                        WorkQueue[] as = new WorkQueue[an];
                        as[tid] = w;
                        int am = an - 1;
                        for (int j = 0; j < n; ++j) {
                            WorkQueue v = ws[j];
                            if (v != null) {
                                as[v.id & am & 0x7E] = v;
                            }
                            if (++j >= n) break;
                            as[j] = ws[j];
                        }
                        this.workQueues = as;
                    }
                }
            }
            wt.setName(prefix.concat(Integer.toString(tid)));
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        WorkQueue w = null;
        int phase = 0;
        if (wt != null && (w = wt.workQueue) != null) {
            String lock = this.workerNamePrefix;
            int wid = w.id;
            long ns = (long)w.nsteals & 0xFFFFFFFFL;
            if (lock != null) {
                String string = lock;
                synchronized (string) {
                    int i;
                    int n;
                    WorkQueue[] ws = this.workQueues;
                    if (this.workQueues != null && (n = ws.length) > 0 && ws[i = wid & n - 1] == w) {
                        ws[i] = null;
                    }
                    this.stealCount += ns;
                }
            }
            phase = w.phase;
        }
        if (phase != 0x40000000) {
            long c;
            while (!CTL.weakCompareAndSet(this, c = this.ctl, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c)) {
            }
        }
        if (w != null) {
            w.cancelAll();
        }
        if (!this.tryTerminate(false, false) && w != null && w.array != null) {
            this.signalWork();
        }
        if (ex == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(ex);
        }
    }

    final void signalWork() {
        long c;
        while ((c = this.ctl) < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                this.tryAddWorker(c);
                break;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || ws.length <= (i = sp & 0xFFFF) || (v = ws[i]) == null) break;
            int np = sp & Integer.MAX_VALUE;
            int vp = v.phase;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            ForkJoinWorkerThread vt = v.owner;
            if (sp != vp || !CTL.compareAndSet(this, c, nc)) continue;
            v.phase = np;
            if (vt == null || v.source >= 0) break;
            LockSupport.unpark(vt);
            break;
        }
    }

    private int tryCompensate(WorkQueue w) {
        long nc;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        short t = (short)(c >>> 32);
        if (t >= 0) {
            int n;
            if (ws == null || (n = ws.length) <= 0 || w == null) {
                return 0;
            }
            int sp = (int)c;
            if (sp != 0) {
                WorkQueue v = ws[sp & n - 1];
                int wp = w.phase;
                long uc = 0xFFFFFFFF00000000L & (wp < 0 ? c + 0x1000000000000L : c);
                int np = sp & Integer.MAX_VALUE;
                if (v != null) {
                    int vp = v.phase;
                    ForkJoinWorkerThread vt = v.owner;
                    long nc2 = (long)v.stackPred & 0xFFFFFFFFL | uc;
                    if (vp == sp && CTL.compareAndSet(this, c, nc2)) {
                        v.phase = np;
                        if (vt != null && v.source < 0) {
                            LockSupport.unpark(vt);
                        }
                        return wp < 0 ? -1 : 1;
                    }
                }
                return 0;
            }
            if ((int)(c >> 48) - (short)(this.bounds & 0xFFFF) > 0) {
                long nc3 = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                return CTL.compareAndSet(this, c, nc3) ? 1 : 0;
            }
            int md = this.mode;
            int pc = md & 0xFFFF;
            int tc = pc + t;
            int bc = 0;
            boolean unstable = false;
            for (int i = 1; i < n; i += 2) {
                Thread.State ts;
                WorkQueue q = ws[i];
                if (q == null) continue;
                if (q.source == 0) {
                    unstable = true;
                    break;
                }
                --tc;
                ForkJoinWorkerThread wt = q.owner;
                if (wt == null || (ts = wt.getState()) != Thread.State.BLOCKED && ts != Thread.State.WAITING) continue;
                ++bc;
            }
            if (unstable || tc != 0 || this.ctl != c) {
                return 0;
            }
            if (t + pc >= Short.MAX_VALUE || t >= this.bounds >>> 16) {
                Predicate<? super ForkJoinPool> sat = this.saturate;
                if (sat != null && sat.test(this)) {
                    return -1;
                }
                if (bc < pc) {
                    Thread.yield();
                    return 0;
                }
                throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
            }
        }
        return CTL.compareAndSet(this, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL) && this.createWorker() ? 1 : 0;
    }

    final void runWorker(WorkQueue w) {
        int r = w.id ^ ThreadLocalRandom.nextSecondarySeed() | 0x10000;
        w.array = new ForkJoinTask[8192];
        while (true) {
            if (this.scan(w, r)) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                continue;
            }
            int phase = w.phase;
            if (phase >= 0) {
                long nc;
                long c;
                w.phase = phase + 65536 | Integer.MIN_VALUE;
                long np = (long)w.phase & 0xFFFFFFFFL;
                do {
                    c = this.ctl;
                    w.stackPred = (int)c;
                } while (!CTL.weakCompareAndSet(this, c, nc = c - 0x1000000000000L & 0xFFFFFFFF00000000L | np));
                continue;
            }
            int pred = w.stackPred;
            Thread.interrupted();
            w.source = -1073741824;
            long c = this.ctl;
            int md = this.mode;
            int rc = (md & 0xFFFF) + (int)(c >> 48);
            if (md < 0 || rc <= 0 && (md & 0x40000) != 0 && this.tryTerminate(false, false)) break;
            if (rc <= 0 && pred != 0 && phase == (int)c) {
                long nc = 0xFFFFFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & (long)pred;
                long d = this.keepAlive + System.currentTimeMillis();
                LockSupport.parkUntil(this, d);
                if (this.ctl == c && d - System.currentTimeMillis() <= 20L && CTL.compareAndSet(this, c, nc)) {
                    w.phase = 0x40000000;
                    break;
                }
            } else if (w.phase < 0) {
                LockSupport.park(this);
            }
            w.source = 0;
        }
    }

    private boolean scan(WorkQueue w, int r) {
        int n;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (n = ws.length) > 0 && w != null) {
            int m = n - 1;
            int j = r & m;
            while (true) {
                int b;
                WorkQueue q;
                if ((q = ws[j]) != null && q.top != (b = q.base)) {
                    int cap;
                    int qid = q.id;
                    ForkJoinTask[] a = q.array;
                    if (q.array != null && (cap = a.length) > 0) {
                        int k = cap - 1 & b;
                        ForkJoinTask t = QA.getAcquire(a, k);
                        if (q.base == b++ && t != null && QA.compareAndSet(a, k, t, null)) {
                            q.base = b;
                            w.source = qid;
                            if (q.top - b > 0) {
                                this.signalWork();
                            }
                            w.topLevelExec(t, q, r & (n << 10) - 1);
                        }
                    }
                    return true;
                }
                if (--n <= 0) break;
                j = j + 1 & m;
            }
        }
        return false;
    }

    final int awaitJoin(WorkQueue w, ForkJoinTask<?> task, long deadline) {
        int s = 0;
        int seed = ThreadLocalRandom.nextSecondarySeed();
        if (!(w == null || task == null || task instanceof CountedCompleter && (s = w.helpCC((CountedCompleter)task, 0, false)) < 0)) {
            w.tryRemoveAndExec(task);
            int src = w.source;
            int id = w.id;
            int r = seed >>> 16 | 1;
            int step = seed & 0xFFFFFFFE | 2;
            s = task.status;
            while (s >= 0) {
                long ms;
                int n;
                WorkQueue[] ws = this.workQueues;
                int m = n - 1;
                for (n = this.workQueues == null ? 0 : ws.length; n > 0; --n) {
                    int b;
                    WorkQueue q = ws[r & m];
                    if (q != null && q.source == id && q.top != (b = q.base)) {
                        int cap;
                        int qid = q.id;
                        ForkJoinTask[] a = q.array;
                        if (q.array == null || (cap = a.length) <= 0) break;
                        int k = cap - 1 & b;
                        ForkJoinTask t = QA.getAcquire(a, k);
                        if (q.source != id || q.base != b++ || t == null || !QA.compareAndSet(a, k, t, null)) break;
                        q.base = b;
                        w.source = qid;
                        t.doExec();
                        w.source = src;
                        break;
                    }
                    r += step;
                }
                if ((s = task.status) < 0) break;
                if (n != 0) continue;
                if (deadline == 0L) {
                    ms = 0L;
                } else {
                    long ns = deadline - System.nanoTime();
                    if (ns <= 0L) break;
                    ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms <= 0L) {
                        ms = 1L;
                    }
                }
                int block = this.tryCompensate(w);
                if (block != 0) {
                    task.internalWait(ms);
                    CTL.getAndAdd(this, block > 0 ? 0x1000000000000L : 0L);
                }
                s = task.status;
            }
        }
        return s;
    }

    final void helpQuiescePool(WorkQueue w) {
        int prevSrc = w.source;
        int seed = ThreadLocalRandom.nextSecondarySeed();
        int r = seed >>> 16;
        int step = r | 1;
        int source = prevSrc;
        int released = -1;
        while (true) {
            int n;
            ForkJoinTask<?> localTask;
            if ((localTask = w.nextLocalTask()) != null) {
                localTask.doExec();
                continue;
            }
            if (w.phase >= 0 && released == -1) {
                released = 1;
            }
            boolean quiet = true;
            boolean empty = true;
            WorkQueue[] ws = this.workQueues;
            int m = n - 1;
            for (n = this.workQueues == null ? 0 : ws.length; n > 0; --n) {
                WorkQueue q = ws[r & m];
                if (q != null) {
                    int qs = q.source;
                    int b = q.base;
                    if (q.top != b) {
                        int cap;
                        empty = false;
                        quiet = false;
                        int qid = q.id;
                        ForkJoinTask[] a = q.array;
                        if (q.array == null || (cap = a.length) <= 0) break;
                        if (released == 0) {
                            released = 1;
                            CTL.getAndAdd(this, 0x1000000000000L);
                        }
                        int k = cap - 1 & b;
                        ForkJoinTask t = QA.getAcquire(a, k);
                        if (q.base != b++ || t == null || !QA.compareAndSet(a, k, t, null)) break;
                        q.base = b;
                        w.source = qid;
                        t.doExec();
                        w.source = source = prevSrc;
                        break;
                    }
                    if ((qs & 0x40000000) == 0) {
                        quiet = false;
                    }
                }
                r += step;
            }
            if (quiet) {
                if (released == 0) {
                    CTL.getAndAdd(this, 0x1000000000000L);
                }
                break;
            }
            if (!empty) continue;
            if (source != 0x40000000) {
                source = 0x40000000;
                w.source = 0x40000000;
            }
            if (released != 1) continue;
            released = 0;
            CTL.getAndAdd(this, -281474976710656L);
        }
        w.source = prevSrc;
    }

    private ForkJoinTask<?> pollScan(boolean submissionsOnly) {
        if ((this.mode & Integer.MIN_VALUE) == 0) {
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && (n = ws.length) > 0) {
                int step;
                int origin;
                int m = n - 1;
                int r = ThreadLocalRandom.nextSecondarySeed();
                int h = r >>> 16;
                if (submissionsOnly) {
                    origin = r & 0xFFFFFFFE & m;
                    step = h & 0xFFFFFFFE | 2;
                } else {
                    origin = r & m;
                    step = h | 1;
                }
                boolean nonempty = false;
                int i = origin;
                int oldSum = 0;
                int checkSum = 0;
                while (true) {
                    WorkQueue q;
                    if ((q = ws[i]) != null) {
                        int b = q.base;
                        if (q.top - b > 0) {
                            nonempty = true;
                            ForkJoinTask<?> t = q.poll();
                            if (t != null) {
                                return t;
                            }
                        } else {
                            checkSum += b + q.id;
                        }
                    }
                    if ((i = i + step & m) != origin) continue;
                    if (!nonempty && oldSum == (oldSum = checkSum)) break;
                    checkSum = 0;
                    nonempty = false;
                }
            }
        }
        return null;
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        ForkJoinTask<?> t;
        if (w == null || (t = w.nextLocalTask()) == null) {
            t = this.pollScan(false);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void externalPush(ForkJoinTask<?> task) {
        WorkQueue q;
        int r = ThreadLocalRandom.getProbe();
        if (r == 0) {
            ThreadLocalRandom.localInit();
            r = ThreadLocalRandom.getProbe();
        }
        while (true) {
            int n;
            int md = this.mode;
            WorkQueue[] ws = this.workQueues;
            if ((md & 0x40000) != 0 || ws == null || (n = ws.length) <= 0) {
                throw new RejectedExecutionException();
            }
            q = ws[n - 1 & r & 0x7E];
            if (q == null) {
                int qid = (r | 0x40000000) & 0xFFFEFFFE;
                String lock = this.workerNamePrefix;
                ForkJoinTask[] qa = new ForkJoinTask[8192];
                q = new WorkQueue(this, null);
                q.array = qa;
                q.id = qid;
                q.source = 0x40000000;
                if (lock == null) continue;
                String string = lock;
                synchronized (string) {
                    int i;
                    int vn;
                    WorkQueue[] vs = this.workQueues;
                    if (this.workQueues != null && (vn = vs.length) > 0 && vs[i = qid & vn - 1 & 0x7E] == null) {
                        vs[i] = q;
                    }
                }
            }
            if (q.tryLockPhase()) break;
            r = ThreadLocalRandom.advanceProbe(r);
        }
        if (q.lockedPush(task)) {
            this.signalWork();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> ForkJoinTask<T> externalSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (w.pool == this && (q = w.workQueue) != null) {
                q.push(task);
                return task;
            }
        }
        this.externalPush(task);
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        ForkJoinPool p = common;
        int r = ThreadLocalRandom.getProbe();
        if (p == null) return null;
        WorkQueue[] ws = p.workQueues;
        if (p.workQueues == null) return null;
        int n = ws.length;
        if (n <= 0) return null;
        WorkQueue workQueue = ws[n - 1 & r & 0x7E];
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> task) {
        WorkQueue w;
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (n = ws.length) > 0 && (w = ws[n - 1 & r & 0x7E]) != null && w.tryLockedUnpush(task);
    }

    final int externalHelpComplete(CountedCompleter<?> task, int maxTasks) {
        WorkQueue w;
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (n = ws.length) > 0 && (w = ws[n - 1 & r & 0x7E]) != null ? w.helpCC(task, maxTasks, true) : 0;
    }

    final int helpComplete(WorkQueue w, CountedCompleter<?> task, int maxTasks) {
        return w == null ? 0 : w.helpCC(task, maxTasks, false);
    }

    static int getSurplusQueuedTaskCount() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool pool = wt.pool;
            if (pool != null && (q = wt.workQueue) != null) {
                int p = pool.mode & 0xFFFF;
                int a = p + (int)(pool.ctl >> 48);
                int n = q.top - q.base;
                return n - (a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8))));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        long oldSum;
        int md;
        while (((md = this.mode) & 0x40000) == 0) {
            if (!enable || this == common) {
                return false;
            }
            MODE.compareAndSet(this, md, md | 0x40000);
        }
        while (((md = this.mode) & Integer.MIN_VALUE) == 0) {
            if (!now) {
                long checkSum;
                WorkQueue[] ws;
                oldSum = 0L;
                do {
                    boolean running = false;
                    checkSum = this.ctl;
                    ws = this.workQueues;
                    if ((md & 0xFFFF) + (int)(checkSum >> 48) > 0) {
                        running = true;
                    } else if (ws != null) {
                        for (int i = 0; i < ws.length; ++i) {
                            WorkQueue w = ws[i];
                            if (w == null) continue;
                            int s = w.source;
                            int p = w.phase;
                            int d = w.id;
                            int b = w.base;
                            if (b != w.top || (d & 1) == 1 && (s >= 0 || p >= 0)) {
                                running = true;
                                break;
                            }
                            checkSum += ((long)s << 48) + ((long)p << 32) + ((long)b << 16) + (long)d;
                        }
                    }
                    md = this.mode;
                    if ((md & Integer.MIN_VALUE) != 0) break;
                    if (!running) continue;
                    return false;
                } while (this.workQueues != ws || oldSum != (oldSum = checkSum));
            }
            if ((md & Integer.MIN_VALUE) != 0) continue;
            MODE.compareAndSet(this, md, md | Integer.MIN_VALUE);
        }
        while (((md = this.mode) & 0x80000) == 0) {
            long checkSum;
            WorkQueue[] ws;
            oldSum = 0L;
            do {
                checkSum = this.ctl;
                ws = this.workQueues;
                if (this.workQueues == null) continue;
                for (int i = 0; i < ws.length; ++i) {
                    WorkQueue w = ws[i];
                    if (w == null) continue;
                    ForkJoinWorkerThread wt = w.owner;
                    w.cancelAll();
                    if (wt != null) {
                        try {
                            wt.interrupt();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    checkSum += ((long)w.phase << 32) + (long)w.base;
                }
            } while (((md = this.mode) & 0x80000) == 0 && (this.workQueues != ws || oldSum != (oldSum = checkSum)));
            if ((md & 0x80000) != 0 || (md & 0xFFFF) + (short)(this.ctl >>> 32) > 0) break;
            if (!MODE.compareAndSet(this, md, md | 0x80000)) continue;
            ForkJoinPool forkJoinPool = this;
            synchronized (forkJoinPool) {
                this.notifyAll();
                break;
            }
        }
        return true;
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        this(parallelism, factory, handler, asyncMode, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode, int corePoolSize, int maximumPoolSize, int minimumRunnable, Predicate<? super ForkJoinPool> saturate, long keepAliveTime, TimeUnit unit) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE || maximumPoolSize < parallelism || keepAliveTime <= 0L) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        long ms = Math.max(unit.toMillis(keepAliveTime), 20L);
        int corep = Math.min(Math.max(corePoolSize, parallelism), Short.MAX_VALUE);
        long c = (long)(-corep) << 32 & 0xFFFF00000000L | (long)(-parallelism) << 48 & 0xFFFF000000000000L;
        int m = parallelism | (asyncMode ? 65536 : 0);
        int maxSpares = Math.min(maximumPoolSize, Short.MAX_VALUE) - parallelism;
        int minAvail = Math.min(Math.max(minimumRunnable, 0), Short.MAX_VALUE);
        int b = minAvail - parallelism & 0xFFFF | maxSpares << 16;
        int n = parallelism > 1 ? parallelism - 1 : 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n = n + 1 << 1;
        this.workerNamePrefix = "ForkJoinPool-" + ForkJoinPool.nextPoolId() + "-worker-";
        this.workQueues = new WorkQueue[n];
        this.factory = factory;
        this.ueh = handler;
        this.saturate = saturate;
        this.keepAlive = ms;
        this.bounds = b;
        this.mode = m;
        this.ctl = c;
        ForkJoinPool.checkPermission();
    }

    private static Object newInstanceFromSystemProperty(String property) throws ReflectiveOperationException {
        String className = System.getProperty(property);
        return className == null ? null : ClassLoader.getSystemClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private ForkJoinPool(byte forCommonPoolOnly) {
        int parallelism = -1;
        ForkJoinWorkerThreadFactory fac = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
            fac = (ForkJoinWorkerThreadFactory)ForkJoinPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            handler = (Thread.UncaughtExceptionHandler)ForkJoinPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
        }
        catch (Exception pp) {
            // empty catch block
        }
        if (fac == null) {
            fac = System.getSecurityManager() == null ? defaultForkJoinWorkerThreadFactory : new InnocuousForkJoinWorkerThreadFactory();
        }
        if (parallelism < 0 && (parallelism = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            parallelism = 1;
        }
        if (parallelism > Short.MAX_VALUE) {
            parallelism = Short.MAX_VALUE;
        }
        long c = (long)(-parallelism) << 32 & 0xFFFF00000000L | (long)(-parallelism) << 48 & 0xFFFF000000000000L;
        int b = 1 - parallelism & 0xFFFF | COMMON_MAX_SPARES << 16;
        int n = parallelism > 1 ? parallelism - 1 : 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n = n + 1 << 1;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
        this.workQueues = new WorkQueue[n];
        this.factory = fac;
        this.ueh = handler;
        this.saturate = null;
        this.keepAlive = 60000L;
        this.bounds = b;
        this.mode = parallelism;
        this.ctl = c;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.externalSubmit(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        this.externalSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.RunnableExecuteAction(task);
        this.externalSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        return this.externalSubmit(task);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return this.externalSubmit(new ForkJoinTask.AdaptedCallable<T>(task));
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return this.externalSubmit(new ForkJoinTask.AdaptedRunnable<T>(task, result));
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.externalSubmit(task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedCallable<T> f = new ForkJoinTask.AdaptedCallable<T>(t);
                futures.add(f);
                this.externalSubmit(f);
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((ForkJoinTask)futures.get(i)).quietlyJoin();
            }
            return futures;
        }
        catch (Throwable t) {
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((Future)futures.get(i)).cancel(false);
            }
            throw t;
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int par = this.mode & 0xFFFF;
        return par > 0 ? par : 1;
    }

    public static int getCommonPoolParallelism() {
        return COMMON_PARALLELISM;
    }

    public int getPoolSize() {
        return (this.mode & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.mode & 0x10000) != 0;
    }

    public int getRunningThreadCount() {
        VarHandle.acquireFence();
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || !w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = (this.mode & 0xFFFF) + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        long c;
        int tc;
        do {
            c = this.ctl;
            int md = this.mode;
            int pc = md & 0xFFFF;
            tc = pc + (short)(c >>> 32);
            int rc = pc + (int)(c >> 48);
            if ((md & 0x80080000) != 0) {
                return true;
            }
            if (rc > 0) {
                return false;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null) continue;
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue v = ws[i];
                if (v == null) continue;
                if (v.source > 0) {
                    return false;
                }
                --tc;
            }
        } while (tc != 0 || this.ctl != c);
        return true;
    }

    public long getStealCount() {
        long count = this.stealCount;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.nsteals & 0xFFFFFFFFL;
            }
        }
        return count;
    }

    public long getQueuedTaskCount() {
        VarHandle.acquireFence();
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += w.queueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        VarHandle.acquireFence();
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += w.queueSize();
            }
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        VarHandle.acquireFence();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || w.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.pollScan(true);
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        VarHandle.acquireFence();
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null) continue;
                while ((t = w.poll()) != null) {
                    c.add(t);
                    ++count;
                }
            }
        }
        return count;
    }

    public String toString() {
        int md = this.mode;
        long c = this.ctl;
        long st = this.stealCount;
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)w.nsteals & 0xFFFFFFFFL;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = md & 0xFFFF;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (md & 0x80000) != 0 ? "Terminated" : ((md & Integer.MIN_VALUE) != 0 ? "Terminating" : ((md & 0x40000) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.mode & 0x80000) != 0;
    }

    public boolean isTerminating() {
        int md = this.mode;
        return (md & Integer.MIN_VALUE) != 0 && (md & 0x80000) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.mode & 0x40000) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        if (nanos <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanos;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
                this.wait(millis > 0L ? millis : 1L);
                nanos = deadline - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        long nanos = unit.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)thread;
            if (wt.pool == this) {
                this.helpQuiescePool(wt.workQueue);
                return true;
            }
        }
        long startTime = System.nanoTime();
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.pollScan(false)) != null) {
                t.doExec();
                continue;
            }
            if (this.isQuiescent()) {
                return true;
            }
            if (System.nanoTime() - startTime > nanos) {
                return false;
            }
            Thread.yield();
        }
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        if (blocker == null) {
            throw new NullPointerException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue w;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool p = wt.pool;
            if (p != null && (w = wt.workQueue) != null) {
                while (!blocker.isReleasable()) {
                    int block = p.tryCompensate(w);
                    if (block == 0) continue;
                    try {
                        while (!blocker.isReleasable() && !blocker.block()) {
                        }
                        CTL.getAndAdd(p, block > 0 ? 0x1000000000000L : 0L);
                    }
                    catch (Throwable throwable) {
                        CTL.getAndAdd(p, block > 0 ? 0x1000000000000L : 0L);
                        throw throwable;
                    }
                    return;
                }
                return;
            }
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    /*
     * Unable to fully structure code
     */
    static void helpAsyncBlocker(Executor e, ManagedBlocker blocker) {
        block3: {
            block5: {
                block4: {
                    if (!(e instanceof ForkJoinPool)) break block3;
                    p = (ForkJoinPool)e;
                    thread = Thread.currentThread();
                    if (!(thread instanceof ForkJoinWorkerThread)) break block4;
                    wt = (ForkJoinWorkerThread)thread;
                    if (wt.pool != p) break block4;
                    w = wt.workQueue;
                    break block5;
                }
                if ((r = ThreadLocalRandom.getProbe()) == 0) ** GOTO lbl-1000
                ws = p.workQueues;
                if (p.workQueues != null && (n = ws.length) > 0) {
                    w = ws[n - 1 & r & 126];
                } else lbl-1000:
                // 2 sources

                {
                    w = null;
                }
            }
            if (w != null) {
                w.helpAsyncBlocker(blocker);
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            CTL = l.findVarHandle(ForkJoinPool.class, "ctl", Long.TYPE);
            MODE = l.findVarHandle(ForkJoinPool.class, "mode", Integer.TYPE);
            QA = MethodHandles.arrayElementVarHandle(ForkJoinTask[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        int commonMaxSpares = 256;
        try {
            String p = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (p != null) {
                commonMaxSpares = Integer.parseInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMMON_MAX_SPARES = commonMaxSpares;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return new ForkJoinPool(0);
            }
        });
        COMMON_PARALLELISM = Math.max(ForkJoinPool.common.mode & 0xFFFF, 1);
    }

    private static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext ACC = ForkJoinPool.contextWithPermissions(modifyThreadPermission, new RuntimePermission("enableContextClassLoaderOverride"), new RuntimePermission("modifyThreadGroup"), new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));

        private InnocuousForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, ACC);
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        volatile int source;
        int id;
        int base;
        int top;
        volatile int phase;
        int stackPred;
        int nsteals;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        static final VarHandle PHASE;
        static final VarHandle BASE;
        static final VarHandle TOP;

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner) {
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final boolean tryLockPhase() {
            return PHASE.compareAndSet(this, 0, 1);
        }

        final void releasePhaseLock() {
            PHASE.setRelease(this, 0);
        }

        final int getPoolIndex() {
            return (this.id & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int n = BASE.getAcquire(this) - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            VarHandle.acquireFence();
            int b = this.base;
            int n = b - this.top;
            if (n >= 0) return true;
            if (n != -1) return false;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return true;
            int cap = a.length;
            if (cap == 0) return true;
            if (a[cap - 1 & b] != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            int cap;
            int s = this.top;
            ForkJoinPool p = this.pool;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int m = cap - 1;
                QA.setRelease(a, m & s, task);
                this.top = s + 1;
                int d = s - BASE.getAcquire(this);
                if ((d & 0xFFFFFFFE) == 0 && p != null) {
                    VarHandle.fullFence();
                    p.signalWork();
                } else if (d == m) {
                    this.growArray(false);
                }
            }
        }

        final boolean lockedPush(ForkJoinTask<?> task) {
            int cap;
            boolean signal = false;
            int s = this.top;
            int b = this.base;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                a[cap - 1 & s] = task;
                this.top = s + 1;
                if (b - s + cap - 1 == 0) {
                    this.growArray(true);
                } else {
                    this.phase = 0;
                    if ((s - this.base & 0xFFFFFFFE) == 0) {
                        signal = true;
                    }
                }
            }
            return signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void growArray(boolean locked) {
            ForkJoinTask[] newA;
            block9: {
                newA = null;
                try {
                    int newSize;
                    int oldSize;
                    ForkJoinTask[] oldA = this.array;
                    if (this.array == null || (oldSize = oldA.length) <= 0 || (newSize = oldSize << 1) > 0x4000000 || newSize <= 0) break block9;
                    try {
                        newA = new ForkJoinTask[newSize];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        // empty catch block
                    }
                    if (newA != null) {
                        ForkJoinTask x;
                        int oldMask = oldSize - 1;
                        int newMask = newSize - 1;
                        int s = this.top - 1;
                        for (int k = oldMask; k >= 0 && (x = QA.getAndSet(oldA, s & oldMask, null)) != null; --k) {
                            newA[s-- & newMask] = x;
                        }
                        this.array = newA;
                        VarHandle.releaseFence();
                    }
                }
                finally {
                    if (locked) {
                        this.phase = 0;
                    }
                }
            }
            if (newA == null) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
        }

        final ForkJoinTask<?> poll() {
            block2: {
                ForkJoinTask t;
                int b;
                while (true) {
                    int cap;
                    ForkJoinTask[] a = this.array;
                    if (this.array == null || (cap = a.length) <= 0 || this.top - (b = this.base) <= 0) break block2;
                    int k = cap - 1 & b;
                    t = QA.getAcquire(a, k);
                    if (this.base != b++) continue;
                    if (t == null) {
                        Thread.yield();
                        continue;
                    }
                    if (QA.compareAndSet(a, k, t, null)) break;
                }
                BASE.setOpaque(this, b);
                return t;
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            int b;
            int s;
            int d;
            int cap;
            ForkJoinTask<?> t = null;
            int md = this.id;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && (d = (s = this.top) - (b = this.base)) > 0) {
                if ((md & 0x10000) == 0 || d == 1) {
                    if ((t = QA.getAndSet(a, cap - 1 & --s, null)) != null) {
                        TOP.setOpaque(this, s);
                    }
                } else if ((t = QA.getAndSet(a, cap - 1 & b++, null)) != null) {
                    BASE.setOpaque(this, b);
                } else {
                    t = this.poll();
                }
            }
            return t;
        }

        final ForkJoinTask<?> peek() {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            return this.array != null && (cap = a.length) > 0 ? a[cap - 1 & ((this.id & 0x10000) != 0 ? this.base : this.top - 1)] : null;
        }

        final boolean tryUnpush(ForkJoinTask<?> task) {
            int s;
            int cap;
            boolean popped = false;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && (s = this.top) != this.base && (popped = QA.compareAndSet(a, cap - 1 & --s, task, null))) {
                TOP.setOpaque(this, s);
            }
            return popped;
        }

        final boolean tryLockedUnpush(ForkJoinTask<?> task) {
            int k;
            int cap;
            boolean popped = false;
            int s = this.top - 1;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && a[k = cap - 1 & s] == task && this.tryLockPhase()) {
                if (this.top == s + 1 && this.array == a && (popped = QA.compareAndSet(a, k, task, null))) {
                    this.top = s;
                }
                this.releasePhaseLock();
            }
            return popped;
        }

        final void cancelAll() {
            ForkJoinTask<?> t;
            while ((t = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }

        final void topLevelExec(ForkJoinTask<?> t, WorkQueue q, int n) {
            if (t != null && q != null) {
                int nstolen = 1;
                while (true) {
                    t.doExec();
                    if (n-- < 0) break;
                    t = this.nextLocalTask();
                    if (t != null) continue;
                    t = q.poll();
                    if (t == null) break;
                    ++nstolen;
                }
                ForkJoinWorkerThread thread = this.owner;
                this.nsteals += nstolen;
                this.source = 0;
                if (thread != null) {
                    thread.afterTopLevelExec();
                }
            }
        }

        final void tryRemoveAndExec(ForkJoinTask<?> task) {
            int s;
            int cap;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && (s = this.top) - this.base > 0) {
                int index;
                ForkJoinTask t;
                int ns;
                int m = cap - 1;
                int i = ns = s - 1;
                while ((t = QA.get(a, index = i & m)) != null) {
                    if (t == task) {
                        if (!QA.compareAndSet(a, index, t, null)) break;
                        this.top = ns;
                        for (int j = i; j != ns; ++j) {
                            int pindex = j + 1 & m;
                            ForkJoinTask f = QA.get(a, pindex);
                            QA.setVolatile(a, pindex, null);
                            int jindex = j & m;
                            QA.setRelease(a, jindex, f);
                        }
                        VarHandle.releaseFence();
                        t.doExec();
                        break;
                    }
                    --i;
                }
            }
        }

        final int helpCC(CountedCompleter<?> task, int limit, boolean shared) {
            int status;
            block8: {
                CountedCompleter<?> v;
                status = 0;
                if (task == null || (status = task.status) < 0) break block8;
                do {
                    block9: {
                        int s;
                        int cap;
                        ForkJoinTask[] a = this.array;
                        if (this.array == null || (cap = a.length) <= 0 || (s = this.top) - this.base <= 0) break block8;
                        v = null;
                        int k = cap - 1 & s - 1;
                        ForkJoinTask<?> o = a[k];
                        if (o instanceof CountedCompleter) {
                            CountedCompleter<?> t;
                            CountedCompleter<?> f = t = (CountedCompleter<?>)o;
                            while (f != task) {
                                f = f.completer;
                                if (f != null) continue;
                                break block9;
                            }
                            if (shared) {
                                if (this.tryLockPhase()) {
                                    if (this.top == s && this.array == a && QA.compareAndSet(a, k, t, null)) {
                                        this.top = s - 1;
                                        v = t;
                                    }
                                    this.releasePhaseLock();
                                }
                            } else if (QA.compareAndSet(a, k, t, null)) {
                                this.top = s - 1;
                                v = t;
                            }
                        }
                    }
                    if (v == null) continue;
                    v.doExec();
                } while ((status = task.status) >= 0 && v != null && (limit == 0 || --limit != 0));
            }
            return status;
        }

        final void helpAsyncBlocker(ManagedBlocker blocker) {
            if (blocker != null) {
                while (true) {
                    int b;
                    int cap;
                    ForkJoinTask[] a = this.array;
                    if (this.array == null || (cap = a.length) <= 0 || this.top - (b = this.base) <= 0) break;
                    int k = cap - 1 & b;
                    ForkJoinTask t = QA.getAcquire(a, k);
                    if (blocker.isReleasable()) break;
                    if (this.base != b++ || t == null) continue;
                    if (!(t instanceof CompletableFuture.AsynchronousCompletionTask)) break;
                    if (!QA.compareAndSet(a, k, t, null)) continue;
                    BASE.setOpaque(this, b);
                    t.doExec();
                }
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt = this.owner;
            return wt != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                PHASE = l.findVarHandle(WorkQueue.class, "phase", Integer.TYPE);
                BASE = l.findVarHandle(WorkQueue.class, "base", Integer.TYPE);
                TOP = l.findVarHandle(WorkQueue.class, "top", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext ACC = ForkJoinPool.contextWithPermissions(new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));

        private DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread(pool, ClassLoader.getSystemClassLoader());
                }
            }, ACC);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

