/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.ByteBuffer;
import jdk.internal.ref.CleanerFactory;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.Util;

class IOVecWrapper {
    private static final int BASE_OFFSET = 0;
    private static final int LEN_OFFSET;
    private static final int SIZE_IOVEC;
    private final AllocatedNativeObject vecArray;
    private final int size;
    private final ByteBuffer[] buf;
    private final int[] position;
    private final int[] remaining;
    private final ByteBuffer[] shadow;
    final long address;
    static int addressSize;
    private static final ThreadLocal<IOVecWrapper> cached;

    private IOVecWrapper(int size) {
        this.size = size;
        this.buf = new ByteBuffer[size];
        this.position = new int[size];
        this.remaining = new int[size];
        this.shadow = new ByteBuffer[size];
        this.vecArray = new AllocatedNativeObject(size * SIZE_IOVEC, false);
        this.address = this.vecArray.address();
    }

    static IOVecWrapper get(int size) {
        IOVecWrapper wrapper = cached.get();
        if (wrapper != null && wrapper.size < size) {
            wrapper.vecArray.free();
            wrapper = null;
        }
        if (wrapper == null) {
            wrapper = new IOVecWrapper(size);
            CleanerFactory.cleaner().register(wrapper, new Deallocator(wrapper.vecArray));
            cached.set(wrapper);
        }
        return wrapper;
    }

    void setBuffer(int i, ByteBuffer buf, int pos, int rem) {
        this.buf[i] = buf;
        this.position[i] = pos;
        this.remaining[i] = rem;
    }

    void setShadow(int i, ByteBuffer buf) {
        this.shadow[i] = buf;
    }

    ByteBuffer getBuffer(int i) {
        return this.buf[i];
    }

    int getPosition(int i) {
        return this.position[i];
    }

    int getRemaining(int i) {
        return this.remaining[i];
    }

    ByteBuffer getShadow(int i) {
        return this.shadow[i];
    }

    void clearRefs(int i) {
        this.buf[i] = null;
        this.shadow[i] = null;
    }

    void putBase(int i, long base) {
        int offset = SIZE_IOVEC * i + 0;
        if (addressSize == 4) {
            this.vecArray.putInt(offset, (int)base);
        } else {
            this.vecArray.putLong(offset, base);
        }
    }

    void putLen(int i, long len) {
        int offset = SIZE_IOVEC * i + LEN_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(offset, (int)len);
        } else {
            this.vecArray.putLong(offset, len);
        }
    }

    static {
        cached = new ThreadLocal();
        LEN_OFFSET = addressSize = Util.unsafe().addressSize();
        SIZE_IOVEC = (short)(addressSize * 2);
    }

    private static class Deallocator
    implements Runnable {
        private final AllocatedNativeObject obj;

        Deallocator(AllocatedNativeObject obj) {
            this.obj = obj;
        }

        @Override
        public void run() {
            this.obj.free();
        }
    }
}

