/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import sun.net.NetHooks;
import sun.net.ext.ExtendedSocketOptions;
import sun.net.util.SocketExceptions;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Object stateLock = new Object();
    private volatile boolean isInputClosed;
    private volatile boolean isOutputClosed;
    private boolean isReuseAddress;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTIONPENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSING = 3;
    private static final int ST_KILLPENDING = 4;
    private static final int ST_KILLED = 5;
    private volatile int state;
    private long readerThread;
    private long writerThread;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private Socket socket;

    SocketChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketChannelImpl(SelectorProvider sp, FileDescriptor fd, boolean bound) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        if (bound) {
            Object object = this.stateLock;
            synchronized (object) {
                this.localAddress = Net.localAddress(fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketChannelImpl(SelectorProvider sp, FileDescriptor fd, InetSocketAddress isa) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        Object object = this.stateLock;
        synchronized (object) {
            this.localAddress = Net.localAddress(fd);
            this.remoteAddress = isa;
            this.state = 2;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void ensureOpenAndConnected() throws ClosedChannelException {
        int state = this.state;
        if (state < 2) {
            throw new NotYetConnectedException();
        }
        if (state > 2) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (name == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                Net.setSocketOption(this.fd, family, name, value);
                return this;
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)value;
                return this;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            if (name == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                return (T)Net.getSocketOption(this.fd, family, name);
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, name);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRead(boolean blocking) throws ClosedChannelException {
        if (blocking) {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                this.ensureOpenAndConnected();
                this.readerThread = NativeThread.current();
            }
        } else {
            this.ensureOpenAndConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object = this.stateLock;
            synchronized (object) {
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int read(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.readLock.lock();
        try {
            int n;
            boolean blocking;
            block14: {
                blocking = this.isBlocking();
                n = 0;
                this.beginRead(blocking);
                if (!this.isInputClosed) break block14;
                int n2 = -1;
                this.endRead(blocking, n > 0);
                if (n <= 0 && this.isInputClosed) {
                    int n3 = -1;
                    return n3;
                }
                return n2;
            }
            try {
                if (blocking) {
                    while ((n = IOUtil.read(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
                    }
                } else {
                    n = IOUtil.read(this.fd, buf, -1L, nd);
                }
                this.endRead(blocking, n > 0);
            }
            catch (Throwable throwable) {
                block15: {
                    this.endRead(blocking, n > 0);
                    if (n > 0 || !this.isInputClosed) break block15;
                    int n4 = -1;
                    this.readLock.unlock();
                    return n4;
                }
                throw throwable;
            }
            if (n <= 0 && this.isInputClosed) {
                int n5 = -1;
                return n5;
            }
            int n6 = IOStatus.normalize(n);
            return n6;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dsts.length);
        this.readLock.lock();
        try {
            long n;
            boolean blocking;
            block14: {
                blocking = this.isBlocking();
                n = 0L;
                this.beginRead(blocking);
                if (!this.isInputClosed) break block14;
                long l = -1L;
                this.endRead(blocking, n > 0L);
                if (n <= 0L && this.isInputClosed) {
                    long l2 = -1L;
                    return l2;
                }
                return l;
            }
            try {
                if (blocking) {
                    while ((n = IOUtil.read(this.fd, dsts, offset, length, nd)) == -3L && this.isOpen()) {
                    }
                } else {
                    n = IOUtil.read(this.fd, dsts, offset, length, nd);
                }
                this.endRead(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                block15: {
                    this.endRead(blocking, n > 0L);
                    if (n > 0L || !this.isInputClosed) break block15;
                    long l = -1L;
                    this.readLock.unlock();
                    return l;
                }
                throw throwable;
            }
            if (n <= 0L && this.isInputClosed) {
                long l = -1L;
                return l;
            }
            long l = IOStatus.normalize(n);
            return l;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginWrite(boolean blocking) throws ClosedChannelException {
        if (blocking) {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                this.ensureOpenAndConnected();
                if (this.isOutputClosed) {
                    throw new ClosedChannelException();
                }
                this.writerThread = NativeThread.current();
            }
        } else {
            this.ensureOpenAndConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWrite(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object = this.stateLock;
            synchronized (object) {
                this.writerThread = 0L;
                if (this.state == 3) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(blocking);
                if (blocking) {
                    while ((n = IOUtil.write(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
                    }
                } else {
                    n = IOUtil.write(this.fd, buf, -1L, nd);
                }
                this.endWrite(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0);
                if (n <= 0 && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (n <= 0 && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, srcs.length);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginWrite(blocking);
                if (blocking) {
                    while ((n = IOUtil.write(this.fd, srcs, offset, length, nd)) == -3L && this.isOpen()) {
                    }
                } else {
                    n = IOUtil.write(this.fd, srcs, offset, length, nd);
                }
                this.endWrite(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0L);
                if (n <= 0L && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (n <= 0L && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendOutOfBandData(byte b) throws IOException {
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(blocking);
                if (blocking) {
                    while ((n = SocketChannelImpl.sendOutOfBandData(this.fd, b)) == -3 && this.isOpen()) {
                    }
                } else {
                    n = SocketChannelImpl.sendOutOfBandData(this.fd, b);
                }
                this.endWrite(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0);
                if (n <= 0 && this.isOutputClosed) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            if (n <= 0 && this.isOutputClosed) {
                throw new AsynchronousCloseException();
            }
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    IOUtil.configureBlocking(this.fd, block);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkListen(isa.getPort());
                    }
                    NetHooks.beforeTcpBind(this.fd, isa.getAddress(), isa.getPort());
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    @Override
    public boolean isConnectionPending() {
        return this.state == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginConnect(boolean blocking, InetSocketAddress isa) throws IOException {
        if (blocking) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            int state = this.state;
            if (state == 2) {
                throw new AlreadyConnectedException();
            }
            if (state == 1) {
                throw new ConnectionPendingException();
            }
            assert (state == 0);
            this.state = 1;
            if (this.localAddress == null) {
                NetHooks.beforeTcpConnect(this.fd, isa.getAddress(), isa.getPort());
            }
            this.remoteAddress = isa;
            if (blocking) {
                this.readerThread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endConnect(boolean blocking, boolean completed) throws IOException {
        this.endRead(blocking, completed);
        if (completed) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    this.localAddress = Net.localAddress(this.fd);
                    this.state = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect(SocketAddress sa) throws IOException {
        InetAddress ia;
        InetSocketAddress isa = Net.checkAddress(sa);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        if ((ia = isa.getAddress()).isAnyLocalAddress()) {
            ia = InetAddress.getLocalHost();
        }
        try {
            this.readLock.lock();
            try {
                this.writeLock.lock();
                try {
                    int n = 0;
                    boolean blocking = this.isBlocking();
                    try {
                        this.beginConnect(blocking, isa);
                        while ((n = Net.connect(this.fd, ia, isa.getPort())) == -3 && this.isOpen()) {
                        }
                        this.endConnect(blocking, n > 0);
                    }
                    catch (Throwable throwable) {
                        this.endConnect(blocking, n > 0);
                        throw throwable;
                    }
                    assert (IOStatus.check(n));
                    boolean bl = n > 0;
                    this.writeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (IOException ioe) {
            this.close();
            throw SocketExceptions.of((IOException)ioe, (InetSocketAddress)isa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginFinishConnect(boolean blocking) throws ClosedChannelException {
        if (blocking) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.state != 1) {
                throw new NoConnectionPendingException();
            }
            if (blocking) {
                this.readerThread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endFinishConnect(boolean blocking, boolean completed) throws IOException {
        this.endRead(blocking, completed);
        if (completed) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    this.localAddress = Net.localAddress(this.fd);
                    this.state = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean finishConnect() throws IOException {
        try {
            this.readLock.lock();
            try {
                block17: {
                    this.writeLock.lock();
                    if (!this.isConnected()) break block17;
                    boolean bl = true;
                    this.writeLock.unlock();
                    return bl;
                }
                try {
                    boolean blocking = this.isBlocking();
                    boolean connected = false;
                    try {
                        this.beginFinishConnect(blocking);
                        int n = 0;
                        if (blocking) {
                            while (((n = SocketChannelImpl.checkConnect(this.fd, true)) == 0 || n == -3) && this.isOpen()) {
                            }
                        } else {
                            n = SocketChannelImpl.checkConnect(this.fd, false);
                        }
                        connected = n > 0;
                    }
                    finally {
                        this.endFinishConnect(blocking, connected);
                    }
                    assert ((blocking && connected) ^ !blocking);
                    boolean bl = connected;
                    this.writeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (IOException ioe) {
            this.close();
            throw SocketExceptions.of((IOException)ioe, (InetSocketAddress)this.remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        boolean connected;
        boolean blocking;
        assert (!this.isOpen());
        boolean interrupted = false;
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state < 3);
            blocking = this.isBlocking();
            connected = this.state == 2;
            this.state = 3;
        }
        if (blocking) {
            object = this.stateLock;
            synchronized (object) {
                assert (this.state == 3);
                long reader = this.readerThread;
                long writer = this.writerThread;
                if (reader != 0L || writer != 0L) {
                    nd.preClose(this.fd);
                    connected = false;
                    if (reader != 0L) {
                        NativeThread.signal(reader);
                    }
                    if (writer != 0L) {
                        NativeThread.signal(writer);
                    }
                    while (this.readerThread != 0L || this.writerThread != 0L) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
        }
        this.readLock.lock();
        try {
            this.writeLock.lock();
            this.writeLock.unlock();
        }
        finally {
            this.readLock.unlock();
        }
        object = this.stateLock;
        synchronized (object) {
            assert (this.state == 3);
            if (connected && this.isRegistered()) {
                try {
                    SocketOption<Integer> opt = StandardSocketOptions.SO_LINGER;
                    int interval = (Integer)Net.getSocketOption(this.fd, Net.UNSPEC, opt);
                    if (interval != 0) {
                        if (interval > 0) {
                            Net.setSocketOption(this.fd, Net.UNSPEC, opt, -1);
                        }
                        Net.shutdown(this.fd, 1);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.state = 4;
        }
        if (!this.isRegistered()) {
            this.kill();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                this.state = 5;
                nd.close(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (!this.isInputClosed) {
                Net.shutdown(this.fd, 0);
                long thread = this.readerThread;
                if (thread != 0L) {
                    NativeThread.signal(thread);
                }
                this.isInputClosed = true;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (!this.isOutputClosed) {
                Net.shutdown(this.fd, 1);
                long thread = this.writerThread;
                if (thread != 0L) {
                    NativeThread.signal(thread);
                }
                this.isOutputClosed = true;
            }
            return this;
        }
    }

    boolean isInputOpen() {
        return !this.isInputClosed;
    }

    boolean isOutputOpen() {
        return !this.isOutputClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollRead(long timeout) throws IOException {
        boolean blocking = this.isBlocking();
        assert (Thread.holdsLock(this.blockingLock()) && blocking);
        this.readLock.lock();
        try {
            boolean polled = false;
            try {
                this.beginRead(blocking);
                int events = Net.poll(this.fd, Net.POLLIN, timeout);
                polled = events != 0;
            }
            finally {
                this.endRead(blocking, polled);
            }
            boolean bl = polled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollConnected(long timeout) throws IOException {
        boolean blocking = this.isBlocking();
        assert (Thread.holdsLock(this.blockingLock()) && blocking);
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                boolean polled = false;
                try {
                    this.beginFinishConnect(blocking);
                    int events = Net.poll(this.fd, Net.POLLCONN, timeout);
                    polled = events != 0;
                }
                finally {
                    this.endFinishConnect(blocking, false);
                }
                boolean bl = polled;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl ski) {
        int intOps = ski.nioInterestOps();
        int oldOps = ski.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            ski.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        boolean connected = this.isConnected();
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0 && connected) {
            newOps |= 1;
        }
        if ((ops & Net.POLLCONN) != 0 && (intOps & 8) != 0 && this.isConnectionPending()) {
            newOps |= 8;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0 && connected) {
            newOps |= 4;
        }
        ski.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, ski.nioReadyOps(), ski);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, 0, ski);
    }

    @Override
    public int translateInterestOps(int ops) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        if ((ops & 8) != 0) {
            newOps |= Net.POLLCONN;
        }
        return newOps;
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSuperclass().getName());
        sb.append('[');
        if (!this.isOpen()) {
            sb.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        sb.append("unconnected");
                        break;
                    }
                    case 1: {
                        sb.append("connection-pending");
                        break;
                    }
                    case 2: {
                        sb.append("connected");
                        if (this.isInputClosed) {
                            sb.append(" ishut");
                        }
                        if (!this.isOutputClosed) break;
                        sb.append(" oshut");
                    }
                }
                InetSocketAddress addr = this.localAddress();
                if (addr != null) {
                    sb.append(" local=");
                    sb.append(Net.getRevealedLocalAddressAsString(addr));
                }
                if (this.remoteAddress() != null) {
                    sb.append(" remote=");
                    sb.append(this.remoteAddress().toString());
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1) throws IOException;

    private static native int sendOutOfBandData(FileDescriptor var0, byte var1) throws IOException;

    static {
        IOUtil.load();
        nd = new SocketDispatcher();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Constable>> set = new HashSet<SocketOption<Constable>>();
            set.add(StandardSocketOptions.SO_SNDBUF);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_KEEPALIVE);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            if (Net.isReusePortAvailable()) {
                set.add(StandardSocketOptions.SO_REUSEPORT);
            }
            set.add(StandardSocketOptions.SO_LINGER);
            set.add(StandardSocketOptions.TCP_NODELAY);
            set.add(StandardSocketOptions.IP_TOS);
            set.add(ExtendedSocketOption.SO_OOBINLINE);
            set.addAll(ExtendedSocketOptions.options((short)1));
            return Collections.unmodifiableSet(set);
        }
    }
}

