/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;

class ServerSocketAdaptor
extends ServerSocket {
    private final ServerSocketChannelImpl ssc;
    private volatile int timeout;

    public static ServerSocket create(ServerSocketChannelImpl ssc) {
        try {
            return new ServerSocketAdaptor(ssc);
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    private ServerSocketAdaptor(ServerSocketChannelImpl ssc) throws IOException {
        this.ssc = ssc;
    }

    @Override
    public void bind(SocketAddress local) throws IOException {
        this.bind(local, 50);
    }

    @Override
    public void bind(SocketAddress local, int backlog) throws IOException {
        if (local == null) {
            local = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(local, backlog);
        }
        catch (Exception x) {
            Net.translateException(x);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        InetSocketAddress local = this.ssc.localAddress();
        if (local == null) {
            return null;
        }
        return Net.getRevealedLocalAddress(local).getAddress();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress local = this.ssc.localAddress();
        if (local == null) {
            return -1;
        }
        return local.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            try {
                long st;
                if (!this.ssc.isBound()) {
                    throw new NotYetBoundException();
                }
                long to = this.timeout;
                if (to == 0L) {
                    SocketChannel sc = this.ssc.accept();
                    if (sc == null && !this.ssc.isBlocking()) {
                        throw new IllegalBlockingModeException();
                    }
                    return sc.socket();
                }
                if (!this.ssc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                do {
                    st = System.currentTimeMillis();
                    if (!this.ssc.pollAccept(to)) continue;
                    return this.ssc.accept().socket();
                } while ((to -= System.currentTimeMillis() - st) > 0L);
                throw new SocketTimeoutException();
            }
            catch (Exception x) {
                Net.translateException(x);
                assert (false);
                return null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ssc.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    @Override
    public boolean isBound() {
        return this.ssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)on);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return false;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException x) {
            Net.translateToSocketException(x);
            return -1;
        }
    }
}

