// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: emulator_controller.proto

package com.android.emulator.control;

/**
 * <pre>
 * A DisplayConfiguration describes a primary or secondary
 * display available to the emulator. The screen aspect ratio
 * cannot be longer (or wider) than 21:9 (or 9:21). Screen sizes
 * larger than 4k will be rejected.
 * Common configurations (w x h) are:
 * - 480p  (480x720)   142 dpi
 * - 720p  (720x1280)  213 dpi
 * - 1080p (1080x1920) 320 dpi
 * - 4K  (2160x3840) 320 dpi
 * - 4K  (2160x3840) 640 dpi (upscaled)
 * The behavior of the virtual display depends on the flags that are provided to
 * this method. By default, virtual displays are created to be private,
 * non-presentation and unsecure.
 * </pre>
 *
 * Protobuf type {@code android.emulation.control.DisplayConfiguration}
 */
public final class DisplayConfiguration extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:android.emulation.control.DisplayConfiguration)
    DisplayConfigurationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use DisplayConfiguration.newBuilder() to construct.
  private DisplayConfiguration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private DisplayConfiguration() {
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new DisplayConfiguration();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private DisplayConfiguration(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {

            width_ = input.readUInt32();
            break;
          }
          case 16: {

            height_ = input.readUInt32();
            break;
          }
          case 24: {

            dpi_ = input.readUInt32();
            break;
          }
          case 32: {

            flags_ = input.readUInt32();
            break;
          }
          case 40: {

            display_ = input.readUInt32();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_DisplayConfiguration_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_DisplayConfiguration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.android.emulator.control.DisplayConfiguration.class, com.android.emulator.control.DisplayConfiguration.Builder.class);
  }

  /**
   * <pre>
   * These are the set of known android flags and their respective values.
   * you can combine the int values to (de)construct the flags field below.
   * </pre>
   *
   * Protobuf enum {@code android.emulation.control.DisplayConfiguration.DisplayFlags}
   */
  public enum DisplayFlags
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>DISPLAYFLAGS_UNSPECIFIED = 0;</code>
     */
    DISPLAYFLAGS_UNSPECIFIED(0),
    /**
     * <pre>
     * When this flag is set, the virtual display is public.
     * A public virtual display behaves just like most any other display
     * that is connected to the system such as an external or wireless
     * display. Applications can open windows on the display and the system
     * may mirror the contents of other displays onto it. see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_PUBLIC
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;</code>
     */
    VIRTUAL_DISPLAY_FLAG_PUBLIC(1),
    /**
     * <pre>
     * When this flag is set, the virtual display is registered as a
     * presentation display in the presentation display category.
     * Applications may automatically project their content to presentation
     * displays to provide richer second screen experiences.
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_PRESENTATION
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;</code>
     */
    VIRTUAL_DISPLAY_FLAG_PRESENTATION(2),
    /**
     * <pre>
     * When this flag is set, the virtual display is considered secure as
     * defined by the Display#FLAG_SECURE display flag. The caller promises
     * to take reasonable measures, such as over-the-air encryption, to
     * prevent the contents of the display from being intercepted or
     * recorded on a persistent medium.
     * see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_SECURE
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_SECURE = 4;</code>
     */
    VIRTUAL_DISPLAY_FLAG_SECURE(4),
    /**
     * <pre>
     * This flag is used in conjunction with VIRTUAL_DISPLAY_FLAG_PUBLIC.
     * Ordinarily public virtual displays will automatically mirror the
     * content of the default display if they have no windows of their own.
     * When this flag is specified, the virtual display will only ever show
     * its own content and will be blanked instead if it has no windows. See
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;</code>
     */
    VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY(8),
    /**
     * <pre>
     * Allows content to be mirrored on private displays when no content is
     * being shown.
     * This flag is mutually exclusive with
     * VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY. If both flags are specified
     * then the own-content only behavior will be applied.
     * see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR)
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;</code>
     */
    VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR(16),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>DISPLAYFLAGS_UNSPECIFIED = 0;</code>
     */
    public static final int DISPLAYFLAGS_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * When this flag is set, the virtual display is public.
     * A public virtual display behaves just like most any other display
     * that is connected to the system such as an external or wireless
     * display. Applications can open windows on the display and the system
     * may mirror the contents of other displays onto it. see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_PUBLIC
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;</code>
     */
    public static final int VIRTUAL_DISPLAY_FLAG_PUBLIC_VALUE = 1;
    /**
     * <pre>
     * When this flag is set, the virtual display is registered as a
     * presentation display in the presentation display category.
     * Applications may automatically project their content to presentation
     * displays to provide richer second screen experiences.
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_PRESENTATION
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;</code>
     */
    public static final int VIRTUAL_DISPLAY_FLAG_PRESENTATION_VALUE = 2;
    /**
     * <pre>
     * When this flag is set, the virtual display is considered secure as
     * defined by the Display#FLAG_SECURE display flag. The caller promises
     * to take reasonable measures, such as over-the-air encryption, to
     * prevent the contents of the display from being intercepted or
     * recorded on a persistent medium.
     * see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_SECURE
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_SECURE = 4;</code>
     */
    public static final int VIRTUAL_DISPLAY_FLAG_SECURE_VALUE = 4;
    /**
     * <pre>
     * This flag is used in conjunction with VIRTUAL_DISPLAY_FLAG_PUBLIC.
     * Ordinarily public virtual displays will automatically mirror the
     * content of the default display if they have no windows of their own.
     * When this flag is specified, the virtual display will only ever show
     * its own content and will be blanked instead if it has no windows. See
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;</code>
     */
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY_VALUE = 8;
    /**
     * <pre>
     * Allows content to be mirrored on private displays when no content is
     * being shown.
     * This flag is mutually exclusive with
     * VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY. If both flags are specified
     * then the own-content only behavior will be applied.
     * see:
     * https://developer.android.com/reference/android/hardware/display/DisplayManager#VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR)
     * </pre>
     *
     * <code>VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;</code>
     */
    public static final int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR_VALUE = 16;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DisplayFlags valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DisplayFlags forNumber(int value) {
      switch (value) {
        case 0: return DISPLAYFLAGS_UNSPECIFIED;
        case 1: return VIRTUAL_DISPLAY_FLAG_PUBLIC;
        case 2: return VIRTUAL_DISPLAY_FLAG_PRESENTATION;
        case 4: return VIRTUAL_DISPLAY_FLAG_SECURE;
        case 8: return VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY;
        case 16: return VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DisplayFlags>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DisplayFlags> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DisplayFlags>() {
            public DisplayFlags findValueByNumber(int number) {
              return DisplayFlags.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.android.emulator.control.DisplayConfiguration.getDescriptor().getEnumTypes().get(0);
    }

    private static final DisplayFlags[] VALUES = values();

    public static DisplayFlags valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DisplayFlags(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:android.emulation.control.DisplayConfiguration.DisplayFlags)
  }

  public static final int WIDTH_FIELD_NUMBER = 1;
  private int width_;
  /**
   * <pre>
   * The width of the display, restricted to:
   * 320 * (dpi / 160) &lt;= width
   * </pre>
   *
   * <code>uint32 width = 1;</code>
   * @return The width.
   */
  @java.lang.Override
  public int getWidth() {
    return width_;
  }

  public static final int HEIGHT_FIELD_NUMBER = 2;
  private int height_;
  /**
   * <pre>
   * The heigh of the display, restricted to:
   * * 320 * (dpi / 160) &lt;= height
   * </pre>
   *
   * <code>uint32 height = 2;</code>
   * @return The height.
   */
  @java.lang.Override
  public int getHeight() {
    return height_;
  }

  public static final int DPI_FIELD_NUMBER = 3;
  private int dpi_;
  /**
   * <pre>
   * The pixel density (dpi).
   * See https://developer.android.com/training/multiscreen/screendensities
   * for details. This value should be in the range [120, ..., 640]
   * </pre>
   *
   * <code>uint32 dpi = 3;</code>
   * @return The dpi.
   */
  @java.lang.Override
  public int getDpi() {
    return dpi_;
  }

  public static final int FLAGS_FIELD_NUMBER = 4;
  private int flags_;
  /**
   * <pre>
   * A combination of virtual display flags. These flags can be constructed
   * by combining the DisplayFlags enum described above.
   * The behavior of the virtual display depends on the flags. By default
   * virtual displays are created to be private, non-presentation and
   * unsecure.
   * </pre>
   *
   * <code>uint32 flags = 4;</code>
   * @return The flags.
   */
  @java.lang.Override
  public int getFlags() {
    return flags_;
  }

  public static final int DISPLAY_FIELD_NUMBER = 5;
  private int display_;
  /**
   * <pre>
   * The id of the display.
   * The primary (default) display has the display ID of 0.
   * A secondary display has a display ID not 0.
   * A display with the id in the range [1, userConfigurable]
   * can be modified. See DisplayConfigurations below for details.
   * The id can be used to get or stream a screenshot.
   * </pre>
   *
   * <code>uint32 display = 5;</code>
   * @return The display.
   */
  @java.lang.Override
  public int getDisplay() {
    return display_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (width_ != 0) {
      output.writeUInt32(1, width_);
    }
    if (height_ != 0) {
      output.writeUInt32(2, height_);
    }
    if (dpi_ != 0) {
      output.writeUInt32(3, dpi_);
    }
    if (flags_ != 0) {
      output.writeUInt32(4, flags_);
    }
    if (display_ != 0) {
      output.writeUInt32(5, display_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (width_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(1, width_);
    }
    if (height_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(2, height_);
    }
    if (dpi_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(3, dpi_);
    }
    if (flags_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(4, flags_);
    }
    if (display_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(5, display_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.android.emulator.control.DisplayConfiguration)) {
      return super.equals(obj);
    }
    com.android.emulator.control.DisplayConfiguration other = (com.android.emulator.control.DisplayConfiguration) obj;

    if (getWidth()
        != other.getWidth()) return false;
    if (getHeight()
        != other.getHeight()) return false;
    if (getDpi()
        != other.getDpi()) return false;
    if (getFlags()
        != other.getFlags()) return false;
    if (getDisplay()
        != other.getDisplay()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + WIDTH_FIELD_NUMBER;
    hash = (53 * hash) + getWidth();
    hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
    hash = (53 * hash) + getHeight();
    hash = (37 * hash) + DPI_FIELD_NUMBER;
    hash = (53 * hash) + getDpi();
    hash = (37 * hash) + FLAGS_FIELD_NUMBER;
    hash = (53 * hash) + getFlags();
    hash = (37 * hash) + DISPLAY_FIELD_NUMBER;
    hash = (53 * hash) + getDisplay();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.android.emulator.control.DisplayConfiguration parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.DisplayConfiguration parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.DisplayConfiguration parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.android.emulator.control.DisplayConfiguration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A DisplayConfiguration describes a primary or secondary
   * display available to the emulator. The screen aspect ratio
   * cannot be longer (or wider) than 21:9 (or 9:21). Screen sizes
   * larger than 4k will be rejected.
   * Common configurations (w x h) are:
   * - 480p  (480x720)   142 dpi
   * - 720p  (720x1280)  213 dpi
   * - 1080p (1080x1920) 320 dpi
   * - 4K  (2160x3840) 320 dpi
   * - 4K  (2160x3840) 640 dpi (upscaled)
   * The behavior of the virtual display depends on the flags that are provided to
   * this method. By default, virtual displays are created to be private,
   * non-presentation and unsecure.
   * </pre>
   *
   * Protobuf type {@code android.emulation.control.DisplayConfiguration}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:android.emulation.control.DisplayConfiguration)
      com.android.emulator.control.DisplayConfigurationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_DisplayConfiguration_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_DisplayConfiguration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.android.emulator.control.DisplayConfiguration.class, com.android.emulator.control.DisplayConfiguration.Builder.class);
    }

    // Construct using com.android.emulator.control.DisplayConfiguration.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      width_ = 0;

      height_ = 0;

      dpi_ = 0;

      flags_ = 0;

      display_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_DisplayConfiguration_descriptor;
    }

    @java.lang.Override
    public com.android.emulator.control.DisplayConfiguration getDefaultInstanceForType() {
      return com.android.emulator.control.DisplayConfiguration.getDefaultInstance();
    }

    @java.lang.Override
    public com.android.emulator.control.DisplayConfiguration build() {
      com.android.emulator.control.DisplayConfiguration result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.android.emulator.control.DisplayConfiguration buildPartial() {
      com.android.emulator.control.DisplayConfiguration result = new com.android.emulator.control.DisplayConfiguration(this);
      result.width_ = width_;
      result.height_ = height_;
      result.dpi_ = dpi_;
      result.flags_ = flags_;
      result.display_ = display_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.android.emulator.control.DisplayConfiguration) {
        return mergeFrom((com.android.emulator.control.DisplayConfiguration)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.android.emulator.control.DisplayConfiguration other) {
      if (other == com.android.emulator.control.DisplayConfiguration.getDefaultInstance()) return this;
      if (other.getWidth() != 0) {
        setWidth(other.getWidth());
      }
      if (other.getHeight() != 0) {
        setHeight(other.getHeight());
      }
      if (other.getDpi() != 0) {
        setDpi(other.getDpi());
      }
      if (other.getFlags() != 0) {
        setFlags(other.getFlags());
      }
      if (other.getDisplay() != 0) {
        setDisplay(other.getDisplay());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.android.emulator.control.DisplayConfiguration parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.android.emulator.control.DisplayConfiguration) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int width_ ;
    /**
     * <pre>
     * The width of the display, restricted to:
     * 320 * (dpi / 160) &lt;= width
     * </pre>
     *
     * <code>uint32 width = 1;</code>
     * @return The width.
     */
    @java.lang.Override
    public int getWidth() {
      return width_;
    }
    /**
     * <pre>
     * The width of the display, restricted to:
     * 320 * (dpi / 160) &lt;= width
     * </pre>
     *
     * <code>uint32 width = 1;</code>
     * @param value The width to set.
     * @return This builder for chaining.
     */
    public Builder setWidth(int value) {
      
      width_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The width of the display, restricted to:
     * 320 * (dpi / 160) &lt;= width
     * </pre>
     *
     * <code>uint32 width = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearWidth() {
      
      width_ = 0;
      onChanged();
      return this;
    }

    private int height_ ;
    /**
     * <pre>
     * The heigh of the display, restricted to:
     * * 320 * (dpi / 160) &lt;= height
     * </pre>
     *
     * <code>uint32 height = 2;</code>
     * @return The height.
     */
    @java.lang.Override
    public int getHeight() {
      return height_;
    }
    /**
     * <pre>
     * The heigh of the display, restricted to:
     * * 320 * (dpi / 160) &lt;= height
     * </pre>
     *
     * <code>uint32 height = 2;</code>
     * @param value The height to set.
     * @return This builder for chaining.
     */
    public Builder setHeight(int value) {
      
      height_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The heigh of the display, restricted to:
     * * 320 * (dpi / 160) &lt;= height
     * </pre>
     *
     * <code>uint32 height = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearHeight() {
      
      height_ = 0;
      onChanged();
      return this;
    }

    private int dpi_ ;
    /**
     * <pre>
     * The pixel density (dpi).
     * See https://developer.android.com/training/multiscreen/screendensities
     * for details. This value should be in the range [120, ..., 640]
     * </pre>
     *
     * <code>uint32 dpi = 3;</code>
     * @return The dpi.
     */
    @java.lang.Override
    public int getDpi() {
      return dpi_;
    }
    /**
     * <pre>
     * The pixel density (dpi).
     * See https://developer.android.com/training/multiscreen/screendensities
     * for details. This value should be in the range [120, ..., 640]
     * </pre>
     *
     * <code>uint32 dpi = 3;</code>
     * @param value The dpi to set.
     * @return This builder for chaining.
     */
    public Builder setDpi(int value) {
      
      dpi_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The pixel density (dpi).
     * See https://developer.android.com/training/multiscreen/screendensities
     * for details. This value should be in the range [120, ..., 640]
     * </pre>
     *
     * <code>uint32 dpi = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearDpi() {
      
      dpi_ = 0;
      onChanged();
      return this;
    }

    private int flags_ ;
    /**
     * <pre>
     * A combination of virtual display flags. These flags can be constructed
     * by combining the DisplayFlags enum described above.
     * The behavior of the virtual display depends on the flags. By default
     * virtual displays are created to be private, non-presentation and
     * unsecure.
     * </pre>
     *
     * <code>uint32 flags = 4;</code>
     * @return The flags.
     */
    @java.lang.Override
    public int getFlags() {
      return flags_;
    }
    /**
     * <pre>
     * A combination of virtual display flags. These flags can be constructed
     * by combining the DisplayFlags enum described above.
     * The behavior of the virtual display depends on the flags. By default
     * virtual displays are created to be private, non-presentation and
     * unsecure.
     * </pre>
     *
     * <code>uint32 flags = 4;</code>
     * @param value The flags to set.
     * @return This builder for chaining.
     */
    public Builder setFlags(int value) {
      
      flags_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A combination of virtual display flags. These flags can be constructed
     * by combining the DisplayFlags enum described above.
     * The behavior of the virtual display depends on the flags. By default
     * virtual displays are created to be private, non-presentation and
     * unsecure.
     * </pre>
     *
     * <code>uint32 flags = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearFlags() {
      
      flags_ = 0;
      onChanged();
      return this;
    }

    private int display_ ;
    /**
     * <pre>
     * The id of the display.
     * The primary (default) display has the display ID of 0.
     * A secondary display has a display ID not 0.
     * A display with the id in the range [1, userConfigurable]
     * can be modified. See DisplayConfigurations below for details.
     * The id can be used to get or stream a screenshot.
     * </pre>
     *
     * <code>uint32 display = 5;</code>
     * @return The display.
     */
    @java.lang.Override
    public int getDisplay() {
      return display_;
    }
    /**
     * <pre>
     * The id of the display.
     * The primary (default) display has the display ID of 0.
     * A secondary display has a display ID not 0.
     * A display with the id in the range [1, userConfigurable]
     * can be modified. See DisplayConfigurations below for details.
     * The id can be used to get or stream a screenshot.
     * </pre>
     *
     * <code>uint32 display = 5;</code>
     * @param value The display to set.
     * @return This builder for chaining.
     */
    public Builder setDisplay(int value) {
      
      display_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The id of the display.
     * The primary (default) display has the display ID of 0.
     * A secondary display has a display ID not 0.
     * A display with the id in the range [1, userConfigurable]
     * can be modified. See DisplayConfigurations below for details.
     * The id can be used to get or stream a screenshot.
     * </pre>
     *
     * <code>uint32 display = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearDisplay() {
      
      display_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:android.emulation.control.DisplayConfiguration)
  }

  // @@protoc_insertion_point(class_scope:android.emulation.control.DisplayConfiguration)
  private static final com.android.emulator.control.DisplayConfiguration DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.android.emulator.control.DisplayConfiguration();
  }

  public static com.android.emulator.control.DisplayConfiguration getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DisplayConfiguration>
      PARSER = new com.google.protobuf.AbstractParser<DisplayConfiguration>() {
    @java.lang.Override
    public DisplayConfiguration parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new DisplayConfiguration(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<DisplayConfiguration> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DisplayConfiguration> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.android.emulator.control.DisplayConfiguration getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

