// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: emulator_controller.proto

package com.android.emulator.control;

/**
 * <pre>
 * KeyboardEvent objects describe a user interaction with the keyboard; each
 * event describes a single interaction between the user and a key (or
 * combination of a key with modifier keys) on the keyboard.
 * This follows the pattern as set by
 * (javascript)[https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent]
 * Note: that only keyCode, key, or text can be set and that the semantics
 * will slightly vary.
 * </pre>
 *
 * Protobuf type {@code android.emulation.control.KeyboardEvent}
 */
public final class KeyboardEvent extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:android.emulation.control.KeyboardEvent)
    KeyboardEventOrBuilder {
private static final long serialVersionUID = 0L;
  // Use KeyboardEvent.newBuilder() to construct.
  private KeyboardEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private KeyboardEvent() {
    codeType_ = 0;
    eventType_ = 0;
    key_ = "";
    text_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new KeyboardEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private KeyboardEvent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {
            int rawValue = input.readEnum();

            codeType_ = rawValue;
            break;
          }
          case 16: {
            int rawValue = input.readEnum();

            eventType_ = rawValue;
            break;
          }
          case 24: {

            keyCode_ = input.readInt32();
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            key_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            text_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_KeyboardEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_KeyboardEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.android.emulator.control.KeyboardEvent.class, com.android.emulator.control.KeyboardEvent.Builder.class);
  }

  /**
   * <pre>
   * Code types that the emulator can receive. Note that the emulator
   * will do its best to translate the code to an evdev value that
   * will be send to the emulator. This translation is based on
   * the chromium translation tables. See
   * (this)[https://android.googlesource.com/platform/external/qemu/+/refs/heads/emu-master-dev/android/android-grpc/android/emulation/control/keyboard/keycode_converter_data.inc]
   * for details on the translation.
   * </pre>
   *
   * Protobuf enum {@code android.emulation.control.KeyboardEvent.KeyCodeType}
   */
  public enum KeyCodeType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>Usb = 0;</code>
     */
    Usb(0),
    /**
     * <code>Evdev = 1;</code>
     */
    Evdev(1),
    /**
     * <code>XKB = 2;</code>
     */
    XKB(2),
    /**
     * <code>Win = 3;</code>
     */
    Win(3),
    /**
     * <code>Mac = 4;</code>
     */
    Mac(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>Usb = 0;</code>
     */
    public static final int Usb_VALUE = 0;
    /**
     * <code>Evdev = 1;</code>
     */
    public static final int Evdev_VALUE = 1;
    /**
     * <code>XKB = 2;</code>
     */
    public static final int XKB_VALUE = 2;
    /**
     * <code>Win = 3;</code>
     */
    public static final int Win_VALUE = 3;
    /**
     * <code>Mac = 4;</code>
     */
    public static final int Mac_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyCodeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyCodeType forNumber(int value) {
      switch (value) {
        case 0: return Usb;
        case 1: return Evdev;
        case 2: return XKB;
        case 3: return Win;
        case 4: return Mac;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyCodeType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        KeyCodeType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<KeyCodeType>() {
            public KeyCodeType findValueByNumber(int number) {
              return KeyCodeType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.android.emulator.control.KeyboardEvent.getDescriptor().getEnumTypes().get(0);
    }

    private static final KeyCodeType[] VALUES = values();

    public static KeyCodeType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyCodeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:android.emulation.control.KeyboardEvent.KeyCodeType)
  }

  /**
   * Protobuf enum {@code android.emulation.control.KeyboardEvent.KeyEventType}
   */
  public enum KeyEventType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Indicates that this keyevent should be send to the emulator
     * as a key down event. Meaning that the key event will be
     * translated to an EvDev event type and bit 11 (0x400) will be
     * set before it is sent to the emulator.
     * </pre>
     *
     * <code>keydown = 0;</code>
     */
    keydown(0),
    /**
     * <pre>
     * Indicates that the keyevent should be send to the emulator
     * as a key up event. Meaning that the key event will be
     * translated to an EvDev event type and
     * sent to the emulator.
     * </pre>
     *
     * <code>keyup = 1;</code>
     */
    keyup(1),
    /**
     * <pre>
     * Indicates that the keyevent will be send to the emulator
     * as e key down event and immediately followed by a keyup event.
     * </pre>
     *
     * <code>keypress = 2;</code>
     */
    keypress(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Indicates that this keyevent should be send to the emulator
     * as a key down event. Meaning that the key event will be
     * translated to an EvDev event type and bit 11 (0x400) will be
     * set before it is sent to the emulator.
     * </pre>
     *
     * <code>keydown = 0;</code>
     */
    public static final int keydown_VALUE = 0;
    /**
     * <pre>
     * Indicates that the keyevent should be send to the emulator
     * as a key up event. Meaning that the key event will be
     * translated to an EvDev event type and
     * sent to the emulator.
     * </pre>
     *
     * <code>keyup = 1;</code>
     */
    public static final int keyup_VALUE = 1;
    /**
     * <pre>
     * Indicates that the keyevent will be send to the emulator
     * as e key down event and immediately followed by a keyup event.
     * </pre>
     *
     * <code>keypress = 2;</code>
     */
    public static final int keypress_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyEventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyEventType forNumber(int value) {
      switch (value) {
        case 0: return keydown;
        case 1: return keyup;
        case 2: return keypress;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyEventType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        KeyEventType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<KeyEventType>() {
            public KeyEventType findValueByNumber(int number) {
              return KeyEventType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.android.emulator.control.KeyboardEvent.getDescriptor().getEnumTypes().get(1);
    }

    private static final KeyEventType[] VALUES = values();

    public static KeyEventType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyEventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:android.emulation.control.KeyboardEvent.KeyEventType)
  }

  public static final int CODETYPE_FIELD_NUMBER = 1;
  private int codeType_;
  /**
   * <pre>
   * Type of keycode contained in the keyCode field.
   * </pre>
   *
   * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
   * @return The enum numeric value on the wire for codeType.
   */
  @java.lang.Override public int getCodeTypeValue() {
    return codeType_;
  }
  /**
   * <pre>
   * Type of keycode contained in the keyCode field.
   * </pre>
   *
   * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
   * @return The codeType.
   */
  @java.lang.Override public com.android.emulator.control.KeyboardEvent.KeyCodeType getCodeType() {
    @SuppressWarnings("deprecation")
    com.android.emulator.control.KeyboardEvent.KeyCodeType result = com.android.emulator.control.KeyboardEvent.KeyCodeType.valueOf(codeType_);
    return result == null ? com.android.emulator.control.KeyboardEvent.KeyCodeType.UNRECOGNIZED : result;
  }

  public static final int EVENTTYPE_FIELD_NUMBER = 2;
  private int eventType_;
  /**
   * <pre>
   * The type of keyboard event that should be sent to the emulator
   * </pre>
   *
   * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
   * @return The enum numeric value on the wire for eventType.
   */
  @java.lang.Override public int getEventTypeValue() {
    return eventType_;
  }
  /**
   * <pre>
   * The type of keyboard event that should be sent to the emulator
   * </pre>
   *
   * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
   * @return The eventType.
   */
  @java.lang.Override public com.android.emulator.control.KeyboardEvent.KeyEventType getEventType() {
    @SuppressWarnings("deprecation")
    com.android.emulator.control.KeyboardEvent.KeyEventType result = com.android.emulator.control.KeyboardEvent.KeyEventType.valueOf(eventType_);
    return result == null ? com.android.emulator.control.KeyboardEvent.KeyEventType.UNRECOGNIZED : result;
  }

  public static final int KEYCODE_FIELD_NUMBER = 3;
  private int keyCode_;
  /**
   * <pre>
   * This property represents a physical key on the keyboard (as opposed
   * to the character generated by pressing the key). In other words, this
   * property is a value which isn't altered by keyboard layout or the
   * state of the modifier keys. This value will be interpreted by the
   * emulator depending on the KeyCodeType. The incoming key code will be
   * translated to an evdev code type and send to the emulator.
   * The values in key and text will be ignored.
   * </pre>
   *
   * <code>int32 keyCode = 3;</code>
   * @return The keyCode.
   */
  @java.lang.Override
  public int getKeyCode() {
    return keyCode_;
  }

  public static final int KEY_FIELD_NUMBER = 4;
  private volatile java.lang.Object key_;
  /**
   * <pre>
   * The value of the key pressed by the user, taking into consideration
   * the state of modifier keys such as Shift as well as the keyboard
   * locale and layout. This follows the w3c standard used in browsers.
   * You can find an accurate description of valid values
   * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
   * Note that some keys can result in multiple evdev events that are
   * delivered to the emulator. for example the Key "A" will result in a
   * sequence:
   * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
   * Not all documented keys are understood by android, and only printable
   * ASCII [32-127) characters are properly translated.
   * Keep in mind that there are a set of key values that result in android
   * specific behavior
   * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
   * - "AppSwitch": Behaves as the "Overview" button in android.
   * - "GoBack": The Back button.
   * - "GoHome": The Home button, which takes the user to the phone's main
   *             screen (usually an application launcher).
   * - "Power":  The Power button.
   * </pre>
   *
   * <code>string key = 4;</code>
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The value of the key pressed by the user, taking into consideration
   * the state of modifier keys such as Shift as well as the keyboard
   * locale and layout. This follows the w3c standard used in browsers.
   * You can find an accurate description of valid values
   * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
   * Note that some keys can result in multiple evdev events that are
   * delivered to the emulator. for example the Key "A" will result in a
   * sequence:
   * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
   * Not all documented keys are understood by android, and only printable
   * ASCII [32-127) characters are properly translated.
   * Keep in mind that there are a set of key values that result in android
   * specific behavior
   * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
   * - "AppSwitch": Behaves as the "Overview" button in android.
   * - "GoBack": The Back button.
   * - "GoHome": The Home button, which takes the user to the phone's main
   *             screen (usually an application launcher).
   * - "Power":  The Power button.
   * </pre>
   *
   * <code>string key = 4;</code>
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_FIELD_NUMBER = 5;
  private volatile java.lang.Object text_;
  /**
   * <pre>
   * Series of utf8 encoded characters to send to the emulator. An attempt
   * will be made to translate every character will an EvDev event type and
   * send to the emulator as a keypress event. The values in keyCode,
   * eventType, codeType and key will be ignored.
   * Note that most printable ASCII characters (range [32-127) can be send
   * individually with the "key" param. Do not expect arbitrary UTF symbols to
   * arrive in the emulator (most will be ignored).
   * Note that it is possible to overrun the keyboard buffer by slamming this
   * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
   * suited for transferring large quantities of text.
   * </pre>
   *
   * <code>string text = 5;</code>
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Series of utf8 encoded characters to send to the emulator. An attempt
   * will be made to translate every character will an EvDev event type and
   * send to the emulator as a keypress event. The values in keyCode,
   * eventType, codeType and key will be ignored.
   * Note that most printable ASCII characters (range [32-127) can be send
   * individually with the "key" param. Do not expect arbitrary UTF symbols to
   * arrive in the emulator (most will be ignored).
   * Note that it is possible to overrun the keyboard buffer by slamming this
   * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
   * suited for transferring large quantities of text.
   * </pre>
   *
   * <code>string text = 5;</code>
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (codeType_ != com.android.emulator.control.KeyboardEvent.KeyCodeType.Usb.getNumber()) {
      output.writeEnum(1, codeType_);
    }
    if (eventType_ != com.android.emulator.control.KeyboardEvent.KeyEventType.keydown.getNumber()) {
      output.writeEnum(2, eventType_);
    }
    if (keyCode_ != 0) {
      output.writeInt32(3, keyCode_);
    }
    if (!getKeyBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, key_);
    }
    if (!getTextBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, text_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (codeType_ != com.android.emulator.control.KeyboardEvent.KeyCodeType.Usb.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, codeType_);
    }
    if (eventType_ != com.android.emulator.control.KeyboardEvent.KeyEventType.keydown.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, eventType_);
    }
    if (keyCode_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(3, keyCode_);
    }
    if (!getKeyBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, key_);
    }
    if (!getTextBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, text_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.android.emulator.control.KeyboardEvent)) {
      return super.equals(obj);
    }
    com.android.emulator.control.KeyboardEvent other = (com.android.emulator.control.KeyboardEvent) obj;

    if (codeType_ != other.codeType_) return false;
    if (eventType_ != other.eventType_) return false;
    if (getKeyCode()
        != other.getKeyCode()) return false;
    if (!getKey()
        .equals(other.getKey())) return false;
    if (!getText()
        .equals(other.getText())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODETYPE_FIELD_NUMBER;
    hash = (53 * hash) + codeType_;
    hash = (37 * hash) + EVENTTYPE_FIELD_NUMBER;
    hash = (53 * hash) + eventType_;
    hash = (37 * hash) + KEYCODE_FIELD_NUMBER;
    hash = (53 * hash) + getKeyCode();
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.android.emulator.control.KeyboardEvent parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.android.emulator.control.KeyboardEvent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.KeyboardEvent parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.android.emulator.control.KeyboardEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.android.emulator.control.KeyboardEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * KeyboardEvent objects describe a user interaction with the keyboard; each
   * event describes a single interaction between the user and a key (or
   * combination of a key with modifier keys) on the keyboard.
   * This follows the pattern as set by
   * (javascript)[https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent]
   * Note: that only keyCode, key, or text can be set and that the semantics
   * will slightly vary.
   * </pre>
   *
   * Protobuf type {@code android.emulation.control.KeyboardEvent}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:android.emulation.control.KeyboardEvent)
      com.android.emulator.control.KeyboardEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_KeyboardEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_KeyboardEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.android.emulator.control.KeyboardEvent.class, com.android.emulator.control.KeyboardEvent.Builder.class);
    }

    // Construct using com.android.emulator.control.KeyboardEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      codeType_ = 0;

      eventType_ = 0;

      keyCode_ = 0;

      key_ = "";

      text_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.android.emulator.control.EmulatorControllerOuterClass.internal_static_android_emulation_control_KeyboardEvent_descriptor;
    }

    @java.lang.Override
    public com.android.emulator.control.KeyboardEvent getDefaultInstanceForType() {
      return com.android.emulator.control.KeyboardEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.android.emulator.control.KeyboardEvent build() {
      com.android.emulator.control.KeyboardEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.android.emulator.control.KeyboardEvent buildPartial() {
      com.android.emulator.control.KeyboardEvent result = new com.android.emulator.control.KeyboardEvent(this);
      result.codeType_ = codeType_;
      result.eventType_ = eventType_;
      result.keyCode_ = keyCode_;
      result.key_ = key_;
      result.text_ = text_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.android.emulator.control.KeyboardEvent) {
        return mergeFrom((com.android.emulator.control.KeyboardEvent)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.android.emulator.control.KeyboardEvent other) {
      if (other == com.android.emulator.control.KeyboardEvent.getDefaultInstance()) return this;
      if (other.codeType_ != 0) {
        setCodeTypeValue(other.getCodeTypeValue());
      }
      if (other.eventType_ != 0) {
        setEventTypeValue(other.getEventTypeValue());
      }
      if (other.getKeyCode() != 0) {
        setKeyCode(other.getKeyCode());
      }
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        onChanged();
      }
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.android.emulator.control.KeyboardEvent parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.android.emulator.control.KeyboardEvent) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int codeType_ = 0;
    /**
     * <pre>
     * Type of keycode contained in the keyCode field.
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
     * @return The enum numeric value on the wire for codeType.
     */
    @java.lang.Override public int getCodeTypeValue() {
      return codeType_;
    }
    /**
     * <pre>
     * Type of keycode contained in the keyCode field.
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
     * @param value The enum numeric value on the wire for codeType to set.
     * @return This builder for chaining.
     */
    public Builder setCodeTypeValue(int value) {
      
      codeType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of keycode contained in the keyCode field.
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
     * @return The codeType.
     */
    @java.lang.Override
    public com.android.emulator.control.KeyboardEvent.KeyCodeType getCodeType() {
      @SuppressWarnings("deprecation")
      com.android.emulator.control.KeyboardEvent.KeyCodeType result = com.android.emulator.control.KeyboardEvent.KeyCodeType.valueOf(codeType_);
      return result == null ? com.android.emulator.control.KeyboardEvent.KeyCodeType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Type of keycode contained in the keyCode field.
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
     * @param value The codeType to set.
     * @return This builder for chaining.
     */
    public Builder setCodeType(com.android.emulator.control.KeyboardEvent.KeyCodeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      codeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of keycode contained in the keyCode field.
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyCodeType codeType = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearCodeType() {
      
      codeType_ = 0;
      onChanged();
      return this;
    }

    private int eventType_ = 0;
    /**
     * <pre>
     * The type of keyboard event that should be sent to the emulator
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
     * @return The enum numeric value on the wire for eventType.
     */
    @java.lang.Override public int getEventTypeValue() {
      return eventType_;
    }
    /**
     * <pre>
     * The type of keyboard event that should be sent to the emulator
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
     * @param value The enum numeric value on the wire for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeValue(int value) {
      
      eventType_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The type of keyboard event that should be sent to the emulator
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
     * @return The eventType.
     */
    @java.lang.Override
    public com.android.emulator.control.KeyboardEvent.KeyEventType getEventType() {
      @SuppressWarnings("deprecation")
      com.android.emulator.control.KeyboardEvent.KeyEventType result = com.android.emulator.control.KeyboardEvent.KeyEventType.valueOf(eventType_);
      return result == null ? com.android.emulator.control.KeyboardEvent.KeyEventType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The type of keyboard event that should be sent to the emulator
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(com.android.emulator.control.KeyboardEvent.KeyEventType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      eventType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The type of keyboard event that should be sent to the emulator
     * </pre>
     *
     * <code>.android.emulation.control.KeyboardEvent.KeyEventType eventType = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      
      eventType_ = 0;
      onChanged();
      return this;
    }

    private int keyCode_ ;
    /**
     * <pre>
     * This property represents a physical key on the keyboard (as opposed
     * to the character generated by pressing the key). In other words, this
     * property is a value which isn't altered by keyboard layout or the
     * state of the modifier keys. This value will be interpreted by the
     * emulator depending on the KeyCodeType. The incoming key code will be
     * translated to an evdev code type and send to the emulator.
     * The values in key and text will be ignored.
     * </pre>
     *
     * <code>int32 keyCode = 3;</code>
     * @return The keyCode.
     */
    @java.lang.Override
    public int getKeyCode() {
      return keyCode_;
    }
    /**
     * <pre>
     * This property represents a physical key on the keyboard (as opposed
     * to the character generated by pressing the key). In other words, this
     * property is a value which isn't altered by keyboard layout or the
     * state of the modifier keys. This value will be interpreted by the
     * emulator depending on the KeyCodeType. The incoming key code will be
     * translated to an evdev code type and send to the emulator.
     * The values in key and text will be ignored.
     * </pre>
     *
     * <code>int32 keyCode = 3;</code>
     * @param value The keyCode to set.
     * @return This builder for chaining.
     */
    public Builder setKeyCode(int value) {
      
      keyCode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This property represents a physical key on the keyboard (as opposed
     * to the character generated by pressing the key). In other words, this
     * property is a value which isn't altered by keyboard layout or the
     * state of the modifier keys. This value will be interpreted by the
     * emulator depending on the KeyCodeType. The incoming key code will be
     * translated to an evdev code type and send to the emulator.
     * The values in key and text will be ignored.
     * </pre>
     *
     * <code>int32 keyCode = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearKeyCode() {
      
      keyCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object key_ = "";
    /**
     * <pre>
     * The value of the key pressed by the user, taking into consideration
     * the state of modifier keys such as Shift as well as the keyboard
     * locale and layout. This follows the w3c standard used in browsers.
     * You can find an accurate description of valid values
     * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
     * Note that some keys can result in multiple evdev events that are
     * delivered to the emulator. for example the Key "A" will result in a
     * sequence:
     * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
     * Not all documented keys are understood by android, and only printable
     * ASCII [32-127) characters are properly translated.
     * Keep in mind that there are a set of key values that result in android
     * specific behavior
     * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
     * - "AppSwitch": Behaves as the "Overview" button in android.
     * - "GoBack": The Back button.
     * - "GoHome": The Home button, which takes the user to the phone's main
     *             screen (usually an application launcher).
     * - "Power":  The Power button.
     * </pre>
     *
     * <code>string key = 4;</code>
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The value of the key pressed by the user, taking into consideration
     * the state of modifier keys such as Shift as well as the keyboard
     * locale and layout. This follows the w3c standard used in browsers.
     * You can find an accurate description of valid values
     * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
     * Note that some keys can result in multiple evdev events that are
     * delivered to the emulator. for example the Key "A" will result in a
     * sequence:
     * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
     * Not all documented keys are understood by android, and only printable
     * ASCII [32-127) characters are properly translated.
     * Keep in mind that there are a set of key values that result in android
     * specific behavior
     * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
     * - "AppSwitch": Behaves as the "Overview" button in android.
     * - "GoBack": The Back button.
     * - "GoHome": The Home button, which takes the user to the phone's main
     *             screen (usually an application launcher).
     * - "Power":  The Power button.
     * </pre>
     *
     * <code>string key = 4;</code>
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The value of the key pressed by the user, taking into consideration
     * the state of modifier keys such as Shift as well as the keyboard
     * locale and layout. This follows the w3c standard used in browsers.
     * You can find an accurate description of valid values
     * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
     * Note that some keys can result in multiple evdev events that are
     * delivered to the emulator. for example the Key "A" will result in a
     * sequence:
     * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
     * Not all documented keys are understood by android, and only printable
     * ASCII [32-127) characters are properly translated.
     * Keep in mind that there are a set of key values that result in android
     * specific behavior
     * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
     * - "AppSwitch": Behaves as the "Overview" button in android.
     * - "GoBack": The Back button.
     * - "GoHome": The Home button, which takes the user to the phone's main
     *             screen (usually an application launcher).
     * - "Power":  The Power button.
     * </pre>
     *
     * <code>string key = 4;</code>
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      key_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The value of the key pressed by the user, taking into consideration
     * the state of modifier keys such as Shift as well as the keyboard
     * locale and layout. This follows the w3c standard used in browsers.
     * You can find an accurate description of valid values
     * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
     * Note that some keys can result in multiple evdev events that are
     * delivered to the emulator. for example the Key "A" will result in a
     * sequence:
     * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
     * Not all documented keys are understood by android, and only printable
     * ASCII [32-127) characters are properly translated.
     * Keep in mind that there are a set of key values that result in android
     * specific behavior
     * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
     * - "AppSwitch": Behaves as the "Overview" button in android.
     * - "GoBack": The Back button.
     * - "GoHome": The Home button, which takes the user to the phone's main
     *             screen (usually an application launcher).
     * - "Power":  The Power button.
     * </pre>
     *
     * <code>string key = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearKey() {
      
      key_ = getDefaultInstance().getKey();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The value of the key pressed by the user, taking into consideration
     * the state of modifier keys such as Shift as well as the keyboard
     * locale and layout. This follows the w3c standard used in browsers.
     * You can find an accurate description of valid values
     * [here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values)
     * Note that some keys can result in multiple evdev events that are
     * delivered to the emulator. for example the Key "A" will result in a
     * sequence:
     * ["Shift", "a"] -&gt; [0x2a, 0x1e] whereas "a" results in ["a"] -&gt; [0x1e].
     * Not all documented keys are understood by android, and only printable
     * ASCII [32-127) characters are properly translated.
     * Keep in mind that there are a set of key values that result in android
     * specific behavior
     * [see](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values#Phone_keys):
     * - "AppSwitch": Behaves as the "Overview" button in android.
     * - "GoBack": The Back button.
     * - "GoHome": The Home button, which takes the user to the phone's main
     *             screen (usually an application launcher).
     * - "Power":  The Power button.
     * </pre>
     *
     * <code>string key = 4;</code>
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      key_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object text_ = "";
    /**
     * <pre>
     * Series of utf8 encoded characters to send to the emulator. An attempt
     * will be made to translate every character will an EvDev event type and
     * send to the emulator as a keypress event. The values in keyCode,
     * eventType, codeType and key will be ignored.
     * Note that most printable ASCII characters (range [32-127) can be send
     * individually with the "key" param. Do not expect arbitrary UTF symbols to
     * arrive in the emulator (most will be ignored).
     * Note that it is possible to overrun the keyboard buffer by slamming this
     * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
     * suited for transferring large quantities of text.
     * </pre>
     *
     * <code>string text = 5;</code>
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Series of utf8 encoded characters to send to the emulator. An attempt
     * will be made to translate every character will an EvDev event type and
     * send to the emulator as a keypress event. The values in keyCode,
     * eventType, codeType and key will be ignored.
     * Note that most printable ASCII characters (range [32-127) can be send
     * individually with the "key" param. Do not expect arbitrary UTF symbols to
     * arrive in the emulator (most will be ignored).
     * Note that it is possible to overrun the keyboard buffer by slamming this
     * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
     * suited for transferring large quantities of text.
     * </pre>
     *
     * <code>string text = 5;</code>
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString
        getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Series of utf8 encoded characters to send to the emulator. An attempt
     * will be made to translate every character will an EvDev event type and
     * send to the emulator as a keypress event. The values in keyCode,
     * eventType, codeType and key will be ignored.
     * Note that most printable ASCII characters (range [32-127) can be send
     * individually with the "key" param. Do not expect arbitrary UTF symbols to
     * arrive in the emulator (most will be ignored).
     * Note that it is possible to overrun the keyboard buffer by slamming this
     * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
     * suited for transferring large quantities of text.
     * </pre>
     *
     * <code>string text = 5;</code>
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      text_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Series of utf8 encoded characters to send to the emulator. An attempt
     * will be made to translate every character will an EvDev event type and
     * send to the emulator as a keypress event. The values in keyCode,
     * eventType, codeType and key will be ignored.
     * Note that most printable ASCII characters (range [32-127) can be send
     * individually with the "key" param. Do not expect arbitrary UTF symbols to
     * arrive in the emulator (most will be ignored).
     * Note that it is possible to overrun the keyboard buffer by slamming this
     * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
     * suited for transferring large quantities of text.
     * </pre>
     *
     * <code>string text = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearText() {
      
      text_ = getDefaultInstance().getText();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Series of utf8 encoded characters to send to the emulator. An attempt
     * will be made to translate every character will an EvDev event type and
     * send to the emulator as a keypress event. The values in keyCode,
     * eventType, codeType and key will be ignored.
     * Note that most printable ASCII characters (range [32-127) can be send
     * individually with the "key" param. Do not expect arbitrary UTF symbols to
     * arrive in the emulator (most will be ignored).
     * Note that it is possible to overrun the keyboard buffer by slamming this
     * endpoint with large quantities of text (&gt;1kb). The clipboard api is better
     * suited for transferring large quantities of text.
     * </pre>
     *
     * <code>string text = 5;</code>
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      text_ = value;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:android.emulation.control.KeyboardEvent)
  }

  // @@protoc_insertion_point(class_scope:android.emulation.control.KeyboardEvent)
  private static final com.android.emulator.control.KeyboardEvent DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.android.emulator.control.KeyboardEvent();
  }

  public static com.android.emulator.control.KeyboardEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyboardEvent>
      PARSER = new com.google.protobuf.AbstractParser<KeyboardEvent>() {
    @java.lang.Override
    public KeyboardEvent parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new KeyboardEvent(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<KeyboardEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyboardEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.android.emulator.control.KeyboardEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

