package com.android.emulator.control;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * An RTC service lets you interact with the emulator through WebRTC
 * Note that this is currently an experimental feature, and that the
 * service definition might change without notice. Use at your own risk!
 * The following endpoints are needed to establish the webrtc protocol
 * Due to limitiations in Javascript we cannot make use of bidirectional
 * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
 * details.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.45.1)",
    comments = "Source: rtc_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class RtcGrpc {

  private RtcGrpc() {}

  public static final String SERVICE_NAME = "android.emulation.control.Rtc";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.android.emulator.control.RtcId> getRequestRtcStreamMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "requestRtcStream",
      requestType = com.google.protobuf.Empty.class,
      responseType = com.android.emulator.control.RtcId.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.android.emulator.control.RtcId> getRequestRtcStreamMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, com.android.emulator.control.RtcId> getRequestRtcStreamMethod;
    if ((getRequestRtcStreamMethod = RtcGrpc.getRequestRtcStreamMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getRequestRtcStreamMethod = RtcGrpc.getRequestRtcStreamMethod) == null) {
          RtcGrpc.getRequestRtcStreamMethod = getRequestRtcStreamMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, com.android.emulator.control.RtcId>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "requestRtcStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.RtcId.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("requestRtcStream"))
              .build();
        }
      }
    }
    return getRequestRtcStreamMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.JsepMsg,
      com.google.protobuf.Empty> getSendJsepMessageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "sendJsepMessage",
      requestType = com.android.emulator.control.JsepMsg.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.JsepMsg,
      com.google.protobuf.Empty> getSendJsepMessageMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.JsepMsg, com.google.protobuf.Empty> getSendJsepMessageMethod;
    if ((getSendJsepMessageMethod = RtcGrpc.getSendJsepMessageMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getSendJsepMessageMethod = RtcGrpc.getSendJsepMessageMethod) == null) {
          RtcGrpc.getSendJsepMessageMethod = getSendJsepMessageMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.JsepMsg, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "sendJsepMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.JsepMsg.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("sendJsepMessage"))
              .build();
        }
      }
    }
    return getSendJsepMessageMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.RtcId,
      com.android.emulator.control.JsepMsg> getReceiveJsepMessagesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "receiveJsepMessages",
      requestType = com.android.emulator.control.RtcId.class,
      responseType = com.android.emulator.control.JsepMsg.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.RtcId,
      com.android.emulator.control.JsepMsg> getReceiveJsepMessagesMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.RtcId, com.android.emulator.control.JsepMsg> getReceiveJsepMessagesMethod;
    if ((getReceiveJsepMessagesMethod = RtcGrpc.getReceiveJsepMessagesMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getReceiveJsepMessagesMethod = RtcGrpc.getReceiveJsepMessagesMethod) == null) {
          RtcGrpc.getReceiveJsepMessagesMethod = getReceiveJsepMessagesMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.RtcId, com.android.emulator.control.JsepMsg>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "receiveJsepMessages"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.RtcId.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.JsepMsg.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("receiveJsepMessages"))
              .build();
        }
      }
    }
    return getReceiveJsepMessagesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.android.emulator.control.RtcId,
      com.android.emulator.control.JsepMsg> getReceiveJsepMessageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "receiveJsepMessage",
      requestType = com.android.emulator.control.RtcId.class,
      responseType = com.android.emulator.control.JsepMsg.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.android.emulator.control.RtcId,
      com.android.emulator.control.JsepMsg> getReceiveJsepMessageMethod() {
    io.grpc.MethodDescriptor<com.android.emulator.control.RtcId, com.android.emulator.control.JsepMsg> getReceiveJsepMessageMethod;
    if ((getReceiveJsepMessageMethod = RtcGrpc.getReceiveJsepMessageMethod) == null) {
      synchronized (RtcGrpc.class) {
        if ((getReceiveJsepMessageMethod = RtcGrpc.getReceiveJsepMessageMethod) == null) {
          RtcGrpc.getReceiveJsepMessageMethod = getReceiveJsepMessageMethod =
              io.grpc.MethodDescriptor.<com.android.emulator.control.RtcId, com.android.emulator.control.JsepMsg>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "receiveJsepMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.RtcId.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.android.emulator.control.JsepMsg.getDefaultInstance()))
              .setSchemaDescriptor(new RtcMethodDescriptorSupplier("receiveJsepMessage"))
              .build();
        }
      }
    }
    return getReceiveJsepMessageMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static RtcStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcStub>() {
        @java.lang.Override
        public RtcStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcStub(channel, callOptions);
        }
      };
    return RtcStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static RtcBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcBlockingStub>() {
        @java.lang.Override
        public RtcBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcBlockingStub(channel, callOptions);
        }
      };
    return RtcBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static RtcFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<RtcFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<RtcFutureStub>() {
        @java.lang.Override
        public RtcFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new RtcFutureStub(channel, callOptions);
        }
      };
    return RtcFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static abstract class RtcImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public void requestRtcStream(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.RtcId> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRequestRtcStreamMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public void sendJsepMessage(com.android.emulator.control.JsepMsg request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSendJsepMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessages(com.android.emulator.control.RtcId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReceiveJsepMessagesMethod(), responseObserver);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessage(com.android.emulator.control.RtcId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReceiveJsepMessageMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getRequestRtcStreamMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                com.android.emulator.control.RtcId>(
                  this, METHODID_REQUEST_RTC_STREAM)))
          .addMethod(
            getSendJsepMessageMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.android.emulator.control.JsepMsg,
                com.google.protobuf.Empty>(
                  this, METHODID_SEND_JSEP_MESSAGE)))
          .addMethod(
            getReceiveJsepMessagesMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                com.android.emulator.control.RtcId,
                com.android.emulator.control.JsepMsg>(
                  this, METHODID_RECEIVE_JSEP_MESSAGES)))
          .addMethod(
            getReceiveJsepMessageMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.android.emulator.control.RtcId,
                com.android.emulator.control.JsepMsg>(
                  this, METHODID_RECEIVE_JSEP_MESSAGE)))
          .build();
    }
  }

  /**
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcStub extends io.grpc.stub.AbstractAsyncStub<RtcStub> {
    private RtcStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public void requestRtcStream(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.RtcId> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRequestRtcStreamMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public void sendJsepMessage(com.android.emulator.control.JsepMsg request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSendJsepMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessages(com.android.emulator.control.RtcId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getReceiveJsepMessagesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public void receiveJsepMessage(com.android.emulator.control.RtcId request,
        io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReceiveJsepMessageMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcBlockingStub extends io.grpc.stub.AbstractBlockingStub<RtcBlockingStub> {
    private RtcBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public com.android.emulator.control.RtcId requestRtcStream(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRequestRtcStreamMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public com.google.protobuf.Empty sendJsepMessage(com.android.emulator.control.JsepMsg request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSendJsepMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public java.util.Iterator<com.android.emulator.control.JsepMsg> receiveJsepMessages(
        com.android.emulator.control.RtcId request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getReceiveJsepMessagesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public com.android.emulator.control.JsepMsg receiveJsepMessage(com.android.emulator.control.RtcId request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReceiveJsepMessageMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * An RTC service lets you interact with the emulator through WebRTC
   * Note that this is currently an experimental feature, and that the
   * service definition might change without notice. Use at your own risk!
   * The following endpoints are needed to establish the webrtc protocol
   * Due to limitiations in Javascript we cannot make use of bidirectional
   * endpoints See this [blog](https://grpc.io/blog/state-of-grpc-web) for
   * details.
   * </pre>
   */
  public static final class RtcFutureStub extends io.grpc.stub.AbstractFutureStub<RtcFutureStub> {
    private RtcFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RtcFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new RtcFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * This function will generate a new identifier that the client
     * should use for further interaction. It will initiate the
     * JSEP protocol on the server side.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.RtcId> requestRtcStream(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRequestRtcStreamMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Sends the given JsepMsg to the server. The RtcId in the
     * message should point to an active stream negotiation in
     * progress, otherwise the message will be ignored.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> sendJsepMessage(
        com.android.emulator.control.JsepMsg request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSendJsepMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * [DEPRECATED] This is only here as the go grpc webproxy used
     * by fuchsia does not support server side streaming. This method
     * will be removed in the future and should not be relied upon.
     * Reads an available jsep messages for the given client id,
     * blocking until one becomes available. Do not use the polling version
     * above if you opt for this one.
     * The ice candidates for example will trickle in on this callback,
     * as will the SDP negotation.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.android.emulator.control.JsepMsg> receiveJsepMessage(
        com.android.emulator.control.RtcId request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReceiveJsepMessageMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_REQUEST_RTC_STREAM = 0;
  private static final int METHODID_SEND_JSEP_MESSAGE = 1;
  private static final int METHODID_RECEIVE_JSEP_MESSAGES = 2;
  private static final int METHODID_RECEIVE_JSEP_MESSAGE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final RtcImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(RtcImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_REQUEST_RTC_STREAM:
          serviceImpl.requestRtcStream((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.RtcId>) responseObserver);
          break;
        case METHODID_SEND_JSEP_MESSAGE:
          serviceImpl.sendJsepMessage((com.android.emulator.control.JsepMsg) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_RECEIVE_JSEP_MESSAGES:
          serviceImpl.receiveJsepMessages((com.android.emulator.control.RtcId) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg>) responseObserver);
          break;
        case METHODID_RECEIVE_JSEP_MESSAGE:
          serviceImpl.receiveJsepMessage((com.android.emulator.control.RtcId) request,
              (io.grpc.stub.StreamObserver<com.android.emulator.control.JsepMsg>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class RtcBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    RtcBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.android.emulator.control.RtcService.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Rtc");
    }
  }

  private static final class RtcFileDescriptorSupplier
      extends RtcBaseDescriptorSupplier {
    RtcFileDescriptorSupplier() {}
  }

  private static final class RtcMethodDescriptorSupplier
      extends RtcBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    RtcMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (RtcGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new RtcFileDescriptorSupplier())
              .addMethod(getRequestRtcStreamMethod())
              .addMethod(getSendJsepMessageMethod())
              .addMethod(getReceiveJsepMessagesMethod())
              .addMethod(getReceiveJsepMessageMethod())
              .build();
        }
      }
    }
    return result;
  }
}
