package com.google.waterfall;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * PortForwarder service runs a port forwarding session via waterfall.
 * It allows start and stop forwarding connections when the waterfall client
 * is unable to mantains any state (e.g. the waterfall adb binary).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.45.1)",
    comments = "Source: waterfall.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class PortForwarderGrpc {

  private PortForwarderGrpc() {}

  public static final String SERVICE_NAME = "waterfall.PortForwarder";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest,
      com.google.protobuf.Empty> getForwardPortMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ForwardPort",
      requestType = com.google.waterfall.WaterfallProto.PortForwardRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest,
      com.google.protobuf.Empty> getForwardPortMethod() {
    io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest, com.google.protobuf.Empty> getForwardPortMethod;
    if ((getForwardPortMethod = PortForwarderGrpc.getForwardPortMethod) == null) {
      synchronized (PortForwarderGrpc.class) {
        if ((getForwardPortMethod = PortForwarderGrpc.getForwardPortMethod) == null) {
          PortForwarderGrpc.getForwardPortMethod = getForwardPortMethod =
              io.grpc.MethodDescriptor.<com.google.waterfall.WaterfallProto.PortForwardRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ForwardPort"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.waterfall.WaterfallProto.PortForwardRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new PortForwarderMethodDescriptorSupplier("ForwardPort"))
              .build();
        }
      }
    }
    return getForwardPortMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest,
      com.google.protobuf.Empty> getStopMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Stop",
      requestType = com.google.waterfall.WaterfallProto.PortForwardRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest,
      com.google.protobuf.Empty> getStopMethod() {
    io.grpc.MethodDescriptor<com.google.waterfall.WaterfallProto.PortForwardRequest, com.google.protobuf.Empty> getStopMethod;
    if ((getStopMethod = PortForwarderGrpc.getStopMethod) == null) {
      synchronized (PortForwarderGrpc.class) {
        if ((getStopMethod = PortForwarderGrpc.getStopMethod) == null) {
          PortForwarderGrpc.getStopMethod = getStopMethod =
              io.grpc.MethodDescriptor.<com.google.waterfall.WaterfallProto.PortForwardRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Stop"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.waterfall.WaterfallProto.PortForwardRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new PortForwarderMethodDescriptorSupplier("Stop"))
              .build();
        }
      }
    }
    return getStopMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.google.protobuf.Empty> getStopAllMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "StopAll",
      requestType = com.google.protobuf.Empty.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.google.protobuf.Empty> getStopAllMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, com.google.protobuf.Empty> getStopAllMethod;
    if ((getStopAllMethod = PortForwarderGrpc.getStopAllMethod) == null) {
      synchronized (PortForwarderGrpc.class) {
        if ((getStopAllMethod = PortForwarderGrpc.getStopAllMethod) == null) {
          PortForwarderGrpc.getStopAllMethod = getStopAllMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "StopAll"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new PortForwarderMethodDescriptorSupplier("StopAll"))
              .build();
        }
      }
    }
    return getStopAllMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.google.waterfall.WaterfallProto.ForwardedSessions> getListMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "List",
      requestType = com.google.protobuf.Empty.class,
      responseType = com.google.waterfall.WaterfallProto.ForwardedSessions.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      com.google.waterfall.WaterfallProto.ForwardedSessions> getListMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, com.google.waterfall.WaterfallProto.ForwardedSessions> getListMethod;
    if ((getListMethod = PortForwarderGrpc.getListMethod) == null) {
      synchronized (PortForwarderGrpc.class) {
        if ((getListMethod = PortForwarderGrpc.getListMethod) == null) {
          PortForwarderGrpc.getListMethod = getListMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, com.google.waterfall.WaterfallProto.ForwardedSessions>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "List"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.waterfall.WaterfallProto.ForwardedSessions.getDefaultInstance()))
              .setSchemaDescriptor(new PortForwarderMethodDescriptorSupplier("List"))
              .build();
        }
      }
    }
    return getListMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PortForwarderStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PortForwarderStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PortForwarderStub>() {
        @java.lang.Override
        public PortForwarderStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PortForwarderStub(channel, callOptions);
        }
      };
    return PortForwarderStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PortForwarderBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PortForwarderBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PortForwarderBlockingStub>() {
        @java.lang.Override
        public PortForwarderBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PortForwarderBlockingStub(channel, callOptions);
        }
      };
    return PortForwarderBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PortForwarderFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PortForwarderFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PortForwarderFutureStub>() {
        @java.lang.Override
        public PortForwarderFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PortForwarderFutureStub(channel, callOptions);
        }
      };
    return PortForwarderFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * PortForwarder service runs a port forwarding session via waterfall.
   * It allows start and stop forwarding connections when the waterfall client
   * is unable to mantains any state (e.g. the waterfall adb binary).
   * </pre>
   */
  public static abstract class PortForwarderImplBase implements io.grpc.BindableService {

    /**
     */
    public void forwardPort(com.google.waterfall.WaterfallProto.PortForwardRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getForwardPortMethod(), responseObserver);
    }

    /**
     */
    public void stop(com.google.waterfall.WaterfallProto.PortForwardRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getStopMethod(), responseObserver);
    }

    /**
     */
    public void stopAll(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getStopAllMethod(), responseObserver);
    }

    /**
     */
    public void list(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.google.waterfall.WaterfallProto.ForwardedSessions> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getForwardPortMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.google.waterfall.WaterfallProto.PortForwardRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_FORWARD_PORT)))
          .addMethod(
            getStopMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.google.waterfall.WaterfallProto.PortForwardRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_STOP)))
          .addMethod(
            getStopAllMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty>(
                  this, METHODID_STOP_ALL)))
          .addMethod(
            getListMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                com.google.waterfall.WaterfallProto.ForwardedSessions>(
                  this, METHODID_LIST)))
          .build();
    }
  }

  /**
   * <pre>
   * PortForwarder service runs a port forwarding session via waterfall.
   * It allows start and stop forwarding connections when the waterfall client
   * is unable to mantains any state (e.g. the waterfall adb binary).
   * </pre>
   */
  public static final class PortForwarderStub extends io.grpc.stub.AbstractAsyncStub<PortForwarderStub> {
    private PortForwarderStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PortForwarderStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PortForwarderStub(channel, callOptions);
    }

    /**
     */
    public void forwardPort(com.google.waterfall.WaterfallProto.PortForwardRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getForwardPortMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void stop(com.google.waterfall.WaterfallProto.PortForwardRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getStopMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void stopAll(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getStopAllMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void list(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<com.google.waterfall.WaterfallProto.ForwardedSessions> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * PortForwarder service runs a port forwarding session via waterfall.
   * It allows start and stop forwarding connections when the waterfall client
   * is unable to mantains any state (e.g. the waterfall adb binary).
   * </pre>
   */
  public static final class PortForwarderBlockingStub extends io.grpc.stub.AbstractBlockingStub<PortForwarderBlockingStub> {
    private PortForwarderBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PortForwarderBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PortForwarderBlockingStub(channel, callOptions);
    }

    /**
     */
    public com.google.protobuf.Empty forwardPort(com.google.waterfall.WaterfallProto.PortForwardRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getForwardPortMethod(), getCallOptions(), request);
    }

    /**
     */
    public com.google.protobuf.Empty stop(com.google.waterfall.WaterfallProto.PortForwardRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getStopMethod(), getCallOptions(), request);
    }

    /**
     */
    public com.google.protobuf.Empty stopAll(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getStopAllMethod(), getCallOptions(), request);
    }

    /**
     */
    public com.google.waterfall.WaterfallProto.ForwardedSessions list(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * PortForwarder service runs a port forwarding session via waterfall.
   * It allows start and stop forwarding connections when the waterfall client
   * is unable to mantains any state (e.g. the waterfall adb binary).
   * </pre>
   */
  public static final class PortForwarderFutureStub extends io.grpc.stub.AbstractFutureStub<PortForwarderFutureStub> {
    private PortForwarderFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PortForwarderFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PortForwarderFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> forwardPort(
        com.google.waterfall.WaterfallProto.PortForwardRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getForwardPortMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> stop(
        com.google.waterfall.WaterfallProto.PortForwardRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getStopMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> stopAll(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getStopAllMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.waterfall.WaterfallProto.ForwardedSessions> list(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_FORWARD_PORT = 0;
  private static final int METHODID_STOP = 1;
  private static final int METHODID_STOP_ALL = 2;
  private static final int METHODID_LIST = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PortForwarderImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PortForwarderImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_FORWARD_PORT:
          serviceImpl.forwardPort((com.google.waterfall.WaterfallProto.PortForwardRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_STOP:
          serviceImpl.stop((com.google.waterfall.WaterfallProto.PortForwardRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_STOP_ALL:
          serviceImpl.stopAll((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_LIST:
          serviceImpl.list((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<com.google.waterfall.WaterfallProto.ForwardedSessions>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PortForwarderBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PortForwarderBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.google.waterfall.WaterfallProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PortForwarder");
    }
  }

  private static final class PortForwarderFileDescriptorSupplier
      extends PortForwarderBaseDescriptorSupplier {
    PortForwarderFileDescriptorSupplier() {}
  }

  private static final class PortForwarderMethodDescriptorSupplier
      extends PortForwarderBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PortForwarderMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PortForwarderGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PortForwarderFileDescriptorSupplier())
              .addMethod(getForwardPortMethod())
              .addMethod(getStopMethod())
              .addMethod(getStopAllMethod())
              .addMethod(getListMethod())
              .build();
        }
      }
    }
    return result;
  }
}
