/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;

public class ResourceValue
extends ResourceReference {
    private final ResourceType mType;
    private final String mLibraryName;
    protected String mValue;

    public ResourceValue(ResourceType type, String name, boolean isFramework) {
        this(type, name, isFramework, null);
    }

    public ResourceValue(ResourceType type, String name, boolean isFramework, String libraryName) {
        super(name, isFramework);
        this.mType = type;
        this.mLibraryName = libraryName;
    }

    public ResourceValue(ResourceType type, String name, String value, boolean isFramework) {
        this(type, name, value, isFramework, null);
    }

    public ResourceValue(ResourceType type, String name, String value, boolean isFramework, String libraryName) {
        super(name, isFramework);
        this.mType = type;
        this.mValue = value;
        this.mLibraryName = libraryName;
    }

    public ResourceType getResourceType() {
        return this.mType;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public boolean isUserDefined() {
        return !this.isFramework() && this.mLibraryName == null;
    }

    public String getValue() {
        return this.mValue;
    }

    public String getRawXmlValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public void replaceWith(ResourceValue value) {
        this.mValue = value.mValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + (Object)((Object)this.mType) + "/" + this.getName() + " = " + this.mValue + " (framework:" + this.isFramework() + ")]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
        result = 31 * result + (this.mValue == null ? 0 : this.mValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceValue other = (ResourceValue)obj;
        if (this.mType == null ? other.mType != null : !this.mType.equals((Object)other.mType)) {
            return false;
        }
        return !(this.mValue == null ? other.mValue != null : !this.mValue.equals(other.mValue));
    }
}

