/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintOptionsConfiguration;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelLintOptions;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 E2\u00020\u0001:\u0002EFB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010 \u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bJ8\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0'2\u0010\b\u0002\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0'J8\u0010)\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u0002000'J\u000e\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0005J\u001e\u00103\u001a\u0004\u0018\u00010\u000b2\b\u00104\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u000bJ.\u00105\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00182\u001e\b\u0002\u00106\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012J\u0018\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;J\b\u0010<\u001a\u0004\u0018\u00010=J\u0010\u0010>\u001a\u0004\u0018\u00010\u000b2\u0006\u0010?\u001a\u00020\u000bJ\u0012\u0010@\u001a\u0004\u0018\u00010\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bJ\u0018\u0010C\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000b2\b\u0010D\u001a\u0004\u0018\u00010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006G"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "rootDir", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dirToConfiguration", "", "Lcom/android/tools/lint/client/api/Configuration;", "fallback", "getFallback", "()Lcom/android/tools/lint/client/api/Configuration;", "setFallback", "(Lcom/android/tools/lint/client/api/Configuration;)V", "lintXmlCreator", "Lkotlin/Function2;", "overrides", "getOverrides", "setOverrides", "parentOf", "projectToConfiguration", "Lcom/android/tools/lint/detector/api/Project;", "getRootDir", "()Ljava/io/File;", "setRootDir", "(Ljava/io/File;)V", "addGlobalConfigurationFromFile", "", "override", "addGlobalConfigurations", "checkForCycle", "child", "createChainedConfigurations", "project", "middle", "createFirst", "Lkotlin/Function0;", "createLast", "createLintOptionsConfiguration", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "fatalOnly", "", "default", "configFactory", "Lcom/android/tools/lint/client/api/LintOptionsConfiguration;", "getConfigurationForFile", "xmlFile", "getConfigurationForFolder", "dir", "getConfigurationForProject", "create", "getDefinedSeverityWithoutOverride", "Lcom/android/tools/lint/detector/api/Severity;", "source", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "getLintXmlConfigurationFallback", "Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "getParentConfiguration", "configuration", "getParentFolder", "folder", "getScopeLeaf", "setParent", "parent", "Companion", "ProjectPlaceholderConfiguration", "lint-api"})
public class ConfigurationHierarchy {
    private final Map<File, Configuration> dirToConfiguration;
    private final Map<Project, Configuration> projectToConfiguration;
    private final Map<Configuration, Configuration> parentOf;
    @Nullable
    private Configuration fallback;
    @Nullable
    private Configuration overrides;
    private final Function2<File, Configuration, Configuration> lintXmlCreator;
    @NotNull
    private final LintClient client;
    @Nullable
    private File rootDir;
    @NotNull
    private static File defaultRootDir;
    private static Set<File> ourAlreadyWarned;
    private static final Companion.NONE.1 NONE;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Configuration getFallback() {
        return this.fallback;
    }

    public final void setFallback(@Nullable Configuration configuration) {
        this.fallback = configuration;
    }

    @Nullable
    public final Configuration getOverrides() {
        return this.overrides;
    }

    public final void setOverrides(@Nullable Configuration configuration) {
        this.overrides = configuration;
    }

    @NotNull
    public final Configuration getConfigurationForProject(@NotNull Project project, @NotNull Function2<? super File, ? super Configuration, ? extends Configuration> create) {
        Configuration configuration;
        LintXmlConfiguration lintXmlConfiguration;
        LintXmlConfiguration lintXmlConfiguration2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(create, (String)"create");
        Configuration prev = this.dirToConfiguration.get(project.getDir());
        if (prev != null && prev != NONE) {
            return prev;
        }
        File file = project.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        File dir = file;
        File file2 = Companion.getLintXmlFile(dir);
        if (file2.isFile()) {
            LintXmlConfiguration lintXmlConfiguration3 = LintXmlConfiguration.Companion.create(this, file2);
            boolean bl = false;
            boolean bl2 = false;
            LintXmlConfiguration it = lintXmlConfiguration3;
            boolean bl3 = false;
            it.setFileLevel(false);
            lintXmlConfiguration2 = lintXmlConfiguration3;
        } else {
            lintXmlConfiguration2 = lintXmlConfiguration = null;
        }
        if ((configuration = (Configuration)create.invoke((Object)dir, lintXmlConfiguration)) == null) {
            configuration = new ProjectPlaceholderConfiguration(this, dir);
        }
        Configuration configuration2 = configuration;
        this.projectToConfiguration.put(project, configuration2);
        if (this.dirToConfiguration.get(dir) == null) {
            this.dirToConfiguration.put(dir, configuration2);
        }
        if (lintXmlConfiguration != null) {
            this.dirToConfiguration.put(file2, lintXmlConfiguration);
        }
        configuration2.setFileLevel(false);
        return configuration2;
    }

    public static /* synthetic */ Configuration getConfigurationForProject$default(ConfigurationHierarchy configurationHierarchy, Project project, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getConfigurationForProject");
        }
        if ((n & 2) != 0) {
            function2 = configurationHierarchy.lintXmlCreator;
        }
        return configurationHierarchy.getConfigurationForProject(project, function2);
    }

    @NotNull
    public final Configuration getConfigurationForFile(@NotNull File xmlFile) {
        Intrinsics.checkParameterIsNotNull((Object)xmlFile, (String)"xmlFile");
        Configuration prev = this.dirToConfiguration.get(xmlFile);
        if (prev != null) {
            boolean bl = prev != NONE;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return prev;
        }
        LintXmlConfiguration configuration = LintXmlConfiguration.Companion.create(this, xmlFile);
        File dir = configuration.getDir();
        if (dir != null && this.client.isKnownProjectDir(dir)) {
            configuration.setFileLevel(false);
        }
        if (dir != null && this.dirToConfiguration.get(dir) == null) {
            this.dirToConfiguration.put(dir, configuration);
        }
        this.dirToConfiguration.put(xmlFile, configuration);
        return configuration;
    }

    @Nullable
    public final Configuration getConfigurationForFolder(@Nullable File dir, @Nullable Configuration configuration) {
        Configuration parent;
        Configuration configuration2;
        Configuration configuration3;
        if (dir == null) {
            return configuration;
        }
        Configuration prev = this.dirToConfiguration.get(dir);
        if (prev != null) {
            return prev != NONE ? prev : null;
        }
        File file = Companion.getLintXmlFile(dir);
        if (file.isFile()) {
            return this.getConfigurationForFile(file);
        }
        if (Intrinsics.areEqual((Object)dir, (Object)this.rootDir) ^ true) {
            configuration3 = this.getConfigurationForFolder(this.getParentFolder(dir), configuration);
        } else {
            configuration3 = configuration;
            if (configuration3 == null) {
                configuration3 = this.fallback;
            }
        }
        if ((configuration2 = (parent = configuration3)) == null) {
            configuration2 = NONE;
        }
        this.dirToConfiguration.put(dir, configuration2);
        return parent;
    }

    public static /* synthetic */ Configuration getConfigurationForFolder$default(ConfigurationHierarchy configurationHierarchy, File file, Configuration configuration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getConfigurationForFolder");
        }
        if ((n & 2) != 0) {
            configuration = null;
        }
        return configurationHierarchy.getConfigurationForFolder(file, configuration);
    }

    @Nullable
    public File getParentFolder(@NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        return folder.getParentFile();
    }

    @Nullable
    public final Configuration getParentConfiguration(@NotNull Configuration configuration) {
        Configuration parent;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Configuration previouslyCreated = this.parentOf.get(configuration);
        if (previouslyCreated != null) {
            return previouslyCreated != NONE ? previouslyCreated : (configuration.isOverriding() ? null : (configuration != this.fallback ? this.fallback : null));
        }
        File file = configuration.getDir();
        if (file == null) {
            return null;
        }
        File configurationDir = file;
        File dir = this.getParentFolder(configurationDir);
        Configuration configuration2 = parent = dir != null && Intrinsics.areEqual((Object)dir, (Object)this.rootDir) ^ true ? this.getConfigurationForFolder(dir, null) : null;
        if (parent != null) {
            this.setParent(configuration, parent);
            if (!configuration.getFileLevel()) {
                parent.setFileLevel(false);
            }
        } else {
            this.parentOf.put(configuration, NONE);
        }
        return parent;
    }

    public final void setParent(@NotNull Configuration child, @Nullable Configuration parent) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        if (parent == null) {
            this.parentOf.remove(child);
            return;
        }
        this.parentOf.put(child, parent);
        this.checkForCycle(child);
    }

    public final void checkForCycle(@NotNull Configuration child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        if (Lint.assertionsEnabled()) {
            Configuration current = child;
            Configuration current2 = child;
            while (current != null) {
                if (this.parentOf.get(current) == null) {
                    return;
                }
                Map<Configuration, Configuration> map = this.parentOf;
                boolean bl = false;
                Configuration configuration = map.get(current2);
                if (configuration == null) {
                    return;
                }
                if (this.parentOf.get(configuration) == null) {
                    return;
                }
                if (current != current2) continue;
                this.client.log(Severity.ERROR, null, "Cyclical configuration chain", new Object[0]);
                this.parentOf.remove(child);
                break;
            }
        }
    }

    @NotNull
    public final Configuration getScopeLeaf(@NotNull Configuration child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        File dir = child.getDir();
        Configuration p = child;
        Configuration configuration = this.parentOf.get(p);
        if (configuration == null) {
            return p;
        }
        Configuration parent = configuration;
        while (Intrinsics.areEqual((Object)parent.getDir(), (Object)dir)) {
            p = parent;
            if (this.parentOf.get(p) != null) continue;
            break;
        }
        return p;
    }

    @NotNull
    public final Configuration createLintOptionsConfiguration(@NotNull Project project, @NotNull LintModelLintOptions lintOptions, boolean fatalOnly, @Nullable Configuration configuration, @NotNull Function0<? extends LintOptionsConfiguration> configFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)lintOptions, (String)"lintOptions");
        Intrinsics.checkParameterIsNotNull(configFactory, (String)"configFactory");
        return this.createChainedConfigurations(project, configuration, configFactory, (Function0<? extends Configuration>)((Function0)new Function0<Configuration>(this, lintOptions){
            final /* synthetic */ ConfigurationHierarchy this$0;
            final /* synthetic */ LintModelLintOptions $lintOptions;

            @Nullable
            public final Configuration invoke() {
                Configuration configuration;
                File lintConfigXml = this.$lintOptions.getLintConfig();
                if (lintConfigXml != null && lintConfigXml.isFile()) {
                    LintXmlConfiguration lintXmlConfiguration = LintXmlConfiguration.Companion.create(this.this$0, lintConfigXml);
                    boolean bl = false;
                    boolean bl2 = false;
                    LintXmlConfiguration $this$apply = lintXmlConfiguration;
                    boolean bl3 = false;
                    $this$apply.setFileLevel(false);
                    configuration = lintXmlConfiguration;
                } else {
                    configuration = null;
                }
                return configuration;
            }
            {
                this.this$0 = configurationHierarchy;
                this.$lintOptions = lintModelLintOptions;
                super(0);
            }
        }));
    }

    public static /* synthetic */ Configuration createLintOptionsConfiguration$default(ConfigurationHierarchy configurationHierarchy, Project project, LintModelLintOptions lintModelLintOptions, boolean bl, Configuration configuration, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createLintOptionsConfiguration");
        }
        if ((n & 0x10) != 0) {
            function0 = (Function0)new Function0<LintOptionsConfiguration>(configurationHierarchy, lintModelLintOptions, bl){
                final /* synthetic */ ConfigurationHierarchy this$0;
                final /* synthetic */ LintModelLintOptions $lintOptions;
                final /* synthetic */ boolean $fatalOnly;

                @NotNull
                public final LintOptionsConfiguration invoke() {
                    return new LintOptionsConfiguration(this.this$0, this.$lintOptions, this.$fatalOnly);
                }
                {
                    this.this$0 = configurationHierarchy;
                    this.$lintOptions = lintModelLintOptions;
                    this.$fatalOnly = bl;
                    super(0);
                }
            };
        }
        return configurationHierarchy.createLintOptionsConfiguration(project, lintModelLintOptions, bl, configuration, (Function0<? extends LintOptionsConfiguration>)function0);
    }

    @NotNull
    public final Configuration createChainedConfigurations(@NotNull Project project, @Nullable Configuration middle, @NotNull Function0<? extends Configuration> createFirst, @NotNull Function0<? extends Configuration> createLast) {
        Configuration parent;
        Configuration configuration;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(createFirst, (String)"createFirst");
        Intrinsics.checkParameterIsNotNull(createLast, (String)"createLast");
        File file = project.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        File dir = file;
        Object object = createFirst.invoke();
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$apply = (Configuration)object;
        boolean bl3 = false;
        $this$apply.setDir(dir);
        $this$apply.setFileLevel(false);
        Configuration primary = (Configuration)object;
        Configuration auxiliary = (Configuration)createLast.invoke();
        File parentFolder = dir.getParentFile();
        if (middle != null && this.parentOf.get(middle) != null) {
            configuration = this.parentOf.get(middle);
            if (configuration == null) {
                configuration = NONE;
            }
        } else if (parentFolder != null && Intrinsics.areEqual((Object)dir, (Object)this.rootDir) ^ true) {
            configuration = ConfigurationHierarchy.getConfigurationForFolder$default(this, parentFolder, null, 2, null);
            if (configuration == null) {
                configuration = NONE;
            }
        } else {
            configuration = parent = (Configuration)NONE;
        }
        if (auxiliary != null) {
            if (middle != null) {
                this.parentOf.put(primary, middle);
                this.parentOf.put(middle, auxiliary);
                this.parentOf.put(auxiliary, parent);
            } else {
                this.parentOf.put(primary, auxiliary);
                this.parentOf.put(auxiliary, parent);
            }
        } else if (middle != null) {
            this.parentOf.put(primary, middle);
            this.parentOf.put(middle, parent);
        } else {
            this.parentOf.put(primary, parent);
        }
        this.checkForCycle(primary);
        this.dirToConfiguration.put(dir, primary);
        return primary;
    }

    public static /* synthetic */ Configuration createChainedConfigurations$default(ConfigurationHierarchy configurationHierarchy, Project project, Configuration configuration, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createChainedConfigurations");
        }
        if ((n & 8) != 0) {
            function02 = createChainedConfigurations.1.INSTANCE;
        }
        return configurationHierarchy.createChainedConfigurations(project, configuration, (Function0<? extends Configuration>)function0, (Function0<? extends Configuration>)function02);
    }

    public final void addGlobalConfigurationFromFile(@Nullable File fallback, @Nullable Configuration override) {
        if (fallback != null) {
            if (!fallback.exists()) {
                Set warned;
                Set set = ourAlreadyWarned;
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    boolean bl = false;
                    boolean bl2 = false;
                    HashSet it = hashSet;
                    boolean bl3 = false;
                    ourAlreadyWarned = it;
                    set = warned = (Set)hashSet;
                }
                if (warned.add((File)fallback)) {
                    this.client.log(Severity.ERROR, null, "Warning: Configuration file %1$s does not exist", fallback);
                }
            } else {
                LintXmlConfiguration xmlConfiguration = LintXmlConfiguration.Companion.create(this, fallback);
                xmlConfiguration.setDir(null);
                xmlConfiguration.setFileLevel(false);
                this.addGlobalConfigurations(xmlConfiguration, override);
                return;
            }
        }
        this.addGlobalConfigurations(null, override);
    }

    public static /* synthetic */ void addGlobalConfigurationFromFile$default(ConfigurationHierarchy configurationHierarchy, File file, Configuration configuration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGlobalConfigurationFromFile");
        }
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            configuration = null;
        }
        configurationHierarchy.addGlobalConfigurationFromFile(file, configuration);
    }

    public final void addGlobalConfigurations(@Nullable Configuration fallback, @Nullable Configuration override) {
        block5: {
            Configuration it;
            boolean bl;
            boolean bl2;
            Configuration prev;
            if (override != null) {
                override.setOverriding(true);
                override.setFileLevel(false);
                prev = this.overrides;
                this.overrides = override;
                boolean bl3 = this.parentOf.get(override) == null;
                bl2 = false;
                bl = false;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Configuration configuration = prev;
                if (configuration != null) {
                    Configuration configuration2 = configuration;
                    bl2 = false;
                    bl = false;
                    it = configuration2;
                    boolean bl5 = false;
                    override.setParent(prev);
                }
            }
            if (fallback == null) break block5;
            fallback.setFileLevel(false);
            prev = this.fallback;
            boolean bl6 = this.parentOf.get(fallback) == null;
            bl2 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean it22 = false;
                String it22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)it22));
            }
            this.fallback = fallback;
            Configuration configuration = prev;
            if (configuration != null) {
                Configuration configuration3 = configuration;
                bl2 = false;
                bl = false;
                it = configuration3;
                boolean bl7 = false;
                fallback.setParent(prev);
            }
        }
    }

    public static /* synthetic */ void addGlobalConfigurations$default(ConfigurationHierarchy configurationHierarchy, Configuration configuration, Configuration configuration2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGlobalConfigurations");
        }
        if ((n & 1) != 0) {
            configuration = null;
        }
        if ((n & 2) != 0) {
            configuration2 = null;
        }
        configurationHierarchy.addGlobalConfigurations(configuration, configuration2);
    }

    @Nullable
    public final LintXmlConfiguration getLintXmlConfigurationFallback() {
        Object v0;
        block1: {
            Sequence configs2;
            Sequence $this$firstIsInstanceOrNull$iv = configs2 = SequencesKt.generateSequence((Object)this.fallback, (Function1)((Function1)new Function1<Configuration, Configuration>(this){
                final /* synthetic */ ConfigurationHierarchy this$0;

                @Nullable
                public final Configuration invoke(@NotNull Configuration it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return (Configuration)ConfigurationHierarchy.access$getParentOf$p(this.this$0).get(it);
                }
                {
                    this.this$0 = configurationHierarchy;
                    super(1);
                }
            }));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof LintXmlConfiguration)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Severity getDefinedSeverityWithoutOverride(@NotNull Configuration source, @NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        if (Intrinsics.areEqual((Object)source, (Object)this.overrides) || this.overrides == null) {
            return null;
        }
        Configuration prev = this.overrides;
        try {
            this.overrides = null;
            Severity severity = source.getDefinedSeverity(issue, source);
            return severity;
        }
        finally {
            this.overrides = prev;
        }
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @Nullable
    public final File getRootDir() {
        return this.rootDir;
    }

    public final void setRootDir(@Nullable File file) {
        this.rootDir = file;
    }

    public ConfigurationHierarchy(@NotNull LintClient client, @Nullable File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.rootDir = rootDir;
        this.dirToConfiguration = new HashMap();
        this.projectToConfiguration = new HashMap();
        this.parentOf = new HashMap();
        this.lintXmlCreator = lintXmlCreator.1.INSTANCE;
    }

    public /* synthetic */ ConfigurationHierarchy(LintClient lintClient, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = defaultRootDir;
        }
        this(lintClient, file);
    }

    static {
        File file;
        Companion = new Companion(null);
        String string = System.getenv("LINT_XML_ROOT");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            file = new File(it);
        } else {
            file = new File(System.getProperty("user.home"));
        }
        defaultRootDir = file;
        NONE = new Configuration(new ConfigurationHierarchy(new LintClient(){

            private final Void unsupported() {
                String string = "Not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }

            public void report(@NotNull Context context2, @NotNull Issue issue, @NotNull Severity severity, @NotNull Location location, @NotNull String message, @NotNull TextFormat format, @Nullable LintFix fix) {
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
                Void void_ = this.unsupported();
                throw null;
            }

            public void log(@NotNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                Void void_ = this.unsupported();
                throw null;
            }

            @NotNull
            public XmlParser getXmlParser() {
                Void void_ = this.unsupported();
                throw null;
            }

            @NotNull
            public UastParser getUastParser(@Nullable Project project) {
                Void void_ = this.unsupported();
                throw null;
            }

            @NotNull
            public GradleVisitor getGradleVisitor() {
                Void void_ = this.unsupported();
                throw null;
            }

            @NotNull
            public CharSequence readFile(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Void void_ = this.unsupported();
                throw null;
            }
        }, null, 2, null)){
            @Nullable
            private File baselineFile;

            @Nullable
            public File getBaselineFile() {
                return this.baselineFile;
            }

            public void setBaselineFile(@Nullable File file) {
                this.baselineFile = file;
            }

            public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location, @NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            }

            public void ignore(@NotNull Issue issue, @NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            }

            public void ignore(@NotNull String issueId, @NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            }

            public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            }

            @Nullable
            public String getOption(@NotNull Issue issue, @NotNull String name, @Nullable String string) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return string;
            }

            @Nullable
            public File getOptionAsFile(@NotNull Issue issue, @NotNull String name, @Nullable File file) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return file;
            }

            @NotNull
            public String toString() {
                return "NONE";
            }
        };
    }

    public static final /* synthetic */ Map access$getParentOf$p(ConfigurationHierarchy $this) {
        return $this.parentOf;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J*\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010%\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J(\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R(\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy$ProjectPlaceholderConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "dir", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Ljava/io/File;)V", "value", "baselineFile", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "fileLevel", "", "getFileLevel", "()Z", "setFileLevel", "(Z)V", "ensureParentIsLocalLintXml", "", "finishBulkEditing", "getDefinedSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "ignore", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "file", "issueId", "isEnabled", "setSeverity", "severity", "startBulkEditing", "validateIssueIds", "client", "Lcom/android/tools/lint/client/api/LintClient;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "lint-api"})
    private final class ProjectPlaceholderConfiguration
    extends Configuration {
        private boolean fileLevel;

        @Override
        public boolean isEnabled(@NotNull Issue issue) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.isEnabled(issue) : super.isEnabled(issue);
        }

        @Override
        @Nullable
        public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object object = this.getParent();
            if (object == null || (object = object.getDefinedSeverity(issue, source)) == null) {
                object = super.getDefinedSeverity(issue, source);
            }
            return object;
        }

        @Override
        public void startBulkEditing() {
            block0: {
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.startBulkEditing();
            }
        }

        @Override
        public void finishBulkEditing() {
            block0: {
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.finishBulkEditing();
            }
        }

        @Override
        public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @NotNull Project project, @NotNull IssueRegistry registry) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.validateIssueIds(client, driver, project, registry);
            }
        }

        @Override
        public boolean getFileLevel() {
            return this.fileLevel;
        }

        @Override
        public void setFileLevel(boolean bl) {
            this.fileLevel = bl;
        }

        private final void ensureParentIsLocalLintXml() {
            File file = this.getDir();
            if (file == null || (file = Companion.getLintXmlFile(file)) == null) {
                return;
            }
            File xmlFile = file;
            if (!xmlFile.isFile()) {
                Configuration currentParent;
                FilesKt.writeText$default((File)xmlFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n</lint>", null, (int)2, null);
                LintXmlConfiguration configuration = LintXmlConfiguration.Companion.create(this.getConfigurations(), xmlFile);
                configuration.setFileLevel(false);
                this.setFileLevel(true);
                Configuration configuration2 = currentParent = this.getParent();
                if (configuration2 != null) {
                    Configuration configuration3 = configuration2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Configuration it = configuration3;
                    boolean bl3 = false;
                    configuration.setParent(it);
                }
                this.setParent(configuration);
            }
        }

        @Override
        @Nullable
        public File getBaselineFile() {
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.getBaselineFile() : null;
        }

        @Override
        public void setBaselineFile(@Nullable File value) {
            block0: {
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.setBaselineFile(value);
            }
        }

        @Override
        public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location, @NotNull String message) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.ignore(context2, issue, location, message);
            }
        }

        @Override
        public void ignore(@NotNull Issue issue, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.ignore(issue.getId(), file);
        }

        @Override
        public void ignore(@NotNull String issueId, @NotNull File file) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.ignore(issueId, file);
            }
        }

        @Override
        public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                this.ensureParentIsLocalLintXml();
                Configuration configuration = this.getParent();
                if (configuration == null) break block0;
                configuration.setSeverity(issue, severity);
            }
        }

        public ProjectPlaceholderConfiguration(@NotNull ConfigurationHierarchy configurations, File dir) {
            Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            super(configurations);
            Configuration configuration = ConfigurationHierarchy.this.getFallback();
            if (configuration != null) {
                Configuration configuration2 = configuration;
                boolean bl = false;
                boolean bl2 = false;
                Configuration it = configuration2;
                boolean bl3 = false;
                this.setParent(it);
            }
            this.setDir(dir);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/ConfigurationHierarchy$Companion;", "", "()V", "NONE", "com/android/tools/lint/client/api/ConfigurationHierarchy$Companion$NONE$1", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy$Companion$NONE$1;", "defaultRootDir", "Ljava/io/File;", "getDefaultRootDir", "()Ljava/io/File;", "setDefaultRootDir", "(Ljava/io/File;)V", "ourAlreadyWarned", "", "getLintXmlFile", "lint-api"})
    public static final class Companion {
        @NotNull
        public final File getDefaultRootDir() {
            return defaultRootDir;
        }

        public final void setDefaultRootDir(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
            defaultRootDir = file;
        }

        @NotNull
        public final File getLintXmlFile(@NotNull File $this$getLintXmlFile) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getLintXmlFile, (String)"$this$getLintXmlFile");
            return new File($this$getLintXmlFile, "lint.xml");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

