/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001=B]\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u0011\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u0000H\u0096\u0002J\u0013\u00101\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010&H\u0096\u0002J\u000e\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00032\u0006\u00103\u001a\u000204J\b\u00106\u001a\u00020\tH\u0016J\u0006\u00107\u001a\u00020\u001aJ\u0006\u00108\u001a\u00020\u001aJ\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u001aJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010<\u001a\u00020\u0003H\u0016R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/detector/api/Issue;", "", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "defaultSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "platforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "suppressNames", "", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Category;ILcom/android/tools/lint/detector/api/Severity;Ljava/util/EnumSet;Ljava/util/Collection;Lcom/android/tools/lint/detector/api/Implementation;)V", "_platforms", "getCategory", "()Lcom/android/tools/lint/detector/api/Category;", "getDefaultSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "enabledByDefault", "", "getId", "()Ljava/lang/String;", "getImplementation", "()Lcom/android/tools/lint/detector/api/Implementation;", "setImplementation", "(Lcom/android/tools/lint/detector/api/Implementation;)V", "moreInfo", "", "getMoreInfo", "()Ljava/util/List;", "moreInfoUrls", "", "getPlatforms", "()Ljava/util/EnumSet;", "getPriority", "()I", "getSuppressNames", "()Ljava/util/Collection;", "addMoreInfo", "moreInfoUrl", "compareTo", "other", "equals", "getBriefDescription", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getExplanation", "hashCode", "isAndroidSpecific", "isEnabledByDefault", "setAndroidSpecific", "value", "setEnabledByDefault", "toString", "Companion", "lint-api"})
@Beta
public final class Issue
implements Comparable<Issue> {
    private Object moreInfoUrls;
    private boolean enabledByDefault;
    private EnumSet<Platform> _platforms;
    @NotNull
    private final String id;
    private final String briefDescription;
    private final String explanation;
    @NotNull
    private final Category category;
    private final int priority;
    @NotNull
    private final Severity defaultSeverity;
    @Nullable
    private final Collection<String> suppressNames;
    @NotNull
    private Implementation implementation;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EnumSet<Platform> getPlatforms() {
        return this._platforms;
    }

    @NotNull
    public final Issue setAndroidSpecific(boolean value) {
        if (value) {
            EnumSet<Platform> enumSet;
            if (this._platforms.isEmpty()) {
                enumSet = Platform.ANDROID_SET;
            } else {
                EnumSet<Platform> enumSet2 = EnumSet.copyOf(this._platforms);
                enumSet2.add(Platform.ANDROID);
                EnumSet<Platform> enumSet3 = enumSet2;
                enumSet = enumSet3;
                Intrinsics.checkExpressionValueIsNotNull(enumSet3, (String)"new");
            }
            this._platforms = enumSet;
        } else {
            EnumSet<Platform> enumSet;
            if (Intrinsics.areEqual(this._platforms, Platform.ANDROID_SET)) {
                enumSet = Platform.UNSPECIFIED;
            } else {
                EnumSet<Platform> enumSet4 = EnumSet.copyOf(this._platforms);
                enumSet4.remove((Object)Platform.ANDROID);
                EnumSet<Platform> enumSet5 = enumSet4;
                enumSet = enumSet5;
                Intrinsics.checkExpressionValueIsNotNull(enumSet5, (String)"new");
            }
            this._platforms = enumSet;
        }
        return this;
    }

    public final boolean isAndroidSpecific() {
        return this._platforms.contains((Object)Platform.ANDROID);
    }

    @NotNull
    public final List<String> getMoreInfo() {
        Object object = this.moreInfoUrls;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        if (object instanceof String) {
            Object object2 = this.moreInfoUrls;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            return CollectionsKt.listOf((Object)((String)object2));
        }
        boolean bl = this.moreInfoUrls instanceof List;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object3 = this.moreInfoUrls;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        }
        return (List)object3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getBriefDescription(@NotNull TextFormat format) {
        void $this$trim$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        String string = this.briefDescription;
        TextFormat textFormat = TextFormat.RAW;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        return textFormat.convertTo(string2, format);
    }

    @NotNull
    public final String getExplanation(@NotNull TextFormat format) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.explanation);
        String message = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message, format);
    }

    @NotNull
    public final Issue addMoreInfo(@NotNull String moreInfoUrl) {
        Intrinsics.checkParameterIsNotNull((Object)moreInfoUrl, (String)"moreInfoUrl");
        Object object = this.moreInfoUrls;
        if (object == null) {
            this.moreInfoUrls = moreInfoUrl;
        } else if (object instanceof String) {
            Object object2 = this.moreInfoUrls;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String existing = (String)object2;
            ArrayList<String> list2 = new ArrayList<String>(2);
            list2.add(existing);
            list2.add(moreInfoUrl);
            this.moreInfoUrls = list2;
        } else {
            boolean bl = this.moreInfoUrls instanceof List;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Object object3 = this.moreInfoUrls;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            }
            TypeIntrinsics.asMutableList((Object)object3).add(moreInfoUrl);
        }
        return this;
    }

    public final boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public int compareTo(@NotNull Issue other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.id.compareTo(other.id);
    }

    @NotNull
    public final Issue setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        Issue issue = (Issue)other;
        return Intrinsics.areEqual((Object)this.id, (Object)issue.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    @Nullable
    public final Collection<String> getSuppressNames() {
        return this.suppressNames;
    }

    @NotNull
    public final Implementation getImplementation() {
        return this.implementation;
    }

    public final void setImplementation(@NotNull Implementation implementation) {
        Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"<set-?>");
        this.implementation = implementation;
    }

    private Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity defaultSeverity, EnumSet<Platform> platforms, Collection<String> suppressNames, Implementation implementation) {
        this.id = id;
        this.briefDescription = briefDescription;
        this.explanation = explanation;
        this.category = category;
        this.priority = priority;
        this.defaultSeverity = defaultSeverity;
        this.suppressNames = suppressNames;
        this.implementation = implementation;
        this.enabledByDefault = true;
        this._platforms = platforms;
        CharSequence charSequence = this.briefDescription;
        boolean bl = false;
        boolean bl2 = !(charSequence.length() == 0);
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CharSequence charSequence2 = this.explanation;
        bl = false;
        boolean bl5 = !(charSequence2.length() == 0);
        bl = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity defaultSeverity, EnumSet platforms, Collection suppressNames, Implementation implementation, DefaultConstructorMarker $constructor_marker) {
        this(id, briefDescription, explanation, category, priority, defaultSeverity, platforms, suppressNames, implementation);
    }

    @JvmStatic
    @NotNull
    public static final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
        return Companion.create(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJ@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0007J\u008f\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004H\u0002\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/detector/api/Issue$Companion;", "", "()V", "computePlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "androidSpecific", "", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "(Ljava/lang/Boolean;Lcom/android/tools/lint/detector/api/Implementation;)Ljava/util/EnumSet;", "create", "Lcom/android/tools/lint/detector/api/Issue;", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "moreInfo", "enabledByDefault", "platforms", "suppressAnnotations", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Implementation;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Category;ILcom/android/tools/lint/detector/api/Severity;ZLjava/lang/Boolean;Ljava/util/EnumSet;Ljava/util/Collection;)Lcom/android/tools/lint/detector/api/Issue;", "scopeImpliesAndroid", "scope", "Lcom/android/tools/lint/detector/api/Scope;", "lint-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkParameterIsNotNull((Object)explanation, (String)"explanation");
            Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
            EnumSet<Platform> platforms = this.computePlatforms(null, implementation);
            return new Issue(id, briefDescription, explanation, category, priority, severity, platforms, null, implementation, null);
        }

        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Implementation implementation, @Nullable String moreInfo, @NotNull Category category, int priority, @NotNull Severity severity, boolean enabledByDefault, @Nullable Boolean androidSpecific, @Nullable EnumSet<Platform> platforms, @Nullable Collection<String> suppressAnnotations) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkParameterIsNotNull((Object)explanation, (String)"explanation");
            Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
            Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            EnumSet<Platform> enumSet = platforms;
            if (enumSet == null) {
                enumSet = this.computePlatforms(androidSpecific, implementation);
            }
            EnumSet<Platform> applicablePlatforms = enumSet;
            Issue issue = new Issue(id, briefDescription, explanation, category, priority, severity, applicablePlatforms, suppressAnnotations, implementation, null);
            if (moreInfo != null) {
                issue.addMoreInfo(moreInfo);
            }
            if (!enabledByDefault) {
                issue.setEnabledByDefault(false);
            }
            return issue;
        }

        public static /* synthetic */ Issue create$default(Companion companion, String string, String string2, String string3, Implementation implementation, String string4, Category category, int n, Severity severity, boolean bl, Boolean bl2, EnumSet enumSet, Collection collection, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                string4 = null;
            }
            if ((n2 & 0x20) != 0) {
                category = Category.CORRECTNESS;
            }
            if ((n2 & 0x40) != 0) {
                n = 5;
            }
            if ((n2 & 0x80) != 0) {
                severity = Severity.WARNING;
            }
            if ((n2 & 0x100) != 0) {
                bl = true;
            }
            if ((n2 & 0x200) != 0) {
                bl2 = null;
            }
            if ((n2 & 0x400) != 0) {
                enumSet = null;
            }
            if ((n2 & 0x800) != 0) {
                collection = null;
            }
            return companion.create(string, string2, string3, implementation, string4, category, n, severity, bl, bl2, enumSet, collection);
        }

        private final EnumSet<Platform> computePlatforms(Boolean androidSpecific, Implementation implementation) {
            boolean bl;
            Boolean bl2 = androidSpecific;
            if (bl2 != null) {
                bl = bl2;
            } else {
                EnumSet<Scope> enumSet = implementation.getScope();
                Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"implementation.scope");
                bl = this.scopeImpliesAndroid(enumSet);
            }
            boolean android = bl;
            return android ? Platform.ANDROID_SET : (Intrinsics.areEqual((Object)androidSpecific, (Object)false) ? Platform.JDK_SET : Platform.UNSPECIFIED);
        }

        private final boolean scopeImpliesAndroid(EnumSet<Scope> scope) {
            return scope.contains((Object)Scope.MANIFEST) || scope.contains((Object)Scope.RESOURCE_FILE) || scope.contains((Object)Scope.BINARY_RESOURCE_FILE) || scope.contains((Object)Scope.ALL_RESOURCE_FILES);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

