/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.lint.client.api.PlatformLookup;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup;", "Lcom/android/tools/lint/client/api/PlatformLookup;", "sdkHome", "Ljava/io/File;", "(Ljava/io/File;)V", "targets", "", "Lcom/android/sdklib/IAndroidTarget;", "getFile", "compileSdkPrefix", "", "pathId", "", "getLatestSdkTarget", "minApi", "includePreviews", "", "includeAddOns", "getTarget", "buildTargetHash", "getTargets", "Companion", "PlatformTarget", "lint-api"})
public final class SimplePlatformLookup
implements PlatformLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File sdkHome;
    @NotNull
    private final List<IAndroidTarget> targets;

    public SimplePlatformLookup(@NotNull File sdkHome) {
        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
        this.sdkHome = sdkHome;
        boolean bl = false;
        List targets = new ArrayList();
        SimplePlatformLookup.Companion.addPlatforms(targets, this.sdkHome, "platforms", null);
        CollectionsKt.sort((List)targets);
        this.targets = targets;
    }

    @Override
    @NotNull
    public List<IAndroidTarget> getTargets(boolean includeAddOns) {
        if (includeAddOns) {
            String string = "Add-ons not supported in this platform lookup";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.targets;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget(@NotNull String buildTargetHash) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)buildTargetHash, (String)"buildTargetHash");
            Iterable $this$firstOrNull$iv = PlatformLookup.DefaultImpls.getTargets$default(this, false, 1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IAndroidTarget it = (IAndroidTarget)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.hashString(), (Object)buildTargetHash)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public IAndroidTarget getLatestSdkTarget(int minApi, boolean includePreviews, boolean includeAddOns) {
        IAndroidTarget iAndroidTarget;
        IAndroidTarget iAndroidTarget2;
        IAndroidTarget it;
        IAndroidTarget element$iv;
        ListIterator<IAndroidTarget> iterator$iv;
        boolean $i$f$lastOrNull;
        List<IAndroidTarget> $this$lastOrNull$iv;
        if (includeAddOns) {
            String string = "Add-ons not supported in this platform lookup";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (includePreviews) {
            IAndroidTarget iAndroidTarget3;
            block6: {
                $this$lastOrNull$iv = this.targets;
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!it.isPlatform()) continue;
                    iAndroidTarget3 = element$iv;
                    break block6;
                }
                iAndroidTarget3 = null;
            }
            iAndroidTarget2 = iAndroidTarget3;
        } else {
            IAndroidTarget iAndroidTarget4;
            block7: {
                $this$lastOrNull$iv = this.targets;
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.isPlatform() && it.getVersion().getCodename() == null)) continue;
                    iAndroidTarget4 = element$iv;
                    break block7;
                }
                iAndroidTarget4 = null;
            }
            iAndroidTarget2 = iAndroidTarget = (IAndroidTarget)iAndroidTarget4;
        }
        if (iAndroidTarget == null) {
            return null;
        }
        IAndroidTarget latest = iAndroidTarget;
        return latest.getVersion().getApiLevel() >= minApi ? latest : null;
    }

    @Nullable
    public final File getFile(@NotNull String compileSdkPrefix, int pathId) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)compileSdkPrefix, (String)"compileSdkPrefix");
        IAndroidTarget iAndroidTarget = this.getTarget(compileSdkPrefix);
        return iAndroidTarget == null ? null : ((path2 = iAndroidTarget.getPath(pathId)) == null ? null : path2.toFile());
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget(int api) {
        return PlatformLookup.DefaultImpls.getTarget(this, api);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup$Companion;", "", "()V", "addPlatforms", "", "into", "", "Lcom/android/sdklib/IAndroidTarget;", "sdkHome", "Ljava/io/File;", "folder", "", "prefix", "getOptionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "platform", "platformFromPackageXml", "location", "packageXml", "platformFromSourceProp", "sourceProperties", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        private final void addPlatforms(List<IAndroidTarget> into, File sdkHome, String folder, String prefix) {
            File[] platformFolders;
            File[] fileArray = new File(sdkHome, folder).listFiles();
            if (fileArray == null) {
                return;
            }
            fileArray = platformFolders = fileArray;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                boolean bl;
                IAndroidTarget iAndroidTarget;
                File platformFolder = fileArray[n];
                ++n;
                String name = platformFolder.getName();
                if (prefix != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'.', (boolean)false, (int)2, null)) continue;
                }
                if (!platformFolder.isDirectory()) continue;
                File packageXml = new File(platformFolder, "package.xml");
                if (packageXml.isFile()) {
                    Intrinsics.checkNotNullExpressionValue((Object)platformFolder, (String)"platformFolder");
                    IAndroidTarget iAndroidTarget2 = this.platformFromPackageXml(platformFolder, packageXml);
                    if (iAndroidTarget2 == null) continue;
                    iAndroidTarget = iAndroidTarget2;
                    boolean bl2 = false;
                    bl = false;
                    IAndroidTarget it = iAndroidTarget;
                    boolean bl3 = false;
                    into.add(it);
                    continue;
                }
                File sourceProperties = new File(platformFolder, "source.properties");
                if (!sourceProperties.isFile()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)platformFolder, (String)"platformFolder");
                iAndroidTarget = this.platformFromSourceProp(platformFolder, sourceProperties);
                if (iAndroidTarget == null) continue;
                IAndroidTarget iAndroidTarget3 = iAndroidTarget;
                bl = false;
                boolean bl4 = false;
                IAndroidTarget it = iAndroidTarget3;
                boolean bl5 = false;
                into.add(it);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IAndroidTarget platformFromPackageXml(File location, File packageXml) {
            String buildTargetHash = null;
            String codeName = null;
            int apiLevel = 0;
            apiLevel = -1;
            String vendorId = null;
            String nameId = null;
            int revision = 0;
            revision = 1;
            try {
                Closeable closeable = new FileReader(packageXml);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    FileReader it = (FileReader)closeable;
                    boolean bl3 = false;
                    KXmlParser parser = new KXmlParser();
                    parser.setInput((Reader)it);
                    while (parser.next() != 1) {
                        int eventType = parser.getEventType();
                        if (eventType != 2) continue;
                        int depth = parser.getDepth();
                        block3 : switch (depth) {
                            case 3: {
                                String tag = parser.getName();
                                if (!Intrinsics.areEqual((Object)tag, (Object)"revision") || parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"major") || parser.next() != 4) break;
                                Object object = parser.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.text");
                                Integer n = StringsKt.toIntOrNull((String)object);
                                revision = n == null ? 1 : n;
                                break;
                            }
                            case 4: {
                                Object object;
                                String tag = parser.getName();
                                if (tag == null) break;
                                int n = -1;
                                switch (tag.hashCode()) {
                                    case -820075192: {
                                        if (tag.equals("vendor")) {
                                            n = 1;
                                        }
                                        break;
                                    }
                                    case -867210760: {
                                        if (tag.equals("codename")) {
                                            n = 2;
                                        }
                                        break;
                                    }
                                    case -1513378287: {
                                        if (tag.equals("api-level")) {
                                            n = 3;
                                        }
                                        break;
                                    }
                                    case 114586: {
                                        if (tag.equals("tag")) {
                                            n = 4;
                                        }
                                        break;
                                    }
                                }
                                switch (n) {
                                    case 3: {
                                        if (parser.next() != 4) break block3;
                                        String text = parser.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                                        object = StringsKt.toIntOrNull((String)text);
                                        if (object == null) break;
                                        Object object2 = object;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        int api = ((Number)object2).intValue();
                                        boolean bl6 = false;
                                        apiLevel = api;
                                        break;
                                    }
                                    case 2: {
                                        if (parser.next() != 4) break block3;
                                        String text = parser.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                                        object = text;
                                        boolean bl7 = false;
                                        if (!(!StringsKt.isBlank((CharSequence)object))) break block3;
                                        codeName = text;
                                        break;
                                    }
                                    case 1: {
                                        if (parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"id") || parser.next() != 4) break block3;
                                        vendorId = parser.getText();
                                        break;
                                    }
                                    case 4: {
                                        if (parser.next() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"id") || parser.next() != 4) break block3;
                                        nameId = parser.getText();
                                    }
                                }
                                break;
                            }
                            case 2: {
                                String path2;
                                String tag = parser.getName();
                                if (!Intrinsics.areEqual((Object)tag, (Object)"localPackage") || (path2 = parser.getAttributeValue(null, "path")) == null || !StringsKt.startsWith$default((String)path2, (String)"platforms;", (boolean)false, (int)2, null)) break;
                                buildTargetHash = StringsKt.removePrefix((String)path2, (CharSequence)"platforms;");
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean platform = true;
            AndroidVersion version = new AndroidVersion(apiLevel, codeName);
            if (nameId != null && vendorId != null && apiLevel != -1) {
                buildTargetHash = AndroidTargetHash.getAddonHashString(vendorId, nameId, (AndroidVersion)version);
                platform = false;
            }
            return buildTargetHash != null && apiLevel != -1 ? (IAndroidTarget)new PlatformTarget(location, buildTargetHash, version, revision, platform) : (IAndroidTarget)null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IAndroidTarget platformFromSourceProp(File location, File sourceProperties) {
            try {
                Closeable closeable = new FileInputStream(sourceProperties);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Object object;
                    Integer n;
                    Object object2;
                    FileInputStream input = (FileInputStream)closeable;
                    boolean bl3 = false;
                    Properties prop = new Properties();
                    prop.load(input);
                    String platformVersion = prop.getProperty("Platform.Version");
                    String string = prop.getProperty("Pkg.Revision");
                    int revision = string == null ? 1 : ((object2 = StringsKt.toIntOrNull((String)string)) == null ? 1 : (Integer)object2);
                    object2 = prop.getProperty("AndroidVersion.ApiLevel");
                    if (object2 == null) {
                        n = null;
                    } else {
                        object = object2;
                        boolean bl4 = false;
                        n = Integer.parseInt((String)object);
                    }
                    Integer apiLevel = n;
                    String codeName = prop.getProperty("AndroidVersion.CodeName");
                    if (platformVersion != null && apiLevel != null) {
                        File file = sourceProperties.getParentFile();
                        Intrinsics.checkNotNull((Object)file);
                        object = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceProperties.parentFile!!.name");
                        IAndroidTarget iAndroidTarget = new PlatformTarget(location, (String)object, new AndroidVersion(apiLevel.intValue(), codeName), revision, true);
                        return iAndroidTarget;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        private final List<OptionalLibrary> getOptionalLibraries(File platform) {
            File optional = new File(platform, "optional");
            File jsonFile = new File(optional, "optional.json");
            if (!jsonFile.isFile()) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            List libraries = new ArrayList();
            String json = FilesKt.readText$default((File)jsonFile, null, (int)1, null);
            Ref.IntRef index = new Ref.IntRef();
            while (com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextItem(index, json)) {
                Pair<String, Object> pair;
                Ref.ObjectRef name = new Ref.ObjectRef();
                String jar = null;
                Ref.BooleanRef manifest = new Ref.BooleanRef();
                while ((pair = com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextPair(index, json)) != null) {
                    Pair<String, Object> pair2 = pair;
                    String key = (String)pair2.getFirst();
                    Object value = pair2.getSecond();
                    if (Intrinsics.areEqual((Object)key, (Object)"name") && value instanceof String) {
                        name.element = value;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)key, (Object)"jar") && value instanceof String) {
                        jar = (String)value;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)key, (Object)"manifest") || !(value instanceof Boolean)) continue;
                    manifest.element = (Boolean)value;
                }
                if (name.element == null || jar == null) continue;
                Path jarPath = new File(optional, jar).toPath();
                OptionalLibrary library2 = new OptionalLibrary((Ref.ObjectRef<String>)name, jarPath, manifest){
                    final /* synthetic */ Ref.ObjectRef<String> $name;
                    final /* synthetic */ Path $jarPath;
                    final /* synthetic */ Ref.BooleanRef $manifest;
                    {
                        this.$name = $name;
                        this.$jarPath = $jarPath;
                        this.$manifest = $manifest;
                    }

                    @NotNull
                    public String getName() {
                        return (String)this.$name.element;
                    }

                    @NotNull
                    public Path getJar() {
                        Path path2 = this.$jarPath;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"jarPath");
                        return path2;
                    }

                    @NotNull
                    public String getDescription() {
                        return (String)this.$name.element;
                    }

                    public boolean isManifestEntryRequired() {
                        return this.$manifest.element;
                    }

                    @NotNull
                    public String getLocalJarPath() {
                        return ((Object)this.getJar().getFileName()).toString();
                    }
                };
                libraries.add(library2);
            }
            return libraries;
        }

        private static final boolean getOptionalLibraries$nextItem(Ref.IntRef $index, String $json) {
            $index.element = StringsKt.indexOf$default((CharSequence)$json, (char)'{', (int)$index.element, (boolean)false, (int)4, null);
            return $index.element != -1;
        }

        private static final Object getOptionalLibraries$nextToken(Ref.IntRef $index, String $json) {
            while ($index.element < $json.length()) {
                char c = $json.charAt($index.element);
                if (CharsKt.isWhitespace((char)c) || c == '{' || c == '[') {
                    int n = $index.element;
                    $index.element = n + 1;
                    continue;
                }
                if (c != '}' && c != ']') break;
                return null;
            }
            if ($index.element == $json.length()) {
                return null;
            }
            int start = $index.element;
            StringBuilder buffer = new StringBuilder();
            if ($json.charAt(start) == '\"') {
                int n = $index.element;
                $index.element = n + 1;
                while ($index.element < $json.length()) {
                    int n2 = $index.element;
                    $index.element = n2 + 1;
                    char c = $json.charAt(n2);
                    if (c == '\\') {
                        n2 = $index.element;
                        $index.element = n2 + 1;
                        buffer.append($json.charAt(n2));
                        continue;
                    }
                    if (c == '\"') {
                        n2 = $index.element;
                        $index.element = n2 + 1;
                        return buffer.toString();
                    }
                    buffer.append(c);
                }
                return null;
            }
            int end = $index.element + 1;
            while ($index.element < $json.length()) {
                int n = $index.element;
                $index.element = n + 1;
                char c = $json.charAt(n);
                if (CharsKt.isWhitespace((char)c) || c == '{' || c == '[') {
                    end = $index.element - 1;
                    break;
                }
                if (c != '}' && c != ']') continue;
                return null;
            }
            if ($index.element == $json.length()) {
                return null;
            }
            String string = $json;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String valueString = string3;
            char c = $json.charAt(start);
            bl = false;
            if (Character.isDigit(c)) {
                int dot = StringsKt.indexOf$default((CharSequence)$json, (char)'.', (int)start, (boolean)false, (int)4, null);
                return dot != -1 && dot < end ? (Number)StringsKt.toDoubleOrNull((String)valueString) : (Number)StringsKt.toIntOrNull((String)valueString);
            }
            if (Intrinsics.areEqual((Object)valueString, (Object)"true")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)valueString, (Object)"false")) {
                return false;
            }
            return null;
        }

        private static final Pair<String, Object> getOptionalLibraries$nextPair(Ref.IntRef $index, String $json) {
            Object keyToken = com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextToken($index, $json);
            Object valueToken = com.android.tools.lint.client.api.SimplePlatformLookup$Companion.getOptionalLibraries$nextToken($index, $json);
            return keyToken instanceof String && valueToken != null ? new Pair(keyToken, valueToken) : (Pair)null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\u0011\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0001H\u0096\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\nJ\b\u0010#\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020\u0006H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010&\u001a\u00020\u0001H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0016\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060,H\u0016J\u0012\u0010-\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\u0013\u00101\u001a\b\u0012\u0004\u0012\u00020 0)H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\bH\u0016J\b\u00105\u001a\u00020\u0006H\u0016J\b\u00106\u001a\u00020\fH\u0016J\b\u00107\u001a\u00020\u0006H\u0016J\b\u00108\u001a\u00020\fH\u0016J\b\u00109\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020;H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/tools/lint/client/api/SimplePlatformLookup$PlatformTarget;", "Lcom/android/sdklib/IAndroidTarget;", "", "location", "Ljava/io/File;", "buildTargetHash", "", "version", "Lcom/android/sdklib/AndroidVersion;", "revision", "", "platform", "", "(Ljava/io/File;Ljava/lang/String;Lcom/android/sdklib/AndroidVersion;IZ)V", "getBuildTargetHash", "()Ljava/lang/String;", "getLocation", "()Ljava/io/File;", "optionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "canRunOn", "target", "compareTo", "other", "getAdditionalLibraries", "", "getBootClasspath", "getBuildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "getClasspathName", "getDefaultSkin", "Ljava/nio/file/Path;", "getFile", "pathId", "getFullName", "getName", "getOptionalLibraries", "getParent", "getPath", "getPlatformLibraries", "", "()[Ljava/lang/String;", "getProperties", "", "getProperty", "name", "getRevision", "getShortClasspathName", "getSkins", "()[Ljava/nio/file/Path;", "getVendor", "getVersion", "getVersionName", "hasRenderingLibrary", "hashString", "isPlatform", "toString", "unsupported", "", "lint-api"})
    private static final class PlatformTarget
    implements IAndroidTarget,
    Comparable<IAndroidTarget> {
        @NotNull
        private final File location;
        @NotNull
        private final String buildTargetHash;
        @NotNull
        private final AndroidVersion version;
        private final int revision;
        private final boolean platform;
        @Nullable
        private List<? extends OptionalLibrary> optionalLibraries;

        public PlatformTarget(@NotNull File location, @NotNull String buildTargetHash, @NotNull AndroidVersion version, int revision, boolean platform) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)buildTargetHash, (String)"buildTargetHash");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.location = location;
            this.buildTargetHash = buildTargetHash;
            this.version = version;
            this.revision = revision;
            this.platform = platform;
        }

        @NotNull
        public final File getLocation() {
            return this.location;
        }

        @NotNull
        public final String getBuildTargetHash() {
            return this.buildTargetHash;
        }

        public boolean isPlatform() {
            return this.platform;
        }

        @NotNull
        public String hashString() {
            return this.buildTargetHash;
        }

        @NotNull
        public AndroidVersion getVersion() {
            return this.version;
        }

        @NotNull
        public String getLocation() {
            String string = this.location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"location.path");
            return string;
        }

        @NotNull
        public Path getPath(int pathId) {
            Path path2 = this.getFile(pathId).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFile(pathId).toPath()");
            return path2;
        }

        @NotNull
        public final File getFile(int pathId) {
            File file;
            int n = pathId;
            switch (n) {
                case 1: {
                    file = new File(this.location, "android.jar");
                    break;
                }
                case 7: {
                    file = new File(this.location, "data");
                    break;
                }
                case 11: {
                    file = new File(this.location, "data" + File.separator + "res");
                    break;
                }
                case 8: {
                    file = new File(this.location, "data/res/values/attrs.xml");
                    break;
                }
                default: {
                    String string = Intrinsics.stringPlus((String)"Unsupported path id in ", (Object)SimplePlatformLookup.class.getName());
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            return file;
        }

        public int getRevision() {
            return this.revision;
        }

        @NotNull
        public List<OptionalLibrary> getOptionalLibraries() {
            List list2;
            List list3 = this.optionalLibraries;
            if (list3 == null) {
                PlatformTarget platformTarget = this;
                boolean bl = false;
                boolean bl2 = false;
                PlatformTarget $this$getOptionalLibraries_u24lambda_u2d1 = platformTarget;
                boolean bl3 = false;
                List list4 = Companion.getOptionalLibraries($this$getOptionalLibraries_u24lambda_u2d1.getLocation());
                boolean bl4 = false;
                boolean bl5 = false;
                List it = list4;
                boolean bl6 = false;
                $this$getOptionalLibraries_u24lambda_u2d1.optionalLibraries = it;
                list2 = list4;
            } else {
                list2 = list3;
            }
            return list2;
        }

        @Override
        public int compareTo(@NotNull IAndroidTarget other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int versionDelta = this.version.compareTo(other.getVersion());
            if (versionDelta != 0) {
                return versionDelta;
            }
            int typeDelta = (this.isPlatform() ? 1 : 0) - (other.isPlatform() ? 1 : 0);
            if (typeDelta != 0) {
                return typeDelta;
            }
            String string = this.location.getPath();
            String string2 = other.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"other.location");
            return string.compareTo(string2);
        }

        @NotNull
        public String toString() {
            return (this.platform ? "Platform" : "Add-on") + ' ' + this.buildTargetHash + ": version=" + this.version;
        }

        @NotNull
        public String getVendor() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getFullName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getClasspathName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getShortClasspathName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getVersionName() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public IAndroidTarget getParent() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public BuildToolInfo getBuildToolInfo() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public List<String> getBootClasspath() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        public boolean hasRenderingLibrary() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Path[] getSkins() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Path getDefaultSkin() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String[] getPlatformLibraries() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getProperty(@Nullable String name) {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Map<String, String> getProperties() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        public boolean canRunOn(@Nullable IAndroidTarget target) {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public List<OptionalLibrary> getAdditionalLibraries() {
            this.unsupported();
            throw new KotlinNothingValueException();
        }

        private final Void unsupported() {
            String string = "This operation is not supported on light weight IAndroidTargets";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }
}

