/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintJavaUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.UImplicitCallExpression;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.BuildScriptUtil;
import com.android.utils.CharSequences;
import com.android.utils.DomExtensions;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.LightMemberOrigin;
import org.jetbrains.kotlin.asJava.elements.KtLightMemberImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u00a8\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a)\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\t\u001a$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a&\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u001a \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\u0019\u001a\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0001\u001a$\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010#\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010%\u001a\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\b\b\u0002\u0010(\u001a\u00020\u0019\u001a2\u0010%\u001a\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\b\b\u0002\u0010(\u001a\u00020\u00192\b\b\u0002\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u0004\u001a\u0010\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u0001\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001\u001a\u000e\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201\u001a\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030'2\u0006\u00100\u001a\u000201\u001a\u0018\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205\u001a\u0016\u00104\u001a\u0004\u0018\u0001052\f\u00108\u001a\b\u0012\u0004\u0012\u0002050'\u001a\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020\u0004\u001a\u0018\u00109\u001a\u00020:2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010>\u001a\u00020\u0004\u001a\u0016\u0010A\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020B\u001a\u0016\u0010A\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u000205\u001a\u000e\u0010C\u001a\u00020\u00012\u0006\u0010=\u001a\u000205\u001a\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010'2\u0006\u0010E\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\u0001\u001a&\u0010G\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010'2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020\u0001\u001a\u000e\u0010L\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010M\u001a\u0004\u0018\u00010\u00012\u0006\u0010N\u001a\u00020O\u001a\u001a\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020U\u001a\u0016\u0010V\u001a\u00020W2\u0006\u0010I\u001a\u00020J2\u0006\u0010X\u001a\u00020W\u001a\u0016\u0010V\u001a\u00020W2\u0006\u0010T\u001a\u00020S2\u0006\u0010X\u001a\u00020W\u001a\u0016\u0010V\u001a\u00020W2\u0006\u0010T\u001a\u00020Y2\u0006\u0010X\u001a\u00020W\u001a\u000e\u0010Z\u001a\u00020\u00012\u0006\u0010[\u001a\u000205\u001a\u0010\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020_\u001a\u0010\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010`\u001a\u00020\u0001\u001a\u0010\u0010a\u001a\u0004\u0018\u00010\u00012\u0006\u0010b\u001a\u00020\u0001\u001a\u0010\u0010c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010d\u001a\u0004\u0018\u00010e2\u0006\u00100\u001a\u00020e\u001a\u000e\u0010f\u001a\u00020\u00192\u0006\u00100\u001a\u00020e\u001a\u0010\u0010g\u001a\u0004\u0018\u00010e2\u0006\u00100\u001a\u00020e\u001a\u000e\u0010h\u001a\u00020\u00192\u0006\u00100\u001a\u00020e\u001a\u0010\u0010i\u001a\u0004\u0018\u00010\u00012\u0006\u0010j\u001a\u00020\u0001\u001a@\u0010k\u001a\n\u0012\u0004\u0012\u00020l\u0018\u00010'2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020\u00012\u0006\u0010m\u001a\u00020\u00012\u0006\u0010n\u001a\u00020\u00012\b\b\u0002\u0010o\u001a\u00020\u0004\u001a \u0010p\u001a\u00020q2\u0006\u0010;\u001a\u00020<2\u0006\u0010r\u001a\u0002052\b\u0010\"\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010p\u001a\u00020q2\u0006\u0010I\u001a\u00020J\u001a \u0010s\u001a\u00020q2\u0006\u0010;\u001a\u00020<2\u0006\u0010t\u001a\u0002052\b\u0010\"\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010u\u001a\u00020\u00042\b\u0010v\u001a\u0004\u0018\u00010\u00012\b\u0010w\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010x\u001a\u00020\u00042\u0006\u0010y\u001a\u00020z\u001a\u000e\u0010{\u001a\u00020\u00042\u0006\u0010|\u001a\u00020\u0001\u001a\u001e\u0010}\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0019\u001a\u0016\u0010~\u001a\u00020\u00042\u0006\u0010^\u001a\u00020_2\u0006\u0010\u007f\u001a\u00020\u0004\u001a\u0011\u0010\u0080\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u0011\u0010\u0081\u0001\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001\u001a\u001b\u0010\u0084\u0001\u001a\u00020\u00042\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001\u001a\u0013\u0010\u0089\u0001\u001a\u00020\u00042\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001\u001a\u0011\u0010\u0089\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u0010\u0010\u008c\u0001\u001a\u00020\u00042\u0007\u0010\u008d\u0001\u001a\u00020\u0001\u001a\u0010\u0010\u008e\u0001\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u000205\u001a\u0010\u0010\u0090\u0001\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u000205\u001a\u0013\u0010\u0091\u0001\u001a\u00020\u00042\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001\u001a\u0011\u0010\u0091\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u0010\u0010\u0092\u0001\u001a\u00020\u00042\u0007\u0010\u008d\u0001\u001a\u00020\u0001\u001a\u0010\u0010\u0093\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u0001\u001a\u000f\u0010\u0093\u0001\u001a\u00020\u00042\u0006\u0010T\u001a\u000203\u001a\u0012\u0010\u0095\u0001\u001a\u00020\u00042\t\u0010\u0096\u0001\u001a\u0004\u0018\u000105\u001a\u000f\u0010\u0097\u0001\u001a\u00020\u00042\u0006\u0010|\u001a\u00020\u0001\u001a5\u0010\u0098\u0001\u001a\u00020\u00042\u0006\u0010I\u001a\u00020J2\u0007\u0010\u0099\u0001\u001a\u00020\u00192\u0007\u0010\u009a\u0001\u001a\u00020\u00192\u0007\u0010\u009b\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u009c\u0001\u001a\u00020\u0004\u001a\u0011\u0010\u009d\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u0011\u0010\u009e\u0001\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001\u001a%\u0010\u009f\u0001\u001a\u00020\u00042\t\u0010\u00a0\u0001\u001a\u0004\u0018\u0001052\u0006\u0010=\u001a\u0002052\t\b\u0002\u0010\u00a1\u0001\u001a\u00020\u0004\u001a\"\u0010\u00a2\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010Y\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000\u001a\u000f\u0010\u00a4\u0001\u001a\u00020\u00042\u0006\u0010T\u001a\u000203\u001a\u001b\u0010\u00a5\u0001\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u0001052\b\u00107\u001a\u0004\u0018\u000105\u001a\u000f\u0010\u00a6\u0001\u001a\u00020\u00042\u0006\u0010y\u001a\u00020z\u001a\u0010\u0010\u00a7\u0001\u001a\u00020\u00042\u0007\u0010\u0082\u0001\u001a\u00020Q\u001a\u0011\u0010\u00a8\u0001\u001a\u00020\u00042\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u000f\u0010\u00a9\u0001\u001a\u00020\u00042\u0006\u0010=\u001a\u000205\u001a\u001b\u0010\u00aa\u0001\u001a\u0004\u0018\u0001032\u0006\u0010T\u001a\u0002032\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001\u001a\u0013\u0010\u00ad\u0001\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010S\u001a\u001b\u0010\u00ae\u0001\u001a\u00020\u00012\u0007\u0010\u00af\u0001\u001a\u00020\u00192\u0007\u0010\u00b0\u0001\u001a\u00020\u0001H\u0002\u001a\u0013\u0010\u00b1\u0001\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010S\u001a#\u0010\u00b2\u0001\u001a\u0004\u0018\u00010@2\u0006\u0010;\u001a\u00020<2\u0007\u0010\u00b3\u0001\u001a\u00020\u00012\u0007\u0010\u00b4\u0001\u001a\u00020\u0019\u001a#\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020<2\u0007\u0010\u00b3\u0001\u001a\u00020\u00012\u0007\u0010\u00b4\u0001\u001a\u00020\u0019\u001a\u0015\u0010\u00b6\u0001\u001a\u0004\u0018\u00010S2\b\u0010R\u001a\u0004\u0018\u00010SH\u0000\u001a\u000f\u0010\u00b7\u0001\u001a\u00020\u00012\u0006\u0010T\u001a\u000203\u001a\u001b\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010\u0014\u001a\u00020\u0001\u001a3\u0010\u00b9\u0001\u001a\u00020\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0007\u0010\u00ba\u0001\u001a\u00020\u00012\u0015\u0010\u00bb\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0007\u001aD\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0007\u0010\u00ba\u0001\u001a\u00020\u00012\u0017\b\u0002\u0010\u00bb\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u000b\b\u0002\u0010\u00bc\u0001\u001a\u0004\u0018\u00010\u0001H\u0007\u001a(\u0010\u00bd\u0001\u001a\u00020\u00042\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010Q2\t\u0010\u00bf\u0001\u001a\u0004\u0018\u00010Q2\u0007\u0010\u00c0\u0001\u001a\u00020\u0004H\u0002\u001a+\u0010\u00c1\u0001\u001a\u0004\u0018\u0001032\r\u0010\u00c2\u0001\u001a\b\u0012\u0004\u0012\u0002030'2\u0007\u0010\u00c3\u0001\u001a\u00020\u00192\u0006\u0010`\u001a\u000203H\u0002\u001a\u0015\u0010\u00c4\u0001\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010SH\u0007\u001a\u0015\u0010\u00c4\u0001\u001a\u0004\u0018\u00010Y2\b\u0010T\u001a\u0004\u0018\u00010YH\u0007\u001a\u0017\u0010\u00c5\u0001\u001a\t\u0012\u0004\u0012\u00020\u00010\u00c6\u00012\u0007\u0010\u00c2\u0001\u001a\u00020\u0001\u001a \u0010\u00c7\u0001\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0007\u0010\u00c8\u0001\u001a\u00020\u0019\u001a\u0014\u0010\u00c9\u0001\u001a\u00020\u00012\t\u0010\u00ca\u0001\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u000e\u0010\u00cb\u0001\u001a\u0005\u0018\u00010\u00cc\u0001*\u00020\u0011\u001a\u000e\u0010\u00cd\u0001\u001a\u0004\u0018\u00010\u0011*\u00030\u00ce\u0001\u001a\u0010\u0010\u00cf\u0001\u001a\u0004\u0018\u00010S*\u00030\u00d0\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0005\n\u00030\u00a3\u0001\u00a8\u0006\u00d1\u0001"}, d2={"UTF_16", "", "UTF_16LE", "assertionsEnabled", "", "coalesce", "T", "ts", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "computeKotlinArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "computeResourceName", "prefix", "name", "folderType", "Lcom/android/resources/ResourceFolderType;", "describeCounts", "errorCount", "", "warningCount", "comma", "capitalize", "editDistance", "s", "t", "max", "endsWith", "string", "suffix", "findSubstring", "formatList", "strings", "", "maxItems", "sort", "useConjunction", "getAutoBoxedType", "primitive", "getBaseName", "fileName", "getChildCount", "node", "Lorg/w3c/dom/Node;", "getChildren", "Lorg/w3c/dom/Element;", "getCommonParent", "Ljava/io/File;", "file1", "file2", "files", "getEncodedString", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "createString", "data", "", "getFileNameWithParent", "Lcom/android/ide/common/util/PathString;", "getFileUri", "getFormattedParameters", "format", "errorMessage", "getInheritedStyles", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "styleUrl", "getInternalMethodName", "getInternalName", "psiClass", "Lcom/intellij/psi/PsiClass;", "getKotlinDelegatePropertyType", "Lcom/intellij/psi/PsiType;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/jetbrains/uast/UVariable;", "getLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "defaultLevel", "Lorg/jetbrains/uast/UElement;", "getLayoutName", "layoutFile", "getLocale", "Lcom/android/ide/common/resources/configuration/LocaleQualifier;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "parent", "getLocaleAndRegion", "folderName", "getMethodName", "getNextInstruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "getNextOpcode", "getPrevInstruction", "getPrevOpcode", "getPrimitiveType", "autoBoxedType", "getStyleAttributes", "Lcom/android/ide/common/rendering/api/ResourceValue;", "namespaceUri", "attribute", "acceptMissing", "guessGradleLocation", "Lcom/android/tools/lint/detector/api/Location;", "projectDir", "guessGradleLocationForFile", "gradle", "idReferencesMatch", "id1", "id2", "isAnonymousClass", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "isDataBindingExpression", "expression", "isEditableTo", "isEnglishResource", "assumeForBase", "isFalseLiteral", "isFileBasedResourceType", "type", "Lcom/android/resources/ResourceType;", "isInlined", "field", "Lcom/intellij/psi/PsiField;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isJava", "language", "Lcom/intellij/lang/Language;", "isJavaKeyword", "keyword", "isJdkFolder", "homePath", "isJreFolder", "isKotlin", "isKotlinHardKeyword", "isLayoutMarkerTag", "tagName", "isManifestFolder", "dir", "isManifestPlaceHolderExpression", "isModelOlderThan", "major", "minor", "micro", "defaultForNonGradleProjects", "isNullLiteral", "isNumberString", "isParent", "parentCandidate", "strict", "isPolyadicFromStringTemplate", "Lorg/jetbrains/uast/UPolyadicExpression;", "isRootElement", "isSameResourceFile", "isStaticInnerClass", "isString", "isTrueLiteral", "isXmlFile", "matchXmlElement", "targetDocument", "Lorg/w3c/dom/Document;", "nextNonWhitespace", "pluralize", "count", "one", "prevNonWhitespace", "readUrlData", "query", "timeout", "readUrlDataAsString", "resolveKotlinCall", "resolveManifestName", "resolvePlaceHolder", "resolvePlaceHolders", "value", "substitutions", "defaultValue", "sameType", "type1", "type2", "equalsOnly", "search", "path", "index", "skipParentheses", "splitPath", "", "startsWith", "offset", "stripIdPrefix", "id", "getUMethod", "Lorg/jetbrains/uast/UMethod;", "resolveOperator", "Lorg/jetbrains/uast/UArrayAccessExpression;", "toSource", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "lint-api"})
@JvmName(name="Lint")
public final class Lint {
    @NotNull
    private static final String UTF_16 = "UTF_16";
    @NotNull
    private static final String UTF_16LE = "UTF_16LE";

    @Nullable
    public static final String getInternalName(@NotNull PsiClass psiClass) {
        PsiClass parent;
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiClass), PsiClass.class)) != null) {
            String string = Lint.getInternalName(parent);
            if (string == null) {
                return null;
            }
            String internalName = string;
            String string2 = JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
            Intrinsics.checkNotNull((Object)string2);
            return Intrinsics.stringPlus((String)internalName, (Object)string2);
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null ? ClassContext.Companion.getInternalName(qualifiedName) : null;
        }
        if (StringsKt.indexOf$default((CharSequence)sig, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            sig = ClassContext.Companion.getInternalName(sig);
        }
        return sig;
    }

    @NotNull
    public static final String getInternalMethodName(@NotNull PsiMethod method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.isConstructor()) {
            string = "<init>";
        } else {
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        method.name\n    }");
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        return Lint.formatList$default(strings, maxItems, true, false, 8, null);
    }

    public static /* synthetic */ String formatList$default(List list2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.formatList(list2, n);
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems, boolean sort, boolean useConjunction) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        List sortedStrings = strings;
        if (sort) {
            ArrayList sorted = new ArrayList(sortedStrings);
            CollectionsKt.sort((List)sorted);
            sortedStrings = sorted;
        }
        StringBuilder sb = new StringBuilder(20 * sortedStrings.size());
        int i = 0;
        int n = sortedStrings.size();
        while (i < n) {
            charSequence = sb;
            boolean bl = false;
            if (charSequence.length() > 0) {
                if (useConjunction && i == n - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append((String)sortedStrings.get(i));
            if (maxItems > 0 && i == maxItems - 1 && n > maxItems) {
                charSequence = StringCompanionObject.INSTANCE;
                String string = "... (%1$d more)";
                Object[] objectArray = new Object[]{n - i - 1};
                boolean bl2 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                sb.append(string2);
                break;
            }
            int n2 = i;
            i = n2 + 1;
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    public static /* synthetic */ String formatList$default(List list2, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return Lint.formatList(list2, n, bl, bl2);
    }

    public static final boolean isFileBasedResourceType(@NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static final boolean isXmlFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml");
    }

    public static final boolean endsWith(@NotNull String string, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.regionMatches((String)string, (int)(string.length() - suffix.length()), (String)suffix, (int)0, (int)suffix.length(), (boolean)true);
    }

    public static final boolean startsWith(@NotNull String string, @NotNull String prefix, int offset) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.regionMatches((String)string, (int)offset, (String)prefix, (int)0, (int)prefix.length(), (boolean)true);
    }

    @NotNull
    public static final String getBaseName(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int extension = StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (extension > 0) {
            String string2 = fileName;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, extension);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = fileName;
        }
        return string;
    }

    @NotNull
    public static final String describeCounts(int errorCount, int warningCount, boolean comma, boolean capitalize) {
        String string;
        if (errorCount == 0 && warningCount == 0) {
            return capitalize ? "No errors or warnings" : "no errors or warnings";
        }
        String errors = Lint.pluralize(errorCount, "error");
        String warnings = Lint.pluralize(warningCount, "warning");
        if (errorCount == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%1$d %2$s";
            Object[] objectArray = new Object[]{warningCount, warnings};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else if (warningCount == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%1$d %2$s";
            Object[] objectArray = new Object[]{errorCount, errors};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            String conjunction = comma ? "," : " and";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "%1$d %2$s%3$s %4$d %5$s";
            Object[] objectArray = new Object[]{errorCount, errors, conjunction, warningCount, warnings};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private static final String pluralize(int count, String one) {
        return count == 1 ? one : Intrinsics.stringPlus((String)one, (Object)"s");
    }

    @NotNull
    public static final List<Element> getChildren(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        NodeList childNodes = node.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(childNodes.getLength());
        int i = 0;
        int n = childNodes.getLength();
        while (i < n) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                if (child == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                children.add((Element)child);
            }
            int n2 = i;
            i = n2 + 1;
        }
        return children;
    }

    public static final int getChildCount(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XmlUtils.getSubTagCount((Node)node);
    }

    public static final boolean isRootElement(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element == element.getOwnerDocument().getDocumentElement();
    }

    @Deprecated(message="Use ResourceUrl for parsing @id and similar strings.", replaceWith=@ReplaceWith(expression="ResourceUrl.parse(id)?.name", imports={"com.android.resources.ResourceUrl"}))
    @NotNull
    public static final String stripIdPrefix(@Nullable String id) {
        String string;
        if (id == null) {
            string = "";
        } else if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id;
            int n = "@+id/".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string4 = id;
            int n = "@id/".length();
            boolean bl = false;
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = id;
        }
        return string;
    }

    public static final boolean idReferencesMatch(@Nullable String id1, @Nullable String id2) {
        boolean bl;
        boolean bl2;
        block12: {
            block11: {
                if (id1 == null || id2 == null) break block11;
                CharSequence charSequence = id1;
                bl2 = false;
                if (charSequence.length() == 0) break block11;
                charSequence = id2;
                bl2 = false;
                if (!(charSequence.length() == 0)) break block12;
            }
            return false;
        }
        if (StringsKt.startsWith$default((String)id1, (String)"@+id/", (boolean)false, (int)2, null)) {
            boolean bl3;
            if (StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null)) {
                bl3 = Intrinsics.areEqual((Object)id1, (Object)id2);
            } else {
                boolean bl4 = StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null);
                bl2 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean $i$a$-assert-Lint$idReferencesMatch$32 = false;
                    String $i$a$-assert-Lint$idReferencesMatch$32 = id2;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Lint$idReferencesMatch$32));
                }
                bl3 = id1.length() - id2.length() == "@+id/".length() - "@id/".length() && StringsKt.regionMatches$default((String)id1, (int)"@+id/".length(), (String)id2, (int)"@id/".length(), (int)(id2.length() - "@id/".length()), (boolean)false, (int)16, null);
            }
            return bl3;
        }
        boolean bl5 = StringsKt.startsWith$default((String)id1, (String)"@id/", (boolean)false, (int)2, null);
        bl2 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string = id1;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null)) {
            bl = Intrinsics.areEqual((Object)id1, (Object)id2);
        } else {
            bl5 = StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null);
            bl2 = false;
            boolean bl7 = false;
            if (_Assertions.ENABLED && !bl5) {
                boolean bl8 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = id2.length() - id1.length() == "@+id/".length() - "@id/".length() && StringsKt.regionMatches$default((String)id2, (int)"@+id/".length(), (String)id1, (int)"@id/".length(), (int)(id1.length() - "@id/".length()), (boolean)false, (int)16, null);
        }
        return bl;
    }

    @NotNull
    public static final String getFileNameWithParent(@NotNull LintClient client, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return LintClient.getDisplayPath$default(client, new File(file.getParentFile().getName(), file.getName()), null, null, 6, null);
    }

    @NotNull
    public static final String getFileNameWithParent(@NotNull LintClient client, @NotNull PathString file) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathString pathString = file.getParent();
        if (pathString == null) {
            throw new IllegalArgumentException();
        }
        PathString parent = pathString;
        return LintClient.getDisplayPath$default(client, new File(parent.getFileName(), file.getFileName()), null, null, 6, null);
    }

    public static final boolean isEditableTo(@NotNull String s, @NotNull String t, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Lint.editDistance(s, t, max) <= max;
    }

    public static final int editDistance(@NotNull String s, @NotNull String t, int max) {
        int j;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (Intrinsics.areEqual((Object)s, (Object)t)) {
            return 0;
        }
        if (Math.abs(s.length() - t.length()) > max) {
            return Integer.MAX_VALUE;
        }
        int m = s.length();
        int n = t.length();
        int n2 = 0;
        int n3 = m + 1;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[n + 1];
        }
        int[][] d = nArrayArray;
        n2 = 0;
        if (n2 <= m) {
            int i;
            do {
                d[i][0] = i = n2++;
            } while (i != m);
        }
        if ((n2 = 0) <= n) {
            do {
                d[0][j] = j = n2++;
            } while (j != n);
        }
        if ((n2 = 1) <= n) {
            do {
                int i;
                j = n2++;
                int n5 = 1;
                if (n5 > m) continue;
                do {
                    if (s.charAt((i = n5++) - 1) == t.charAt(j - 1)) {
                        d[i][j] = d[i - 1][j - 1];
                        continue;
                    }
                    int deletion = d[i - 1][j] + 1;
                    int insertion = d[i][j - 1] + 1;
                    int substitution = d[i - 1][j - 1] + 1;
                    d[i][j] = Math.min(deletion, Math.min(insertion, substitution));
                } while (i != m);
            } while (j != n);
        }
        return d[m][n];
    }

    public static /* synthetic */ int editDistance$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.editDistance(string, string2, n);
    }

    public static final boolean assertionsEnabled() {
        return LintJavaUtils.assertionsEnabled();
    }

    @Nullable
    public static final PsiMethod resolveOperator(@NotNull UArrayAccessExpression $this$resolveOperator) {
        PsiMethod psiMethod;
        block29: {
            PsiMethod typeEqualsMatch;
            PsiMethod method;
            int n;
            int expectedCount;
            PsiMethod[] methods;
            int parameterCount;
            List indices2;
            boolean isSetter;
            UBinaryExpression parent;
            block28: {
                PsiMethod psiMethod2;
                PsiMethod arityCountMatch;
                PsiParameter[] parameters;
                block27: {
                    PsiMethod psiMethod3;
                    PsiClass psiClass;
                    PsiClassType psiClassType;
                    Intrinsics.checkNotNullParameter((Object)$this$resolveOperator, (String)"<this>");
                    UExpression receiver = $this$resolveOperator.getReceiver();
                    PsiType psiType = receiver.getExpressionType();
                    PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    if (psiClassType == null) {
                        return null;
                    }
                    PsiClassType type = psiClassType;
                    PsiElement source = Lint.resolveKotlinCall($this$resolveOperator.getSourcePsi());
                    if (source instanceof PsiMethod) {
                        return (PsiMethod)source;
                    }
                    PsiClass psiClass2 = type.resolve();
                    if (psiClass2 == null) {
                        return null;
                    }
                    PsiClass clz = psiClass = psiClass2;
                    psiClass2 = $this$resolveOperator.getUastParent();
                    parent = psiClass2 instanceof UBinaryExpression ? (UBinaryExpression)psiClass2 : null;
                    isSetter = parent != null && UastExpressionUtils.isAssignment((UElement)((UElement)parent));
                    indices2 = $this$resolveOperator.getIndices();
                    parameterCount = indices2.size();
                    methods = clz.findMethodsByName(isSetter ? "set" : "get", true);
                    if (source != null) {
                        UElement method2;
                        Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
                        for (PsiMethod method3 : methods) {
                            LightMemberOrigin lightMemberOrigin;
                            if (!(method3 instanceof KtLightMemberImpl) || ((lightMemberOrigin = ((KtLightMemberImpl)method3).getLightMemberOrigin()) == null ? null : lightMemberOrigin.getOriginalElement()) != source) continue;
                            return method3;
                        }
                        if (source instanceof KtNamedFunction && KtPsiUtilKt.isExtensionDeclaration((PsiElement)source) && (method2 = UastContextKt.toUElement((PsiElement)source)) instanceof UMethod) {
                            return (PsiMethod)method2;
                        }
                    }
                    expectedCount = isSetter ? parameterCount + 1 : parameterCount;
                    Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
                    PsiMethod[] psiMethodArray = methods;
                    int n2 = 0;
                    if (psiMethodArray.length == 0) {
                        return null;
                    }
                    if (methods.length == 1) {
                        PsiMethod only = methods[0];
                        return expectedCount == only.getParameterList().getParametersCount() ? only : null;
                    }
                    PsiMethod[] $this$singleOrNull$iv = methods;
                    boolean $i$f$singleOrNull = false;
                    PsiMethod single$iv = null;
                    boolean found$iv = false;
                    PsiMethod[] psiMethodArray2 = $this$singleOrNull$iv;
                    int n3 = psiMethodArray2.length;
                    for (n = 0; n < n3; ++n) {
                        PsiMethod element$iv;
                        method = element$iv = psiMethodArray2[n];
                        boolean bl = false;
                        PsiParameter[] psiParameterArray = method.getParameterList();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList");
                        parameters = psiParameterArray;
                        if (!(parameters.getParametersCount() == expectedCount)) continue;
                        if (found$iv) {
                            psiMethod3 = null;
                            break block27;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    psiMethod3 = arityCountMatch = !found$iv ? null : single$iv;
                }
                if (arityCountMatch != null) {
                    return arityCountMatch;
                }
                PsiMethod[] $this$singleOrNull$iv = methods;
                boolean $i$f$singleOrNull = false;
                PsiMethod single$iv = null;
                boolean found$iv = false;
                PsiMethod[] psiMethodArray = $this$singleOrNull$iv;
                n = psiMethodArray.length;
                for (int element$iv = 0; element$iv < n; ++element$iv) {
                    boolean bl;
                    PsiMethod element$iv2;
                    PsiMethod method4 = element$iv2 = psiMethodArray[element$iv];
                    boolean bl2 = false;
                    parameters = method4.getParameterList().getParameters();
                    if (parameters.length == expectedCount) {
                        boolean matches2 = true;
                        int n4 = 0;
                        if (n4 < parameterCount) {
                            do {
                                int i;
                                if (Lint.sameType(((UExpression)indices2.get(i = n4++)).getExpressionType(), parameters[i].getType(), true)) continue;
                                matches2 = false;
                                break;
                            } while (n4 < parameterCount);
                        }
                        if (isSetter && matches2) {
                            UExpression uExpression;
                            PsiType assignmentType;
                            UBinaryExpression uBinaryExpression = parent;
                            PsiType psiType = uBinaryExpression == null ? null : (assignmentType = (uExpression = uBinaryExpression.getRightOperand()) == null ? null : uExpression.getExpressionType());
                            if (!Lint.sameType(assignmentType, parameters[parameterCount].getType(), true)) {
                                matches2 = false;
                            }
                        }
                        bl = matches2;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    if (found$iv) {
                        psiMethod2 = null;
                        break block28;
                    }
                    single$iv = element$iv2;
                    found$iv = true;
                }
                psiMethod2 = typeEqualsMatch = !found$iv ? null : single$iv;
            }
            if (typeEqualsMatch != null) {
                return typeEqualsMatch;
            }
            PsiMethod[] $this$firstOrNull$iv = methods;
            boolean $i$f$firstOrNull = false;
            PsiMethod[] psiMethodArray = $this$firstOrNull$iv;
            int n5 = psiMethodArray.length;
            for (n = 0; n < n5; ++n) {
                boolean bl;
                PsiMethod element$iv;
                method = element$iv = psiMethodArray[n];
                boolean bl3 = false;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length == expectedCount) {
                    boolean matches = true;
                    int matches2 = 0;
                    if (matches2 < parameterCount) {
                        do {
                            int i;
                            if (Lint.sameType(((UExpression)indices2.get(i = matches2++)).getExpressionType(), parameters[i].getType(), false)) continue;
                            matches = false;
                            break;
                        } while (matches2 < parameterCount);
                    }
                    if (isSetter && matches) {
                        UExpression uExpression;
                        PsiType assignmentType;
                        UBinaryExpression uBinaryExpression = parent;
                        PsiType psiType = uBinaryExpression == null ? null : (assignmentType = (uExpression = uBinaryExpression.getRightOperand()) == null ? null : uExpression.getExpressionType());
                        if (!Lint.sameType(assignmentType, parameters[parameterCount].getType(), false)) {
                            matches = false;
                        }
                    }
                    bl = matches;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                psiMethod = element$iv;
                break block29;
            }
            psiMethod = null;
        }
        PsiMethod typeMatch = psiMethod;
        return typeMatch;
    }

    @Nullable
    public static final PsiElement resolveKotlinCall(@Nullable PsiElement sourcePsi) {
        KtElement ktElement;
        KtElement ktElement2 = ktElement = sourcePsi instanceof KtElement ? (KtElement)sourcePsi : null;
        if (ktElement == null) {
            return null;
        }
        KtElement ktElement3 = ktElement;
        KotlinUastResolveProviderService kotlinUastResolveProviderService = (KotlinUastResolveProviderService)((KtElement)sourcePsi).getProject().getService(KotlinUastResolveProviderService.class);
        if (kotlinUastResolveProviderService == null) {
            return null;
        }
        KotlinUastResolveProviderService service = kotlinUastResolveProviderService;
        BindingContext bindingContext = service.getBindingContext(ktElement3);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)ktElement3, (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        return (resolvedCall = Lint.toSource((DeclarationDescriptor)resolvedCall2.getResultingDescriptor())) == null ? LintJavaUtils.resolveToPsiMethod(ktElement3, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor(), null) : resolvedCall;
    }

    @Nullable
    public static final PsiType getKotlinDelegatePropertyType(@Nullable PsiElement sourcePsi, @NotNull UVariable element) {
        KotlinType newType;
        KtExpression expression;
        KtPropertyDelegate delegate;
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement ktElement2 = ktElement = sourcePsi instanceof KtElement ? (KtElement)sourcePsi : null;
        if (ktElement == null) {
            return null;
        }
        KtElement ktElement3 = ktElement;
        KotlinUastResolveProviderService kotlinUastResolveProviderService = (KotlinUastResolveProviderService)((KtElement)sourcePsi).getProject().getService(KotlinUastResolveProviderService.class);
        if (kotlinUastResolveProviderService == null) {
            return null;
        }
        KotlinUastResolveProviderService service = kotlinUastResolveProviderService;
        BindingContext bindingContext = service.getBindingContext(ktElement3);
        if (ktElement3 instanceof KtProperty && (delegate = ((KtProperty)ktElement3).getDelegate()) != null && (expression = delegate.getExpression()) != null && (newType = bindingContext.getType(expression)) != null) {
            return LintJavaUtils.getType(newType, (UElement)element, ktElement3, false);
        }
        return element.getType();
    }

    private static final PsiElement toSource(DeclarationDescriptor $this$toSource) {
        PsiElement psiElement;
        try {
            psiElement = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)DescriptorToSourceUtils.getEffectiveReferencedDescriptors((DeclarationDescriptor)$this$toSource)), (Function1)toSource.1.INSTANCE));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            psiElement = null;
        }
        return psiElement;
    }

    private static final boolean sameType(PsiType type1, PsiType type2, boolean equalsOnly) {
        boolean equals = PsiTypesUtil.compareTypes((PsiType)type1, (PsiType)type2, (boolean)true);
        if (equals || equalsOnly) {
            return equals;
        }
        PsiType psiType = type1;
        if (psiType == null) {
            return false;
        }
        psiType = type2;
        if (psiType == null) {
            return false;
        }
        return TypeConversionUtil.areTypesConvertible((PsiType)type2, (PsiType)type1);
    }

    @NotNull
    public static final String getLayoutName(@NotNull File layoutFile) {
        String name;
        Intrinsics.checkNotNullParameter((Object)layoutFile, (String)"layoutFile");
        String string = name = layoutFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        int dotIndex = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex != -1) {
            string = name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            int n = 0;
            boolean bl = false;
            String string2 = string.substring(n, dotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            name = string2;
        }
        string = name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return string;
    }

    @NotNull
    public static final Iterable<String> splitPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (StringsKt.indexOf$default((CharSequence)path2, (char)';', (int)0, (boolean)false, (int)6, null) != -1) {
            Iterable iterable = Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path2);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"on(';').omitEmptyStrings\u2026trimResults().split(path)");
            return iterable;
        }
        ArrayList<String> combined = new ArrayList<String>();
        Iterables.addAll((Collection)combined, (Iterable)Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)path2));
        int i = 0;
        int n = combined.size();
        while (i < n) {
            Object object = combined.get(i);
            Intrinsics.checkNotNullExpressionValue(object, (String)"combined[i]");
            String p = (String)object;
            if (p.length() == 1 && i < n - 1 && Character.isLetter(p.charAt(0))) {
                object = combined.get(i + 1);
                Intrinsics.checkNotNullExpressionValue(object, (String)"combined[i + 1]");
                object = (CharSequence)object;
                boolean bl = false;
                if (!(object.length() == 0) && ((String)combined.get(i + 1)).charAt(0) == '\\') {
                    combined.set(i, p + ':' + (String)combined.get(i + 1));
                    combined.remove(i + 1);
                    int n2 = n;
                    n = n2 + -1;
                }
            }
            int n3 = i;
            i = n3 + 1;
        }
        return combined;
    }

    @Nullable
    public static final File getCommonParent(@NotNull List<? extends File> files) {
        int fileCount;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        int n = fileCount = files.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return files.get(0);
            }
            case 2: {
                return Lint.getCommonParent(files.get(0), files.get(1));
            }
        }
        File common = files.get(0);
        int n2 = 1;
        if (n2 < fileCount) {
            do {
                int i = n2++;
                File file = common;
                Intrinsics.checkNotNull((Object)file);
                common = Lint.getCommonParent(file, files.get(i));
                if (common != null) continue;
                return null;
            } while (n2 < fileCount);
        }
        return common;
    }

    @Nullable
    public static final File getCommonParent(@NotNull File file1, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        if (Intrinsics.areEqual((Object)file1, (Object)file2)) {
            return file1;
        }
        String string = file1.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file1.path");
        String string2 = string;
        string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file2.path");
        if (StringsKt.startsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) {
            return file2;
        }
        string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file2.path");
        String string3 = string;
        string = file1.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file1.path");
        if (StringsKt.startsWith$default((String)string3, (String)string, (boolean)false, (int)2, null)) {
            return file1;
        }
        for (File first = file1.getParentFile(); first != null; first = first.getParentFile()) {
            for (File second = file2.getParentFile(); second != null; second = second.getParentFile()) {
                if (!Intrinsics.areEqual((Object)first, (Object)second)) continue;
                return first;
            }
        }
        return null;
    }

    public static final boolean isParent(@Nullable File parentCandidate, @NotNull File file, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = parentCandidate;
        if (file2 == null) {
            return false;
        }
        String path2 = file.getPath();
        String parentPath = parentCandidate.getPath();
        int parentLength = parentPath.length();
        int pathLength = path2.length();
        if (pathLength <= parentLength) {
            if (pathLength == parentLength) {
                return strict ? false : Intrinsics.areEqual((Object)path2, (Object)parentPath);
            }
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        Intrinsics.checkNotNullExpressionValue((Object)parentPath, (String)"parentPath");
        if (!StringsKt.startsWith$default((String)path2, (String)parentPath, (boolean)false, (int)2, null)) {
            return false;
        }
        return path2.charAt(parentLength) == '/' || path2.charAt(parentLength) == '\\';
    }

    public static /* synthetic */ boolean isParent$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Lint.isParent(file, file2, bl);
    }

    @NotNull
    public static final String getFileUri(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.toURI().toURL().toString();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"file://", (boolean)false, (int)2, null)) {
            String string3 = it;
            int n = 5;
            boolean bl4 = false;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string = Intrinsics.stringPlus((String)"file://", (Object)string4);
        } else {
            String string5;
            string = string5 = it;
        }
        return string;
    }

    @NotNull
    public static final CharSequence getEncodedString(@NotNull LintClient client, @NotNull File file, boolean createString) throws IOException {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] bytes = client.readBytes(file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (Lint.endsWith(string, ".xml")) {
            string = PositionXmlParser.getXmlString((byte[])bytes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        PositionXmlPar\u2026getXmlString(bytes)\n    }");
            charSequence = string;
        } else {
            charSequence = Lint.getEncodedString(bytes, createString);
        }
        return charSequence;
    }

    public static final boolean isDataBindingExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return StringsKt.startsWith$default((String)expression, (String)"@{", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)expression, (String)"@={", (boolean)false, (int)2, null);
    }

    public static final boolean isManifestPlaceHolderExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return StringsKt.contains$default((CharSequence)expression, (CharSequence)"${", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final CharSequence getEncodedString(@Nullable byte[] data, boolean createString) {
        boolean bl;
        if (data == null) {
            return "";
        }
        int offset = 0;
        String defaultCharset = "UTF-8";
        String charset = null;
        if (data.length > 4) {
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                defaultCharset = charset = "UTF-8";
                offset += 3;
            } else if (data[0] == -2 && data[1] == -1) {
                defaultCharset = charset = UTF_16;
                offset += 2;
            } else if (data[0] == 0 && data[1] == 0 && data[2] == -2 && data[3] == -1) {
                defaultCharset = charset = "UTF_32";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2 && data[2] == 0 && data[3] == 0) {
                defaultCharset = charset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2) {
                defaultCharset = charset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        int n = offset;
        int n2 = data.length;
        if (n < n2) {
            do {
                int lineEnd;
                if (data[lineEnd = n++] == 0) {
                    if ((lineEnd - offset) % 2 == 0) {
                        seenEvenZero = true;
                        continue;
                    }
                    seenOddZero = true;
                    continue;
                }
                if (data[lineEnd] == 10 || data[lineEnd] == 13) break;
            } while (n < n2);
        }
        if (charset == null) {
            String string = seenOddZero ? UTF_16LE : (charset = seenEvenZero ? UTF_16 : "UTF-8");
        }
        if (!createString && Intrinsics.areEqual((Object)"UTF-8", (Object)charset)) {
            ByteBuffer bytes = ByteBuffer.wrap(data, offset, length);
            try {
                CharBuffer decode22 = Charsets.UTF_8.newDecoder().decode(bytes);
                decode22.compact();
                int size = decode22.position();
                boolean bl2 = size <= decode22.limit();
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                char[] array = decode22.array();
                CharSequence charSequence = CharSequences.createSequence((char[])array, (int)0, (int)size);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"createSequence(array, 0, size)");
                return charSequence;
            }
            catch (CharacterCodingException decode22) {
                // empty catch block
            }
        }
        CharSequence text = null;
        try {
            boolean decode22 = false;
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.forName(charsetName)");
            Charset decode22 = charset2;
            bl = false;
            text = new String(data, offset, length, decode22);
        }
        catch (UnsupportedEncodingException e) {
            try {
                if (!Intrinsics.areEqual((Object)charset, (Object)defaultCharset)) {
                    bl = false;
                    Charset charset3 = Charset.forName(defaultCharset);
                    Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"Charset.forName(charsetName)");
                    Charset charset4 = charset3;
                    boolean bl6 = false;
                    text = new String(data, offset, length, charset4);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (text == null) {
            boolean bl7 = false;
            text = new String(data, offset, length, Charsets.UTF_8);
        }
        return text;
    }

    public static final boolean isStaticInnerClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List fieldList = classNode.fields;
        for (FieldNode f : fieldList) {
            if (f == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldNode");
            }
            FieldNode field = f;
            String string = field.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
            if (!StringsKt.startsWith$default((String)string, (String)"this$", (boolean)false, (int)2, null) || (field.access & 0x1000) == 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isAnonymousClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        if (classNode.outerClass == null) {
            return false;
        }
        String name = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'$', (int)0, (boolean)false, (int)6, null);
        return index == -1 || index == name.length() - 1 ? false : Character.isDigit(name.charAt(index + 1));
    }

    public static final int getPrevOpcode(@NotNull AbstractInsnNode node) {
        int n;
        AbstractInsnNode prev;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode abstractInsnNode = prev = Lint.getPrevInstruction(node);
        return abstractInsnNode == null ? 0 : (n = abstractInsnNode.getOpcode());
    }

    @Nullable
    public static final AbstractInsnNode getPrevInstruction(@NotNull AbstractInsnNode node) {
        int type;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode prev = node;
        do {
            if ((prev = prev.getPrevious()) != null) continue;
            return null;
        } while ((type = prev.getType()) == 15 || type == 8 || type == 14);
        return prev;
    }

    public static final int getNextOpcode(@NotNull AbstractInsnNode node) {
        int n;
        AbstractInsnNode next;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode abstractInsnNode = next = Lint.getNextInstruction(node);
        return abstractInsnNode == null ? 0 : (n = abstractInsnNode.getOpcode());
    }

    @Nullable
    public static final AbstractInsnNode getNextInstruction(@NotNull AbstractInsnNode node) {
        int type;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode next = node;
        do {
            if ((next = next.getNext()) != null) continue;
            return null;
        } while ((type = next.getType()) == 15 || type == 8 || type == 14);
        return next;
    }

    public static final boolean isManifestFolder(@Nullable File dir) {
        File file = dir;
        if (file == null) {
            return false;
        }
        File current = file;
        boolean hasManifest = new File(current, "AndroidManifest.xml").exists();
        if (hasManifest && Intrinsics.areEqual((Object)current.getName(), (Object)"bin")) {
            File file2 = current.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"current.parentFile");
            current = file2;
            if (Lint.isManifestFolder(current)) {
                return false;
            }
        }
        return hasManifest;
    }

    @Nullable
    public static final String getLocaleAndRegion(@NotNull String folderName) {
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        if (StringsKt.indexOf$default((CharSequence)folderName, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
            return null;
        }
        String locale = null;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName)) {
            char second;
            char first;
            int qualifierLength = qualifier.length();
            if (qualifierLength == 2) {
                first = qualifier.charAt(0);
                second = qualifier.charAt(1);
                boolean bl = 'a' <= first ? first <= 'z' : false;
                if (!bl) continue;
                boolean bl2 = 'a' <= second ? second <= 'z' : false;
                if (!bl2) continue;
                locale = qualifier;
                continue;
            }
            if (qualifierLength == 3 && qualifier.charAt(0) == 'r' && locale != null) {
                first = qualifier.charAt(1);
                second = qualifier.charAt(2);
                boolean bl = 'A' <= first ? first <= 'Z' : false;
                if (!bl) break;
                boolean bl3 = 'A' <= second ? second <= 'Z' : false;
                if (!bl3) break;
                return locale + '-' + qualifier;
            }
            Intrinsics.checkNotNullExpressionValue((Object)qualifier, (String)"qualifier");
            if (!StringsKt.startsWith$default((String)qualifier, (String)"b+", (boolean)false, (int)2, null)) continue;
            return qualifier;
        }
        return locale;
    }

    @Nullable
    public static final List<ResourceValue> getStyleAttributes(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl, @NotNull String namespaceUri, @NotNull String attribute, boolean acceptMissing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)styleUrl, (String)"styleUrl");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = new ArrayList();
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        int count = 0;
        while (count < 30 && !queue.isEmpty()) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            if (!acceptMissing && items.isEmpty()) {
                return null;
            }
            for (ResourceItem item : items) {
                String parentName;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                ResourceNamespace namespace = (ResourceNamespace)MoreObjects.firstNonNull((Object)ResourceNamespace.fromNamespaceUri((String)namespaceUri), (Object)ResourceNamespace.TODO());
                String frameworkResource = !StringsKt.startsWith$default((String)attribute, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID) ? Intrinsics.stringPlus((String)"android:", (Object)attribute) : (String)null;
                for (StyleItemResourceValue styleItem : srv.getDefinedItems()) {
                    if ((!Intrinsics.areEqual((Object)styleItem.getAttrName(), (Object)attribute) || !Intrinsics.areEqual((Object)styleItem.getNamespace(), (Object)namespace)) && !Intrinsics.areEqual((Object)styleItem.getAttrName(), (Object)frameworkResource) || result.contains(styleItem)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)styleItem, (String)"styleItem");
                    result.add(styleItem);
                }
                String parent = srv.getParentStyleName();
                if (parent != null && !StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) && (p = ResourceUrl.parse((String)parent)) != null) {
                    if (!acceptMissing && p.isFramework()) {
                        return null;
                    }
                    if (!p.isFramework() && !seen.contains(p.name)) {
                        seen.add(p.name);
                        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (parent != null || index <= 0) continue;
                String string = name;
                int n = 0;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
            int n = count;
            count = n + 1;
        }
        return result;
    }

    public static /* synthetic */ List getStyleAttributes$default(Project project, LintClient lintClient, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return Lint.getStyleAttributes(project, lintClient, string, string2, string3, bl);
    }

    @Nullable
    public static final List<StyleResourceValue> getInheritedStyles(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)styleUrl, (String)"styleUrl");
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = null;
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        int count = 0;
        while (count < 30 && !queue.isEmpty()) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            for (ResourceItem item : items) {
                String parentName;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(rv);
                String parent = ((StyleResourceValue)rv).getParentStyleName();
                if (!(parent == null || StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) || (p = ResourceUrl.parse((String)parent)) == null || p.isFramework() || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                }
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (index <= 0) continue;
                String string = name;
                int n = 0;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
            int n = count;
            count = n + 1;
        }
        return result;
    }

    public static final boolean isSameResourceFile(@Nullable File file1, @Nullable File file2) {
        if (file1 != null && file2 != null && Intrinsics.areEqual((Object)file1.getName(), (Object)file2.getName())) {
            File parent1 = file1.getParentFile();
            File parent2 = file2.getParentFile();
            if (parent1 != null && parent2 != null && Intrinsics.areEqual((Object)parent1.getName(), (Object)parent2.getName())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final String computeResourceName(@NotNull String prefix, @NotNull String name, @Nullable ResourceFolderType folderType) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object newPrefix = prefix;
        String newName = name;
        CharSequence charSequence = (CharSequence)newPrefix;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return newName;
        }
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            charSequence = newName;
            Object object = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
            n = 0;
            CharSequence charSequence2 = charSequence;
            boolean bl2 = false;
            String string2 = ((String)charSequence2).toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
            newName = string2;
            String underlined = SdkVersionInfo.camelCaseToUnderlines((String)newPrefix);
            if (!Intrinsics.areEqual((Object)newPrefix, (Object)underlined)) {
                object = underlined;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"underlined");
                if (!StringsKt.endsWith$default((String)object, (String)"_", (boolean)false, (int)2, null)) {
                    underlined = Intrinsics.stringPlus((String)underlined, (Object)"_");
                }
                object = underlined;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"underlined");
                newPrefix = object;
            }
        }
        charSequence = newName;
        bl = false;
        if (!(charSequence.length() == 0) && Character.isUpperCase(newName.charAt(0))) {
            if (StringsKt.indexOf$default((CharSequence)((CharSequence)newPrefix), (char)'_', (int)0, (boolean)false, (int)6, null) != -1) {
                charSequence = SdkVersionInfo.underlinesToCamelCase((String)newPrefix);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"underlinesToCamelCase(newPrefix)");
                newPrefix = charSequence;
            }
            char c = Character.toUpperCase(((String)newPrefix).charAt(0));
            String string3 = newPrefix;
            n = 1;
            boolean bl3 = false;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string4;
            n = 0;
            newPrefix = String.valueOf(c) + string3;
            if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
                Object object = newPrefix;
                int n2 = 0;
                n = ((String)newPrefix).length() - 1;
                bl3 = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = ((String)object2).substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                newPrefix = string5;
            }
        }
        CharSequence charSequence3 = newName;
        int n3 = 0;
        if (charSequence3.length() == 0) {
            string = newPrefix;
        } else if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
            string = Intrinsics.stringPlus((String)newPrefix, (Object)newName);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append((String)newPrefix).append(Character.toUpperCase(newName.charAt(0)));
            charSequence3 = newName;
            n3 = 1;
            n = 0;
            CharSequence charSequence4 = charSequence3;
            if (charSequence4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = ((String)charSequence4).substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string6).toString();
        }
        return string;
    }

    public static /* synthetic */ String computeResourceName$default(String string, String string2, ResourceFolderType resourceFolderType, int n, Object object) {
        if ((n & 4) != 0) {
            resourceFolderType = null;
        }
        return Lint.computeResourceName(string, string2, resourceFolderType);
    }

    public static final boolean isModelOlderThan(@NotNull Project project, int major, int minor, int micro, boolean defaultForNonGradleProjects) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleVersion gradleVersion = project.getGradleModelVersion();
        if (gradleVersion == null) {
            return defaultForNonGradleProjects;
        }
        GradleVersion gradleVersion2 = gradleVersion;
        GradleVersion version = gradleVersion2;
        if (version.getMajor() != major) {
            return version.getMajor() < major;
        }
        return version.getMinor() != minor ? version.getMinor() < minor : version.getMicro() < micro;
    }

    public static /* synthetic */ boolean isModelOlderThan$default(Project project, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return Lint.isModelOlderThan(project, n, n2, n3, bl);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull UElement element, @NotNull LanguageLevel defaultLevel) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        if (uFile == null) {
            return defaultLevel;
        }
        UFile containingFile = uFile;
        return Lint.getLanguageLevel((PsiElement)containingFile.getPsi(), defaultLevel);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull PsiElement element, @NotNull LanguageLevel defaultLevel) {
        LanguageLevel languageLevel;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : null;
        PsiFile containingFile = psiFile == null ? element.getContainingFile() : psiFile;
        PsiJavaFile psiJavaFile = psiFile = containingFile instanceof PsiJavaFile ? (PsiJavaFile)containingFile : null;
        return psiFile == null ? defaultLevel : ((languageLevel = psiFile.getLanguageLevel()) == null ? defaultLevel : languageLevel);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull Project project, @NotNull LanguageLevel defaultLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        com.intellij.openapi.project.Project project2 = project.getIdeaProject();
        if (project2 == null) {
            return defaultLevel;
        }
        com.intellij.openapi.project.Project project3 = project2;
        com.intellij.openapi.project.Project p = project3;
        if ((project2 = LanguageLevelProjectExtension.getInstance((com.intellij.openapi.project.Project)p)) == null) {
            return defaultLevel;
        }
        com.intellij.openapi.project.Project extension = project2;
        project2 = extension.getLanguageLevel();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"extension.languageLevel");
        return project2;
    }

    @Nullable
    public static final String findSubstring(@NotNull String string, @Nullable String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int start = 0;
        if (prefix != null) {
            start = StringsKt.indexOf$default((CharSequence)string, (String)prefix, (int)0, (boolean)false, (int)6, null);
            if (start == -1) {
                return null;
            }
            start += prefix.length();
        }
        if (suffix != null) {
            String string2;
            int end = StringsKt.indexOf$default((CharSequence)string, (String)suffix, (int)start, (boolean)false, (int)4, null);
            if (end == -1) {
                string2 = null;
            } else {
                String string3 = string;
                boolean bl = false;
                String string4 = string3.substring(start, end);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }
        String string5 = string;
        boolean bl = false;
        String string6 = string5.substring(start);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        return string6;
    }

    @NotNull
    public static final List<String> getFormattedParameters(@NotNull String format, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        StringBuilder pattern = new StringBuilder(format.length());
        int parameter = 0;
        parameter = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int i = 0;
        int n = format.length();
        while (i < n) {
            int n2;
            char c = format.charAt(i);
            if (c == '%') {
                n2 = i < format.length() - 4 ? 1 : 0;
                boolean bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$62 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$62 = format;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$62));
                }
                n2 = format.charAt(i + 1) == 48 + parameter ? 1 : 0;
                bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$72 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$72 = format;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$72));
                }
                n2 = Character.isDigit(format.charAt(i + 1)) ? 1 : 0;
                bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$82 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$82 = format;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$82));
                }
                n2 = format.charAt(i + 2) == '$' ? 1 : 0;
                bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$92 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$92 = format;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$92));
                }
                n2 = format.charAt(i + 3) == 's' ? 1 : 0;
                bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean bl5 = false;
                    String string = format;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                n2 = parameter;
                parameter = n2 + 1;
                i += 3;
                pattern.append("(.*)");
            } else {
                pattern.append(c);
            }
            n2 = i;
            i = n2 + 1;
        }
        try {
            Pattern compile = Pattern.compile(pattern.toString());
            Matcher matcher = compile.matcher(errorMessage);
            if (matcher.find()) {
                int groupCount = matcher.groupCount();
                ArrayList<String> parameters = new ArrayList<String>(groupCount);
                int n3 = 1;
                if (n3 <= groupCount) {
                    int i2;
                    do {
                        i2 = n3++;
                        parameters.add(matcher.group(i2));
                    } while (i2 != groupCount);
                }
                return parameters;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull String parent) {
        FolderConfiguration config;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (StringsKt.indexOf$default((CharSequence)parent, (char)'-', (int)0, (boolean)false, (int)6, null) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parent)) != null) {
            return config.getLocaleQualifier();
        }
        return null;
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull XmlContext context2) {
        String locale;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Element root = context2.document.getDocumentElement();
        if (root != null && (locale = root.getAttributeNS("http://schemas.android.com/tools", "locale")) != null) {
            CharSequence charSequence = locale;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                if (StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
                    return LocaleQualifier.getQualifier((String)locale);
                }
                FolderConfiguration config = FolderConfiguration.getConfigForQualifierString((String)locale);
                if (config != null) {
                    return config.getLocaleQualifier();
                }
            }
        }
        String string = context2.file.getParentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.parentFile.name");
        return Lint.getLocale(string);
    }

    public static final boolean isEnglishResource(@NotNull XmlContext context2, boolean assumeForBase) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LocaleQualifier locale = Lint.getLocale(context2);
        return locale == null ? assumeForBase : Intrinsics.areEqual((Object)"en", (Object)locale.getLanguage());
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.getDir()");
        File dir = file;
        Location location2 = null;
        File topLevel = BuildScriptUtil.findGradleBuildFile((File)dir);
        location2 = topLevel.exists() ? Location.Companion.create(topLevel) : Location.Companion.create(dir);
        return location2;
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull LintClient client, @NotNull File projectDir, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        File gradle = BuildScriptUtil.findGradleBuildFile((File)projectDir);
        return Lint.guessGradleLocationForFile(client, gradle, string);
    }

    @NotNull
    public static final Location guessGradleLocationForFile(@NotNull LintClient client, @NotNull File gradle, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        if (gradle.isFile()) {
            if (string == null) {
                return Location.Companion.create(gradle);
            }
            String contents = ((Object)client.readFile(gradle)).toString();
            int match = StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)0, (boolean)false, (int)6, null);
            if (match != -1) {
                int length = string.length();
                if (StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)(match + length), (boolean)false, (int)4, null) == -1) {
                    return Location.Companion.create(gradle, contents, match, match + length);
                }
                int end = contents.length();
                char first = string.charAt(0);
                int offset = 0;
                while (offset < end - 1) {
                    char c = contents.charAt(offset);
                    if (c == '/') {
                        char next = contents.charAt(offset + 1);
                        if (next == '/') {
                            if ((offset = StringsKt.indexOf$default((CharSequence)contents, (char)'\n', (int)offset, (boolean)false, (int)4, null)) != -1) {
                                int n = offset;
                                offset = n + 1;
                                continue;
                            }
                            break;
                        }
                        if (next == '*') {
                            if ((offset = StringsKt.indexOf$default((CharSequence)contents, (String)"*/", (int)offset, (boolean)false, (int)4, null)) != -1) continue;
                            break;
                        }
                    }
                    if (c == first && StringsKt.regionMatches$default((String)contents, (int)offset, (String)string, (int)0, (int)length, (boolean)false, (int)16, null)) {
                        return Location.Companion.create(gradle, contents, offset, offset + length);
                    }
                    int n = offset;
                    offset = n + 1;
                }
            }
        } else if (gradle.isDirectory()) {
            return Lint.guessGradleLocation(client, gradle, string);
        }
        return Location.Companion.create(gradle);
    }

    public static final boolean isNullLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"null", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isTrueLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"true", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isFalseLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"false", (Object)((PsiLiteral)element).getText());
    }

    @Deprecated(message="This method is ambiguous. To move up/out in the AST, use skipParenthesizedExprUp instead (and from Java, import static method in UastUtils). To go inside the parentheses, instead use skipParenthesizedExprUp()", replaceWith=@ReplaceWith(expression="skipParenthesizedExprUp(element)", imports={"com.intellij.psi.util.PsiUtil.skipParenthesizedExprUp"}))
    @Nullable
    public static final PsiElement skipParentheses(@Nullable PsiElement element) {
        return PsiUtil.skipParenthesizedExprUp((PsiElement)element);
    }

    @Deprecated(message="This method is ambiguous. To move up/out in the AST, use skipParenthesizedExprUp instead (and from Java, import static method in UastUtils). If the element is not a UExpression there's no need to call this method. To go inside the parentheses, instead use skipParenthesizedExprUp()", replaceWith=@ReplaceWith(expression="skipParenthesizedExprUp(element)", imports={"org.jetbrains.uast.skipParenthesizedExprUp"}))
    @Nullable
    public static final UElement skipParentheses(@Nullable UElement element) {
        UElement current = element;
        while (current instanceof UParenthesizedExpression) {
            current = ((UParenthesizedExpression)current).getUastParent();
        }
        return current;
    }

    @Nullable
    public static final PsiElement nextNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getNextSibling();
            }
        }
        return current;
    }

    @Nullable
    public static final PsiElement prevNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getPrevSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getPrevSibling();
            }
        }
        return current;
    }

    public static final boolean isString(@NotNull PsiType type) {
        String shortName;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof PsiClassType && !Objects.equal((Object)(shortName = ((PsiClassType)type).getClassName()), (Object)"String")) {
            return false;
        }
        return Intrinsics.areEqual((Object)"java.lang.String", (Object)type.getCanonicalText());
    }

    public static final boolean isInlined(@NotNull PsiField field, @NotNull JavaEvaluator evaluator) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        PsiType psiType = field.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"field.type");
        PsiType type = psiType;
        return type instanceof PsiPrimitiveType || Lint.isString(type) ? evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field) : false;
    }

    @Nullable
    public static final String getAutoBoxedType(@NotNull String primitive) {
        Intrinsics.checkNotNullParameter((Object)primitive, (String)"primitive");
        return Intrinsics.areEqual((Object)"int", (Object)primitive) ? "java.lang.Integer" : (Intrinsics.areEqual((Object)"long", (Object)primitive) ? "java.lang.Long" : (Intrinsics.areEqual((Object)"char", (Object)primitive) ? "java.lang.Character" : (Intrinsics.areEqual((Object)"float", (Object)primitive) ? "java.lang.Float" : (Intrinsics.areEqual((Object)"double", (Object)primitive) ? "java.lang.Double" : (Intrinsics.areEqual((Object)"boolean", (Object)primitive) ? "java.lang.Boolean" : (Intrinsics.areEqual((Object)"short", (Object)primitive) ? "java.lang.Short" : (Intrinsics.areEqual((Object)"byte", (Object)primitive) ? "java.lang.Byte" : null)))))));
    }

    @Nullable
    public static final String getPrimitiveType(@NotNull String autoBoxedType) {
        Intrinsics.checkNotNullParameter((Object)autoBoxedType, (String)"autoBoxedType");
        return Intrinsics.areEqual((Object)"java.lang.Integer", (Object)autoBoxedType) ? "int" : (Intrinsics.areEqual((Object)"java.lang.Long", (Object)autoBoxedType) ? "long" : (Intrinsics.areEqual((Object)"java.lang.Character", (Object)autoBoxedType) ? "char" : (Intrinsics.areEqual((Object)"java.lang.Float", (Object)autoBoxedType) ? "float" : (Intrinsics.areEqual((Object)"java.lang.Double", (Object)autoBoxedType) ? "double" : (Intrinsics.areEqual((Object)"java.lang.Boolean", (Object)autoBoxedType) ? "boolean" : (Intrinsics.areEqual((Object)"java.lang.Short", (Object)autoBoxedType) ? "short" : (Intrinsics.areEqual((Object)"java.lang.Byte", (Object)autoBoxedType) ? "byte" : null)))))));
    }

    @NotNull
    public static final String resolveManifestName(@NotNull Element element) {
        String pkg;
        String className;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        string = className = StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) {
            pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return Intrinsics.stringPlus((String)pkg, (Object)className);
        }
        pkg = className;
        Intrinsics.checkNotNullExpressionValue((Object)pkg, (String)"className");
        if (StringsKt.indexOf$default((CharSequence)pkg, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return pkg + '.' + className;
        }
        string = className;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        return string;
    }

    @Deprecated(message="Supply defaultValue for missing variables", replaceWith=@ReplaceWith(expression="resolvePlaceHolders(project, value, substitutions, \"\"", imports={}))
    @NotNull
    public static final String resolvePlaceHolders(@Nullable Project project, @NotNull String value, @Nullable Map<String, String> substitutions) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = Lint.resolvePlaceHolders(project, value, substitutions, "");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Contract(value="_, !null, _, !null -> !null")
    @Nullable
    public static final String resolvePlaceHolders(@Nullable Project project, @NotNull String value, @Nullable Map<String, String> substitutions, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String s = value;
        int start;
        while ((start = StringsKt.indexOf$default((CharSequence)s, (String)"${", (int)0, (boolean)false, (int)6, null)) != -1) {
            Object object;
            String name;
            int end = StringsKt.indexOf$default((CharSequence)s, (String)"}", (int)(start + 1), (boolean)false, (int)4, null);
            if (end == -1) {
                return s;
            }
            String string = s;
            int n = start + "${".length();
            int n2 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = Lint.resolvePlaceHolder(project, name);
            if (string3 == null) {
                String string4;
                Object object2 = substitutions;
                String string5 = string4 = object2 == null ? null : object2.get(name);
                if (string4 == null) {
                    object2 = defaultValue;
                    if (object2 == null) {
                        return null;
                    }
                    object = object2;
                } else {
                    object = string4;
                }
            } else {
                object = string3;
            }
            String replacement = object;
            StringBuilder stringBuilder = new StringBuilder();
            string3 = s;
            n2 = 0;
            boolean bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, start);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string7).append(replacement);
            string3 = s;
            n2 = end + "}".length();
            bl = false;
            String string8 = string3;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            s = stringBuilder2.append(string9).toString();
        }
        return s;
    }

    public static /* synthetic */ String resolvePlaceHolders$default(Project project, String string, Map map, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return Lint.resolvePlaceHolders(project, string, map, string2);
    }

    @Nullable
    public static final String resolvePlaceHolder(@Nullable Project project, @NotNull String name) {
        LintModelVariant lintModelVariant;
        LintModelVariant lintModelVariant2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Project project2 = project;
        LintModelVariant lintModelVariant3 = lintModelVariant2 = project2 == null ? null : project2.getBuildVariant();
        if (lintModelVariant2 == null) {
            return null;
        }
        LintModelVariant variant = lintModelVariant = lintModelVariant2;
        Map placeHolders = variant.getManifestPlaceholders();
        return (String)placeHolders.get(name);
    }

    public static final boolean isJavaKeyword(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        switch (keyword) {
            case "synchronized": 
            case "do": 
            case "float": 
            case "while": 
            case "protected": 
            case "continue": 
            case "else": 
            case "catch": 
            case "if": 
            case "case": 
            case "new": 
            case "package": 
            case "static": 
            case "void": 
            case "byte": 
            case "double": 
            case "finally": 
            case "this": 
            case "strictfp": 
            case "throws": 
            case "enum": 
            case "extends": 
            case "null": 
            case "transient": 
            case "final": 
            case "true": 
            case "try": 
            case "implements": 
            case "private": 
            case "const": 
            case "import": 
            case "for": 
            case "interface": 
            case "long": 
            case "switch": 
            case "default": 
            case "goto": 
            case "public": 
            case "native": 
            case "assert": 
            case "class": 
            case "break": 
            case "false": 
            case "volatile": 
            case "abstract": 
            case "int": 
            case "instanceof": 
            case "super": 
            case "boolean": 
            case "throw": 
            case "char": 
            case "short": 
            case "return": {
                return true;
            }
        }
        return false;
    }

    public static final boolean isKotlinHardKeyword(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        switch (keyword) {
            case "for": 
            case "do": 
            case "interface": 
            case "while": 
            case "when": 
            case "continue": 
            case "else": 
            case "typealias": 
            case "class": 
            case "if": 
            case "typeof": 
            case "val": 
            case "package": 
            case "break": 
            case "in": 
            case "var": 
            case "false": 
            case "this": 
            case "is": 
            case "super": 
            case "as": 
            case "null": 
            case "throw": 
            case "true": 
            case "try": 
            case "fun": 
            case "return": 
            case "object": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] readUrlData(@NotNull LintClient client, @NotNull String query, int timeout) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        URL url = new URL(query);
        Object object = client.openConnection(url, timeout);
        if (object == null) {
            return null;
        }
        URLConnection connection = object;
        try {
            InputStream inputStream = connection.getInputStream();
            if (inputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            InputStream is = inputStream;
            object = ByteStreams.toByteArray((InputStream)is);
        }
        finally {
            client.closeConnection(connection);
        }
        return object;
    }

    @Nullable
    public static final String readUrlDataAsString(@NotNull LintClient client, @NotNull String query, int timeout) {
        String string;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        byte[] bytes = Lint.readUrlData(client, query, timeout);
        if (bytes != null) {
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            string = new String(bytes, charset);
        } else {
            string = null;
        }
        return string;
    }

    @SafeVarargs
    @Nullable
    public static final <T> T coalesce(T ... ts) {
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static final String getMethodName(@NotNull UCallExpression call) {
        UIdentifier methodIdentifier;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        UIdentifier uIdentifier = methodIdentifier = call.getMethodIdentifier();
        String string = uIdentifier == null ? null : uIdentifier.getName();
        return string == null ? call.getMethodName() : string;
    }

    public static final boolean isKotlin(@Nullable PsiElement element) {
        return element != null && Lint.isKotlin(element.getLanguage());
    }

    public static final boolean isLayoutMarkerTag(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tagName = element.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)tagName, (String)"tagName");
        if (Lint.isLayoutMarkerTag(tagName)) {
            return true;
        }
        return Intrinsics.areEqual((Object)tagName, (Object)"attr") && Intrinsics.areEqual((Object)element.getNamespaceURI(), (Object)"http://schemas.android.com/aapt");
    }

    public static final boolean isLayoutMarkerTag(@NotNull String tagName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        switch (tagName) {
            case "layout": 
            case "requestFocus": 
            case "data": 
            case "import": 
            case "variable": 
            case "tag": 
            case "aapt:attr": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isJava(@Nullable PsiElement element) {
        return element != null && Lint.isJava(element.getLanguage());
    }

    public static final boolean isKotlin(@Nullable Language language) {
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    public static final boolean isJava(@Nullable Language language) {
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE);
    }

    public static final boolean isNumberString(@Nullable String s) {
        block6: {
            block5: {
                if (s == null) break block5;
                CharSequence charSequence = s;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block6;
            }
            return false;
        }
        int i = 0;
        int n = s.length();
        while (i < n) {
            if (!Character.isDigit(s.charAt(i))) {
                return false;
            }
            int n2 = i;
            i = n2 + 1;
        }
        return true;
    }

    public static final boolean isPolyadicFromStringTemplate(@Nullable UElement element) {
        boolean bl = false;
        return element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getSourcePsi() instanceof KtStringTemplateExpression;
    }

    @Nullable
    public static final Map<UExpression, PsiParameter> computeKotlinArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        int n;
        Object[] objectArray;
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (call instanceof UImplicitCallExpression) {
            return ((UImplicitCallExpression)call).getArgumentMapping();
        }
        if (method.getParameterList().getParametersCount() <= 1) {
            return null;
        }
        PsiElement psiElement = call.getPsi();
        KtElement ktElement2 = ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement == null) {
            return null;
        }
        KtElement receiver = ktElement;
        psiElement = (KotlinUastResolveProviderService)receiver.getProject().getService(KotlinUastResolveProviderService.class);
        if (psiElement == null) {
            return null;
        }
        PsiElement service = psiElement;
        BindingContext bindingContext = service.getBindingContext(receiver);
        Object[] parameters = method.getParameterList().getParameters();
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)receiver, (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Map map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"resolvedCall.valueArguments");
        Map valueArguments = map;
        boolean bl = false;
        Object[] elementMap = (Object[])new LinkedHashMap();
        for (UExpression parameter : call.getValueArguments()) {
            objectArray = elementMap;
            PsiElement psiElement2 = parameter.getPsi();
            if (psiElement2 == null) continue;
            n = 0;
            objectArray.put(psiElement2, parameter);
        }
        Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"parameters");
        Object[] objectArray2 = parameters;
        boolean parameter = false;
        objectArray = objectArray2;
        boolean bl2 = false;
        if (!(objectArray.length == 0)) {
            parameter = false;
            Map mapping = new LinkedHashMap();
            int firstParameterIndex = 0;
            PsiParameter firstParameter = (PsiParameter)ArraysKt.first((Object[])parameters);
            Intrinsics.checkNotNullExpressionValue((Object)firstParameter, (String)"firstParameter");
            if (UastLintUtilsKt.isReceiver(firstParameter)) {
                UExpression callReceiver = call.getReceiver();
                if (callReceiver != null) {
                    Map map2 = mapping;
                    PsiParameter psiParameter = firstParameter;
                    boolean bl3 = false;
                    map2.put(callReceiver, psiParameter);
                }
                n = firstParameterIndex;
                firstParameterIndex = n + 1;
            }
            Iterator iterator = valueArguments;
            boolean bl4 = false;
            Object object = iterator.entrySet().iterator();
            while (object.hasNext()) {
                Iterator iterator2 = iterator = object.next();
                boolean bl5 = false;
                ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)iterator2.getKey();
                Iterator iterator3 = iterator;
                boolean bl6 = false;
                ResolvedValueArgument valueArgument = (ResolvedValueArgument)iterator3.getValue();
                block2: for (ValueArgument argument : valueArgument.getArguments()) {
                    Object object2;
                    Object object3;
                    KtExpression ktExpression = argument.getArgumentExpression();
                    if (ktExpression == null) continue;
                    KtExpression expression = ktExpression;
                    UExpression arg = (UExpression)elementMap.get(expression);
                    int index = firstParameterIndex + parameterDescriptor.getIndex();
                    if (index >= parameters.length) continue;
                    if (arg != null) {
                        object3 = mapping;
                        object2 = parameters[index];
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters[index]");
                        boolean bl7 = false;
                        object3.put(arg, object2);
                        continue;
                    }
                    object2 = elementMap;
                    boolean bl8 = false;
                    object3 = object2.entrySet().iterator();
                    while (object3.hasNext()) {
                        Object object4 = object2 = (Map.Entry)object3.next();
                        boolean bl9 = false;
                        PsiElement a = (PsiElement)object4.getKey();
                        Object object5 = object2;
                        boolean bl10 = false;
                        UExpression b = (UExpression)object5.getValue();
                        if (mapping.get(b) != null || a.getParent() != expression) continue;
                        object5 = mapping;
                        Object object6 = parameters[index];
                        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters[index]");
                        boolean bl11 = false;
                        object5.put(b, object6);
                        continue block2;
                    }
                }
            }
            object = mapping;
            boolean bl12 = false;
            if (!object.isEmpty()) {
                return mapping;
            }
        }
        return null;
    }

    @Nullable
    public static final UMethod getUMethod(@NotNull PsiMethod $this$getUMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getUMethod, (String)"<this>");
        UElement uElement = UastFacade.INSTANCE.convertElementWithParent((PsiElement)$this$getUMethod, UMethod.class);
        return uElement instanceof UMethod ? (UMethod)uElement : null;
    }

    public static final boolean isJreFolder(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static final boolean isJdkFolder(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        return new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile();
    }

    @Nullable
    public static final Element matchXmlElement(@NotNull Element element, @NotNull Document targetDocument) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)targetDocument, (String)"targetDocument");
        Element target = targetDocument.getDocumentElement();
        boolean bl = false;
        List path2 = new ArrayList();
        Element curr = element;
        while (true) {
            Element element2;
            path2.add(curr);
            node = curr.getParentNode();
            Element element3 = element2 = node instanceof Element ? (Element)node : null;
            if (element2 == null) break;
            curr = element2;
        }
        if (path2.size() == 1 && Intrinsics.areEqual((Object)element.getTagName(), (Object)target.getTagName())) {
            return target;
        }
        CollectionsKt.reverse((List)path2);
        node = target;
        if (node == null) {
            return null;
        }
        Node start = node;
        if (!Intrinsics.areEqual((Object)start.getTagName(), (Object)((Element)path2.get(0)).getTagName())) {
            return null;
        }
        return Lint.search(path2, 1, (Element)start);
    }

    private static final Element search(List<? extends Element> path2, int index, Element parent) {
        if (index == path2.size()) {
            return parent;
        }
        Element source = path2.get(index);
        if (source.hasAttribute("name")) {
            String name = source.getAttribute("name");
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getAttribute("name"), (Object)name)) continue;
                return Lint.search(path2, index + 1, child);
            }
        } else if (source.hasAttribute("id")) {
            String id = source.getAttribute("id");
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getAttribute("id"), (Object)id)) continue;
                return Lint.search(path2, index + 1, child);
            }
        } else {
            Element element;
            int n;
            Node curr;
            String tag = source.getNodeName();
            int ordinal = 0;
            for (curr = (Node)source; curr != null; curr = curr.getPreviousSibling()) {
                if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)tag)) continue;
                n = ordinal;
                ordinal = n + 1;
            }
            curr = parent.getFirstChild();
            while (curr != null) {
                if ((curr = curr.getNextSibling()).getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)tag) || (ordinal = (n = ordinal) + -1) != 0) continue;
                Node node = curr;
                if (node == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element child = (Element)node;
                element = Lint.search(path2, index + 1, child);
                if (element != null) {
                    Element element2 = element;
                    boolean bl = false;
                    boolean bl2 = false;
                    Element it = element2;
                    boolean bl3 = false;
                    return it;
                }
                node = null;
                break;
            }
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getTagName(), (Object)tag) || (element = Lint.search(path2, index + 1, child)) == null) continue;
                Element element3 = element;
                boolean bl = false;
                boolean bl4 = false;
                Element it = element3;
                boolean bl5 = false;
                return it;
            }
        }
        return null;
    }
}

