/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AppCompatResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"AppCompatResource", (String)"Menu namespace", (String)"When using the appcompat library, menu resources should refer to the `showAsAction` in the `app:` namespace, not the `android:` namespace.\n\nSimilarly, when *not* using the appcompat library, you should be using the `android:showAsAction` attribute.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(AppCompatResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("showAsAction");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Project mainProject = context.getMainProject();
        if (mainProject.isGradleProject()) {
            Boolean appCompat = mainProject.dependsOn("com.android.support:appcompat-v7");
            if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                if (context.getFolderVersion() >= 14) {
                    return;
                }
                if (appCompat == Boolean.TRUE) {
                    context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Should use `app:showAsAction` with the appcompat library with `xmlns:app=\"http://schemas.android.com/apk/res-auto\"`");
                }
            } else if (appCompat == Boolean.FALSE) {
                context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Should use `android:showAsAction` when not using the appcompat library");
            }
        }
    }
}

