/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySizeDetector
extends ResourceXmlDetector {
    public static final Issue INCONSISTENT = Issue.create((String)"InconsistentArrays", (String)"Inconsistencies in array element counts", (String)"When an array is translated in a different locale, it should normally have the same number of elements as the original array. When adding or removing elements to an array, it is easy to forget to update all the locales, and this lint warning finds inconsistencies like these.\n\nNote however that there may be cases where you really want to declare a different number of array items in each configuration (for example where the array represents available options, and those options differ for different layout orientations and so on), so use your own judgement to decide if this is really an error.\n\nYou can suppress this error type if it finds false errors in your project.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)new Implementation(ArraySizeDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private Multimap<File, Pair<String, Integer>> mFileToArrayCount;
    private Map<String, Location> mLocations;
    private Map<String, String> mDescriptions;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("array", "string-array", "integer-array");
    }

    public void beforeCheckProject(Context context) {
        if (context.getPhase() == 1) {
            this.mFileToArrayCount = ArrayListMultimap.create((int)30, (int)5);
        }
    }

    public void afterCheckProject(Context context) {
        if (context.getPhase() == 1) {
            boolean haveAllResources = context.getScope().contains(Scope.ALL_RESOURCE_FILES);
            if (!haveAllResources) {
                return;
            }
            HashSet<String> alreadyReported = new HashSet<String>();
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            HashMap<String, File> fileMap = new HashMap<String, File>();
            ArrayList keys = new ArrayList(this.mFileToArrayCount.keySet());
            Collections.sort(keys);
            for (File file : keys) {
                Collection pairs = this.mFileToArrayCount.get((Object)file);
                for (Pair pair : pairs) {
                    String name = (String)pair.getFirst();
                    if (alreadyReported.contains(name)) continue;
                    Integer count = (Integer)pair.getSecond();
                    Integer current = (Integer)countMap.get(name);
                    if (current == null) {
                        countMap.put(name, count);
                        fileMap.put(name, file);
                        continue;
                    }
                    if (count.equals(current)) continue;
                    alreadyReported.add(name);
                    if (this.mLocations == null) {
                        this.mLocations = new HashMap<String, Location>();
                        this.mDescriptions = new HashMap<String, String>();
                    }
                    this.mLocations.put(name, null);
                    String thisName = file.getParentFile().getName() + File.separator + file.getName();
                    File otherFile = (File)fileMap.get(name);
                    String otherName = otherFile.getParentFile().getName() + File.separator + otherFile.getName();
                    String message = String.format("Array `%1$s` has an inconsistent number of items (%2$d in `%3$s`, %4$d in `%5$s`)", name, count, thisName, current, otherName);
                    this.mDescriptions.put(name, message);
                }
            }
            if (this.mLocations != null) {
                context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
            this.mFileToArrayCount = null;
        } else {
            if (this.mLocations != null) {
                ArrayList<String> names = new ArrayList<String>(this.mLocations.keySet());
                Collections.sort(names);
                for (String name : names) {
                    Location location = this.mLocations.get(name);
                    if (location == null) continue;
                    location = Location.reverse((Location)location);
                    int count = -1;
                    LintDriver driver = context.getDriver();
                    boolean foundConflict = false;
                    for (Location curr = location; curr != null; curr = curr.getSecondary()) {
                        Object clientData = curr.getClientData();
                        if (clientData instanceof Node) {
                            int newCount;
                            Node node = (Node)clientData;
                            if (driver.isSuppressed(null, INCONSISTENT, node) || (newCount = LintUtils.getChildCount((Node)node)) == count) continue;
                            if (count == -1) {
                                count = newCount;
                                continue;
                            }
                            foundConflict = true;
                            break;
                        }
                        foundConflict = true;
                        break;
                    }
                    if (!foundConflict) continue;
                    String message = this.mDescriptions.get(name);
                    context.report(INCONSISTENT, location, message);
                }
            }
            this.mLocations = null;
            this.mDescriptions = null;
        }
    }

    public void visitElement(XmlContext context, Element element) {
        int phase = context.getPhase();
        Attr attribute = element.getAttributeNode("name");
        if (attribute == null || attribute.getValue().isEmpty()) {
            if (phase != 1) {
                return;
            }
            context.report(INCONSISTENT, (Node)element, context.getLocation((Node)element), String.format("Missing name attribute in `%1$s` declaration", element.getTagName()));
        } else {
            String name = attribute.getValue();
            if (phase == 1) {
                if (context.getProject().getReportIssues()) {
                    int childCount = LintUtils.getChildCount((Node)element);
                    if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.getClient().supportsProjectResources()) {
                        ArraySizeDetector.incrementalCheckCount(context, element, name, childCount);
                        return;
                    }
                    this.mFileToArrayCount.put((Object)context.file, (Object)Pair.of((Object)name, (Object)childCount));
                }
            } else {
                assert (phase == 2);
                if (this.mLocations.containsKey(name)) {
                    if (context.getDriver().isSuppressed(context, INCONSISTENT, (Node)element)) {
                        return;
                    }
                    Location location = context.getLocation((Node)element);
                    location.setClientData((Object)element);
                    location.setMessage(String.format("Declaration with array size (%1$d)", LintUtils.getChildCount((Node)element)));
                    location.setSecondary(this.mLocations.get(name));
                    this.mLocations.put(name, location);
                }
            }
        }
    }

    private static void incrementalCheckCount(XmlContext context, Element element, String name, int childCount) {
        Project project;
        LintClient client = context.getClient();
        AbstractResourceRepository resources = client.getResourceRepository(project = context.getMainProject(), true, false);
        if (resources == null) {
            return;
        }
        List items = resources.getResourceItem(ResourceType.ARRAY, name);
        if (items != null) {
            for (ResourceItem item : items) {
                ArrayResourceValue arv;
                ResourceValue rv;
                ResourceFile source = (ResourceFile)item.getSource();
                if (source != null && LintUtils.isSameResourceFile((File)context.file, (File)source.getFile()) || !((rv = item.getResourceValue(false)) instanceof ArrayResourceValue) || childCount == (arv = (ArrayResourceValue)rv).getElementCount()) continue;
                String thisName = context.file.getParentFile().getName() + File.separator + context.file.getName();
                assert (source != null);
                File otherFile = source.getFile();
                String otherName = otherFile.getParentFile().getName() + File.separator + otherFile.getName();
                String message = String.format("Array `%1$s` has an inconsistent number of items (%2$d in `%3$s`, %4$d in `%5$s`)", name, childCount, thisName, arv.getElementCount(), otherName);
                context.report(INCONSISTENT, (Node)element, context.getLocation((Node)element), message);
            }
        }
    }
}

