/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DetectMissingPrefix
extends LayoutDetector {
    public static final Issue MISSING_NAMESPACE = Issue.create((String)"MissingPrefix", (String)"Missing Android XML namespace", (String)"Most Android views have attributes in the Android namespace. When referencing these attributes you *must* include the namespace prefix, or your attribute will be interpreted by `aapt` as just a custom attribute.\n\nSimilarly, in manifest files, nearly all attributes should be in the `android:` namespace.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(DetectMissingPrefix.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE}));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.INTERPOLATOR;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    private static boolean isNoPrefixAttribute(String attribute) {
        switch (attribute) {
            case "class": 
            case "style": 
            case "layout": 
            case "package": 
            case "coreApp": {
                return true;
            }
        }
        return false;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String uri = attribute.getNamespaceURI();
        if (uri == null || uri.isEmpty()) {
            Element root;
            String name = attribute.getName();
            if (name == null) {
                return;
            }
            if (DetectMissingPrefix.isNoPrefixAttribute(name)) {
                return;
            }
            Element element = attribute.getOwnerElement();
            if (DetectMissingPrefix.isCustomView(element) && context.getResourceFolderType() != null) {
                return;
            }
            if (context.getResourceFolderType() == ResourceFolderType.LAYOUT && "layout".equals((root = element.getOwnerDocument().getDocumentElement()).getTagName())) {
                return;
            }
            if (name.indexOf(58) != -1) {
                return;
            }
            String elementNamespace = element.getNamespaceURI();
            if (elementNamespace != null && !elementNamespace.isEmpty()) {
                return;
            }
            context.report(MISSING_NAMESPACE, (Node)attribute, context.getLocation((Node)attribute), "Attribute is missing the Android namespace prefix");
        } else if (!("http://schemas.android.com/apk/res/android".equals(uri) || "http://schemas.android.com/tools".equals(uri) || context.getResourceFolderType() != ResourceFolderType.LAYOUT || DetectMissingPrefix.isCustomView(attribute.getOwnerElement()) || DetectMissingPrefix.isFragment(attribute.getOwnerElement()) || attribute.getLocalName().startsWith("layout_") || attribute.getOwnerElement().getParentNode().getNodeType() != 1 || DetectMissingPrefix.isCustomView((Element)attribute.getOwnerElement().getParentNode()))) {
            String prefix;
            if (context.getResourceFolderType() == ResourceFolderType.LAYOUT && "http://schemas.android.com/apk/res-auto".equals(uri)) {
                List items;
                Element root = attribute.getOwnerDocument().getDocumentElement();
                if ("layout".equals(root.getTagName())) {
                    return;
                }
                if (attribute.getLocalName().equals("srcCompat")) {
                    return;
                }
                Project project = context.getMainProject();
                LintClient client = context.getClient();
                AbstractResourceRepository repository = client.getResourceRepository(project, true, true);
                if (repository != null && (items = repository.getResourceItem(ResourceType.ATTR, attribute.getLocalName())) != null && !items.isEmpty()) {
                    for (Node item : items) {
                        String libraryName = item.getLibraryName();
                        if (libraryName == null || !libraryName.startsWith("appcompat-")) continue;
                        return;
                    }
                }
            }
            if ("xmlns".equals(prefix = attribute.getPrefix())) {
                String name = attribute.getNodeName();
                Element root = attribute.getOwnerDocument().getDocumentElement();
                NamedNodeMap attributes = root.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node item;
                    item = attributes.item(i);
                    if (!name.equals(item.getNodeName()) || !attribute.getValue().equals(item.getNodeValue())) continue;
                    context.report(NamespaceDetector.UNUSED, (Node)attribute, context.getLocation((Node)attribute), String.format("Unused namespace declaration %1$s; already declared on the root element", name));
                }
                return;
            }
            context.report(MISSING_NAMESPACE, (Node)attribute, context.getLocation((Node)attribute), String.format("Unexpected namespace prefix \"%1$s\" found for tag `%2$s`", prefix, attribute.getOwnerElement().getTagName()));
        }
    }

    private static boolean isFragment(Element element) {
        return "fragment".equals(element.getTagName());
    }

    private static boolean isCustomView(Element element) {
        String tag = element.getTagName();
        if (tag.equals("view")) {
            return true;
        }
        if ("android.support.constraint.ConstraintLayout".equals(tag) || "android.support.constraint.Guideline".equals(tag)) {
            return false;
        }
        return tag.indexOf(46) != -1 && (!tag.startsWith("android.") || tag.startsWith("android.support."));
    }
}

