/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;

public class IconDetector
extends ResourceXmlDetector
implements Detector.JavaPsiScanner {
    private static final boolean INCLUDE_LDPI;
    private static final Pattern DENSITY_PATTERN;
    private static final Pattern DP_NAME_PATTERN;
    private List<String> cachedRequiredDensities;
    private Project cachedDensitiesForProject;
    private static final String[] DENSITY_QUALIFIERS;
    private static final EnumSet<Scope> ICON_TYPE_SCOPE;
    private static final Implementation IMPLEMENTATION_JAVA;
    private static final Implementation IMPLEMENTATION_RES_ONLY;
    public static final Issue ICON_EXPECTED_SIZE;
    public static final Issue ICON_DIP_SIZE;
    public static final Issue ICON_LOCATION;
    public static final Issue ICON_DENSITIES;
    public static final Issue ICON_MISSING_FOLDER;
    public static final Issue GIF_USAGE;
    public static final Issue DUPLICATES_NAMES;
    public static final Issue DUPLICATES_CONFIGURATIONS;
    public static final Issue ICON_NODPI;
    public static final Issue ICON_MIX_9PNG;
    public static final Issue ICON_XML_AND_PNG;
    public static final Issue ICON_EXTENSION;
    public static final Issue ICON_COLORS;
    public static final Issue ICON_LAUNCHER_SHAPE;
    public static final Issue ICON_LAUNCHER_FORMAT;
    public static final Issue WEBP_ELIGIBLE;
    public static final Issue WEBP_UNSUPPORTED;
    private Map<File, BufferedImage> imageCache;
    private Map<String, PsiElement> notificationIcons;
    private Set<String> actionBarIcons;
    private Set<String> launcherIcons;
    private Multimap<String, String> menuToIcons;
    private Set<Object> roundIcons;
    private static final String NOTIFICATION_CLASS = "Notification";
    private static final String NOTIFICATION_BUILDER_CLASS = "Notification.Builder";
    private static final String NOTIFICATION_COMPAT_BUILDER_CLASS = "NotificationCompat.Builder";
    private static final String SET_SMALL_ICON = "setSmallIcon";
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";

    public void beforeCheckProject(Context context) {
        this.launcherIcons = null;
        this.actionBarIcons = null;
        this.notificationIcons = null;
        this.roundIcons = null;
    }

    public void afterCheckLibraryProject(Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        this.checkResourceFolder(context, context.getProject());
    }

    public void afterCheckProject(Context context) {
        this.checkResourceFolder(context, context.getProject());
    }

    private void checkResourceFolder(Context context, Project project) {
        List resourceFolders = project.getResourceFolders();
        for (File res : resourceFolders) {
            File[] folders = res.listFiles();
            if (folders == null) continue;
            boolean checkFolders = context.isEnabled(ICON_DENSITIES) || context.isEnabled(ICON_MISSING_FOLDER) || context.isEnabled(ICON_NODPI) || context.isEnabled(ICON_MIX_9PNG) || context.isEnabled(ICON_XML_AND_PNG);
            boolean checkDipSizes = context.isEnabled(ICON_DIP_SIZE);
            boolean checkDuplicates = context.isEnabled(DUPLICATES_NAMES) || context.isEnabled(DUPLICATES_CONFIGURATIONS);
            boolean checkWebp = context.isEnabled(WEBP_ELIGIBLE);
            HashMap<File, Dimension> pixelSizes = null;
            HashMap<File, Long> fileSizes = null;
            if (checkDipSizes || checkDuplicates || checkWebp) {
                pixelSizes = new HashMap<File, Dimension>();
                fileSizes = new HashMap<File, Long>();
            }
            HashMap<File, Set<String>> folderToNames = new HashMap<File, Set<String>>();
            HashMap<File, Set<String>> nonDpiFolderNames = new HashMap<File, Set<String>>();
            for (File file : folders) {
                String name;
                HashSet<String> names;
                File[] files;
                String folderName = file.getName();
                if (!folderName.startsWith("drawable") && !folderName.startsWith("mipmap") || (files = file.listFiles()) == null) continue;
                this.checkDrawableDir(context, file, files, pixelSizes, fileSizes);
                if (checkFolders && DENSITY_PATTERN.matcher(folderName).matches()) {
                    names = new HashSet(files.length);
                    for (File f : files) {
                        name = f.getName();
                        if (!IconDetector.isDrawableFile(name)) continue;
                        names.add(name);
                    }
                    folderToNames.put(file, names);
                    continue;
                }
                if (!checkFolders) continue;
                names = new HashSet<String>(files.length);
                for (File f : files) {
                    name = f.getName();
                    if (!IconDetector.isDrawableFile(name)) continue;
                    names.add(name);
                }
                nonDpiFolderNames.put(file, names);
            }
            if (checkDipSizes) {
                IconDetector.checkDipSizes(context, pixelSizes);
            }
            if (checkDuplicates) {
                IconDetector.checkDuplicates(context, pixelSizes, fileSizes);
            }
            if (checkFolders && !folderToNames.isEmpty()) {
                this.checkDensities(context, res, folderToNames, nonDpiFolderNames);
            }
            if (!checkWebp || context.getMainProject().getMinSdkVersion().getApiLevel() < 18) continue;
            File largest = null;
            long size = 0L;
            for (Map.Entry entry : fileSizes.entrySet()) {
                Long sizeLong;
                String folderName;
                File f = (File)entry.getKey();
                String name = f.getName();
                if ((!SdkUtils.endsWithIgnoreCase((String)name, (String)".png") || SdkUtils.endsWithIgnoreCase((String)name, (String)".9.png")) && !SdkUtils.endsWithIgnoreCase((String)name, (String)".jpg") && !SdkUtils.endsWithIgnoreCase((String)name, (String)".jpeg") || this.isLauncherIcon(folderName = f.getParentFile().getName(), IconDetector.getBaseName(name)) || (sizeLong = (Long)entry.getValue()) == null || sizeLong <= size) continue;
                size = sizeLong;
                largest = f;
            }
            if (largest == null) continue;
            Location location = Location.create(largest);
            String message = "One or more images in this project can be converted to the WebP format which typically results in smaller file sizes, even for lossless conversion (but launcher icons should use PNG).";
            context.report(WEBP_ELIGIBLE, location, message);
        }
    }

    public static boolean isDrawableFile(String name) {
        return LintUtils.endsWith((String)name, (String)".png") || LintUtils.endsWith((String)name, (String)".jpg") || LintUtils.endsWith((String)name, (String)".gif") || LintUtils.endsWith((String)name, (String)".xml") || LintUtils.endsWith((String)name, (String)".jpeg") || LintUtils.endsWith((String)name, (String)".webp");
    }

    private static void checkDuplicates(Context context, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes) {
        HashMap<Long, HashSet<File>> sameSizes = new HashMap<Long, HashSet<File>>();
        HashMap<Long, File> seenSizes = new HashMap<Long, File>(fileSizes.size());
        for (Map.Entry<File, Long> entry : fileSizes.entrySet()) {
            File file = entry.getKey();
            Long size = entry.getValue();
            if (seenSizes.containsKey(size)) {
                HashSet<File> set = (HashSet<File>)sameSizes.get(size);
                if (set == null) {
                    set = new HashSet<File>();
                    set.add((File)seenSizes.get(size));
                    sameSizes.put(size, set);
                }
                set.add(file);
                continue;
            }
            seenSizes.put(size, file);
        }
        if (sameSizes.isEmpty()) {
            return;
        }
        Collection candidateLists = sameSizes.values();
        for (Set candidates : candidateLists) {
            HashMap<Dimension, HashSet<Object>> sameDimensions = new HashMap<Dimension, HashSet<Object>>(candidates.size());
            ArrayList<Object> noSize = new ArrayList<Object>();
            for (Object file : candidates) {
                Dimension dimension = pixelSizes.get(file);
                if (dimension != null) {
                    Set<Object> set = (HashSet<Object>)sameDimensions.get(dimension);
                    if (set == null) {
                        set = new HashSet<Object>();
                        sameDimensions.put(dimension, (HashSet<Object>)set);
                    }
                    set.add(file);
                    continue;
                }
                noSize.add(file);
            }
            Collection sets = sameDimensions.values();
            if (!noSize.isEmpty()) {
                if (!sets.isEmpty()) {
                    Object file;
                    file = sets.iterator();
                    while (file.hasNext()) {
                        Set set = (Set)file.next();
                        set.addAll(noSize);
                    }
                } else {
                    HashSet noSizeSet = new HashSet(noSize);
                    sets = Collections.singletonList(noSizeSet);
                }
            }
            HashMap<File, byte[]> fileContents = new HashMap<File, byte[]>();
            for (Set<Object> set : sets) {
                if (set.size() < 2) continue;
                for (File file : set) {
                    byte[] bits = (byte[])fileContents.get(file);
                    if (bits != null) continue;
                    try {
                        bits = context.getClient().readBytes(file);
                        fileContents.put(file, bits);
                    }
                    catch (IOException e) {
                        context.log((Throwable)e, null, new Object[0]);
                    }
                }
                HashMap<Object, File> equal = new HashMap<Object, File>();
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        File file1 = (File)arrayList.get(i);
                        File file = (File)arrayList.get(j);
                        byte[] contents1 = (byte[])fileContents.get(file1);
                        byte[] byArray = (byte[])fileContents.get(file);
                        if (contents1 == null || byArray == null || contents1.length != byArray.length) continue;
                        boolean same = true;
                        for (int k = 0; k < contents1.length; ++k) {
                            if (contents1[k] == byArray[k]) continue;
                            same = false;
                            break;
                        }
                        if (!same) continue;
                        equal.put(file1, file);
                    }
                }
                if (equal.isEmpty()) continue;
                HashMap<File, HashSet<Object>> partitions = new HashMap<File, HashSet<Object>>();
                ArrayList<HashSet<Object>> sameSets = new ArrayList<HashSet<Object>>();
                for (Map.Entry entry : equal.entrySet()) {
                    File file1 = (File)entry.getKey();
                    File file = (File)entry.getValue();
                    Set set1 = (Set)partitions.get(file1);
                    Set set2 = (Set)partitions.get(file);
                    if (set1 != null) {
                        set1.add(file);
                        continue;
                    }
                    if (set2 != null) {
                        set2.add(file1);
                        continue;
                    }
                    set = new HashSet();
                    sameSets.add((HashSet<Object>)set);
                    set.add(file1);
                    set.add(file);
                    partitions.put(file1, (HashSet<Object>)set);
                    partitions.put(file, (HashSet<Object>)set);
                }
                ArrayList lists = new ArrayList();
                for (Set same : sameSets) {
                    assert (!same.isEmpty());
                    ArrayList arrayList2 = new ArrayList(same);
                    Collections.sort(arrayList2);
                    lists.add(arrayList2);
                }
                lists.sort((list1, list2) -> ((File)list1.get(0)).compareTo((File)list2.get(0)));
                ListIterator listIterator = lists.listIterator();
                while (listIterator.hasNext()) {
                    List list = (List)listIterator.next();
                    boolean bl = true;
                    for (File file : list) {
                        String name = file.getName();
                        if (DP_NAME_PATTERN.matcher(name).matches()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    listIterator.remove();
                }
                for (List list : lists) {
                    Object message;
                    StringBuilder sb;
                    Location location = null;
                    boolean sameNames = true;
                    String lastName = null;
                    for (Object file : list) {
                        if (lastName != null && !lastName.equals(((File)file).getName())) {
                            sameNames = false;
                        }
                        lastName = ((File)file).getName();
                        Location linkedLocation = location;
                        location = Location.create((File)file);
                        location.setSecondary(linkedLocation);
                    }
                    if (sameNames) {
                        Object file;
                        sb = new StringBuilder(list.size() * 16);
                        file = list.iterator();
                        while (file.hasNext()) {
                            File file2 = (File)file.next();
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(file2.getParentFile().getName());
                        }
                        message = String.format("The `%1$s` icon has identical contents in the following configuration folders: %2$s", lastName, sb.toString());
                        if (location == null) continue;
                        context.report(DUPLICATES_CONFIGURATIONS, location, (String)message);
                        continue;
                    }
                    sb = new StringBuilder(list.size() * 16);
                    for (File file : list) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(file.getName());
                    }
                    message = String.format("The following unrelated icon files have identical contents: %1$s", sb.toString());
                    context.report(DUPLICATES_NAMES, location, (String)message);
                }
            }
        }
    }

    private static void checkDipSizes(Context context, Map<File, Dimension> pixelSizes) {
        HashMap<String, ArrayList<File>> nameToFiles = new HashMap<String, ArrayList<File>>();
        for (File file : pixelSizes.keySet()) {
            String name = file.getName();
            ArrayList<File> list = (ArrayList<File>)nameToFiles.get(name);
            if (list == null) {
                list = new ArrayList<File>();
                nameToFiles.put(name, list);
            }
            list.add(file);
        }
        ArrayList names = new ArrayList(nameToFiles.keySet());
        Collections.sort(names);
        HashMap configMap = new HashMap();
        for (Map.Entry entry : nameToFiles.entrySet()) {
            String name = (String)entry.getKey();
            List files = (List)entry.getValue();
            for (File file : files) {
                ArrayList<File> list;
                String parentName = file.getParentFile().getName();
                int index = -1;
                for (String qualifier : DENSITY_QUALIFIERS) {
                    index = parentName.indexOf(qualifier);
                    if (index == -1) continue;
                    parentName = parentName.substring(0, index) + parentName.substring(index + qualifier.length());
                    break;
                }
                if (index == -1) continue;
                HashMap<String, ArrayList<File>> folderMap = (HashMap<String, ArrayList<File>>)configMap.get(name);
                if (folderMap == null) {
                    folderMap = new HashMap<String, ArrayList<File>>();
                    configMap.put(name, folderMap);
                }
                if ((list = (ArrayList<File>)folderMap.get(parentName)) == null) {
                    list = new ArrayList<File>();
                    folderMap.put(parentName, list);
                }
                list.add(file);
            }
        }
        for (String name : names) {
            Map configurations = (Map)configMap.get(name);
            if (configurations == null) continue;
            for (Map.Entry entry : configurations.entrySet()) {
                Object size;
                List files = (List)entry.getValue();
                HashMap<File, Dimension> dipSizes = new HashMap<File, Dimension>();
                int dipWidthSum = 0;
                int dipHeightSum = 0;
                int count = 0;
                for (File file : files) {
                    String dpString;
                    int dp;
                    String folderName = file.getParentFile().getName();
                    float factor = IconDetector.getMdpiScalingFactor(folderName);
                    if (!(factor > 0.0f) || (size = pixelSizes.get(file)) == null) continue;
                    Dimension dip = new Dimension(Math.round((float)((Dimension)size).width / factor), Math.round((float)((Dimension)size).height / factor));
                    dipWidthSum += dip.width;
                    dipHeightSum += dip.height;
                    dipSizes.put(file, dip);
                    ++count;
                    String fileName = file.getName();
                    Matcher matcher = DP_NAME_PATTERN.matcher(fileName);
                    if (!matcher.matches() || Math.abs(dip.width - (dp = Integer.parseInt(dpString = matcher.group(1)))) <= 2 && Math.abs(dip.height - dp) <= 2) continue;
                    String message = String.format("Suspicious file name `%1$s`: The implied %2$s `dp` size does not match the actual `dp` size (pixel size %3$d\u00d7%4$d in a `%5$s` folder computes to %6$d\u00d7%7$d `dp`)", fileName, dpString, ((Dimension)size).width, ((Dimension)size).height, folderName, dip.width, dip.height);
                    context.report(ICON_DIP_SIZE, Location.create((File)file), message);
                }
                if (count == 0) continue;
                int meanWidth = dipWidthSum / count;
                int meanHeight = dipHeightSum / count;
                int squareWidthSum = 0;
                int squareHeightSum = 0;
                size = dipSizes.values().iterator();
                while (size.hasNext()) {
                    Dimension size2 = (Dimension)size.next();
                    squareWidthSum += (size2.width - meanWidth) * (size2.width - meanWidth);
                    squareHeightSum += (size2.height - meanHeight) * (size2.height - meanHeight);
                }
                double widthStdDev = Math.sqrt(squareWidthSum / count);
                double heightStdDev = Math.sqrt(squareHeightSum / count);
                if (!(widthStdDev > (double)(meanWidth / 10)) && !(heightStdDev > (double)meanHeight)) continue;
                Location location = null;
                StringBuilder sb = new StringBuilder(100);
                ArrayList entries = new ArrayList();
                for (Map.Entry entry2 : dipSizes.entrySet()) {
                    entries.add(entry2);
                }
                entries.sort((e1, e2) -> {
                    Dimension d1 = (Dimension)e1.getValue();
                    Dimension d2 = (Dimension)e2.getValue();
                    if (d1.width != d2.width) {
                        return d2.width - d1.width;
                    }
                    return d2.height - d1.height;
                });
                for (Map.Entry entry2 : entries) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    File file = (File)entry2.getKey();
                    Location linkedLocation = location;
                    location = Location.create((File)file);
                    location.setSecondary(linkedLocation);
                    Dimension dip = (Dimension)entry2.getValue();
                    Dimension px = pixelSizes.get(file);
                    String fileName = file.getParentFile().getName() + File.separator + file.getName();
                    sb.append(String.format("%1$s: %2$dx%3$d dp (%4$dx%5$d px)", fileName, dip.width, dip.height, px.width, px.height));
                }
                String message = String.format("The image `%1$s` varies significantly in its density-independent (dip) size across the various density versions: %2$s", name, sb.toString());
                if (location == null) continue;
                context.report(ICON_DIP_SIZE, location, message);
            }
        }
    }

    private void checkDensities(Context context, File res, Map<File, Set<String>> folderToNames, Map<File, Set<String>> nonDpiFolderNames) {
        Iterator folderName;
        HashSet<String> definedDensities = new HashSet<String>();
        for (File f : folderToNames.keySet()) {
            definedDensities.add(f.getName());
        }
        if (context.isEnabled(ICON_MISSING_FOLDER)) {
            boolean bl;
            ArrayList<String> missing = new ArrayList<String>();
            List<String> requiredDensityFolders = this.getRequiredDensityFolders(context);
            boolean bl2 = false;
            Iterator<Object> iterator = requiredDensityFolders.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!definedDensities.contains(string)) {
                    missing.add(string);
                    continue;
                }
                bl = true;
            }
            if (!missing.isEmpty() && bl) {
                context.report(ICON_MISSING_FOLDER, Location.create((File)res), String.format("Missing density variation folders in `%1$s`: %2$s", context.getProject().getDisplayPath(res), LintUtils.formatList(missing, (int)-1)));
            }
        }
        if (context.isEnabled(ICON_NODPI)) {
            HashSet<String> noDpiNames = new HashSet<String>();
            for (Map.Entry entry : folderToNames.entrySet()) {
                if (!IconDetector.isNoDpiFolder((File)entry.getKey())) continue;
                noDpiNames.addAll((Collection)entry.getValue());
            }
            if (!noDpiNames.isEmpty()) {
                HashSet inBoth = new HashSet();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (Map.Entry entry : folderToNames.entrySet()) {
                    File folder = (File)entry.getKey();
                    folderName = folder.getName();
                    if (IconDetector.isNoDpiFolder(folder)) continue;
                    assert (DENSITY_PATTERN.matcher((CharSequence)((Object)folderName)).matches());
                    Set<String> overlap = IconDetector.nameIntersection(noDpiNames, (Set)entry.getValue());
                    inBoth.addAll(overlap);
                    Iterator iterator = overlap.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        arrayList.add(new File(folder, string));
                    }
                }
                if (!inBoth.isEmpty()) {
                    ArrayList list = new ArrayList(inBoth);
                    Collections.sort(list);
                    Location location = IconDetector.chainLocations(arrayList);
                    context.report(ICON_NODPI, location, String.format("The following images appear in both `-nodpi` and in a density folder: %1$s", LintUtils.formatList((List)list, (int)(context.getDriver().isAbbreviating() ? 10 : -1))));
                }
            }
        }
        if (context.isEnabled(ICON_MIX_9PNG)) {
            IconDetector.checkMixedNinePatches(context, folderToNames);
        }
        if (context.isEnabled(ICON_XML_AND_PNG)) {
            Set<String> overlap;
            HashMap folderMap = Maps.newHashMap(folderToNames);
            folderMap.putAll(nonDpiFolderNames);
            HashSet xmlNames = Sets.newHashSetWithExpectedSize((int)100);
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)100);
            for (Map.Entry entry : folderMap.entrySet()) {
                Set names = (Set)entry.getValue();
                folderName = ((File)entry.getKey()).getName();
                for (Object name : names) {
                    if (LintUtils.endsWith((String)name, (String)".xml")) {
                        if (((String)((Object)folderName)).contains("-v")) continue;
                        xmlNames.add(name);
                        continue;
                    }
                    if (!IconDetector.isDrawableFile((String)name)) continue;
                    hashSet.add(name);
                }
            }
            if (!(xmlNames.isEmpty() || hashSet.isEmpty() || (overlap = IconDetector.nameIntersection(xmlNames, hashSet)).isEmpty())) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                HashSet bases = Sets.newHashSetWithExpectedSize((int)overlap.size());
                for (String name : overlap) {
                    bases.add(LintUtils.getBaseName((String)name));
                }
                for (Object base : bases) {
                    for (Map.Entry entry : folderMap.entrySet()) {
                        File folder = (File)entry.getKey();
                        for (String n : (Set)entry.getValue()) {
                            if (!((String)base).equals(LintUtils.getBaseName((String)n))) continue;
                            arrayListMultimap.put(base, (Object)new File(folder, n));
                        }
                    }
                }
                ArrayList sorted = new ArrayList(arrayListMultimap.keySet());
                Collections.sort(sorted);
                for (Object name : sorted) {
                    ArrayList arrayList = Lists.newArrayList((Iterable)arrayListMultimap.get(name));
                    Location location = IconDetector.chainLocations(arrayList);
                    ArrayList fileNames = Lists.newArrayList();
                    boolean seenXml = false;
                    boolean seenNonXml = false;
                    for (File f : arrayList) {
                        boolean isXml = LintUtils.endsWith((String)f.getPath(), (String)".xml");
                        if (isXml && !seenXml) {
                            fileNames.add(context.getProject().getDisplayPath(f));
                            seenXml = true;
                            continue;
                        }
                        if (isXml || seenNonXml) continue;
                        fileNames.add(context.getProject().getDisplayPath(f));
                        seenNonXml = true;
                    }
                    context.report(ICON_XML_AND_PNG, location, String.format("The following images appear both as density independent `.xml` files and as bitmap files: %1$s", LintUtils.formatList((List)fileNames, (int)(context.getDriver().isAbbreviating() ? 10 : -1))));
                }
            }
        }
        if (context.isEnabled(ICON_DENSITIES)) {
            HashSet<String> allNames = new HashSet<String>();
            for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
                if (IconDetector.isNoDpiFolder(entry.getKey())) continue;
                Set<String> names = entry.getValue();
                allNames.addAll(names);
            }
            for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
                ArrayList<String> delta;
                Set<String> set;
                File file = entry.getKey();
                if (IconDetector.isNoDpiFolder(file) || (set = entry.getValue()).size() == allNames.size() || (delta = new ArrayList<String>(IconDetector.nameDifferences(allNames, set))).isEmpty()) continue;
                Collections.sort(delta);
                String foundIn = "";
                if (delta.size() == 1) {
                    Object name;
                    ArrayList<String> defined = new ArrayList<String>();
                    name = (String)delta.get(0);
                    for (Map.Entry<File, Set<String>> e : folderToNames.entrySet()) {
                        if (!e.getValue().contains(name)) continue;
                        defined.add(e.getKey().getName());
                    }
                    if (!defined.isEmpty()) {
                        foundIn = String.format(" (found in %1$s)", LintUtils.formatList(defined, (int)(context.getDriver().isAbbreviating() ? 5 : -1)));
                    }
                }
                String folder = file.getName();
                if (!this.getRequiredDensityFolders(context).contains(folder)) continue;
                context.report(ICON_DENSITIES, Location.create((File)file), String.format("Missing the following drawables in `%1$s`: %2$s%3$s", folder, LintUtils.formatList(delta, (int)(context.getDriver().isAbbreviating() ? 5 : -1)), foundIn));
            }
        }
    }

    private List<String> getRequiredDensityFolders(Context context) {
        if (this.cachedRequiredDensities == null || context.getProject() != this.cachedDensitiesForProject) {
            this.cachedDensitiesForProject = context.getProject();
            this.cachedRequiredDensities = Lists.newArrayListWithExpectedSize((int)10);
            List applicableDensities = context.getProject().getApplicableDensities();
            if (applicableDensities != null) {
                this.cachedRequiredDensities.addAll(applicableDensities);
            } else {
                if (INCLUDE_LDPI) {
                    this.cachedRequiredDensities.add("drawable-ldpi");
                }
                this.cachedRequiredDensities.add("drawable-mdpi");
                this.cachedRequiredDensities.add("drawable-hdpi");
                this.cachedRequiredDensities.add("drawable-xhdpi");
                this.cachedRequiredDensities.add("drawable-xxhdpi");
            }
        }
        return this.cachedRequiredDensities;
    }

    private static void addResConfigsFromFlavor(Set<String> relevantDensities, List<String> variantFlavors, ProductFlavorContainer container) {
        ProductFlavor flavor = container.getProductFlavor();
        if ((variantFlavors == null || variantFlavors.contains(flavor.getName())) && !flavor.getResourceConfigurations().isEmpty()) {
            for (String densityName : flavor.getResourceConfigurations()) {
                Density density = Density.getEnum((String)densityName);
                if (density == null || !density.isRecommended() || density == Density.NODPI || density == Density.ANYDPI) continue;
                relevantDensities.add(densityName);
            }
        }
    }

    private static Set<String> nameDifferences(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String string : a) {
            names1.add(LintUtils.getBaseName((String)string));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(LintUtils.getBaseName((String)s));
        }
        names1.removeAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(LintUtils.getBaseName((String)s))) continue;
                hashSet.add(s);
            }
            for (String s : b) {
                if (!names1.contains(LintUtils.getBaseName((String)s))) continue;
                hashSet.add(s);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private static Set<String> nameIntersection(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String string : a) {
            names1.add(LintUtils.getBaseName((String)string));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(LintUtils.getBaseName((String)s));
        }
        names1.retainAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(LintUtils.getBaseName((String)s))) continue;
                hashSet.add(s);
            }
            for (String s : b) {
                if (!names1.contains(LintUtils.getBaseName((String)s))) continue;
                hashSet.add(s);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private static boolean isNoDpiFolder(File file) {
        return file.getName().contains("-nodpi");
    }

    private BufferedImage getImage(File file) throws IOException {
        BufferedImage image;
        if (file == null) {
            return null;
        }
        if (this.imageCache == null) {
            this.imageCache = Maps.newHashMap();
        } else {
            image = this.imageCache.get(file);
            if (image != null) {
                return image;
            }
        }
        image = ImageIO.read(file);
        this.imageCache.put(file, image);
        return image;
    }

    private void checkDrawableDir(Context context, File folder, File[] files, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes) {
        Dimension size;
        String name;
        String folderName = folder.getName();
        if (folderName.equals("drawable") && context.isEnabled(ICON_LOCATION) && context.getProject().getMinSdk() >= 4) {
            for (File file : files) {
                name = file.getName();
                if (name.endsWith(".xml") || !LintUtils.endsWith((String)name, (String)".png") && !LintUtils.endsWith((String)name, (String)".jpg") && !LintUtils.endsWith((String)name, (String)".jpeg") && !LintUtils.endsWith((String)name, (String)".webp") && !LintUtils.endsWith((String)name, (String)".gif")) continue;
                context.report(ICON_LOCATION, Location.create((File)file), String.format("Found bitmap drawable `res/drawable/%1$s` in densityless folder", file.getName()));
            }
        }
        if (context.isEnabled(GIF_USAGE)) {
            for (File file : files) {
                name = file.getName();
                if (!LintUtils.endsWith((String)name, (String)".gif")) continue;
                context.report(GIF_USAGE, Location.create((File)file), "Using the `.gif` format for bitmaps is discouraged");
            }
        }
        if (context.isEnabled(ICON_EXTENSION)) {
            for (File file : files) {
                String path = file.getPath();
                if (!IconDetector.isDrawableFile(path) || LintUtils.endsWith((String)path, (String)".xml")) continue;
                IconDetector.checkExtension(context, file);
            }
        }
        if (context.isEnabled(ICON_COLORS)) {
            for (File file : files) {
                String baseName;
                boolean isActionBarIcon;
                name = file.getName();
                if (!IconDetector.isDrawableFile(name) || LintUtils.endsWith((String)name, (String)".xml") || LintUtils.endsWith((String)name, (String)".9.png") || !(isActionBarIcon = this.isActionBarIcon(context, folderName, baseName = IconDetector.getBaseName(name), file)) && !this.isNotificationIcon(baseName) || (size = this.checkColor(context, file, isActionBarIcon)) == null || pixelSizes == null) continue;
                pixelSizes.put(file, size);
            }
        }
        boolean checkLauncherShape = context.isEnabled(ICON_LAUNCHER_SHAPE);
        boolean checkLauncherFormat = context.isEnabled(ICON_LAUNCHER_FORMAT);
        if (checkLauncherShape || checkLauncherFormat) {
            for (File file : files) {
                String name2 = file.getName();
                if (!this.isLauncherIcon(folderName, IconDetector.getBaseName(name2))) continue;
                if (checkLauncherShape && !LintUtils.endsWith((String)name2, (String)".xml") && !LintUtils.endsWith((String)name2, (String)".9.png")) {
                    this.checkLauncherShape(context, folderName, file);
                }
                if (!checkLauncherFormat) continue;
                IconDetector.checkLauncherIconFormat(context, file);
            }
        }
        if (context.isEnabled(ICON_EXPECTED_SIZE)) {
            this.checkExpectedSizes(context, folder, files);
        }
        if (pixelSizes != null || fileSizes != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!LintUtils.endsWith((String)fileName, (String)".png") && !LintUtils.endsWith((String)fileName, (String)".jpg") && !LintUtils.endsWith((String)fileName, (String)".jpeg") && !LintUtils.endsWith((String)fileName, (String)".webp")) continue;
                if (pixelSizes != null && !LintUtils.endsWith((String)fileName, (String)".9.png") && !pixelSizes.containsKey(file)) {
                    size = IconDetector.getSize(file);
                    pixelSizes.put(file, size);
                }
                if (fileSizes == null) continue;
                fileSizes.put(file, file.length());
            }
        }
        if (context.isEnabled(WEBP_UNSUPPORTED) && files.length > 0) {
            this.checkWebpSupported(context, files);
        }
        this.imageCache = null;
    }

    private void checkWebpSupported(Context context, File[] files) {
        int minSdk = Math.max(context.getMainProject().getMinSdk(), context.getDriver().getResourceFolderVersion(files[0]));
        if (minSdk >= 18) {
            return;
        }
        for (File file : files) {
            int required;
            String path = file.getPath();
            if (!SdkUtils.endsWithIgnoreCase((String)path, (String)".webp")) continue;
            String name = file.getName();
            if (this.isLauncherIcon(file.getParentFile().getName(), IconDetector.getBaseName(name))) {
                Location location = Location.create((File)file);
                String message = "Launcher icons must be in PNG format";
                context.report(WEBP_UNSUPPORTED, location, message);
                continue;
            }
            WebpHeader header = WebpHeader.getWebpHeader(file);
            if (header == null || header.format == null) continue;
            boolean simpleFormat = "VP8".equals(header.format);
            int n = required = simpleFormat ? 15 : 18;
            if (required <= minSdk) continue;
            Location location = Location.create((File)file);
            String message = simpleFormat ? "WebP requires Android 4.0 (API 15)" : "WebP extended or lossless format requires Android 4.2.1 (API 18)";
            message = message + "; current minSdkVersion is " + minSdk;
            context.report(WEBP_UNSUPPORTED, location, message);
        }
    }

    private static void checkLauncherIconFormat(Context context, File file) {
        String path = file.getPath();
        if (SdkUtils.endsWithIgnoreCase((String)path, (String)".png") || SdkUtils.endsWithIgnoreCase((String)path, (String)".jpeg")) {
            return;
        }
        Location location = Location.create((File)file);
        String message = "Launcher icons must be in PNG format";
        context.report(ICON_LAUNCHER_FORMAT, location, message);
    }

    private void checkLauncherShape(Context context, String folderName, File file) {
        try {
            BufferedImage image = this.getImage(file);
            if (image != null) {
                if (this.isRoundIcon(folderName, IconDetector.getBaseName(file.getName())) && !IconDetector.isRound(image)) {
                    String message = "Launcher icon used as round icon did not have a circular shape";
                    context.report(ICON_LAUNCHER_SHAPE, Location.create((File)file), message);
                    return;
                }
                int height = image.getHeight();
                for (int y = 0; y < height; ++y) {
                    int width = image.getWidth();
                    for (int x = 0; x < width; ++x) {
                        int rgb = image.getRGB(x, y);
                        if ((rgb & 0xFF000000) != 0) continue;
                        return;
                    }
                }
                String message = "Launcher icons should not fill every pixel of their square region; see the design guide for details";
                context.report(ICON_LAUNCHER_SHAPE, Location.create((File)file), message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isRound(BufferedImage image) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        int imageHeight = image.getHeight();
        int imageWidth = image.getWidth();
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) continue;
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (x < minX) {
                    minX = x;
                }
                if (y >= minY) continue;
                minY = y;
            }
        }
        int shapeWidth = maxX - minX + 1;
        int shapeHeight = maxY - minY + 1;
        if (Math.abs(shapeWidth - shapeHeight) > imageWidth / 10) {
            return false;
        }
        BufferedImage circle = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics graphics = circle.getGraphics();
        graphics.fillOval(minX, minY, shapeWidth, shapeHeight);
        graphics.dispose();
        int threshold = 64;
        int different = 0;
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                boolean cir;
                int sourceAlpha = (image.getRGB(x, y) & 0xFF000000) >>> 24;
                int circleAlpha = (circle.getRGB(x, y) & 0xFF000000) >>> 24;
                if (sourceAlpha > 0 && sourceAlpha < 64) continue;
                boolean original = sourceAlpha < 64;
                boolean bl = cir = circleAlpha < 64;
                if (original == cir) continue;
                ++different;
            }
        }
        long total = imageHeight * imageWidth;
        double percentDifferent = (double)(100 * different) / (double)total;
        return percentDifferent < 4.0;
    }

    private Dimension checkColor(Context context, File file, boolean isActionBarIcon) {
        block14: {
            int folderVersion = context.getDriver().getResourceFolderVersion(file);
            if (isActionBarIcon ? folderVersion != -1 && folderVersion < 11 || !IconDetector.isAndroid30(context, folderVersion) : folderVersion != -1 && folderVersion < 9 || !IconDetector.isAndroid23(context, folderVersion) && !IconDetector.isAndroid30(context, folderVersion)) {
                return null;
            }
            try {
                BufferedImage image;
                block15: {
                    image = this.getImage(file);
                    if (image == null) break block14;
                    if (isActionBarIcon) {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b) continue;
                                String message = "Action Bar icons should use a single gray color (`#333333` for light themes (with 60%/30% opacity for enabled/disabled), and `#FFFFFF` with opacity 80%/30% for dark themes";
                                context.report(ICON_COLORS, Location.create((File)file), message);
                                break block15;
                            }
                        }
                    } else if (folderVersion >= 11 || IconDetector.isAndroid30(context, folderVersion)) {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                Project project;
                                LintClient client;
                                JavaParser parser;
                                PsiElement usage;
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0 || (rgb & 0xFFFFFF) == 0xFFFFFF) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b && (x < width - 1 && rgb != image.getRGB(x + 1, y) || x > 0 && rgb != image.getRGB(x - 1, y) || y < height - 1 && rgb != image.getRGB(x, y + 1) || y > 0 && rgb != image.getRGB(x, y - 1))) continue;
                                String message = "Notification icons must be entirely white";
                                Location location = Location.create((File)file);
                                String name = IconDetector.getBaseName(file.getName());
                                PsiElement psiElement = usage = this.notificationIcons != null ? this.notificationIcons.get(name) : null;
                                if (usage != null && (parser = (client = context.getClient()).getJavaParser(project = context.getProject())) != null) {
                                    Location secondary = parser.createLocation(usage);
                                    secondary.setMessage("Icon used in notification here");
                                    location.setSecondary(secondary);
                                }
                                context.report(ICON_COLORS, location, message);
                                break block15;
                            }
                        }
                    } else {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b) continue;
                                String message = "Notification icons should not use colors";
                                context.report(ICON_COLORS, Location.create((File)file), message);
                                break block15;
                            }
                        }
                    }
                }
                return new Dimension(image.getWidth(), image.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkExtension(Context context, File file) {
        block14: {
            try {
                ImageInputStream input = ImageIO.createImageInputStream(file);
                if (input == null) break block14;
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (!readers.hasNext() && !SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".webp") && WebpHeader.getWebpHeader(file) != null) {
                        String extension = file.getName();
                        extension = extension.substring(extension.lastIndexOf(46) + 1);
                        String message = String.format("Misleading file extension; named `.%1$s` but the file format is `%2$s`", extension, "webp");
                        Location location = Location.create((File)file);
                        context.report(ICON_EXTENSION, location, message);
                    }
                    while (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            int index;
                            reader.setInput(input);
                            String formatName = reader.getFormatName();
                            if (formatName == null || formatName.isEmpty()) continue;
                            String path = file.getPath();
                            String extension = path.substring((index = path.lastIndexOf(46)) + 1).toLowerCase(Locale.US);
                            if (!formatName.equalsIgnoreCase(extension)) {
                                if (LintUtils.endsWith((String)path, (String)".jpg") && formatName.equals("JPEG")) {
                                    return;
                                }
                                String message = String.format("Misleading file extension; named `.%1$s` but the file format is `%2$s`", extension, formatName);
                                Location location = Location.create((File)file);
                                context.report(ICON_EXTENSION, location, message);
                            }
                            break;
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                System.out.println("foo");
            }
        }
    }

    private static String getBaseName(String name) {
        String baseName = name;
        int index = baseName.indexOf(46);
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        return baseName;
    }

    private static void checkMixedNinePatches(Context context, Map<File, Set<String>> folderToNames) {
        Set conflictSet = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            HashSet<String> hashSet = new HashSet<String>();
            Set<String> names = entry.getValue();
            for (String string : names) {
                assert (IconDetector.isDrawableFile(string)) : string;
                String base = IconDetector.getBaseName(string);
                if (hashSet.contains(base)) {
                    String ninepatch = base + ".9.png";
                    String png = base + ".png";
                    if (!names.contains(ninepatch) || !names.contains(png)) continue;
                    if (conflictSet == null) {
                        conflictSet = Sets.newHashSet();
                    }
                    conflictSet.add(base);
                    continue;
                }
                hashSet.add(base);
            }
        }
        if (conflictSet == null || conflictSet.isEmpty()) {
            return;
        }
        Map conflicts = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            File dir = entry.getKey();
            Set<String> names = entry.getValue();
            for (String name : names) {
                List files;
                assert (IconDetector.isDrawableFile(name)) : name;
                String base = IconDetector.getBaseName(name);
                if (!conflictSet.contains(base)) continue;
                if (conflicts == null) {
                    conflicts = Maps.newHashMap();
                }
                if ((files = (List)conflicts.get(base)) == null) {
                    files = Lists.newArrayList();
                    conflicts.put(base, files);
                }
                files.add(new File(dir, name));
            }
        }
        assert (conflicts != null && !conflicts.isEmpty()) : conflictSet;
        ArrayList arrayList = new ArrayList(conflicts.keySet());
        Collections.sort(arrayList);
        for (String name : arrayList) {
            List files = (List)conflicts.get(name);
            assert (files != null) : name;
            Location location = IconDetector.chainLocations(files);
            String message = String.format("The files `%1$s.png` and `%1$s.9.png` clash; both will map to `@drawable/%1$s`", name);
            context.report(ICON_MIX_9PNG, location, message);
        }
    }

    private static Location chainLocations(List<File> files) {
        Collections.sort(files);
        Location location = null;
        for (File file : files) {
            Location linkedLocation = location;
            location = Location.create((File)file);
            location.setSecondary(linkedLocation);
        }
        return location;
    }

    private void checkExpectedSizes(Context context, File folder, File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        String folderName = folder.getName();
        int folderVersion = context.getDriver().getResourceFolderVersion(files[0]);
        FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
        for (File file : files) {
            String name = file.getName();
            String baseName = IconDetector.getBaseName(name);
            if (this.isLauncherIcon(folderName, baseName)) {
                IconDetector.checkSize(context, folderName, file, 48, 48, true, folderConfig);
                continue;
            }
            if (this.isActionBarIcon(folderName, baseName)) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (name.startsWith("ic_dialog_")) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (name.startsWith("ic_tab_")) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (this.isNotificationIcon(baseName)) {
                if (IconDetector.isAndroid30(context, folderVersion)) {
                    IconDetector.checkSize(context, folderName, file, 24, 24, true, folderConfig);
                    continue;
                }
                if (IconDetector.isAndroid23(context, folderVersion)) {
                    IconDetector.checkSize(context, folderName, file, 16, 25, false, folderConfig);
                    continue;
                }
                IconDetector.checkSize(context, folderName, file, 25, 25, true, folderConfig);
                continue;
            }
            if (!name.startsWith("ic_menu_")) continue;
            if (IconDetector.isAndroid30(context, folderVersion)) {
                IconDetector.checkSize(context, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (IconDetector.isAndroid23(context, folderVersion)) {
                IconDetector.checkSize(context, folderName, file, 48, 48, true, folderConfig);
                continue;
            }
            IconDetector.checkSize(context, folderName, file, 48, 48, true, folderConfig);
        }
    }

    private static boolean isAndroid30(Context context, int folderVersion) {
        return folderVersion >= 11 || context.getMainProject().getMinSdk() >= 11;
    }

    private static boolean isAndroid23(Context context, int folderVersion) {
        if (IconDetector.isAndroid30(context, folderVersion)) {
            return false;
        }
        if (folderVersion == 9 || folderVersion == 10) {
            return true;
        }
        int minSdk = context.getMainProject().getMinSdk();
        return minSdk == 9 || minSdk == 10;
    }

    private static float getMdpiScalingFactor(String folderName) {
        if (folderName.contains("-mdpi")) {
            return 1.0f;
        }
        if (folderName.contains("-hdpi")) {
            return 1.5f;
        }
        if (folderName.contains("-xhdpi")) {
            return 2.0f;
        }
        if (folderName.contains("-xxhdpi")) {
            return 3.0f;
        }
        if (folderName.contains("-xxxhdpi")) {
            return 4.0f;
        }
        if (folderName.contains("-ldpi")) {
            return 0.75f;
        }
        return 0.0f;
    }

    private static void checkSize(Context context, String folderName, File file, int mdpiWidth, int mdpiHeight, boolean exactMatch, FolderConfiguration folderConfig) {
        int height;
        int width;
        String fileName = file.getName();
        if (!(LintUtils.endsWith((String)fileName, (String)".png") && !LintUtils.endsWith((String)fileName, (String)".9.png") || LintUtils.endsWith((String)fileName, (String)".webp") || LintUtils.endsWith((String)fileName, (String)".jpg") || LintUtils.endsWith((String)fileName, (String)".jpeg"))) {
            return;
        }
        if (folderName.startsWith("drawable-mdpi")) {
            width = mdpiWidth;
            height = mdpiHeight;
        } else if (folderName.startsWith("drawable-hdpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 2.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 2.0f);
        } else if (folderName.startsWith("drawable-xhdpi")) {
            width = mdpiWidth * 2;
            height = mdpiHeight * 2;
        } else if (folderName.startsWith("drawable-xxhdpi")) {
            width = mdpiWidth * 3;
            height = mdpiWidth * 3;
        } else if (folderName.startsWith("drawable-ldpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 4.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 4.0f);
        } else if (folderConfig != null && folderConfig.getDensityQualifier() != null && !folderConfig.getDensityQualifier().hasFakeValue()) {
            Density density = folderConfig.getDensityQualifier().getValue();
            if (density == null) {
                return;
            }
            width = mdpiWidth * density.getDpiValue() / 160;
            height = mdpiHeight * density.getDpiValue() / 160;
        } else {
            return;
        }
        Dimension size = IconDetector.getSize(file);
        if (size != null) {
            if (exactMatch && (size.width != width || size.height != height)) {
                context.report(ICON_EXPECTED_SIZE, Location.create((File)file), String.format("Incorrect icon size for `%1$s`: expected %2$dx%3$d, but was %4$dx%5$d", folderName + File.separator + file.getName(), width, height, size.width, size.height));
            } else if (!(exactMatch || size.width <= width && size.height <= height)) {
                context.report(ICON_EXPECTED_SIZE, Location.create((File)file), String.format("Incorrect icon size for `%1$s`: icon size should be at most %2$dx%3$d, but was %4$dx%5$d", folderName + File.separator + file.getName(), width, height, size.width, size.height));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Dimension getSize(File file) {
        try {
            WebpHeader header;
            ImageInputStream input = ImageIO.createImageInputStream(file);
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            if (SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".webp") && (header = WebpHeader.getWebpHeader(file)) != null && header.width > 0) {
                return new Dimension(header.width, header.height);
            }
            BufferedImage image = ImageIO.read(file);
            if (image != null) {
                return new Dimension(image.getWidth(), image.getHeight());
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isLauncherIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1) : name;
        if (name.startsWith("ic_launcher")) {
            return true;
        }
        if (this.launcherIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.launcherIcons.contains(name);
        }
        return false;
    }

    private boolean isRoundIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1) : name;
        if (name.endsWith("_round")) {
            return true;
        }
        if (this.roundIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.roundIcons.contains(name);
        }
        return false;
    }

    private boolean isNotificationIcon(String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_stat_")) {
            return true;
        }
        return this.notificationIcons != null && this.notificationIcons.containsKey(name);
    }

    private boolean isActionBarIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_action_")) {
            return true;
        }
        if (this.actionBarIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.actionBarIcons.contains(name);
        }
        return false;
    }

    private boolean isActionBarIcon(Context context, String folderName, String name, File file) {
        if (this.isActionBarIcon(folderName, name)) {
            return true;
        }
        return file != null && name.startsWith("ic_menu_") && IconDetector.isAndroid30(context, context.getDriver().getResourceFolderVersion(file));
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "activity-alias", "service", "provider", "receiver", "item");
    }

    public void visitElement(XmlContext context, Element element) {
        String icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
        this.addIcon(context, element, icon);
        icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "roundIcon");
        String key = this.addIcon(context, element, icon);
        if (key != null) {
            if (this.roundIcons == null) {
                this.roundIcons = Sets.newHashSet();
            }
            this.roundIcons.add(key);
        }
    }

    private String addIcon(XmlContext context, Element element, String icon) {
        if (icon == null || icon.isEmpty()) {
            return null;
        }
        if (icon.startsWith("@drawable/")) {
            icon = icon.substring("@drawable/".length());
        } else if (!icon.startsWith("@mipmap/")) {
            return null;
        }
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            if (this.menuToIcons == null) {
                this.menuToIcons = ArrayListMultimap.create();
            }
            String menu = IconDetector.getBaseName(context.file.getName());
            this.menuToIcons.put((Object)menu, (Object)icon);
        } else {
            if (this.launcherIcons == null) {
                this.launcherIcons = Sets.newHashSet();
            }
            this.launcherIcons.add(icon);
        }
        return icon;
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        ArrayList<Class<? extends PsiElement>> types = new ArrayList<Class<? extends PsiElement>>(2);
        types.add(PsiNewExpression.class);
        types.add(PsiMethod.class);
        return types;
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new NotificationFinder();
    }

    private boolean handleSelect(PsiElement select) {
        ResourceUrl url = ResourceEvaluator.getResourceConstant((PsiElement)select);
        if (url != null && url.type == ResourceType.DRAWABLE && !url.framework) {
            if (this.notificationIcons == null) {
                this.notificationIcons = Maps.newHashMap();
            }
            this.notificationIcons.put(url.name, select);
            return true;
        }
        return false;
    }

    static {
        boolean includeLdpi = false;
        String value = System.getenv("ANDROID_LINT_INCLUDE_LDPI");
        if (value != null) {
            includeLdpi = Boolean.valueOf(value);
        }
        INCLUDE_LDPI = includeLdpi;
        DENSITY_PATTERN = Pattern.compile("^drawable-(nodpi|xxxhdpi|xxhdpi|xhdpi|hdpi|mdpi" + (INCLUDE_LDPI ? "|ldpi" : "") + ")$");
        DP_NAME_PATTERN = Pattern.compile(".+_(\\d+)dp\\.[a-zA-Z]+");
        DENSITY_QUALIFIERS = new String[]{"-ldpi", "-mdpi", "-hdpi", "-xhdpi", "-xxhdpi", "-xxxhdpi"};
        ICON_TYPE_SCOPE = EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE, Scope.MANIFEST);
        IMPLEMENTATION_JAVA = new Implementation(IconDetector.class, ICON_TYPE_SCOPE);
        IMPLEMENTATION_RES_ONLY = new Implementation(IconDetector.class, Scope.ALL_RESOURCES_SCOPE);
        ICON_EXPECTED_SIZE = Issue.create((String)"IconExpectedSize", (String)"Icon has incorrect size", (String)"There are predefined sizes (for each density) for launcher icons. You should follow these conventions to make sure your icons fit in with the overall look of the platform.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA).setEnabledByDefault(false).addMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_DIP_SIZE = Issue.create((String)"IconDipSize", (String)"Icon density-independent size validation", (String)"Checks the all icons which are provided in multiple densities, all compute to roughly the same density-independent pixel (`dip`) size. This catches errors where images are either placed in the wrong folder, or icons are changed to new sizes but some folders are forgotten.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_LOCATION = Issue.create((String)"IconLocation", (String)"Image defined in density-independent drawable folder", (String)"The res/drawable folder is intended for density-independent graphics such as shapes defined in XML. For bitmaps, move it to `drawable-mdpi` and consider providing higher and lower resolution versions in `drawable-ldpi`, `drawable-hdpi` and `drawable-xhdpi`. If the icon *really* is density independent (for example a solid color) you can place it in `drawable-nodpi`.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_DENSITIES = Issue.create((String)"IconDensities", (String)"Icon densities validation", (String)"Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra high). This lint check identifies icons which do not have complete coverage across the densities.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", (Category)Category.ICONS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        ICON_MISSING_FOLDER = Issue.create((String)"IconMissingDensityFolder", (String)"Missing density folder", (String)"Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra-high, extra-extra-high). This lint check identifies folders which are missing, such as `drawable-hdpi`.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see http://developer.android.com/resources/dashboard/screens.html", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html");
        GIF_USAGE = Issue.create((String)"GifUsage", (String)"Using `.gif` format for bitmaps is discouraged", (String)"The `.gif` file format is discouraged. Consider using `.png` (preferred) or `.jpg` (acceptable) instead.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY).addMoreInfo("http://developer.android.com/guide/topics/resources/drawable-resource.html#Bitmap");
        DUPLICATES_NAMES = Issue.create((String)"IconDuplicates", (String)"Duplicated icons under different names", (String)"If an icon is repeated under different names, you can consolidate and just use one of the icons and delete the others to make your application smaller. However, duplicated icons usually are not intentional and can sometimes point to icons that were accidentally overwritten or accidentally not updated.", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        DUPLICATES_CONFIGURATIONS = Issue.create((String)"IconDuplicatesConfig", (String)"Identical bitmaps across various configurations", (String)"If an icon is provided under different configuration parameters such as `drawable-hdpi` or `-v11`, they should typically be different. This detector catches cases where the same icon is provided in different configuration folder which is usually not intentional.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_NODPI = Issue.create((String)"IconNoDpi", (String)"Icon appears in both `-nodpi` and dpi folders", (String)"Bitmaps that appear in `drawable-nodpi` folders will not be scaled by the Android framework. If a drawable resource of the same name appears *both* in a `-nodpi` folder as well as a dpi folder such as `drawable-hdpi`, then the behavior is ambiguous and probably not intentional. Delete one or the other, or use different names for the icons.", (Category)Category.ICONS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_MIX_9PNG = Issue.create((String)"IconMixedNinePatch", (String)"Clashing PNG and 9-PNG files", (String)"If you accidentally name two separate resources `file.png` and `file.9.png`, the image file and the nine patch file will both map to the same drawable resource, `@drawable/file`, which is probably not what was intended.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_XML_AND_PNG = Issue.create((String)"IconXmlAndPng", (String)"Icon is specified both as `.xml` file and as a bitmap", (String)"If a drawable resource appears as an `.xml` file in the `drawable/` folder, it's usually not intentional for it to also appear as a bitmap using the same name; generally you expect the drawable XML file to define states and each state has a corresponding drawable bitmap.", (Category)Category.ICONS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_EXTENSION = Issue.create((String)"IconExtension", (String)"Icon format does not match the file extension", (String)"Ensures that icons have the correct file extension (e.g. a `.png` file is really in the PNG format and not for example a GIF file named `.png`.)", (Category)Category.ICONS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_RES_ONLY);
        ICON_COLORS = Issue.create((String)"IconColors", (String)"Icon colors do not follow the recommended visual style", (String)"Notification icons and Action Bar icons should only white and shades of gray. See the Android Design Guide for more details. Note that the way Lint decides whether an icon is an action bar icon or a notification icon is based on the filename prefix: `ic_menu_` for action bar icons, `ic_stat_` for notification icons etc. These correspond to the naming conventions documented in http://developer.android.com/guide/practices/ui_guidelines/icon_design.html", (Category)Category.ICONS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA).addMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_LAUNCHER_SHAPE = Issue.create((String)"IconLauncherShape", (String)"The launcher icon shape should use a distinct silhouette", (String)"According to the Android Design Guide (http://developer.android.com/design/style/iconography.html) your launcher icons should \"use a distinct silhouette\", a \"three-dimensional, front view, with a slight perspective as if viewed from above, so that users perceive some depth.\"\n\nThe unique silhouette implies that your launcher icon should not be a filled square.", (Category)Category.ICONS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA).addMoreInfo("http://developer.android.com/design/style/iconography.html");
        ICON_LAUNCHER_FORMAT = Issue.create((String)"IconLauncherFormat", (String)"Wrong launcher icon format", (String)"Launcher icons should be in the PNG format. This requirement is enforced by the The Google Play Developer Console.", (Category)Category.ICONS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_JAVA).addMoreInfo("https://developer.android.com/guide/practices/ui_guidelines/icon_design_launcher.html#size");
        WEBP_ELIGIBLE = Issue.create((String)"ConvertToWebp", (String)"Convert to WebP", (String)"The WebP format is typically more compact than PNG and JPEG. As of Android 4.2.1 it supports transparency and lossless conversion as well. Note that there is a quickfix in the IDE which lets you perform conversion.\n\nLauncher icons must be in the PNG format.", (Category)Category.ICONS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_JAVA).setEnabledByDefault(false);
        WEBP_UNSUPPORTED = Issue.create((String)"WebpUnsupported", (String)"WebP Unsupported", (String)"The WebP format requires Android 4.0 (API 15). Certain features, such as lossless encoding and transparency, requires Android 4.2.1 (API 18; API 17 is 4.2.0.)", (Category)Category.ICONS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_JAVA);
    }

    private final class MenuFinder
    extends JavaRecursiveElementVisitor {
        private MenuFinder() {
        }

        public void visitReferenceExpression(PsiReferenceExpression node) {
            Collection icons;
            super.visitReferenceExpression(node);
            ResourceUrl url = ResourceEvaluator.getResourceConstant((PsiElement)node);
            if (url != null && url.type == ResourceType.MENU && !url.framework && IconDetector.this.menuToIcons != null && (icons = IconDetector.this.menuToIcons.get((Object)url.name)) != null) {
                if (IconDetector.this.actionBarIcons == null) {
                    IconDetector.this.actionBarIcons = Sets.newHashSet();
                }
                IconDetector.this.actionBarIcons.addAll(icons);
            }
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
        }
    }

    private final class SetIconFinder
    extends JavaRecursiveElementVisitor {
        private SetIconFinder() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression[] arguments;
            super.visitMethodCallExpression(expression);
            if (IconDetector.SET_SMALL_ICON.equals(expression.getMethodExpression().getReferenceName()) && (arguments = expression.getArgumentList().getExpressions()).length == 1 && arguments[0] instanceof PsiReferenceExpression) {
                IconDetector.this.handleSelect((PsiElement)arguments[0]);
            }
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
        }
    }

    private final class NotificationFinder
    extends JavaElementVisitor {
        private NotificationFinder() {
        }

        public void visitMethod(PsiMethod method) {
            if (IconDetector.ON_CREATE_OPTIONS_MENU.equals(method.getName())) {
                method.accept((PsiElementVisitor)new MenuFinder());
            }
        }

        public void visitNewExpression(PsiNewExpression node) {
            PsiMethod method;
            PsiJavaCodeReferenceElement classReference = node.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiElement resolved = classReference.resolve();
            if (!(resolved instanceof PsiClass)) {
                return;
            }
            String typeName = ((PsiClass)resolved).getName();
            if (IconDetector.NOTIFICATION_CLASS.equals(typeName)) {
                PsiExpression[] args;
                PsiExpressionList argumentList = node.getArgumentList();
                PsiExpression[] psiExpressionArray = args = argumentList != null ? argumentList.getExpressions() : PsiExpression.EMPTY_ARRAY;
                if (args.length == 3) {
                    if (args[0] instanceof PsiReferenceExpression && IconDetector.this.handleSelect((PsiElement)args[0])) {
                        return;
                    }
                    ResourceUrl url = ResourceEvaluator.getResource(null, (PsiElement)args[0]);
                    if (url != null && (url.type == ResourceType.DRAWABLE || url.type == ResourceType.COLOR || url.type == ResourceType.MIPMAP)) {
                        if (IconDetector.this.notificationIcons == null) {
                            IconDetector.this.notificationIcons = Maps.newHashMap();
                        }
                        IconDetector.this.notificationIcons.put(url.name, node);
                    }
                }
            } else if ((IconDetector.NOTIFICATION_BUILDER_CLASS.equals(typeName) || IconDetector.NOTIFICATION_COMPAT_BUILDER_CLASS.equals(typeName)) && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true)) != null) {
                SetIconFinder finder = new SetIconFinder();
                method.accept((PsiElementVisitor)finder);
            }
        }
    }

    private static class WebpHeader {
        public String format;
        int width;
        int height;

        private WebpHeader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static WebpHeader getWebpHeader(File file) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                if (((InputStream)is).read() != 82 || ((InputStream)is).read() != 73 || ((InputStream)is).read() != 70 || ((InputStream)is).read() != 70 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() != 87 || ((InputStream)is).read() != 69 || ((InputStream)is).read() != 66 || ((InputStream)is).read() != 80) {
                    WebpHeader webpHeader = null;
                    return webpHeader;
                }
                if (((InputStream)is).read() != 86 || ((InputStream)is).read() != 80 || ((InputStream)is).read() != 56) {
                    WebpHeader webpHeader = null;
                    return webpHeader;
                }
                int format = ((InputStream)is).read();
                WebpHeader data = new WebpHeader();
                if (format == 76) {
                    data.format = "VP8L";
                    for (int i = 0; i < 4; ++i) {
                        ((InputStream)is).read();
                    }
                    if (((InputStream)is).read() == 47) {
                        int byte1 = ((InputStream)is).read();
                        int byte2 = ((InputStream)is).read();
                        int byte3 = ((InputStream)is).read();
                        int byte4 = ((InputStream)is).read();
                        if (((InputStream)is).read() != -1) {
                            data.width = ((byte2 & 0x3F) << 8 | byte1) + 1;
                            data.height = ((byte4 & 0xF) << 10 | byte3 << 2 | (byte2 & 0xC0) >> 6) + 1;
                        }
                    }
                    WebpHeader byte1 = data;
                    return byte1;
                }
                if (format == 88) {
                    data.format = "VP8X";
                    for (int i = 0; i < 8; ++i) {
                        ((InputStream)is).read();
                    }
                    int byte1 = ((InputStream)is).read();
                    int byte2 = ((InputStream)is).read();
                    int byte3 = ((InputStream)is).read();
                    int byte4 = ((InputStream)is).read();
                    int byte5 = ((InputStream)is).read();
                    int byte6 = ((InputStream)is).read();
                    if (((InputStream)is).read() != -1) {
                        data.width = (byte1 | byte2 << 8 | byte3 << 16) + 1;
                        data.height = (byte4 | byte5 << 8 | byte6 << 16) + 1;
                    }
                    WebpHeader webpHeader = data;
                    return webpHeader;
                }
                if (format == 32) {
                    data.format = "VP8";
                    for (int i = 0; i < 7; ++i) {
                        ((InputStream)is).read();
                    }
                    if (((InputStream)is).read() == 157 && ((InputStream)is).read() == 1 && ((InputStream)is).read() == 42) {
                        int byte1 = ((InputStream)is).read();
                        int byte2 = ((InputStream)is).read();
                        int byte3 = ((InputStream)is).read();
                        int byte4 = ((InputStream)is).read();
                        if (((InputStream)is).read() != -1) {
                            data.width = byte1 | (byte2 & 0x3F) << 8;
                            data.height = byte3 | (byte4 & 0x3F) << 8;
                        }
                    }
                    WebpHeader webpHeader = data;
                    return webpHeader;
                }
                WebpHeader webpHeader = null;
                return webpHeader;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

