/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringAuthLeakDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue AUTH_LEAK = Issue.create((String)"AuthLeak", (String)"Code might contain an auth leak", (String)"Strings in java apps can be discovered by decompiling apps, this lint check looks for code which looks like it may contain an url with a username and password", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(StringAuthLeakDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiLiteralExpression.class);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new AuthLeakChecker(context);
    }

    private static class AuthLeakChecker
    extends JavaElementVisitor {
        private static final String LEGAL_CHARS = "([\\w_.!~*'()%;&=+$,-]+)";
        private static final Pattern AUTH_REGEXP = Pattern.compile("([\\w+.-]+)://([\\w_.!~*'()%;&=+$,-]+):([\\w_.!~*'()%;&=+$,-]+)@([\\w_.!~*'()%;&=+$,-]+)");
        private final JavaContext mContext;

        private AuthLeakChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitLiteralExpression(PsiLiteralExpression node) {
            Matcher matcher;
            if (node.getValue() instanceof String && (matcher = AUTH_REGEXP.matcher((String)node.getValue())).find()) {
                String password = matcher.group(3);
                if (password == null || password.startsWith("%") && password.endsWith("s")) {
                    return;
                }
                TextRange textRange = node.getTextRange();
                Location location = this.mContext.getRangeLocation((PsiElement)node, matcher.start() + 1, (PsiElement)node, -(textRange.getLength() - matcher.end() - 1));
                this.mContext.report(AUTH_LEAK, (PsiElement)node, location, "Possible credential leak");
            }
        }
    }
}

