/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;

public class ViewConstructorDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"ViewConstructor", (String)"Missing View constructors for XML inflation", (String)"Some layout tools (such as the Android layout editor) need to find a constructor with one of the following signatures:\n* `View(Context context)`\n* `View(Context context, AttributeSet attrs)`\n* `View(Context context, AttributeSet attrs, int defStyle)`\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if `View#isInEditMode()` is false, since that method will return `false` at runtime but true within a user interface editor.", (Category)Category.USABILITY, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewConstructorDetector.class, Scope.JAVA_FILE_SCOPE));

    private static boolean isXmlConstructor(JavaEvaluator evaluator, PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        int argumentCount = parameterList.getParametersCount();
        if (argumentCount == 0 || argumentCount > 3) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (!evaluator.typeMatches(parameters[0].getType(), "android.content.Context")) {
            return false;
        }
        if (argumentCount == 1) {
            return true;
        }
        if (!evaluator.typeMatches(parameters[1].getType(), "android.util.AttributeSet")) {
            return false;
        }
        if (argumentCount == 2) {
            return true;
        }
        return PsiType.INT.equals((Object)parameters[2].getType());
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration) || evaluator.isPrivate((PsiModifierListOwner)declaration) || declaration instanceof PsiAnonymousClass) {
            return;
        }
        if (declaration.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)declaration)) {
            return;
        }
        boolean found = false;
        for (PsiMethod constructor : declaration.getConstructors()) {
            if (!ViewConstructorDetector.isXmlConstructor(evaluator, constructor)) continue;
            found = true;
            break;
        }
        if (!found) {
            String message = String.format("Custom view `%1$s` is missing constructor used by tools: `(Context)` or `(Context,AttributeSet)` or `(Context,AttributeSet,int)`", declaration.getName());
            Location location = context.getNameLocation((PsiElement)declaration);
            context.report(ISSUE, (PsiElement)declaration, location, message);
        }
    }
}

