/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiDatabase;
import com.android.tools.lint.checks.ApiMember;
import com.android.utils.Pair;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiClass
extends ApiClassBase {
    private final int mSince;
    private final int mDeprecatedIn;
    private final int mRemovedIn;
    private final List<Pair<String, Integer>> mSuperClasses = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> mInterfaces = new ArrayList<Pair<String, Integer>>();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();
    private Map<String, Integer> mMembersDeprecatedIn;
    private Map<String, Integer> mElementsRemovedIn;

    ApiClass(String name, int since, int deprecatedIn, int removedIn) {
        super(name);
        this.mSince = since;
        this.mDeprecatedIn = deprecatedIn;
        this.mRemovedIn = removedIn;
    }

    int getSince() {
        return this.mSince;
    }

    int getDeprecatedIn() {
        return this.mDeprecatedIn;
    }

    int getRemovedIn() {
        return this.mRemovedIn;
    }

    int getField(String name, Api<? extends ApiClassBase> info) {
        int apiLevel = this.getValueWithDefault(this.mFields, name, 0);
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int i;
            ApiClassBase superClass = info.getClass((String)superClassPair.getFirst());
            if (!(superClass instanceof ApiClass) || (i = ((ApiClass)superClass).getField(name, info)) == 0) continue;
            int tmp = Math.max((Integer)superClassPair.getSecond(), i);
            if (apiLevel != 0 && tmp >= apiLevel) continue;
            apiLevel = tmp;
        }
        return apiLevel;
    }

    int getMemberDeprecatedIn(String name, Api info) {
        int apiLevel = this.getValueWithDefault(this.mMembersDeprecatedIn, name, 0);
        return apiLevel == 0 ? this.mDeprecatedIn : (this.mDeprecatedIn == 0 ? apiLevel : Math.min(apiLevel, this.mDeprecatedIn));
    }

    int getMemberRemovedIn(String name, Api info) {
        int removedIn = this.getMemberRemovedInInternal(name, info);
        return removedIn == Integer.MAX_VALUE ? this.mRemovedIn : (removedIn > 0 ? removedIn : 0);
    }

    private int getMemberRemovedInInternal(String name, Api<ApiClass> info) {
        int apiLevel = this.getValueWithDefault(this.mElementsRemovedIn, name, Integer.MAX_VALUE);
        if (apiLevel == Integer.MAX_VALUE) {
            if (this.mMethods.containsKey(name) || this.mFields.containsKey(name)) {
                return this.mRemovedIn == 0 ? Integer.MAX_VALUE : this.mRemovedIn;
            }
            apiLevel = -1;
        }
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int tmp;
            int i;
            ApiClass superClass;
            String superClassName = (String)superClassPair.getFirst();
            int superClassRemovedIn = this.getValueWithDefault(this.mElementsRemovedIn, superClassName, Integer.MAX_VALUE);
            if (superClassRemovedIn <= apiLevel || (superClass = info.getClass(superClassName)) == null || (i = superClass.getMemberRemovedInInternal(name, info)) == -1 || (tmp = Math.min(superClassRemovedIn, i)) <= apiLevel) continue;
            apiLevel = tmp;
        }
        return apiLevel;
    }

    private int getValueWithDefault(Map<String, Integer> map, String key, int defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Integer value = map.get(key);
        return value == null ? defaultValue : value;
    }

    int getMethod(String methodSignature, Api<? extends ApiClassBase> info) {
        int apiLevel = this.getValueWithDefault(this.mMethods, methodSignature, 0);
        if (!methodSignature.startsWith("<init>")) {
            for (Pair pair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
                int i;
                ApiClassBase superClass = info.getClass((String)pair.getFirst());
                if (!(superClass instanceof ApiClass) || (i = ((ApiClass)superClass).getMethod(methodSignature, info)) == 0) continue;
                int tmp = Math.max((Integer)pair.getSecond(), i);
                if (apiLevel != 0 && tmp >= apiLevel) continue;
                apiLevel = tmp;
            }
        }
        return apiLevel;
    }

    void addField(String name, int since, int deprecatedIn, int removedIn) {
        this.mFields.put(name, since);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addMethod(String name, int since, int deprecatedIn, int removedIn) {
        int index = name.indexOf(41);
        if (index != -1) {
            name = name.substring(0, index + 1);
        }
        this.mMethods.put(name, since);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addSuperClass(String superClass, int since, int removedIn) {
        ApiClass.addToArray(this.mSuperClasses, superClass, since);
        this.addToRemoved(superClass, removedIn);
    }

    void addInterface(String interfaceClass, int since, int removedIn) {
        ApiClass.addToArray(this.mInterfaces, interfaceClass, since);
        this.addToRemoved(interfaceClass, removedIn);
    }

    static void addToArray(List<Pair<String, Integer>> list, String name, int value) {
        for (Pair<String, Integer> pair : list) {
            if (!name.equals(pair.getFirst())) continue;
            assert (false);
            return;
        }
        list.add((Pair<String, Integer>)Pair.of((Object)name, (Object)value));
    }

    private void addToDeprecated(String name, int deprecatedIn) {
        if (deprecatedIn > 0) {
            if (this.mMembersDeprecatedIn == null) {
                this.mMembersDeprecatedIn = new HashMap<String, Integer>();
            }
            this.mMembersDeprecatedIn.put(name, deprecatedIn);
        }
    }

    private void addToRemoved(String name, int removedIn) {
        if (removedIn > 0) {
            if (this.mElementsRemovedIn == null) {
                this.mElementsRemovedIn = new HashMap<String, Integer>();
            }
            this.mElementsRemovedIn.put(name, removedIn);
        }
    }

    Set<String> getAllMethods(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllMethods(info, members, true);
        return members;
    }

    List<Pair<String, Integer>> getInterfaces() {
        return this.mInterfaces;
    }

    List<Pair<String, Integer>> getSuperClasses() {
        return this.mSuperClasses;
    }

    private void addAllMethods(Api<ApiClass> info, Set<String> set, boolean includeConstructors) {
        if (includeConstructors) {
            set.addAll(this.mMethods.keySet());
        } else {
            for (String method : this.mMethods.keySet()) {
                if (method.startsWith("<init>")) continue;
                set.add(method);
            }
        }
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            if (cls == null) continue;
            cls.addAllMethods(info, set, false);
        }
    }

    Set<String> getAllFields(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllFields(info, members);
        return members;
    }

    private void addAllFields(Api<ApiClass> info, Set<String> set) {
        set.addAll(this.mFields.keySet());
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            if (cls == null) {
                throw new RuntimeException("could not find " + (String)superClass.getFirst() + " for " + this.getName());
            }
            cls.addAllFields(info, set);
        }
    }

    Collection<ApiMember> getAllRemovedFields(Api info) {
        Set<String> fields = this.getAllFields(info);
        if (fields.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedFields = new ArrayList<ApiMember>();
        for (String fieldName : fields) {
            int removedIn = this.getMemberRemovedIn(fieldName, info);
            if (removedIn <= 0) continue;
            int since = this.getField(fieldName, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(fieldName, info);
            removedFields.add(new ApiMember(fieldName, since, deprecatedIn, removedIn));
        }
        return removedFields;
    }

    Collection<ApiMember> getAllRemovedMethods(Api info) {
        Set<String> methods = this.getAllMethods(info);
        if (methods.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedMethods = new ArrayList<ApiMember>();
        for (String methodSignature : methods) {
            int removedIn = this.getMemberRemovedIn(methodSignature, info);
            if (removedIn <= 0) continue;
            int since = this.getMethod(methodSignature, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(methodSignature, info);
            removedMethods.add(new ApiMember(methodSignature, since, deprecatedIn, removedIn));
        }
        return removedMethods;
    }

    @Override
    void writeSuperInterfaces(Api<? extends ApiClassBase> info, ByteBuffer buffer) {
        int api;
        List<Pair<String, Integer>> supers;
        int since = this.getSince();
        int deprecatedIn = this.getDeprecatedIn();
        int removedIn = this.getRemovedIn();
        ApiClass.writeSinceDeprecatedInRemovedIn(buffer, since, deprecatedIn, removedIn);
        List<Pair<String, Integer>> interfaces = this.getInterfaces();
        int count = 0;
        if (!interfaces.isEmpty()) {
            for (Pair<String, Integer> pair : interfaces) {
                int api2 = (Integer)pair.getSecond();
                if (api2 <= this.getSince()) continue;
                ++count;
            }
        }
        if (!(supers = this.getSuperClasses()).isEmpty()) {
            for (Pair<String, Integer> pair : supers) {
                api = (Integer)pair.getSecond();
                if (api <= this.getSince()) continue;
                ++count;
            }
        }
        buffer.put((byte)count);
        if (count > 0) {
            for (Pair<String, Integer> pair : supers) {
                api = (Integer)pair.getSecond();
                if (api <= this.getSince()) continue;
                ApiClassBase superClass = info.getClasses().get(pair.getFirst());
                assert (superClass != null) : this;
                ApiDatabase.put3ByteInt(buffer, superClass.index);
                buffer.put((byte)api);
            }
            for (Pair<String, Integer> pair : interfaces) {
                api = (Integer)pair.getSecond();
                if (api <= this.getSince()) continue;
                ApiClassBase interfaceClass = info.getClasses().get(pair.getFirst());
                assert (interfaceClass != null) : this;
                ApiDatabase.put3ByteInt(buffer, interfaceClass.index);
                buffer.put((byte)api);
            }
        }
    }

    @Override
    int computeExtraStorageNeeded(Api<? extends ApiClassBase> info) {
        int estimatedSize = 0;
        Set<String> allMethods = this.getAllMethods(info);
        Set<String> allFields = this.getAllFields(info);
        this.members = new ArrayList(allMethods.size() + allFields.size());
        this.members.addAll(allMethods);
        this.members.addAll(allFields);
        estimatedSize += 2 + 4 * this.getInterfaces().size();
        if (this.getSuperClasses().size() > 1) {
            estimatedSize += 2 + 4 * this.getSuperClasses().size();
        }
        Collections.sort(this.members);
        for (String member : this.members) {
            estimatedSize += member.length();
            estimatedSize += 16;
        }
        return estimatedSize;
    }

    @Override
    void writeMemberData(Api<? extends ApiClassBase> info, String member, ByteBuffer buffer) {
        byte[] signature;
        int since = member.indexOf(40) >= 0 ? this.getMethod(member, info) : this.getField(member, info);
        if (since == 0) {
            assert (false) : this.getName() + ':' + member;
            since = 1;
        }
        int deprecatedIn = this.getMemberDeprecatedIn(member, info);
        assert (deprecatedIn >= 0) : "Invalid deprecatedIn " + deprecatedIn + " for " + member;
        int removedIn = this.getMemberRemovedIn(member, info);
        assert (removedIn >= 0) : "Invalid removedIn " + removedIn + " for " + member;
        for (byte b : signature = member.getBytes(StandardCharsets.UTF_8)) {
            assert (b == (b & 0x7F)) : member;
            buffer.put(b);
            if (b == 41) break;
        }
        buffer.put((byte)0);
        ApiClass.writeSinceDeprecatedInRemovedIn(buffer, since, deprecatedIn, removedIn);
    }

    private static void writeSinceDeprecatedInRemovedIn(ByteBuffer buffer, int since, int deprecatedIn, int removedIn) {
        boolean isRemoved;
        assert (since != 0 && since == (since & 0xFFFFFF7F));
        assert (deprecatedIn == (deprecatedIn & 0xFFFFFF7F));
        assert (removedIn == (removedIn & 0xFFFFFF7F));
        boolean isDeprecated = deprecatedIn > 0;
        boolean bl = isRemoved = removedIn > 0;
        if (isDeprecated || isRemoved) {
            since |= 0x80;
        }
        buffer.put((byte)since);
        if (isDeprecated || isRemoved) {
            if (isRemoved) {
                deprecatedIn |= 0x80;
            }
            buffer.put((byte)deprecatedIn);
            if (isRemoved) {
                buffer.put((byte)removedIn);
            }
        }
    }
}

