/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeprecationDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"Deprecated", (String)"Using deprecated resources", (String)"Deprecated views, attributes and so on are deprecated because there is a better way to do something. Do it that new way. You've been warned.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, (Implementation)new Implementation(DeprecationDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE}));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    public void visitDocument(XmlContext context, Document document) {
        if (context.getResourceFolderType() == ResourceFolderType.XML) {
            Element rootElement = document.getDocumentElement();
            String tagName = rootElement.getTagName();
            if (tagName.startsWith("android.preference.")) {
                context.report(ISSUE, (Node)rootElement, context.getNameLocation((Node)rootElement), "The `android.preference` library is deprecated, it is recommended that you migrate to the AndroidX Preference library instead.");
                return;
            }
            if (tagName.startsWith("androidx.preference.")) {
                return;
            }
            UastParser parser = context.getClient().getUastParser(context.getProject());
            PsiClass tagClass = parser.getEvaluator().findClass(rootElement.getTagName());
            if (tagClass != null && parser.getEvaluator().inheritsFrom(tagClass, "android.preference.Preference", false)) {
                context.report(ISSUE, (Node)rootElement, context.getNameLocation((Node)rootElement), String.format("`%1$s` inherits from `android.preference.Preference` which is now deprecated, it is recommended that you migrate to the AndroidX Preference library.", tagName));
            }
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("AbsoluteLayout", "uses-permission-sdk-m");
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("editable", "inputMethod", "autoText", "capitalize", "numeric", "phoneNumber", "password");
    }

    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        String message2 = String.format("`%1$s` is deprecated", tagName);
        if ("uses-permission-sdk-m".equals(tagName)) {
            message2 = message2 + ": Use `uses-permission-sdk-23 instead";
        }
        context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), message2);
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String fix;
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        String name = attribute.getLocalName();
        int minSdk = 1;
        if (name.equals("editable")) {
            fix = !"EditText".equals(attribute.getOwnerElement().getTagName()) ? "Use an `<EditText>` to make it editable" : ("true".equals(attribute.getValue()) ? "`<EditText>` is already editable" : "Use `inputType` instead");
        } else if (name.equals("singleLine")) {
            fix = "false".equals(attribute.getValue()) ? "False is the default, so just remove the attribute" : "Use `maxLines=\"1\"` instead";
        } else {
            assert (name.equals("inputMethod") || name.equals("capitalize") || name.equals("numeric") || name.equals("phoneNumber") || name.equals("password") || name.equals("autoText"));
            fix = "Use `inputType` instead";
            minSdk = 3;
        }
        if (context.getProject().getMinSdk() < minSdk) {
            return;
        }
        context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("`%1$s` is deprecated: %2$s", attribute.getName(), fix));
    }
}

