/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Lint;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0010H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "", "methodDescriptors", "", "", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "compare", "", "owner", "name", "desc", "combined", "isDesugared", "", "isSymbolSeparator", "", "Companion", "lint-checks"})
public final class DesugaredMethodLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] methodDescriptors;
    @NotNull
    private static final String[] defaultDesugaredMethods;
    @NotNull
    private static DesugaredMethodLookup lookup;

    public DesugaredMethodLookup(@NotNull String[] methodDescriptors) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptors, (String)"methodDescriptors");
        this.methodDescriptors = methodDescriptors;
    }

    private final boolean isDesugared(String owner, String name, String desc) {
        Comparator signatureComparator2 = new Comparator(this, owner, name, desc){
            final /* synthetic */ DesugaredMethodLookup this$0;
            final /* synthetic */ String $owner;
            final /* synthetic */ String $name;
            final /* synthetic */ String $desc;
            {
                this.this$0 = $receiver;
                this.$owner = $owner;
                this.$name = $name;
                this.$desc = $desc;
            }

            public final int compare(String o1, String $noName_1) {
                Intrinsics.checkNotNullExpressionValue((Object)o1, (String)"o1");
                return DesugaredMethodLookup.access$compare(this.this$0, this.$owner, this.$name, this.$desc, o1);
            }
        };
        return Arrays.binarySearch(this.methodDescriptors, "placeholder", signatureComparator2) >= 0;
    }

    private final int compare(String owner, String name, String desc, String combined) {
        Ref.IntRef ownerIndex = new Ref.IntRef();
        Ref.IntRef nameIndex = new Ref.IntRef();
        Ref.IntRef descIndex = new Ref.IntRef();
        int lastParen = StringsKt.lastIndexOf$default((CharSequence)combined, (char)')', (int)0, (boolean)false, (int)6, null);
        int combinedLength = lastParen == -1 ? combined.length() : lastParen + 1;
        int i = '\u0000';
        do {
            char d;
            char c;
            char c2 = DesugaredMethodLookup.compare$getNext(ownerIndex, owner, nameIndex, name, descIndex, desc);
            char c3 = i;
            i = c3 + 1;
            c3 = combined.charAt(c3);
            boolean bl = false;
            boolean bl2 = false;
            char it = c3;
            boolean bl3 = false;
            if (it == '#') {
                char c4 = i;
                i = c4 + 1;
                c = combined.charAt(c4);
            } else {
                c = it;
            }
            if (c2 == (d = c) || this.isSymbolSeparator(c2) && this.isSymbolSeparator(d)) continue;
            return d - c2;
        } while (i != combinedLength);
        return nameIndex.element == 0 || nameIndex.element == name.length() && descIndex.element == 0 || descIndex.element == desc.length() ? 0 : 1;
    }

    private final boolean isSymbolSeparator(char $this$isSymbolSeparator) {
        return $this$isSymbolSeparator == '/' || $this$isSymbolSeparator == '$' || $this$isSymbolSeparator == '.';
    }

    private static final char compare$getNext(Ref.IntRef ownerIndex, String $owner, Ref.IntRef nameIndex, String $name, Ref.IntRef descIndex, String $desc) {
        char c;
        if (ownerIndex.element < $owner.length()) {
            int n = ownerIndex.element;
            ownerIndex.element = n + 1;
            c = $owner.charAt(n);
        } else if (nameIndex.element < $name.length()) {
            int n = nameIndex.element;
            nameIndex.element = n + 1;
            c = $name.charAt(n);
        } else if (descIndex.element < $desc.length()) {
            int n = descIndex.element;
            descIndex.element = n + 1;
            c = $desc.charAt(n);
        } else {
            c = '\u0000';
        }
        return c;
    }

    public static final /* synthetic */ int access$compare(DesugaredMethodLookup $this, String owner, String name, String desc, String combined) {
        return $this.compare(owner, name, desc, combined);
    }

    static {
        String[] stringArray = new String[]{"android/util/SparseArray#set(ILjava/lang/Object;)V", "java/lang/Boolean#compare(ZZ)I", "java/lang/Boolean#hashCode(Z)I", "java/lang/Boolean#logicalAnd(ZZ)Z", "java/lang/Boolean#logicalOr(ZZ)Z", "java/lang/Boolean#logicalXor(ZZ)Z", "java/lang/Byte#compare(BB)I", "java/lang/Byte#compareUnsigned(BB)I", "java/lang/Byte#hashCode(B)I", "java/lang/Byte#toUnsignedInt(B)I", "java/lang/Byte#toUnsignedLong(B)J", "java/lang/CharSequence#compare(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)I", "java/lang/Character#compare(CC)I", "java/lang/Character#hashCode(C)I", "java/lang/Character#toString(I)Ljava/lang/String;", "java/lang/Double#hashCode(D)I", "java/lang/Double#isFinite(D)Z", "java/lang/Double#max(DD)D", "java/lang/Double#min(DD)D", "java/lang/Double#sum(DD)D", "java/lang/Float#hashCode(F)I", "java/lang/Float#isFinite(F)Z", "java/lang/Float#max(FF)F", "java/lang/Float#min(FF)F", "java/lang/Float#sum(FF)F", "java/lang/Integer#compare(II)I", "java/lang/Integer#compareUnsigned(II)I", "java/lang/Integer#divideUnsigned(II)I", "java/lang/Integer#hashCode(I)I", "java/lang/Integer#max(II)I", "java/lang/Integer#min(II)I", "java/lang/Integer#parseInt(Ljava/lang/CharSequence;III)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;I)I", "java/lang/Integer#remainderUnsigned(II)I", "java/lang/Integer#sum(II)I", "java/lang/Integer#toUnsignedLong(I)J", "java/lang/Integer#toUnsignedString(I)Ljava/lang/String;", "java/lang/Integer#toUnsignedString(II)Ljava/lang/String;", "java/lang/Long#compare(JJ)I", "java/lang/Long#compareUnsigned(JJ)I", "java/lang/Long#divideUnsigned(JJ)J", "java/lang/Long#hashCode(J)I", "java/lang/Long#max(JJ)J", "java/lang/Long#min(JJ)J", "java/lang/Long#parseLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;I)J", "java/lang/Long#remainderUnsigned(JJ)J", "java/lang/Long#sum(JJ)J", "java/lang/Long#toUnsignedString(J)Ljava/lang/String;", "java/lang/Long#toUnsignedString(JI)Ljava/lang/String;", "java/lang/Math#addExact(II)I", "java/lang/Math#addExact(JJ)J", "java/lang/Math#decrementExact(I)I", "java/lang/Math#decrementExact(J)J", "java/lang/Math#floorDiv(II)I", "java/lang/Math#floorDiv(JI)J", "java/lang/Math#floorDiv(JJ)J", "java/lang/Math#floorMod(II)I", "java/lang/Math#floorMod(JI)I", "java/lang/Math#floorMod(JJ)J", "java/lang/Math#incrementExact(I)I", "java/lang/Math#incrementExact(J)J", "java/lang/Math#multiplyExact(II)I", "java/lang/Math#multiplyExact(JI)J", "java/lang/Math#multiplyExact(JJ)J", "java/lang/Math#multiplyFull(II)J", "java/lang/Math#multiplyHigh(JJ)J", "java/lang/Math#negateExact(I)I", "java/lang/Math#negateExact(J)J", "java/lang/Math#nextDown(D)D", "java/lang/Math#nextDown(F)F", "java/lang/Math#subtractExact(II)I", "java/lang/Math#subtractExact(JJ)J", "java/lang/Math#toIntExact(J)I", "java/lang/Short#compare(SS)I", "java/lang/Short#compareUnsigned(SS)I", "java/lang/Short#hashCode(S)I", "java/lang/Short#toUnsignedInt(S)I", "java/lang/Short#toUnsignedLong(S)J", "java/lang/StrictMath#addExact(II)I", "java/lang/StrictMath#addExact(JJ)J", "java/lang/StrictMath#floorDiv(II)I", "java/lang/StrictMath#floorDiv(JI)J", "java/lang/StrictMath#floorDiv(JJ)J", "java/lang/StrictMath#floorMod(II)I", "java/lang/StrictMath#floorMod(JI)I", "java/lang/StrictMath#floorMod(JJ)J", "java/lang/StrictMath#multiplyExact(II)I", "java/lang/StrictMath#multiplyExact(JI)J", "java/lang/StrictMath#multiplyExact(JJ)J", "java/lang/StrictMath#multiplyFull(II)J", "java/lang/StrictMath#multiplyHigh(JJ)J", "java/lang/StrictMath#nextDown(D)D", "java/lang/StrictMath#nextDown(F)F", "java/lang/StrictMath#subtractExact(II)I", "java/lang/StrictMath#subtractExact(JJ)J", "java/lang/StrictMath#toIntExact(J)I", "java/lang/String#isBlank()Z", "java/lang/String#join(Ljava/lang/CharSequence;Ljava/lang/Iterable;)Ljava/lang/String;", "java/lang/String#join(Ljava/lang/CharSequence;[Ljava/lang/CharSequence;)Ljava/lang/String;", "java/lang/String#repeat(I)Ljava/lang/String;", "java/lang/String#strip()Ljava/lang/String;", "java/lang/String#stripLeading()Ljava/lang/String;", "java/lang/String#stripTrailing()Ljava/lang/String;", "java/util/Collections#emptyEnumeration()Ljava/util/Enumeration;", "java/util/Collections#emptyIterator()Ljava/util/Iterator;", "java/util/Collections#emptyListIterator()Ljava/util/ListIterator;", "java/util/List#copyOf(Ljava/util/Collection;)Ljava/util/List;", "java/util/List#of()Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of([Ljava/lang/Object;)Ljava/util/List;", "java/util/Map#copyOf(Ljava/util/Map;)Ljava/util/Map;", "java/util/Map#entry(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", "java/util/Map#of()Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#ofEntries([Ljava/util/Map$Entry;)Ljava/util/Map;", "java/util/Objects#checkFromIndexSize(III)I", "java/util/Objects#checkFromToIndex(III)I", "java/util/Objects#checkIndex(II)I", "java/util/Objects#compare(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)I", "java/util/Objects#deepEquals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#equals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#hash([Ljava/lang/Object;)I", "java/util/Objects#hashCode(Ljava/lang/Object;)I", "java/util/Objects#isNull(Ljava/lang/Object;)Z", "java/util/Objects#nonNull(Ljava/lang/Object;)Z", "java/util/Objects#requireNonNull(Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#requireNonNull(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "java/util/Objects#requireNonNullElse(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#requireNonNullElseGet(Ljava/lang/Object;Ljava/util/function/Supplier;)Ljava/lang/Object;", "java/util/Objects#toString(Ljava/lang/Object;)Ljava/lang/String;", "java/util/Objects#toString(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "java/util/Set#copyOf(Ljava/util/Collection;)Ljava/util/Set;", "java/util/Set#of()Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of([Ljava/lang/Object;)Ljava/util/Set;"};
        defaultDesugaredMethods = stringArray;
        lookup = new DesugaredMethodLookup(defaultDesugaredMethods);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0005R\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup$Companion;", "", "()V", "defaultDesugaredMethods", "", "", "getDefaultDesugaredMethods", "()[Ljava/lang/String;", "[Ljava/lang/String;", "lookup", "Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "getLookup", "()Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "setLookup", "(Lcom/android/tools/lint/checks/DesugaredMethodLookup;)V", "isDesugared", "", "owner", "name", "desc", "reset", "", "setDesugaredMethods", "fileContents", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDesugared(@NotNull String owner, @NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return this.getLookup().isDesugared(owner, name, desc);
        }

        public final void setDesugaredMethods(@NotNull String fileContents) {
            Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
            char[] cArray = new char[]{'\n'};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)fileContents, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] descriptors = stringArray;
            if (Lint.assertionsEnabled()) {
                String prev = "";
                for (String s : descriptors) {
                    CharSequence charSequence = s;
                    boolean bl = false;
                    boolean bl2 = charSequence.length() == 0 || s.compareTo(prev) > 0;
                    bl = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl2) {
                        boolean bl4 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    prev = s;
                }
            }
            this.setLookup(new DesugaredMethodLookup(descriptors));
        }

        public final void reset() {
            this.setLookup(new DesugaredMethodLookup(this.getDefaultDesugaredMethods()));
        }

        @VisibleForTesting
        @NotNull
        public final String[] getDefaultDesugaredMethods() {
            return defaultDesugaredMethods;
        }

        @NotNull
        public final DesugaredMethodLookup getLookup() {
            return lookup;
        }

        public final void setLookup(@NotNull DesugaredMethodLookup desugaredMethodLookup) {
            Intrinsics.checkNotNullParameter((Object)desugaredMethodLookup, (String)"<set-?>");
            lookup = desugaredMethodLookup;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

