/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "references", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "Lcom/android/tools/lint/detector/api/Location;", "referencesRecorded", "", "resourceModel", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "kotlin.jvm.PlatformType", "isIncrementalMode", "motionSceneUrlFromMotionLayoutFileName", "Lcom/android/tools/lint/detector/api/XmlContext;", "visitElement", "element", "Lorg/w3c/dom/Element;", "visitMotionLayout", "visitMotionScene", "Companion", "lint-checks"})
public final class MotionLayoutDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean referencesRecorded;
    @Nullable
    private ResourceUsageModel resourceModel;
    @Nullable
    private Map<ResourceUsageModel.Resource, Location> references;
    @NotNull
    public static final String KEY_URL = "url";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MotionLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue INVALID_SCENE_FILE_REFERENCE = Issue.Companion.create("MotionLayoutInvalidSceneFileReference", "layoutDescription must specify a scene file", "\n                A motion scene file specifies the animations used in a `MotionLayout`. \\\n                The `layoutDescription` is required to specify a valid motion \\\n                scene file.\n                ", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{SdkConstants.MOTION_LAYOUT.oldName(), SdkConstants.MOTION_LAYOUT.newName(), "MotionScene"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.referencesRecorded) {
            return;
        }
        boolean isIncremental = this.isIncrementalMode(context);
        Map<ResourceUsageModel.Resource, Location> map = this.references;
        if (map != null) {
            Map<ResourceUsageModel.Resource, Location> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<ResourceUsageModel.Resource, Location> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<ResourceUsageModel.Resource, Location>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                ResourceUsageModel.Resource resource;
                Map.Entry<ResourceUsageModel.Resource, Location> element$iv;
                Map.Entry<ResourceUsageModel.Resource, Location> $dstr$reference$location = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<ResourceUsageModel.Resource, Location> entry = $dstr$reference$location;
                boolean bl3 = false;
                ResourceUsageModel.Resource reference = entry.getKey();
                Map.Entry<ResourceUsageModel.Resource, Location> entry2 = $dstr$reference$location;
                boolean bl4 = false;
                Location location = entry2.getValue();
                Object[] objectArray = this.resourceModel;
                ResourceUsageModel.Resource resource2 = resource = objectArray == null ? null : objectArray.getResource(reference.type, reference.name);
                if (isIncremental || resource != null && resource.isDeclared()) continue;
                String string = "The motion scene file: " + reference.getUrl() + " doesn't exist";
                LintFix.Builder builder = this.fix().name(Intrinsics.stringPlus((String)"Create ", (Object)reference.getUrl()));
                objectArray = new Object[2];
                objectArray[0] = KEY_URL;
                String string2 = reference.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reference.url");
                objectArray[1] = string2;
                context.report(INVALID_SCENE_FILE_REFERENCE, location, string, builder.data(objectArray));
            }
        }
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getTagName();
        if (Intrinsics.areEqual((Object)string, (Object)"MotionScene")) {
            this.visitMotionScene(context, element);
        } else {
            this.visitMotionLayout(context, element);
        }
    }

    private final void visitMotionScene(XmlContext context, Element element) {
        ResourceUsageModel resourceUsageModel;
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType resourceFolderType2 = resourceFolderType;
        ResourceType resourceType = ResourceType.fromFolderName((String)resourceFolderType2.getName());
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        String name = FilesKt.getNameWithoutExtension((File)context.file);
        ResourceUsageModel resourceUsageModel2 = this.resourceModel;
        if (resourceUsageModel2 == null) {
            ResourceUsageModel resourceUsageModel3 = new ResourceUsageModel();
            boolean bl = false;
            boolean bl2 = false;
            ResourceUsageModel it = resourceUsageModel3;
            boolean bl3 = false;
            this.resourceModel = it;
            resourceUsageModel = resourceUsageModel3;
        } else {
            resourceUsageModel = resourceUsageModel2;
        }
        ResourceUsageModel model = resourceUsageModel;
        model.addDeclaredResource(resourceType2, name, null, true);
    }

    private final void visitMotionLayout(XmlContext context, Element element) {
        Attr description = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (description == null) {
            String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context);
            Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
            context.report(INVALID_SCENE_FILE_REFERENCE, (Node)element, context.getNameLocation((Node)element), "The attribute: `layoutDescription` is missing", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
        } else {
            ResourceUsageModel resourceUsageModel;
            boolean bl;
            ResourceUsageModel resourceUsageModel2 = this.resourceModel;
            if (resourceUsageModel2 == null) {
                ResourceUsageModel resourceUsageModel3 = new ResourceUsageModel();
                boolean bl2 = false;
                bl = false;
                ResourceUsageModel it = resourceUsageModel3;
                boolean bl3 = false;
                this.resourceModel = it;
                resourceUsageModel = resourceUsageModel3;
            } else {
                resourceUsageModel = resourceUsageModel2;
            }
            ResourceUsageModel model = resourceUsageModel;
            ResourceUsageModel.Resource resource = model.getResourceFromUrl(description.getValue());
            if (resource != null && resource.type == ResourceType.XML) {
                Map references;
                Map map;
                boolean bl4;
                Map map2 = this.references;
                if (map2 == null) {
                    bl = false;
                    Map map3 = new LinkedHashMap();
                    boolean bl5 = false;
                    bl4 = false;
                    Map it = map3;
                    boolean bl6 = false;
                    this.references = it;
                    map = map3;
                } else {
                    map = map2;
                }
                map2 = references = map;
                ResourceUsageModel.Resource resource2 = resource;
                Location location = context.getValueLocation(description);
                bl4 = false;
                map2.put((ResourceUsageModel.Resource)resource2, (Location)location);
                this.referencesRecorded = true;
            } else {
                String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context);
                Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
                context.report(INVALID_SCENE_FILE_REFERENCE, (Node)element, context.getValueLocation(description), '`' + description.getValue() + "` is an invalid value for layoutDescription", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
            }
        }
    }

    private final boolean isIncrementalMode(Context context) {
        return !context.getScope().contains(Scope.ALL_RESOURCE_FILES);
    }

    private final String motionSceneUrlFromMotionLayoutFileName(XmlContext context) {
        return "@xml/" + FilesKt.getNameWithoutExtension((File)context.file) + "_scene";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INVALID_SCENE_FILE_REFERENCE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_URL", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

