/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/GestureBackNavDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkEnabledBackInvokedCallback", "", "document", "Lorg/w3c/dom/Document;", "filterIncident", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableReferenceNames", "", "", "visitReference", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "lint-checks"})
public final class GestureBackNavDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENABLE_ON_BACK_INVOKED_CALLBACK = "enableOnBackInvokedCallback";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"KEYCODE_BACK");
    }

    private final boolean checkEnabledBackInvokedCallback(Document document) {
        Element application;
        Element manifest;
        Document document2 = document;
        Element element = manifest = document2 != null ? document2.getDocumentElement() : null;
        Element element2 = application = element != null ? DomExtensions.subtag((Element)element, (String)"application") : null;
        return Intrinsics.areEqual((Object)(element2 != null ? element2.getAttributeNS("http://schemas.android.com/apk/res/android", ENABLE_ON_BACK_INVOKED_CALLBACK) : null), (Object)"true");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (referenced instanceof PsiField && context.getEvaluator().isMemberInClass((PsiMember)referenced, "android.view.KeyEvent")) {
            UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)reference.getUastParent());
            if (uElement == null) {
                return;
            }
            UElement keycodeBack = uElement;
            UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)keycodeBack.getUastParent());
            if (uElement2 == null) {
                return;
            }
            UElement parent = uElement2;
            UElement uElement3 = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
            if (uElement3 == null) {
                return;
            }
            UElement ifExpression = uElement3;
            if (ifExpression instanceof UIfExpression || ifExpression instanceof USwitchClauseExpression || parent instanceof USwitchClauseExpression) {
                String message2 = "If intercepting back events, this should be handled through the registration of callbacks on the window level; Please see https://developer.android.com/about/versions/13/features/predictive-back-gesture";
                LintFix fix = this.fix().url("https://developer.android.com/about/versions/13/features/predictive-back-gesture").build();
                context.report(new Incident(ISSUE, (Object)referenced, context.getLocation(keycodeBack), message2, fix), this.map());
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return this.checkEnabledBackInvokedCallback(context.getMainProject().getMergedManifest());
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(GestureBackNavDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"GestureBackNavigation", (String)"Usage of KeyEvent.KEYCODE_BACK", (String)"\n                Starting in Android 13 (API 33+), the handling of back events is moving to \\\n                an ahead-of-time callback model. \\\n                Use `OnBackInvokedDispatcher.registerOnBackInvokedCallback(...)` and \\\n                `onBackInvokedCallback` or AndroidX's `OnBackPressedDispatcher` with an implemented \\\n                `onBackPressedCallback` to handle back gestures and key presses.\n                ", (Implementation)implementation, (String)"https://developer.android.com/about/versions/13/features/predictive-back-gesture", (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/GestureBackNavDetector$Companion;", "", "()V", "ENABLE_ON_BACK_INVOKED_CALLBACK", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

