/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.CharSequences;
import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "checkEscapes", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "contents", "", "line", "", "offset", "", "valueStart", "checkLine", "checkNewerVersion", "isGitIgnored", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "run", "Companion", "lint-checks"})
public final class PropertyFileDetector
extends Detector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_VERSION_KEY = "android.experimental.lint.version";
    @JvmField
    @NotNull
    public static final Issue ESCAPE = Issue.Companion.create("PropertyEscape", "Incorrect property escapes", "\n                All backslashes and colons in .property files must be escaped with a \\\n                backslash (\\). This means that when writing a Windows path, you must \\\n                escape the file separators, so the path \\My\\Files should be written as \\\n                `key=\\\\My\\\\Files.`", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    @JvmField
    @NotNull
    public static final Issue HTTP;
    @JvmField
    @NotNull
    public static final Issue PROXY_PASSWORD;

    public void run(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        int offset = 0;
        Iterator iterator = Splitter.on((char)'\n').split(contents).iterator();
        String line = null;
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Intrinsics.checkNotNullExpressionValue(t, (String)"iterator.next()");
            line = (String)t;
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) {
                offset += line.length() + 1;
                continue;
            }
            int valueStart = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
            if (valueStart == 0) {
                offset += line.length() + 1;
                continue;
            }
            this.checkLine(context, contents, offset, line, valueStart);
            offset += line.length() + 1;
        }
    }

    private final void checkLine(Context context, CharSequence contents, int offset, String line, int valueStart) {
        String distributionPrefix = "distributionUrl=http\\";
        if (StringsKt.startsWith$default((String)line, (String)distributionPrefix, (boolean)false, (int)2, null)) {
            String string = line.substring(distributionPrefix.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String https = "https" + string;
            String escaped = StringsKt.replace$default((String)https, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
            int startOffset = offset + valueStart;
            int endOffset = startOffset + 4;
            Incident incident = IncidentKt.Incident((Context)context, (Issue)HTTP).message("Replace HTTP with HTTPS for better security; use " + escaped).fix(this.fix().replace().text("http").with("https").build()).location(Location.Companion.create(context.file, contents, startOffset, endOffset));
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        } else if (StringsKt.startsWith$default((String)line, (String)"systemProp.http.proxyPassword=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"systemProp.https.proxyPassword=", (boolean)false, (int)2, null)) {
            if (this.isGitIgnored(context.getClient(), context.file)) {
                return;
            }
            int startOffset = offset + valueStart;
            int endOffset = line.length();
            Incident incident = IncidentKt.Incident((Context)context, (Issue)PROXY_PASSWORD).message("Storing passwords in clear text is risky; make sure this file is not shared or checked in via version control").location(Location.Companion.create(context.file, contents, startOffset, endOffset));
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        } else if (StringsKt.indexOf$default((CharSequence)line, (char)'\\', (int)0, (boolean)false, (int)6, null) != -1 || StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
            this.checkEscapes(context, contents, line, offset, valueStart);
        } else if (StringsKt.startsWith$default((String)line, (String)LINT_VERSION_KEY, (boolean)false, (int)2, null)) {
            this.checkNewerVersion(context, contents, line);
        }
    }

    private final void checkNewerVersion(Context context, CharSequence contents, String line) {
        int index2;
        block8: {
            block7: {
                index2 = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index2 == -1) break block7;
                String string = line.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)LINT_VERSION_KEY)) break block8;
            }
            return;
        }
        String string = line.substring(index2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String versionString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)versionString).length() == 0) {
            return;
        }
        Version version = Version.Companion.parse(versionString);
        if (version == null) {
            return;
        }
        Version version2 = version;
        GoogleMavenRepository repository2 = new GradleDetector().getGoogleMavenRepository(context.getClient());
        Dependency dependency = Dependency.Companion.parse("com.android.tools.build:gradle:" + versionString);
        boolean allowPreview = true;
        Version version3 = repository2.findVersion(dependency, null, allowPreview);
        if (version3 == null) {
            return;
        }
        Version newerVersion = version3;
        if (newerVersion.compareTo(version2) > 0) {
            int startOffset = StringsKt.indexOf$default((CharSequence)contents, (String)versionString, (int)0, (boolean)false, (int)6, null);
            int endOffset = startOffset + versionString.length();
            String newerVersionString = newerVersion.toString();
            LintFix fix = this.fix().name("Update lint to " + newerVersionString).replace().all().with(newerVersionString).build();
            Location location = Location.Companion.create(context.file, contents, startOffset, endOffset);
            Incident incident = IncidentKt.Incident((Context)context, (Issue)GradleDetector.DEPENDENCY).location(location).message("Newer version of lint available: " + newerVersion).fix(fix);
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        }
    }

    private final boolean isGitIgnored(LintClient client, File file) {
        for (File curr = file.getParentFile(); curr != null; curr = curr.getParentFile()) {
            CharSequence ignored;
            File ignoreFile = new File(curr, ".gitignore");
            if (!ignoreFile.exists() || CharSequences.indexOf((CharSequence)(ignored = client.readFile(ignoreFile)), (CharSequence)file.getName()) == -1) continue;
            return true;
        }
        return false;
    }

    private final void checkEscapes(Context context, CharSequence contents, String line, int offset, int valueStart) {
        boolean escaped = false;
        boolean hadNonPathEscape = false;
        int errorStart = -1;
        int errorEnd = -1;
        StringBuilder path = new StringBuilder();
        int n = line.length();
        for (int i = valueStart; i < n; ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (!escaped) continue;
                path.append(c);
                continue;
            }
            if (c == ':') {
                if (!escaped) {
                    hadNonPathEscape = true;
                    if (errorStart < 0) {
                        errorStart = i;
                    }
                    errorEnd = i;
                } else {
                    escaped = false;
                }
                path.append(c);
                continue;
            }
            if (escaped) {
                hadNonPathEscape = true;
                if (errorStart < 0) {
                    errorStart = i;
                }
                errorEnd = i;
            }
            escaped = false;
            path.append(c);
        }
        String string = path.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.toString()");
        String pathString = string;
        String string2 = line.substring(0, valueStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String key = string2;
        if (hadNonPathEscape && StringsKt.endsWith$default((String)key, (String)".dir=", (boolean)false, (int)2, null) || new File(pathString).exists()) {
            String string3 = line.substring(valueStart, line.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String escapedPath = Companion.suggestEscapes(string3);
            String message2 = "Windows file separators (`\\`) and drive letter separators (':') must be escaped (`\\\\`) in property files; use " + StringsKt.replace$default((String)escapedPath, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
            int startOffset = offset + errorStart;
            int endOffset = offset + errorEnd + 1;
            String locationRange = ((Object)contents.subSequence(startOffset, endOffset)).toString();
            String escapedRange = Companion.suggestEscapes(locationRange);
            LintFix fix = this.fix().name("Escape").replace().text(locationRange).with(escapedRange).build();
            Location location = Location.Companion.create(context.file, contents, startOffset, endOffset);
            Incident incident = IncidentKt.Incident((Context)context, (Issue)ESCAPE).message(message2).fix(fix).location(location);
            PropertyFileDetector.Companion.report(incident, contents, startOffset);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE);
        HTTP = Issue.Companion.create$default((Issue.Companion)companion, (String)"UsingHttp", (String)"Using HTTP instead of HTTPS", (String)"\n                The Gradle Wrapper is available both via HTTP and HTTPS. HTTPS is more \\\n                secure since it protects against man-in-the-middle attacks etc. Older \\\n                projects created in Android Studio used HTTP but we now default to HTTPS \\\n                and recommend upgrading existing projects.", (Implementation)implementation, (String)"https://goo.gle/UsingHttp", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
        PROXY_PASSWORD = Issue.Companion.create("ProxyPassword", "Proxy Password in Cleartext", "\n                Storing proxy server passwords in clear text is dangerous if this file is \\\n                shared via version control. If this is deliberate or this is a truly private \\\n                project, suppress this warning.", Category.SECURITY, 2, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector$Companion;", "", "()V", "ESCAPE", "Lcom/android/tools/lint/detector/api/Issue;", "HTTP", "LINT_VERSION_KEY", "", "PROXY_PASSWORD", "isSuppressed", "", "issue", "source", "", "offset", "", "report", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "startOffset", "suggestEscapes", "value", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPropertyFileDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyFileDetector.kt\ncom/android/tools/lint/checks/PropertyFileDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String suggestEscapes(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\\:", (String)":", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
            String string = SdkUtils.escapePropertyValue((String)escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapePropertyValue(escaped)");
            return string;
        }

        private final void report(Incident incident, CharSequence source, int startOffset) {
            if (this.isSuppressed(incident.getIssue(), source, startOffset)) {
                return;
            }
            incident.report();
        }

        public final boolean isSuppressed(@NotNull Issue issue, @NotNull CharSequence source, int offset) {
            int n;
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int prevLineEnd = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)offset, (boolean)false, (int)4, null) - 1;
            if (prevLineEnd < 0) {
                return false;
            }
            int it = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)prevLineEnd, (boolean)false, (int)4, null);
            boolean bl = false;
            int prevLineBegin = it == -1 ? 0 : it;
            int suppress = StringsKt.indexOf$default((CharSequence)source, (String)"noinspection ", (int)prevLineBegin, (boolean)false, (int)4, null);
            return (0 <= suppress ? suppress < prevLineEnd : false) ? (0 <= (n = StringsKt.indexOf$default((CharSequence)source, (String)issue.getId(), (int)suppress, (boolean)false, (int)4, null)) ? n < prevLineEnd : false) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

