/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ApiDetectorKt;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.AppCompatCustomViewDetectorKt;
import com.android.tools.lint.checks.DesugaredMethodLookup;
import com.android.tools.lint.checks.LibraryDesugaringKt;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UImplicitCallExpressionKt;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.VersionChecks;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScannerConstants;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastSpecialExpressionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 S2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002RSB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J:\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\f\u001a\u00020\u001dH\u0016J \u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0+H\u0016J\u0016\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0.0\bH\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\tH\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0002J$\u00108\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\b\u00109\u001a\u0004\u0018\u00010\t2\b\u0010:\u001a\u0004\u0018\u00010\tH\u0002J$\u00108\u001a\u00020#2\u0006\u0010;\u001a\u00020<2\b\u00109\u001a\u0004\u0018\u00010\t2\b\u0010:\u001a\u0004\u0018\u00010\tH\u0002J8\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\u00142\u0014\b\u0002\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0CH\u0002J@\u0010D\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0014H\u0002J(\u0010K\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0018\u0010P\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0018\u0010Q\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/android/tools/lint/checks/ApiDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/ApiLookup;", "applicableAnnotations", "", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "tag", "api", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "gradleVersion", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "checkFolder", "Lcom/android/tools/lint/detector/api/ResourceContext;", "folderName", "checkLevelList", "checkObsoleteSdkVersion", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApiLevelString", "requires", "getApplicableAttributes", "", "getApplicableElements", "getApplicableUastTypes", "Ljava/lang/Class;", "getMinSdk", "inheritAnnotation", "annotation", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isAttributeOfGradientOrGradientItem", "attribute", "Lorg/w3c/dom/Attr;", "isLibraryDesugared", "owner", "name", "project", "Lcom/android/tools/lint/detector/api/Project;", "isSurroundedByHigherTargetAnnotation", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "Lorg/jetbrains/uast/UAnnotation;", "atLeast", "isApiLevelAnnotation", "Lkotlin/Function1;", "report", "scope", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "minSdk", "visitAnnotationUsage", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "visitAttribute", "visitElement", "ApiVisitor", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,3490:1\n1#2:3491\n1855#3,2:3492\n*S KotlinDebug\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector\n*L\n722#1:3492,2\n*E\n"})
public final class ApiDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
ResourceFolderScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ApiLookup apiDatabase;
    @NotNull
    public static final String KEY_FILE = "file";
    @NotNull
    public static final String KEY_REQUIRES_API = "requiresApi";
    @NotNull
    public static final String KEY_FOLDER_NAME = "folderName";
    @NotNull
    public static final String KEY_CONDITIONAL = "conditional";
    @NotNull
    public static final String KEY_REQUIRE_CLASS = "requireClass";
    @NotNull
    public static final String KEY_MIN_API = "minSdk";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final String KEY_OWNER = "owner";
    @NotNull
    private static final String KEY_NAME = "name";
    @NotNull
    private static final String KEY_DESUGAR = "desugar";
    @NotNull
    private static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    @NotNull
    private static final String ANDROIDX_SDK_SUPPRESS_ANNOTATION = "androidx.test.filters.SdkSuppress";
    @NotNull
    private static final String ROBO_ELECTRIC_CONFIG_ANNOTATION = "org.robolectric.annotation.Config";
    @NotNull
    private static final String ATTR_PROPERTY_VALUES_HOLDER = "propertyValuesHolder";
    public static final boolean REPEATED_API_ANNOTATION_REQUIRES_ALL = true;
    @NotNull
    private static final Implementation JAVA_IMPLEMENTATION = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final Pair<Boolean, ApiConstraint> NOT_SUPPRESSED = new Pair((Object)false, null);
    @NotNull
    private static final Pair<Boolean, ApiConstraint> SUPPRESSED = new Pair((Object)true, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_9 = ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)9, (int)0, (int)2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_19 = ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)19, (int)0, (int)2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_21 = ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)21, (int)0, (int)2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_23 = ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)23, (int)0, (int)2, null);
    @NotNull
    private static final ApiConstraint.SdkApiConstraint API_24 = ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)24, (int)0, (int)2, null);
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED;
    @JvmField
    @NotNull
    public static final Issue INLINED;
    @JvmField
    @NotNull
    public static final Issue UNUSED;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_SDK;
    @NotNull
    private static final String TAG_RIPPLE = "ripple";
    @NotNull
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    @NotNull
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.apiDatabase == null) {
            this.apiDatabase = ApiLookup.get(context.getClient(), context.getProject().getBuildTarget());
        }
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        List list = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Location location4;
        Object minSdk;
        Object message2;
        Object owner;
        String name;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        ApiConstraint attributeApiLevel = (ApiConstraint)ApiConstraint.ALL;
        String namespace = attribute.getNamespaceURI();
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace)) {
            Location location2;
            ApiConstraint minSdk2;
            name = attribute.getLocalName();
            if (!(Intrinsics.areEqual((Object)name, (Object)"layout_width") || Intrinsics.areEqual((Object)name, (Object)"layout_height") || Intrinsics.areEqual((Object)name, (Object)"id") || (this.isAttributeOfGradientOrGradientItem(attribute) || Intrinsics.areEqual((Object)name, (Object)"fillType")) && AppCompatCustomViewDetectorKt.dependsOnAppCompat$default(context.getProject(), false, 1, null))) {
                owner = "android/R$attr";
                ApiConstraint apiConstraint = apiDatabase.getFieldVersions((String)owner, name);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getFieldVersions(owner, name)");
                attributeApiLevel = apiConstraint;
                ApiConstraint apiConstraint2 = this.getMinSdk((Context)context);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk3 = apiConstraint2;
                if (!(Intrinsics.areEqual((Object)attributeApiLevel, (Object)ApiConstraint.UNKNOWN) || minSdk3.isAtLeast(attributeApiLevel) || ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), attributeApiLevel))) {
                    Element element = attribute.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attribute.ownerElement");
                    if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(attributeApiLevel)) {
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)KEY_NAME);
                        if (!(Companion.isBenignUnusedAttribute(name) || ApiDetector.Companion.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel) || RtlDetector.isRtlAttributeName(name) || Intrinsics.areEqual((Object)"supportsRtl", (Object)name))) {
                            Location location3 = context.getLocation((Node)attribute);
                            String localName = attribute.getLocalName();
                            String message3 = "Attribute `" + localName + "` is only used in API level " + attributeApiLevel.minString() + " and higher (current min is %1$s)";
                            if (Intrinsics.areEqual((Object)"fontFamily", (Object)localName) && AppCompatCustomViewDetectorKt.dependsOnAppCompat$default(context.getProject(), false, 1, null)) {
                                String prefix = XmlUtils.lookupNamespacePrefix((Node)attribute, (String)"http://schemas.android.com/apk/res-auto", (String)"app", (boolean)false);
                                message3 = message3 + " Did you mean `" + prefix + ":fontFamily` ?";
                            }
                            this.report(context, UNUSED, attribute, location3, message3, attributeApiLevel, minSdk3);
                        }
                    }
                }
            }
            if (Intrinsics.areEqual((Object)name, (Object)"divider")) {
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"theme") && Intrinsics.areEqual((Object)"include", (Object)attribute.getOwnerElement().getTagName())) {
                ApiConstraint apiConstraint = this.getMinSdk((Context)context);
                if (apiConstraint == null) {
                    return;
                }
                minSdk2 = apiConstraint;
                if (!minSdk2.isAtLeast((ApiConstraint)API_23) && !ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), (ApiConstraint)API_23)) {
                    location2 = context.getLocation((Node)attribute);
                    message2 = "Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is %1$s)";
                    this.report(context, UNUSED, attribute, location2, (String)message2, (ApiConstraint)API_23, minSdk2);
                }
            }
            if (Intrinsics.areEqual((Object)name, (Object)"foreground") && context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
                String string = attribute.getOwnerElement().getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.ownerElement.tagName");
                if (!ApiDetector.Companion.isFrameLayout(context, string, true)) {
                    ApiConstraint apiConstraint = this.getMinSdk((Context)context);
                    if (apiConstraint == null) {
                        return;
                    }
                    minSdk2 = apiConstraint;
                    if (!minSdk2.isAtLeast((ApiConstraint)API_23) && !ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), (ApiConstraint)API_23)) {
                        location2 = context.getLocation((Node)attribute);
                        message2 = "Attribute `android:foreground` has no effect on API levels lower than 23 (current min is %1$s)";
                        this.report(context, UNUSED, attribute, location2, (String)message2, (ApiConstraint)API_23, minSdk2);
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace) && Intrinsics.areEqual((Object)(name = attribute.getLocalName()), (Object)"targetApi")) {
            Integer api2;
            Object object;
            String targetApiString = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)targetApiString, (String)"targetApiString");
            if (!StringsKt.isBlank((CharSequence)targetApiString) && Character.isDigit(targetApiString.charAt(0))) {
                try {
                    message2 = Integer.parseInt(targetApiString);
                }
                catch (NumberFormatException e) {
                    message2 = null;
                }
                object = message2;
            } else {
                object = api2 = Integer.valueOf(SdkVersionInfo.getApiByBuildCode((String)targetApiString, (boolean)true));
            }
            if (api2 != null) {
                message2 = "Unnecessary; SDK_INT is always >= " + api2;
                LintFix fix = this.fix().replace().all().with("").range(context.getLocation((Node)attribute)).name("Delete " + attribute.getName()).build();
                context.report(new Incident(OBSOLETE_SDK, (String)message2, context.getLocation((Node)attribute), (Object)attribute, fix), Constraints.minSdkAtLeast((int)api2));
                return;
            }
        }
        String value = attribute.getValue();
        owner = null;
        String name2 = null;
        String prefix = null;
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value, (String)"@android:", (boolean)false, (int)2, null)) {
            prefix = "@android:";
        } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE) {
                ApiConstraint.SdkApiConstraint api3 = API_21;
                ApiConstraint apiConstraint = this.getMinSdk((Context)context);
                if (apiConstraint == null) {
                    return;
                }
                minSdk = apiConstraint;
                if (!minSdk.isAtLeast((ApiConstraint)api3) && !ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), (ApiConstraint)api3)) {
                    Element element = attribute.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attribute.ownerElement");
                    if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast((ApiConstraint)api3)) {
                        location4 = context.getLocation((Node)attribute);
                        String message4 = "Using theme references in XML drawables requires API level " + api3.minString() + " (current min is %1$s)";
                        this.report(context, UNSUPPORTED, attribute, location4, message4, (ApiConstraint)api3, (ApiConstraint)minSdk);
                        return;
                    }
                }
            }
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)KEY_NAME, (Object)attribute.getName()) && Intrinsics.areEqual((Object)"item", (Object)attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            String string = value.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            name2 = string;
            prefix = null;
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)"parent", (Object)attribute.getName()) && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            String string = value.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            name2 = ResourcesUtil.resourceNameToFieldName((String)string);
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            String string = prefix;
            int index2 = StringsKt.indexOf$default((CharSequence)value, (char)'/', (int)(string != null ? string.length() : 0), (boolean)false, (int)4, null);
            if (index2 >= 0) {
                minSdk = value;
                String string2 = prefix;
                int location4 = string2 != null ? string2.length() : 0;
                String string3 = ((String)minSdk).substring(location4, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                owner = "android/R$" + string3;
                String string4 = value.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                name2 = ResourcesUtil.resourceNameToFieldName((String)string4);
            } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
                owner = "android/R$attr";
                String string5 = value.substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                name2 = string5;
            } else {
                return;
            }
        }
        if (name2 == null) {
            return;
        }
        ApiConstraint apiConstraint = apiDatabase.getFieldVersions((String)owner, name2);
        Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getFieldVersions(owner, name)");
        ApiConstraint api4 = apiConstraint;
        if (Intrinsics.areEqual((Object)api4, (Object)ApiConstraint.UNKNOWN)) {
            return;
        }
        ApiConstraint apiConstraint3 = this.getMinSdk((Context)context);
        if (apiConstraint3 == null) {
            return;
        }
        minSdk = apiConstraint3;
        if (!minSdk.isAtLeast(api4) && !ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), api4)) {
            Element element = attribute.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attribute.ownerElement");
            if (!ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api4)) {
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)attributeApiLevel, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                if (!attributeApiLevel.isAtLeast(api4)) {
                    if (!minSdk.isAtLeast(attributeApiLevel)) {
                        String attributeName = attribute.getLocalName();
                        Location location5 = context.getLocation((Node)attribute);
                        String message5 = "`" + name2 + "` requires API level " + api4.minString() + " (current min is %1$s), but note that attribute `" + attributeName + "` is only used in API level " + attributeApiLevel.minString() + " and higher";
                        this.report(context, UNSUPPORTED, attribute, location5, message5, api4, (ApiConstraint)minSdk);
                    } else {
                        String old;
                        if (api4.min() == 17 && RtlDetector.isRtlAttributeName(name2) && !Intrinsics.areEqual((Object)name2, (Object)(old = RtlDetector.convertNewToOld(name2)))) {
                            Element parent = attribute.getOwnerElement();
                            if (Intrinsics.areEqual((Object)"item", (Object)parent.getTagName())) {
                                Node node = parent.getParentNode();
                                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"parent.parentNode");
                                for (Element item : Lint.getChildren((Node)node)) {
                                    String v = item.getAttribute(KEY_NAME);
                                    Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                                    Intrinsics.checkNotNullExpressionValue((Object)old, (String)"old");
                                    if (!StringsKt.endsWith$default((String)v, (String)old, (boolean)false, (int)2, null)) continue;
                                    return;
                                }
                            } else if (parent.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                                return;
                            }
                        }
                        location4 = context.getLocation((Node)attribute);
                        String minString = api4.minString();
                        String message6 = "`" + value + "` requires API level " + minString + " (current min is %1$s)";
                        this.report(context, UNSUPPORTED, attribute, location4, message6, api4, (ApiConstraint)minSdk);
                    }
                }
            }
        }
    }

    private final boolean isAttributeOfGradientOrGradientItem(Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"gradient")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"item")) {
            Node node = element.getParentNode();
            return Intrinsics.areEqual((Object)(node != null ? node.getLocalName() : null), (Object)"gradient");
        }
        return false;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        String string = element.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.tagName");
        String tag = string;
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, "vector", (ApiConstraint)API_21, "1.4.0", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, (ApiConstraint)API_21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, (ApiConstraint)API_21, null, UNSUPPORTED);
                this.checkElement(context, element, "animated-vector", (ApiConstraint)API_21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", (ApiConstraint)API_24, null, UNSUPPORTED);
                if (Intrinsics.areEqual((Object)"layer-list", (Object)tag)) {
                    this.checkLevelList(context, element);
                } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    this.checkElement(context, element, tag, (ApiConstraint)API_24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                ApiConstraint minSdk;
                ApiConstraint api2;
                String string2;
                String typeString;
                String string3;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3) continue;
                String string4 = text = textNode.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text");
                if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"@android:", (boolean)false, (int)2, null)) continue;
                String string5 = text;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text");
                String string6 = text = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"text");
                int index2 = StringsKt.indexOf$default((CharSequence)string6, (char)'/', (int)9, (boolean)false, (int)4, null);
                if (index2 == -1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                int n2 = 9;
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n2, index2), (String)"substring(...)");
                if (ResourceType.fromXmlValue((String)typeString) == null) continue;
                String owner = "android/R$" + typeString;
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                int n3 = index2 + 1;
                String string7 = string2.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                String name = ResourcesUtil.resourceNameToFieldName((String)string7);
                Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getFieldVersions(owner, name), (String)"apiDatabase.getFieldVersions(owner, name)");
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) continue;
                if (this.getMinSdk((Context)context) == null) {
                    return;
                }
                if (minSdk.isAtLeast(api2) || ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), api2) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api2)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)textNode, (String)"textNode");
                Location location = context.getLocation(textNode);
                String message2 = "`" + text + "` requires API level " + api2.minString() + " (current min is %1$s)";
                this.report(context, UNSUPPORTED, element, location, message2, api2, minSdk);
            }
        } else {
            ApiConstraint localMinSdk;
            if (Intrinsics.areEqual((Object)"view", (Object)tag)) {
                String string8 = element.getAttribute("class");
                if (string8 == null) {
                    return;
                }
                tag = string8;
                if (((CharSequence)tag).length() == 0) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", (ApiConstraint)API_21, null, UNUSED);
            }
            if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            Object fqn = "android/widget/" + tag;
            if (Intrinsics.areEqual((Object)tag, (Object)"TextureView")) {
                fqn = "android/view/TextureView";
            }
            ApiConstraint apiConstraint = apiDatabase.getClassVersions((String)fqn);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getClassVersions(fqn)");
            ApiConstraint api3 = apiConstraint;
            if (Intrinsics.areEqual((Object)api3, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = this.getMinSdk((Context)context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (!(minSdk.isAtLeast(api3) || ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), api3) || (localMinSdk = ApiDetector.Companion.getLocalMinSdk(element)).isAtLeast(api3))) {
                Location location = context.getNameLocation((Node)element);
                String message3 = "View requires API level " + api3.minString() + " (current min is %1$s): `<" + tag + ">`";
                this.report(context, UNSUPPORTED, element, location, message3, api3, localMinSdk);
            }
        }
    }

    private final void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            ApiConstraint minSdk;
            Element e;
            if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)"item", (Object)curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height")) continue;
            ApiConstraint.SdkApiConstraint attributeApiLevel = API_23;
            if (this.getMinSdk((Context)context) == null) {
                return;
            }
            if (minSdk.isAtLeast((ApiConstraint)attributeApiLevel) || ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), (ApiConstraint)attributeApiLevel) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast((ApiConstraint)attributeApiLevel)) continue;
            String[] stringArray = new String[]{"width", "height"};
            for (String attributeName : stringArray) {
                Attr attribute;
                if (e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName) == null) continue;
                Location location = context.getLocation((Node)attribute);
                String message2 = "Attribute `" + attribute.getLocalName() + "` is only used in API level " + attributeApiLevel.minString() + " and higher (current min is %1$s)";
                this.report(context, UNUSED, attribute, location, message2, (ApiConstraint)attributeApiLevel, minSdk);
            }
        }
    }

    private final void checkElement(XmlContext context, Element element, String tag, ApiConstraint api2, String gradleVersion, Issue issue) {
        String realTag = tag;
        if (Intrinsics.areEqual((Object)realTag, (Object)element.getTagName())) {
            ApiConstraint apiConstraint = this.getMinSdk((Context)context);
            if (apiConstraint == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            if (!(minSdk.isAtLeast(api2) || ApiDetectorKt.access$isAtLeast(context.getFolderVersion(), api2) || ApiDetector.Companion.getLocalMinSdk(element).isAtLeast(api2) || ApiDetector.Companion.featureProvidedByGradle(context, gradleVersion))) {
                Location location = context.getNameLocation((Node)element);
                if (Intrinsics.areEqual((Object)"drawable", (Object)realTag)) {
                    Attr attr = element.getAttributeNode("class");
                    if (attr == null) {
                        return;
                    }
                    Attr attribute = attr;
                    location = context.getLocation((Node)attribute);
                    realTag = "class";
                }
                String message2 = null;
                if (issue == UNSUPPORTED) {
                    message2 = "`<" + realTag + ">` requires API level " + api2.minString() + " (current min is %1$s)";
                    if (gradleVersion != null) {
                        message2 = message2 + " or building with Android Gradle plugin " + gradleVersion + " or higher";
                    } else if (StringsKt.contains$default((CharSequence)realTag, (CharSequence)".", (boolean)false, (int)2, null)) {
                        message2 = "Custom drawables requires API level " + api2.minString() + " (current min is %1$s)";
                    }
                } else {
                    boolean bl;
                    boolean bl2 = bl = issue == UNUSED;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        Issue issue2 = issue;
                        throw new AssertionError(issue2);
                    }
                    message2 = "`<" + realTag + ">` is only used in API level " + api2.minString() + " and higher (current min is %1$s)";
                }
                this.report(context, issue, element, location, message2, api2, minSdk);
            }
        }
    }

    private final ApiConstraint getMinSdk(Context context) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return !project.isAndroidProject() ? null : project.getMinSdkVersions();
    }

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[6];
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.oldName(), (String)"REQUIRES_API_ANNOTATION.oldName()");
        Intrinsics.checkNotNullExpressionValue((Object)VersionChecks.REQUIRES_API_ANNOTATION.newName(), (String)"REQUIRES_API_ANNOTATION.newName()");
        objectArray[2] = "androidx.annotation.RequiresExtension";
        objectArray[3] = ANDROIDX_SDK_SUPPRESS_ANNOTATION;
        objectArray[4] = "android.annotation.TargetApi";
        objectArray[5] = ROBO_ELECTRIC_CONFIG_ANNOTATION;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Issue issue;
        Object object;
        ApiConstraint apiConstraint;
        PsiMember member;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMember psiMember = member = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
        if (!VersionChecks.Companion.isRequiresApiAnnotation(annotationInfo.getQualifiedName()) || usageInfo.getAnnotations().size() == 1) {
            ApiConstraint.SdkApiConstraint sdkApiConstraint = Companion.getApiLevel(context, annotation, annotationInfo.getQualifiedName());
            if (sdkApiConstraint == null) {
                return;
            }
            apiConstraint = (ApiConstraint)sdkApiConstraint;
        } else {
            if (usageInfo.getType() != AnnotationUsageType.DEFINITION && usageInfo.anyCloser((Function1)visitAnnotationUsage.api.1.INSTANCE)) {
                return;
            }
            ApiConstraint.SdkApiConstraint constraint = null;
            PsiElement target2 = annotationInfo.getAnnotated();
            Iterable $this$forEach$iv = usageInfo.getAnnotations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiConstraint.SdkApiConstraint apiLevel;
                AnnotationInfo info = (AnnotationInfo)element$iv;
                boolean bl = false;
                String qualifiedName = info.getQualifiedName();
                if (info.getAnnotated() != target2 || !VersionChecks.Companion.isRequiresApiAnnotation(qualifiedName) || (apiLevel = Companion.getApiLevel(context, info.getAnnotation(), qualifiedName)) == null) continue;
                if (constraint != null) {
                    if (ApiConstraint.findSdk$default((ApiConstraint)((ApiConstraint)constraint), (int)apiLevel.getSdkId(), (boolean)false, (int)2, null) != null) continue;
                    constraint = ApiConstraint.Companion.maxNullable((ApiConstraint)constraint, (ApiConstraint)apiLevel, false);
                    continue;
                }
                constraint = apiLevel;
            }
            apiConstraint = (ApiConstraint)constraint;
            if (apiConstraint == null) {
                return;
            }
        }
        ApiConstraint api2 = apiConstraint;
        String string = annotation.getQualifiedName();
        if (string == null) {
            return;
        }
        String qualifiedName = string;
        ApiConstraint apiConstraint2 = this.getMinSdk((Context)context);
        if (apiConstraint2 == null) {
            return;
        }
        ApiConstraint minSdk = apiConstraint2;
        JavaEvaluator evaluator = context.getEvaluator();
        if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
            if (api2.getSdk() != 0) {
                return;
            }
            LintFix fix = this.fix().replace().all().with("").range(context.getLocation((UElement)annotation)).name("Delete @" + StringsKt.substringAfterLast$default((String)qualifiedName, (char)'.', null, (int)2, null)).build();
            UElement uElement = element.getUastParent();
            Pair pair = VersionChecks.Companion.getTargetApiAnnotation$default((VersionChecks.Companion)VersionChecks.Companion, (JavaEvaluator)evaluator, (UElement)(uElement != null ? uElement.getUastParent() : null), null, (int)4, null);
            UAnnotation targetAnnotation = (UAnnotation)pair.component1();
            ApiConstraint target3 = (ApiConstraint)pair.component2();
            if (target3 != null && !api2.isAtLeast(target3)) {
                Object object2 = targetAnnotation;
                String outerAnnotation = "@" + (object2 != null && (object2 = object2.getQualifiedName()) != null ? StringsKt.substringAfterLast$default((String)object2, (char)'.', null, (int)2, null) : null) + "(" + target3.minString() + ")";
                String message2 = "Unnecessary; SDK_INT is always >= " + target3.minString() + " from outer annotation (`" + outerAnnotation + "`)";
                context.report(new Incident(OBSOLETE_SDK, message2, context.getLocation((UElement)annotation), (Object)annotation, fix));
            } else {
                String message3 = "Unnecessary; SDK_INT is always >= " + api2.minString();
                context.report(new Incident(OBSOLETE_SDK, message3, context.getLocation((UElement)annotation), (Object)annotation, fix), Constraints.minSdkAtLeast((int)api2.min()));
            }
            return;
        }
        if (!VersionChecks.Companion.isRequiresApiAnnotation(qualifiedName)) {
            return;
        }
        Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(context, api2, element, minSdk);
        boolean suppressed = (Boolean)pair.component1();
        ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
        if (suppressed) {
            return;
        }
        minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
        Pair pair2 = VersionChecks.Companion.getTargetApiAnnotation$default((VersionChecks.Companion)VersionChecks.Companion, (JavaEvaluator)evaluator, (UElement)element, null, (int)4, null);
        UAnnotation targetAnnotation = (UAnnotation)pair2.component1();
        ApiConstraint target4 = (ApiConstraint)pair2.component2();
        if (targetAnnotation != null && ApiDetector.isSurroundedByHigherTargetAnnotation$default(this, evaluator, targetAnnotation, api2, null, 8, null)) {
            return;
        }
        Location location = null;
        Object fqcn = null;
        if (element instanceof UCallExpression && !Intrinsics.areEqual((Object)((UCallExpression)element).getKind(), (Object)UastCallKind.METHOD_CALL) && ((UCallExpression)element).getClassReference() != null) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)element).getClassReference();
            Intrinsics.checkNotNull((Object)uReferenceExpression);
            UReferenceExpression classReference = uReferenceExpression;
            location = context.getRangeLocation(element, 0, (UElement)classReference, 0);
            String string2 = classReference.getResolvedName();
            if (string2 == null) {
                PsiMember psiMember2 = member;
                string2 = psiMember2 != null ? psiMember2.getName() : null;
                if (string2 == null) {
                    string2 = "";
                }
            }
            fqcn = string2;
        } else {
            location = context.getNameLocation(element);
            Object object3 = member;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "";
            }
            fqcn = object3;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()]) {
            case 6: {
                object = "Extending " + (String)fqcn;
                break;
            }
            case 4: 
            case 5: {
                object = "Class";
                break;
            }
            case 8: 
            case 9: {
                object = "Method";
                break;
            }
            case 3: 
            case 10: {
                object = "Field";
                break;
            }
            default: {
                object = "Call";
            }
        }
        Object type = object;
        PsiElement field = usageInfo.getReferenced();
        if (field instanceof PsiField && Lint.isInlined((PsiField)((PsiField)field), (JavaEvaluator)context.getEvaluator())) {
            JavaEvaluator javaEvaluator = context.getEvaluator();
            PsiField psiField = (PsiField)field;
            String string3 = ((PsiField)field).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"field.name");
            Object object4 = ((PsiField)field).getContainingClass();
            if (object4 == null || (object4 = object4.getQualifiedName()) == null) {
                object4 = "";
            }
            if (Companion.isBenignConstantUsage(javaEvaluator, psiField, element, string3, (String)object4)) {
                return;
            }
            issue = INLINED;
        } else {
            issue = UNSUPPORTED;
        }
        Issue issue2 = issue;
        ApiVisitor.report$default(new ApiVisitor(context), issue2, element, location, (String)type, (String)fqcn, api2, minSdk, null, null, null, null, null, null, 8064, null);
    }

    private final boolean isSurroundedByHigherTargetAnnotation(JavaEvaluator evaluator, UAnnotation annotation, ApiConstraint atLeast, Function1<? super String, Boolean> isApiLevelAnnotation) {
        UAnnotation uAnnotation = annotation;
        if (uAnnotation == null) {
            return false;
        }
        UAnnotation curr = uAnnotation;
        while (true) {
            UElement uElement = curr.getUastParent();
            Pair pair = VersionChecks.Companion.getTargetApiAnnotation(evaluator, (UElement)(uElement != null ? uElement.getUastParent() : null), isApiLevelAnnotation);
            UAnnotation outer = (UAnnotation)pair.component1();
            ApiConstraint target2 = (ApiConstraint)pair.component2();
            if (target2 != null && target2.isAtLeast(atLeast)) {
                return true;
            }
            if (outer != null) continue;
            return false;
        }
    }

    static /* synthetic */ boolean isSurroundedByHigherTargetAnnotation$default(ApiDetector apiDetector, JavaEvaluator javaEvaluator, UAnnotation uAnnotation, ApiConstraint apiConstraint, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                @NotNull
                public final Boolean invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                }
            };
        }
        return apiDetector.isSurroundedByHigherTargetAnnotation(javaEvaluator, uAnnotation, apiConstraint, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.apiDatabase == null || context.isTestSource() && !context.getDriver().getCheckTestSources()) {
            return null;
        }
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return project.isAndroidProject() ? (UElementHandler)new ApiVisitor(context) : null;
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{USimpleNameReferenceExpression.class, ULocalVariable.class, UTryExpression.class, UBinaryExpressionWithType.class, UBinaryExpression.class, UUnaryExpression.class, UCallExpression.class, UClass.class, UMethod.class, UForEachExpression.class, UClassLiteralExpression.class, USwitchExpression.class, UCallableReferenceExpression.class, UArrayAccessExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Desugaring desugaring;
        Desugaring desugaring2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Project mainProject = context.getMainProject();
        if (!mainProject.isAndroidProject()) {
            return false;
        }
        ApiConstraint mainMinSdk = mainProject.getMinSdkVersions();
        ApiConstraint apiConstraint = LintMap.getApiConstraint$default((LintMap)map, (String)KEY_REQUIRES_API, null, (int)2, null);
        if (apiConstraint == null) {
            return false;
        }
        ApiConstraint requires = apiConstraint;
        if (mainMinSdk.isAtLeast(requires)) {
            return false;
        }
        Integer n = map.getInt(KEY_DESUGAR, null);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            desugaring2 = Desugaring.Companion.fromConstant(it);
        } else {
            desugaring2 = desugaring = null;
        }
        if (desugaring == null || desugaring == Desugaring.JAVA_8_LIBRARY) {
            if (mainProject.isDesugaring(Desugaring.JAVA_8_LIBRARY)) {
                String owner;
                String string = owner = map.getString(KEY_OWNER, null);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    String name = LintMap.getString$default((LintMap)map, (String)KEY_NAME, null, (int)2, null);
                    if (this.isLibraryDesugared(mainProject, owner, name)) {
                        return false;
                    }
                }
            }
        } else if (mainProject.isDesugaring(desugaring)) {
            return false;
        }
        ApiConstraint apiConstraint2 = LintMap.getApiConstraint$default((LintMap)map, (String)KEY_MIN_API, null, (int)2, null);
        if (apiConstraint2 == null) {
            return false;
        }
        ApiConstraint target2 = apiConstraint2;
        ApiConstraint maxMinSdk = !target2.isEmpty() ? ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)target2, (ApiConstraint)mainMinSdk, (boolean)false, (int)4, null) : mainMinSdk;
        Object object = maxMinSdk.findSdk(((ApiConstraint.SdkApiConstraint)CollectionsKt.first((List)requires.getConstraints())).getSdk(), true);
        if (object == null || (object = object.minString()) == null) {
            object = "0";
        }
        Object minSdk = object;
        String string = LintMap.getString$default((LintMap)map, (String)KEY_MESSAGE, null, (int)2, null);
        if (string == null) {
            return false;
        }
        String formatString = string;
        Object[] objectArray = new Object[]{minSdk};
        String string2 = String.format(formatString, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        incident.setMessage(string2);
        return true;
    }

    private final boolean isLibraryDesugared(Context context, String owner, String name) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return this.isLibraryDesugared(project, owner, name);
    }

    private final boolean isLibraryDesugared(Project project, String owner, String name) {
        return owner != null && (StringsKt.startsWith$default((String)owner, (String)"java/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null)) && project.isDesugaring(Desugaring.JAVA_8_LIBRARY) && LibraryDesugaringKt.isApiDesugared(project, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), name);
    }

    private final void report(XmlContext context, Issue issue, Node scope, Location location, String message2, ApiConstraint api2, ApiConstraint minSdk) {
        boolean bl;
        LintMap lintMap;
        boolean bl2 = StringsKt.contains$default((CharSequence)message2, (CharSequence)"%1$s", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LintFix lintFix = ApiDetector.Companion.apiLevelFix(api2, minSdk);
        Incident incident = new Incident(issue, (Object)scope, location, "", lintFix);
        LintMap $this$report_u24lambda_u244 = lintMap = this.map();
        boolean bl3 = false;
        $this$report_u24lambda_u244.put(KEY_REQUIRES_API, api2);
        $this$report_u24lambda_u244.put(KEY_MESSAGE, message2);
        boolean bl4 = bl = minSdk != ApiConstraint.UNKNOWN;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Node node = scope;
        Element element = node instanceof Attr ? ((Attr)scope).getOwnerElement() : (node instanceof Element ? (Element)scope : scope.getOwnerDocument().getDocumentElement());
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
        $this$report_u24lambda_u244.put(KEY_MIN_API, ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)ApiDetector.Companion.getLocalMinSdk(element), (boolean)false, (int)4, null));
        LintMap map = lintMap;
        context.report(incident, map);
    }

    private final String getApiLevelString(ApiConstraint requires, JavaContext context) {
        int level = requires.fromInclusive();
        if (requires.getSdk() == 0) {
            if (level > 34 && level > context.getProject().getBuildSdk()) {
                IAndroidTarget iAndroidTarget = context.getProject().getBuildTarget();
                boolean bl = iAndroidTarget != null && (iAndroidTarget = iAndroidTarget.getVersion()) != null ? iAndroidTarget.isPreview() : false;
                if (bl) {
                    String string = SdkVersionInfo.getCodeName((int)level);
                    if (string == null) {
                        string = requires.toString();
                    }
                    return string;
                }
            }
            if (level == 10000) {
                return "CUR_DEVELOPMENT/10000";
            }
        }
        return requires.minString();
    }

    private final void checkObsoleteSdkVersion(JavaContext context, UElement node) {
        UBinaryExpression binary = (UBinaryExpression)UastUtils.getParentOfType((UElement)node, UBinaryExpression.class, (boolean)true);
        if (binary != null) {
            ApiConstraint apiConstraint = this.getMinSdk((Context)context);
            if (apiConstraint == null || (apiConstraint = ApiConstraint.findSdk$default((ApiConstraint)apiConstraint, (int)0, (boolean)false, (int)2, null)) == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            ApiConstraint constraint = VersionChecks.Companion.getVersionCheckConditional$default((VersionChecks.Companion)VersionChecks.Companion, (UBinaryExpression)binary, (LintClient)context.getClient(), (JavaEvaluator)context.getEvaluator(), (Project)context.getProject(), null, (int)16, null);
            if (constraint != null) {
                String string;
                boolean always = constraint.alwaysAtLeast(minSdk);
                boolean never = constraint.not().alwaysAtLeast(minSdk);
                String minString = minSdk.minString();
                ApiConstraint apiConstraint2 = VersionChecks.Companion.getOuterVersionCheckConstraint(context, (UElement)binary);
                ApiConstraint.SdkApiConstraint outer = apiConstraint2 != null ? ApiConstraint.findSdk$default((ApiConstraint)apiConstraint2, (int)constraint.getSdk(), (boolean)false, (int)2, null) : null;
                ApiConstraint both = constraint.and((ApiConstraint)outer);
                if (both.isEmpty()) {
                    PsiElement psiElement = binary.getSourcePsi();
                    String string2 = psiElement != null ? psiElement.getText() : null;
                    if (string2 == null) {
                        string2 = binary.asSourceString();
                    }
                    string = "Unnecessary;` " + string2 + "` is never true here";
                } else if (always) {
                    string = "Unnecessary; SDK_INT is always >= " + minString;
                } else if (never) {
                    string = "Unnecessary; SDK_INT is never < " + minString;
                } else {
                    return;
                }
                String message2 = string;
                Object[] objectArray = new Object[]{KEY_CONDITIONAL, always};
                context.report(new Incident(OBSOLETE_SDK, message2, context.getLocation((UElement)binary), (Object)binary, LintFix.Companion.create().data(objectArray)));
            }
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)KEY_FOLDER_NAME);
        int folderVersion = context.getFolderVersion();
        AndroidVersion minSdkVersion = context.getProject().getMinSdkVersion();
        if (folderVersion > 1 && folderVersion <= minSdkVersion.getFeatureLevel()) {
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfiguration == null) {
                throw new IllegalStateException(((Object)context.file).toString());
            }
            FolderConfiguration folderConfig = folderConfiguration;
            folderConfig.setVersionQualifier(null);
            ResourceFolderType resourceFolderType = context.getResourceFolderType();
            if (resourceFolderType == null) {
                throw new IllegalStateException(((Object)context.file).toString());
            }
            ResourceFolderType resourceFolderType2 = resourceFolderType;
            String newFolderName = folderConfig.getFolderName(resourceFolderType2);
            String message2 = "This folder configuration (`v" + folderVersion + "`) is unnecessary; `minSdkVersion` is " + minSdkVersion.getApiString() + ". Merge all the resources in this folder into `" + newFolderName + "`.";
            Object[] objectArray = new Object[]{KEY_FILE, context.file, KEY_FOLDER_NAME, newFolderName, KEY_REQUIRES_API, minSdkVersion.getApiLevel()};
            context.report(new Incident(OBSOLETE_SDK, message2, Location.Companion.create(context.file), this.fix().data(objectArray)));
        }
    }

    @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(evaluator, scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @Nullable
    public static final ApiConstraint.SdkApiConstraint getApiLevel(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
        return Companion.getApiLevel(context, annotation, qualifiedName);
    }

    @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable UElement scope) {
        return Companion.getTargetApi(scope);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope) {
        return Companion.getTargetApi(evaluator, scope);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        Implementation implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        UNSUPPORTED = Issue.Companion.create$default((Issue.Companion)companion, (String)"NewApi", (String)"Calling new methods on older versions", (String)"\n                This check scans through all the Android API calls in the application and \\\n                warns about any calls that are not available on **all** versions targeted by \\\n                this application (according to its minimum SDK attribute in the manifest).\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n\n                If you are deliberately setting `android:` attributes in style definitions, \\\n                make sure you place this in a `values-v`*NN* folder in order to avoid running \\\n                into runtime conflicts on certain devices where manufacturers have added \\\n                custom attributes whose ids conflict with the new ones on later platforms.\n\n                Similarly, you can use tools:targetApi=\"11\" in an XML file to indicate that \\\n                the element will only be inflated in an adequate context.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        INLINED = Issue.Companion.create$default((Issue.Companion)companion, (String)"InlinedApi", (String)"Using inlined constants on older versions", (String)"\n                This check scans through all the Android API field references in the \\\n                application and flags certain constants, such as static final integers and \\\n                Strings, which were introduced in later versions. These will actually be \\\n                copied into the class files rather than being referenced, which means that \\\n                the value is available even when running on older devices. In some cases \\\n                that's fine, and in other cases it can result in a runtime crash or \\\n                incorrect behavior. It depends on the context, so consider the code carefully \\\n                and decide whether it's safe and can be suppressed or whether the code needs \\\n                to be guarded.\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.RESOURCE_FOLDER_SCOPE};
        implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER), enumSetArray);
        UNUSED = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnusedAttribute", (String)"Attribute unused on older versions", (String)"\n                This check finds attributes set in XML files that were introduced in a version \\\n                newer than the oldest version targeted by your application (with the \\\n                `minSdkVersion` attribute).\n\n                This is not an error; the application will simply ignore the attribute. \\\n                However, if the attribute is important to the appearance or functionality of \\\n                your application, you should consider finding an alternative way to achieve the \\\n                same result with only available attributes, and then you can optionally create \\\n                a copy of the layout in a layout-vNN folder which will be used on API NN or \\\n                higher where you can take advantage of the newer attribute.\n\n                Note: This check does not only apply to attributes. For example, some tags can \\\n                be unused too, such as the new `<tag>` element in layouts introduced in API 21.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        OBSOLETE_SDK = Issue.Companion.create$default((Issue.Companion)companion, (String)"ObsoleteSdkInt", (String)"Obsolete SDK_INT Version Check", (String)"\n                This check flags version checks that are not necessary, because the \\\n                `minSdkVersion` (or surrounding known API level) is already at least as high \\\n                as the version checked for.\n\n                Similarly, it also looks for resources in `-vNN` folders, such as `values-v14` \\\n                where the version qualifier is less than or equal to the `minSdkVersion`, \\\n                where the contents should be merged into the best folder.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\"\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J*\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\"\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0002JJ\u0010+\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00152\b\u00104\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u0002072\u0006\u00101\u001a\u000202H\u0002J*\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010\u00152\u0014\b\u0002\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060<H\u0002J8\u0010=\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0015H\u0002J \u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u0002092\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010@\u001a\u000209H\u0002Jt\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010J\u001a\u0002092\u0006\u0010K\u001a\u0002092\n\b\u0002\u0010L\u001a\u0004\u0018\u00010MH\u0002J\u0086\u0001\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010D\u001a\u00020E2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010J\u001a\u0002092\u0006\u0010?\u001a\u0002092\n\b\u0002\u0010G\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\bJ\u0010\u0010O\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020TH\u0016J \u0010U\u001a\u00020\u000b2\u0006\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0015H\u0002JL\u0010U\u001a\u00020\u000b2\u0006\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u00020\u00152\u0006\u0010V\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010I\u001a\u00020\b2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010W\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010X\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020cH\u0016J\u0010\u0010d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u0010\u0010i\u001a\u00020\u000b2\u0006\u00106\u001a\u00020TH\u0002J\u0010\u0010j\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020kH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$ApiVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/checks/ApiDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "canBeDesugaredLater", "", "owner", "", "name", "checkAnimator", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkArgumentCast", "argument", "Lorg/jetbrains/uast/UExpression;", "parameterType", "Lcom/intellij/psi/PsiClassType;", "checkCast", "node", "Lorg/jetbrains/uast/UElement;", "classType", "interfaceType", "implicit", "checkCatchTypeElement", "statement", "Lorg/jetbrains/uast/UTryExpression;", "typeReference", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "type", "Lcom/intellij/psi/PsiType;", "checkClass", "element", "cls", "Lcom/intellij/psi/PsiClass;", "descriptor", "fqcn", "checkClassReference", "checkClassType", "checkField", "field", "Lcom/intellij/psi/PsiField;", "checkKotlinStdlibAlias", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "aliasClassName", "aliasMethodName", "aliasDesc", "method", "Lcom/intellij/psi/PsiMethod;", "reference", "original", "checkMethodReference", "expression", "Lorg/jetbrains/uast/UReferenceExpression;", "getTargetApi", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "scope", "isApiLevelAnnotation", "Lkotlin/Function1;", "handleKotlinExtensionMethods", "isAtLeast", "minSdk", "api", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "formatString", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "desc", "requires", "min", "desugaring", "Lcom/android/tools/lint/detector/api/Desugaring;", "sig", "visitArrayAccessExpression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitCall", "containingClass", "visitCallExpression", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitForEachExpression", "Lorg/jetbrains/uast/UForEachExpression;", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "visitTryExpression", "visitTypeCastExpression", "visitUnaryExpression", "Lorg/jetbrains/uast/UUnaryExpression;", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$ApiVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,3490:1\n1#2:3491\n1282#3,2:3492\n*S KotlinDebug\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$ApiVisitor\n*L\n2219#1:3492,2\n*E\n"})
    private final class ApiVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public ApiVisitor(JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        public final void report(@NotNull Issue issue, @NotNull UElement node, @NotNull Location location, @NotNull String type, @NotNull String sig, @NotNull ApiConstraint requires, @NotNull ApiConstraint minSdk, @Nullable LintFix fix, @Nullable String owner, @Nullable String name, @Nullable String desc, @Nullable Desugaring desugaring, @Nullable String original) {
            LintFix lintFix;
            String formatString;
            String string;
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
            Intrinsics.checkNotNullParameter((Object)requires, (String)"requires");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            ApiConstraint.SdkApiConstraint sdkApiConstraint = minSdk.firstMissing(requires);
            ApiConstraint missing = sdkApiConstraint != null ? (ApiConstraint)sdkApiConstraint : requires;
            String apiLevel = ApiDetector.this.getApiLevelString(missing, this.context);
            String typeString = StringHelper.usLocaleCapitalize((String)type);
            int sdk = missing.getSdk();
            if (sdk == 0) {
                string = typeString + " requires API level " + apiLevel + " (current min is %1$s): `" + sig + "`";
            } else {
                String sdkString;
                ApiLookup apiLookup = ApiDetector.this.apiDatabase;
                String string2 = apiLookup != null ? apiLookup.getSdkName(sdk) : null;
                if (string2 == null) {
                    string2 = ExtensionSdk.Companion.getSdkExtensionField(sdk, false);
                }
                string = formatString = typeString + " requires version " + apiLevel + " of " + (Character.isDigit((sdkString = string2).charAt(0)) ? "SDK " + sdkString : "the " + sdkString + " SDK") + " (current min is %1$s): `" + sig + "`";
            }
            if (original != null) {
                formatString = formatString + " (called from `" + original + "`)";
            }
            if ((lintFix = fix) == null) {
                lintFix = Companion.apiLevelFix(missing, minSdk);
            }
            this.report(issue, node, location, formatString, lintFix, owner, name, desc, missing, minSdk, desugaring);
        }

        public static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, String string2, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, LintFix lintFix, String string3, String string4, String string5, Desugaring desugaring, String string6, int n, Object object) {
            if ((n & 0x80) != 0) {
                lintFix = null;
            }
            if ((n & 0x100) != 0) {
                string3 = null;
            }
            if ((n & 0x200) != 0) {
                string4 = null;
            }
            if ((n & 0x400) != 0) {
                string5 = null;
            }
            if ((n & 0x800) != 0) {
                desugaring = null;
            }
            if ((n & 0x1000) != 0) {
                string6 = null;
            }
            apiVisitor.report(issue, uElement, location, string, string2, apiConstraint, apiConstraint2, lintFix, string3, string4, string5, desugaring, string6);
        }

        private final void report(Issue issue, UElement node, Location location, String formatString, LintFix fix, String owner, String name, String desc, ApiConstraint requires, ApiConstraint min, Desugaring desugaring) {
            LintMap lintMap;
            if (ApiDetector.this.isLibraryDesugared((Context)this.context, owner, name)) {
                return;
            }
            Incident incident = new Incident(issue, (Object)node, location, "", fix);
            LintMap $this$report_u24lambda_u241 = lintMap = ApiDetector.this.map();
            boolean bl = false;
            $this$report_u24lambda_u241.put(ApiDetector.KEY_REQUIRES_API, requires);
            $this$report_u24lambda_u241.put(ApiDetector.KEY_MIN_API, ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)min, (ApiConstraint)ApiVisitor.getTargetApi$default(this, node, null, 2, null), (boolean)false, (int)4, null));
            $this$report_u24lambda_u241.put(ApiDetector.KEY_MESSAGE, formatString);
            if (owner != null && this.canBeDesugaredLater(owner, name)) {
                $this$report_u24lambda_u241.put(ApiDetector.KEY_OWNER, owner);
                String string = name;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    $this$report_u24lambda_u241.put(ApiDetector.KEY_NAME, it);
                }
            }
            if (desugaring != null) {
                $this$report_u24lambda_u241.put(ApiDetector.KEY_DESUGAR, desugaring.getConstant());
            }
            LintMap map = lintMap;
            this.context.report(incident, map);
        }

        static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, LintFix lintFix, String string2, String string3, String string4, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, Desugaring desugaring, int n, Object object) {
            if ((n & 0x10) != 0) {
                lintFix = null;
            }
            if ((n & 0x20) != 0) {
                string2 = null;
            }
            if ((n & 0x40) != 0) {
                string3 = null;
            }
            if ((n & 0x80) != 0) {
                string4 = null;
            }
            if ((n & 0x400) != 0) {
                desugaring = null;
            }
            apiVisitor.report(issue, uElement, location, string, lintFix, string2, string3, string4, apiConstraint, apiConstraint2, desugaring);
        }

        private final boolean canBeDesugaredLater(String owner, String name) {
            Project project = this.context.isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject();
            return owner != null && (StringsKt.startsWith$default((String)owner, (String)"java/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null)) && !project.isDesugaring(Desugaring.JAVA_8_LIBRARY);
        }

        public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            }
        }

        public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiMethod) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        private final void checkMethodReference(UReferenceExpression expression, PsiMethod method) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName((PsiMethod)method);
            String string2 = evaluator.getMethodDescription(method, false, false);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            ApiConstraint apiConstraint = apiDatabase.getMethodVersions(owner, name, desc);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getMethodVersions(owner, name, desc)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, (UElement)expression, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            String signature = expression.asSourceString();
            Location location = this.context.getLocation((UElement)expression);
            ApiVisitor.report$default(this, UNSUPPORTED, (UElement)expression, location, "Method reference", signature, api2, minSdk, null, owner, name, desc, null, null, 6144, null);
        }

        public void visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            PsiType type;
            UTypeReferenceExpression typeReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isTypeCast((UElement)((UElement)node))) {
                this.visitTypeCastExpression(node);
            } else if (UastExpressionUtils.isInstanceCheck((UElement)((UElement)node)) && (typeReference = node.getTypeReference()) != null && (type = typeReference.getType()) instanceof PsiClassType) {
                this.checkClassReference((UElement)typeReference, (PsiClassType)type);
            }
        }

        private final void visitTypeCastExpression(UBinaryExpressionWithType expression) {
            UExpression operand = expression.getOperand();
            PsiType operandType = operand.getExpressionType();
            PsiType castType = expression.getType();
            if (Intrinsics.areEqual((Object)castType, (Object)operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            UTypeReferenceExpression typeReference = expression.getTypeReference();
            if (typeReference != null && !this.checkClassReference((UElement)typeReference, (PsiClassType)castType)) {
                return;
            }
            this.checkCast((UElement)expression, (PsiClassType)operandType, (PsiClassType)castType);
        }

        private final boolean checkClassReference(UElement node, PsiClassType classType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return true;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(classType);
            if (string == null) {
                return true;
            }
            String expressionOwner = string;
            ApiConstraint apiConstraint = apiDatabase.getClassVersions(expressionOwner);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getClassVersions(expressionOwner)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return true;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return true;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return true;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            Location location = this.context.getLocation(node);
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, "Class", expressionOwner, api2, minSdk, null, expressionOwner, null, null, null, null, 7680, null);
            return false;
        }

        private final void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType) {
            if (Intrinsics.areEqual((Object)classType, (Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String classTypeInternal = evaluator.getQualifiedName(classType);
            String interfaceTypeInternal = evaluator.getQualifiedName(interfaceType);
            this.checkCast(node, classTypeInternal, interfaceTypeInternal, false);
        }

        private final void checkCast(UElement node, String classType, String interfaceType, boolean implicit) {
            if (interfaceType == null || classType == null) {
                return;
            }
            if (ApiLookup.equivalentName(interfaceType, "java/lang/Object")) {
                return;
            }
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            ApiConstraint apiConstraint = apiDatabase.getValidCastVersions(classType, interfaceType);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getValidCast\u2026classType, interfaceType)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (minSdk.isAtLeast(api2)) {
                return;
            }
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            UElement curr = node;
            while (true) {
                Object condition;
                UElement uElement;
                if ((uElement = curr) instanceof UIfExpression) {
                    PsiType type;
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((UIfExpression)curr).getThenExpression()), (boolean)true) && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)curr).getCondition())) instanceof UBinaryExpressionWithType && (type = ((UBinaryExpressionWithType)condition).getType()) instanceof PsiClassType && Intrinsics.areEqual((Object)this.context.getEvaluator().getQualifiedName((PsiClassType)type), (Object)interfaceType)) {
                        return;
                    }
                } else if (uElement instanceof USwitchClauseExpressionWithBody) {
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((USwitchClauseExpressionWithBody)curr).getBody()), (boolean)true)) {
                        condition = ((USwitchClauseExpressionWithBody)curr).getCaseValues().iterator();
                        while (condition.hasNext()) {
                            PsiType type;
                            UExpression uExpression = (UExpression)condition.next();
                            UExpression condition2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                            if (!(condition2 instanceof UBinaryExpressionWithType) || !((type = ((UBinaryExpressionWithType)condition2).getType()) instanceof PsiClassType) || !Intrinsics.areEqual((Object)this.context.getEvaluator().getQualifiedName((PsiClassType)type), (Object)interfaceType)) continue;
                            return;
                        }
                    }
                } else if (uElement instanceof UMethod) break;
                if (curr.getUastParent() == null) break;
            }
            UElement locationNode = node;
            boolean implicitCast = implicit;
            if (Intrinsics.areEqual((Object)interfaceType, (Object)"java.lang.AutoCloseable") || Intrinsics.areEqual((Object)interfaceType, (Object)"java.io.Closeable")) {
                UElement selector;
                UElement uElement = node.getUastParent();
                Object object = selector = uElement != null ? UastLintUtilsKt.findSelector((UElement)uElement) : null;
                if (selector instanceof UCallExpression) {
                    UIdentifier uIdentifier = ((UCallExpression)selector).getMethodIdentifier();
                    if (Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)"use")) {
                        implicitCast = true;
                        UIdentifier uIdentifier2 = ((UCallExpression)selector).getMethodIdentifier();
                        locationNode = uIdentifier2 != null ? (UElement)uIdentifier2 : selector;
                    }
                }
            }
            String castType = implicitCast ? "Implicit cast" : "Cast";
            Location location = this.context.getLocation(locationNode);
            String message2 = null;
            String to = StringsKt.substringAfterLast$default((String)interfaceType, (char)'.', null, (int)2, null);
            String from = StringsKt.substringAfterLast$default((String)classType, (char)'.', null, (int)2, null);
            message2 = Intrinsics.areEqual((Object)interfaceType, (Object)classType) ? castType + " to `" + to + "` requires API level " + api2.minString() + " (current min is %1$s)" : castType + " from `" + from + "` to `" + to + "` requires API level " + api2.minString() + " (current min is %1$s)";
            ApiVisitor.report$default(this, UNSUPPORTED, locationNode, location, message2, Companion.apiLevelFix(api2, minSdk), classType, null, null, api2, minSdk, null, 1216, null);
        }

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiClass containingClass = node.getJavaPsi().getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !this.context.getProject().isDesugaring(Desugaring.INTERFACE_METHODS)) {
                PsiModifierList psiModifierList = node.getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"node.modifierList");
                PsiModifierList methodModifierList = psiModifierList;
                if (methodModifierList.hasExplicitModifier("default") || methodModifierList.hasExplicitModifier("static")) {
                    ApiConstraint.SdkApiConstraint api2 = API_24;
                    ApiConstraint apiConstraint = ApiDetector.this.getMinSdk((Context)this.context);
                    if (apiConstraint == null) {
                        return;
                    }
                    ApiConstraint minSdk = apiConstraint;
                    if (!Companion.isSuppressed(this.context, (ApiConstraint)api2, (UElement)node, minSdk)) {
                        Location location = this.context.getLocation(node);
                        String desc = methodModifierList.hasExplicitModifier("default") ? "Default method" : "Static interface method";
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, desc, containingClass.getName() + "#" + node.getName(), (ApiConstraint)api2, minSdk, null, containingClass.getQualifiedName(), null, null, Desugaring.INTERFACE_METHODS, null, 5632, null);
                    }
                }
            }
        }

        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.isAnnotationType() && !this.context.getProject().isDesugaring(Desugaring.TYPE_ANNOTATIONS)) {
                JavaEvaluator evaluator = this.context.getEvaluator();
                for (UAnnotation annotation : JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)node), (boolean)false, null, (int)4, null)) {
                    ApiConstraint minSdk;
                    String name = annotation.getQualifiedName();
                    if (!Intrinsics.areEqual((Object)"java.lang.annotation.Repeatable", (Object)name)) continue;
                    ApiConstraint.SdkApiConstraint api2 = API_24;
                    if (ApiDetector.this.getMinSdk((Context)this.context) == null) {
                        return;
                    }
                    if (Companion.isSuppressed(this.context, (ApiConstraint)api2, (UElement)node, minSdk)) continue;
                    Location location = this.context.getLocation((UElement)annotation);
                    ApiConstraint min = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)ApiVisitor.getTargetApi$default(this, (UElement)node, null, 2, null), (boolean)false, (int)4, null);
                    Issue issue = UNSUPPORTED;
                    LintFix lintFix = Companion.apiLevelFix((ApiConstraint)api2, min);
                    Incident incident = new Incident(issue, (Object)annotation, location, "", lintFix);
                    LintFix $this$visitClass_u24lambda_u242 = lintFix = ApiDetector.this.map();
                    boolean bl = false;
                    $this$visitClass_u24lambda_u242.put(ApiDetector.KEY_REQUIRES_API, (ApiConstraint)api2);
                    $this$visitClass_u24lambda_u242.put(ApiDetector.KEY_MIN_API, min);
                    $this$visitClass_u24lambda_u242.put(ApiDetector.KEY_MESSAGE, "Repeatable annotation requires API level " + api2.minString() + " (current min is %1$s)");
                    $this$visitClass_u24lambda_u242.put(ApiDetector.KEY_DESUGAR, Desugaring.TYPE_ANNOTATIONS.getConstant());
                    LintFix map = lintFix;
                    this.context.report(incident, (LintMap)map);
                }
            }
            for (UTypeReferenceExpression typeReferenceExpression : node.getUastSuperTypes()) {
                PsiClass cls;
                PsiType type = typeReferenceExpression.getType();
                if (!(type instanceof PsiClassType) || (cls = ((PsiClassType)type).resolve()) == null) continue;
                this.checkClass((UElement)typeReferenceExpression, cls);
            }
        }

        public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiType type = node.getType();
            if (type instanceof PsiClassType) {
                UExpression lhs = node.getExpression();
                UExpression uExpression = lhs;
                if (uExpression == null) {
                    uExpression = (UExpression)node;
                }
                UExpression locationElement = uExpression;
                this.checkClassType((UElement)locationElement, (PsiClassType)type, null);
            }
        }

        private final void checkClassType(UElement element, PsiClassType classType, String descriptor) {
            String owner = this.context.getEvaluator().getQualifiedName(classType);
            String string = classType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classType.canonicalText");
            String fqcn = string;
            if (owner != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, PsiClass cls) {
            String string = this.context.getEvaluator().getQualifiedName(cls);
            if (string == null) {
                return;
            }
            String owner = string;
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, null, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, String descriptor, String owner, String fqcn) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            ApiConstraint apiConstraint = apiDatabase.getClassVersions(owner);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getClassVersions(owner)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, element, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            if (UastUtils.getParentOfType$default((UElement)element, UAnnotation.class, (boolean)false, (int)2, null) != null) {
                return;
            }
            Location location = this.context.getNameLocation(element);
            String string = descriptor;
            if (string == null) {
                string = "Class";
            }
            String desc = string;
            ApiVisitor.report$default(this, UNSUPPORTED, element, location, desc, fqcn, api2, minSdk, null, owner, null, null, null, null, 7680, null);
        }

        public void visitForEachExpression(@NotNull UForEachExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            UExpression value = node.getIteratedValue();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiType type = value.getExpressionType();
            if (type instanceof PsiClassType) {
                PsiClass containingClass;
                PsiElement keySet;
                String string = evaluator.getQualifiedName((PsiClassType)type);
                if (string == null) {
                    return;
                }
                String expressionOwner = string;
                ApiConstraint apiConstraint = apiDatabase.getClassVersions(expressionOwner);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getClassVersions(expressionOwner)");
                ApiConstraint api2 = apiConstraint;
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint2;
                Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, (UElement)node, minSdk);
                boolean suppressed = (Boolean)pair.component1();
                ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
                if (suppressed) {
                    return;
                }
                minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
                Location location = this.context.getLocation((UElement)value);
                String message2 = "The type of the for loop iterated value is " + ((PsiClassType)type).getCanonicalText() + ", which requires API level " + api2.minString() + " (current min is %1$s)";
                if (value instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)"keySet", (Object)((UQualifiedReferenceExpression)value).getResolvedName()) && (keySet = ((UQualifiedReferenceExpression)value).resolve()) instanceof PsiMethod && (containingClass = ((PsiMethod)keySet).getContainingClass()) != null && Intrinsics.areEqual((Object)"java.util.concurrent.ConcurrentHashMap", (Object)containingClass.getQualifiedName())) {
                    message2 = message2 + "; to work around this, add an explicit cast to `(Map)` before the `keySet` call.";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, message2, Companion.apiLevelFix(api2, minSdk), expressionOwner, null, null, api2, minSdk, null, 1216, null);
            }
        }

        public void visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolve();
            if (method != null) {
                this.visitCall(method, node, (UElement)node);
            }
        }

        private final void visitCall(PsiMethod method, UCallExpression call, UElement reference) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList parameterList = psiParameterList;
            if (parameterList.getParametersCount() > 0) {
                PsiParameter[] psiParameterArray = parameterList.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"parameterList.parameters");
                PsiParameter[] parameters = psiParameterArray;
                int n = parameters.length;
                for (int i = 0; i < n; ++i) {
                    PsiClassType elementType;
                    PsiType psiType;
                    UExpression argument;
                    PsiType parameterType;
                    Intrinsics.checkNotNullExpressionValue((Object)parameters[i].getType(), (String)"parameters[i].type");
                    if (parameterType instanceof PsiClassType) {
                        if (call.getArgumentForParameter(i) == null) continue;
                        this.checkArgumentCast(argument, (PsiClassType)parameterType);
                        continue;
                    }
                    if (!(parameterType instanceof PsiEllipsisType) || call.getArgumentForParameter(i) == null || ((psiType = ((PsiEllipsisType)parameterType).getComponentType()) instanceof PsiClassType ? (PsiClassType)psiType : null) == null) continue;
                    elementType = elementType;
                    if (argument instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)argument).getKind(), (Object)UastSpecialExpressionKind.VARARGS)) {
                        for (UExpression expression : ((UExpressionList)argument).getExpressions()) {
                            this.checkArgumentCast(expression, elementType);
                        }
                        continue;
                    }
                    this.checkArgumentCast(argument, elementType);
                }
            }
            if (!(method instanceof PsiCompiledElement)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            String name = Lint.getInternalMethodName((PsiMethod)method);
            if (!apiDatabase.containsClass(owner)) {
                this.handleKotlinExtensionMethods(name, owner, call, evaluator, method, reference);
                return;
            }
            String string2 = evaluator.getMethodDescription(method, false, false);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            ApiVisitor.visitCall$default(this, method, call, reference, containingClass, owner, name, desc, null, 128, null);
        }

        private final void checkArgumentCast(UExpression argument, PsiClassType parameterType) {
            PsiType argumentType = argument.getExpressionType();
            if (argumentType == null || Intrinsics.areEqual((Object)parameterType, (Object)argumentType) || !(argumentType instanceof PsiClassType) || Intrinsics.areEqual((Object)parameterType.rawType(), (Object)((PsiClassType)argumentType).rawType())) {
                return;
            }
            this.checkCast((UElement)argument, (PsiClassType)argumentType, parameterType);
        }

        private final void visitCall(PsiMethod method, UCallExpression call, UElement reference, PsiClass containingClass, String owner, String name, String desc, String original) {
            Location location;
            UExpression receiver;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (ApiLookup.startsWithEquivalentPrefix(owner, "java/text/SimpleDateFormat") && Intrinsics.areEqual((Object)name, (Object)"<init>") && !Intrinsics.areEqual((Object)desc, (Object)"()V")) {
                ApiConstraint apiConstraint = ApiDetector.this.getMinSdk((Context)this.context);
                if (apiConstraint == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint;
                Companion.checkSimpleDateFormat(this.context, call, minSdk);
            } else if (Intrinsics.areEqual((Object)name, (Object)"loadAnimator") && Intrinsics.areEqual((Object)owner, (Object)"android.animation.AnimatorInflater") && Intrinsics.areEqual((Object)desc, (Object)"(Landroid.content.Context;I)")) {
                this.checkAnimator(this.context, call);
            }
            ApiConstraint apiConstraint = apiDatabase.getMethodVersions(owner, name, desc);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getMethodVersions(owner, name, desc)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (minSdk.isAtLeast(api2)) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            UExpression uExpression = receiver = UastExpressionUtils.isMethodCall((UElement)((UElement)call)) ? call.getReceiver() : null;
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                if (receiver != null && !(receiver instanceof UThisExpression) && !(receiver instanceof PsiSuperExpression)) {
                    PsiClassType containingType;
                    List inheritanceChain;
                    PsiType receiverType = receiver.getExpressionType();
                    if (receiverType instanceof PsiClassType && (inheritanceChain = Companion.getInheritanceChain((PsiClassType)receiverType, containingType = this.context.getEvaluator().getClassType(containingClass))) != null) {
                        for (PsiClassType type : inheritanceChain) {
                            ApiConstraint specificApi;
                            String expressionOwner = evaluator.getQualifiedName(type);
                            if (expressionOwner == null || Intrinsics.areEqual((Object)expressionOwner, (Object)owner)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(expressionOwner, name, desc), (String)"apiDatabase.getMethodVer\u2026ressionOwner, name, desc)");
                            if (Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN)) {
                                if (!apiDatabase.isRelevantOwner(expressionOwner)) continue;
                                return;
                            }
                            if (minSdk.isAtLeast(specificApi)) {
                                return;
                            }
                            if (specificApi.isAtLeast(api2)) continue;
                            api2 = specificApi;
                            fqcn = type.getCanonicalText();
                        }
                    }
                } else {
                    UInstanceExpression pte;
                    PsiElement resolved;
                    PsiClass cls = null;
                    PsiType receiverType = call.getReceiverType();
                    if (receiverType instanceof PsiClassType) {
                        cls = ((PsiClassType)receiverType).resolve();
                    }
                    if ((receiver instanceof UThisExpression || receiver instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)receiver).resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        ApiConstraint specificApi;
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            PsiClassType anonymousBaseType;
                            boolean found = false;
                            Intrinsics.checkNotNullExpressionValue((Object)((PsiAnonymousClass)cls).getBaseClassType(), (String)"cls.baseClassType");
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)cls), PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getQualifiedName(cls)) == null || ApiLookup.equivalentName(expressionOwner, "java/lang/Object")) break;
                        Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(expressionOwner, name, desc), (String)"apiDatabase.getMethodVer\u2026ressionOwner, name, desc)");
                        if (Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN)) {
                            if (apiDatabase.isRelevantOwner(expressionOwner)) {
                                break;
                            }
                        } else {
                            if (minSdk.isAtLeast(specificApi)) {
                                return;
                            }
                            if (specificApi.isAtLeast(api2)) break;
                            api2 = specificApi;
                            fqcn = cls.getQualifiedName();
                            break;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, reference, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            if (receiver != null || UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                PsiClass target2 = null;
                if (!method.isConstructor()) {
                    if (receiver != null) {
                        PsiClassType type;
                        type = receiver.getExpressionType();
                        if (type instanceof PsiClassType) {
                            target2 = type.resolve();
                        }
                    } else {
                        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)call));
                        Object object = target2 = uClass != null ? uClass.getJavaPsi() : null;
                    }
                }
                if (target2 != null) {
                    PsiMethod[] psiMethodArray = target2.findMethodsBySignature(method, true);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"target.findMethodsBySignature(method, true)");
                    PsiMethod[] methods = psiMethodArray;
                    if (methods.length > 1) {
                        for (PsiMethod m : methods) {
                            ApiConstraint interfaceRequirement;
                            ApiConstraint methodApi;
                            String methodOwner;
                            PsiClass provider;
                            if (Intrinsics.areEqual((Object)method, (Object)m) || (provider = m.getContainingClass()) == null || (methodOwner = evaluator.getQualifiedName(provider)) == null) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)apiDatabase.getMethodVersions(methodOwner, name, desc), (String)"apiDatabase.getMethodVer\u2026(methodOwner, name, desc)");
                            if (!Intrinsics.areEqual((Object)methodApi, (Object)ApiConstraint.UNKNOWN) && !minSdk.isAtLeast(methodApi)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)(provider.isInterface() ? apiDatabase.getValidCastVersions(owner, methodOwner) : (ApiConstraint)ApiConstraint.UNKNOWN), (String)"if (provider.isInterface\u2026                        }");
                            interfaceRequirement = interfaceRequirement;
                            if (!Intrinsics.areEqual((Object)interfaceRequirement, (Object)ApiConstraint.UNKNOWN) && !minSdk.isAtLeast(interfaceRequirement)) continue;
                            return;
                        }
                    }
                }
                if (receiver instanceof USuperExpression) {
                    PsiMethod containingMethod;
                    UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)call));
                    Object object = containingMethod = uMethod != null ? uMethod.getJavaPsi() : null;
                    if (containingMethod != null && Intrinsics.areEqual((Object)name, (Object)containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                        return;
                    }
                }
            }
            if (DesugaredMethodLookup.Companion.isDesugared(owner, name, desc, this.context.getSourceSetType(), this.context.getProject())) {
                return;
            }
            Desugaring desugaring = null;
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.Throwable") && (Intrinsics.areEqual((Object)name, (Object)"addSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.Throwable;)") || Intrinsics.areEqual((Object)name, (Object)"getSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"()"))) {
                if (this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                    return;
                }
                desugaring = Desugaring.TRY_WITH_RESOURCES;
            }
            String signature = fqcn == null ? name : (Intrinsics.areEqual((Object)"<init>", (Object)name) ? (Lint.isKotlin((PsiElement)reference.getSourcePsi()) ? fqcn + "()" : "new " + fqcn) : fqcn + "#" + name);
            UIdentifier nameIdentifier = call.getMethodIdentifier();
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && call.getClassReference() != null) {
                UElement uElement = (UElement)call;
                UReferenceExpression uReferenceExpression = call.getClassReference();
                Intrinsics.checkNotNull((Object)uReferenceExpression);
                location = this.context.getRangeLocation(uElement, 0, (UElement)uReferenceExpression, 0);
            } else {
                location = nameIdentifier != null ? this.context.getLocation((UElement)nameIdentifier) : this.context.getLocation(reference);
            }
            Location location2 = location;
            this.report(UNSUPPORTED, reference, location2, "Call", signature, api2, minSdk, null, owner, name, desc, desugaring, original);
        }

        static /* synthetic */ void visitCall$default(ApiVisitor apiVisitor, PsiMethod psiMethod, UCallExpression uCallExpression, UElement uElement, PsiClass psiClass, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 0x80) != 0) {
                string4 = null;
            }
            apiVisitor.visitCall(psiMethod, uCallExpression, uElement, psiClass, string, string2, string3, string4);
        }

        private final void handleKotlinExtensionMethods(String name, String owner, UCallExpression call, JavaEvaluator evaluator, PsiMethod method, UElement reference) {
            String desc;
            if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.collections.jdk8.CollectionsJDK8Kt")) {
                if (Intrinsics.areEqual((Object)name, (Object)"getOrDefault")) {
                    this.checkKotlinStdlibAlias(call, evaluator, "java.util.Map", name, "(Ljava/lang/Object;Ljava/lang/Object;)", method, reference, "kotlin.collections.Map#getOrDefault");
                } else if (Intrinsics.areEqual((Object)name, (Object)"remove")) {
                    this.checkKotlinStdlibAlias(call, evaluator, "java.util.Map", name, "(Ljava/lang/Object;Ljava/lang/Object;)", method, reference, "kotlin.collections.Map#remove");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.text.jdk8.RegexExtensionsJDK8Kt") && Intrinsics.areEqual((Object)name, (Object)"get")) {
                String desc2 = evaluator.getMethodDescription(method, false, false);
                if (Intrinsics.areEqual((Object)desc2, (Object)"(Lkotlin.text.MatchGroupCollection;Ljava.lang.String;)")) {
                    this.checkKotlinStdlibAlias(call, evaluator, "java.util.regex.Matcher", "start", "(Ljava/lang/String;)", method, reference, "kotlin.text.MatchGroupCollection#get(String)");
                }
            } else if (Intrinsics.areEqual((Object)owner, (Object)"kotlin.text.MatchNamedGroupCollection") && Intrinsics.areEqual((Object)name, (Object)"get") && Intrinsics.areEqual((Object)(desc = evaluator.getMethodDescription(method, false, false)), (Object)"(Ljava.lang.String;)")) {
                this.checkKotlinStdlibAlias(call, evaluator, "java.util.regex.Matcher", "start", "(Ljava/lang/String;)", method, reference, "kotlin.text.MatchNamedGroupCollection#get");
            }
        }

        private final void checkKotlinStdlibAlias(UCallExpression call, JavaEvaluator evaluator, String aliasClassName, String aliasMethodName, String aliasDesc, PsiMethod method, UElement reference, String original) {
            PsiClass psiClass = evaluator.findClass(aliasClassName);
            if (psiClass == null) {
                return;
            }
            PsiClass matcherClass = psiClass;
            this.visitCall(method, call, reference, matcherClass, aliasClassName, aliasMethodName, aliasDesc, original);
        }

        private final void checkAnimator(JavaContext context, UCallExpression call) {
            UExpression resourceParameter = (UExpression)call.getValueArguments().get(1);
            ResourceReference resourceReference = ResourceReference.Companion.get((UElement)resourceParameter);
            if (resourceReference == null) {
                return;
            }
            ResourceReference resource = resourceReference;
            if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android")) {
                return;
            }
            ApiConstraint.SdkApiConstraint api2 = API_21;
            ApiConstraint apiConstraint = ApiDetector.this.getMinSdk((Context)context);
            if (apiConstraint == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint;
            if (minSdk.isAtLeast((ApiConstraint)api2)) {
                return;
            }
            if (VersionChecks.Companion.isWithinVersionCheckConditional$default((VersionChecks.Companion)VersionChecks.Companion, (JavaContext)context, (UElement)((UElement)call), (ApiConstraint)((ApiConstraint)api2), (boolean)false, (int)8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, (UElement)call, (ApiConstraint)api2)) {
                return;
            }
            LintClient client = context.getClient();
            ResourceRepository resources = context.isGlobalAnalysis() ? client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : client.getResources(context.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
            List items = resources.getResources(ResourceNamespace.TODO(), resource.getType(), resource.getName());
            Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
            Set paths2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)items), (Function1)checkAnimator.paths.1.INSTANCE));
            for (PathString path : paths2) {
                try {
                    XmlPullParser xmlPullParser = client.createXmlPullParser(path);
                    if (xmlPullParser == null) continue;
                    XmlPullParser parser = xmlPullParser;
                    block8: while (true) {
                        int event = parser.next();
                        switch (event) {
                            case 2: {
                                String name;
                                if (parser.getName() == null || !Intrinsics.areEqual((Object)name, (Object)ApiDetector.ATTR_PROPERTY_VALUES_HOLDER)) continue block8;
                                Object object = path.toFile();
                                if (object != null && (object = ((File)object).getParentFile()) != null && (object = ((File)object).getName()) != null) {
                                    FolderConfiguration folderConfiguration;
                                    Object nae = object;
                                    boolean bl = false;
                                    FolderConfiguration folderConfiguration2 = folderConfiguration = FolderConfiguration.getConfigForFolder((String)nae);
                                    if (folderConfiguration2 != null) {
                                        Intrinsics.checkNotNullExpressionValue((Object)folderConfiguration2, (String)"getConfigForFolder(nae)");
                                        FolderConfiguration config = folderConfiguration;
                                        boolean bl2 = false;
                                        VersionQualifier versionQualifier = config.getVersionQualifier();
                                        if (versionQualifier != null && ApiDetectorKt.access$isAtLeast(versionQualifier.getVersion(), (ApiConstraint)api2)) {
                                            return;
                                        }
                                    }
                                }
                                JavaContext.report$default((JavaContext)context, (Issue)UNSUPPORTED, (UElement)((UElement)call), (Location)context.getLocation((UElement)call), (String)("The resource `" + resource.getType() + "." + resource.getName() + "` includes the tag `propertyValuesHolder` which causes crashes on API < " + api2.minString() + ". Consider switching to `AnimatorInflaterCompat.loadAnimator` to safely load the animation."), null, (int)16, null);
                                return;
                            }
                            case 1: {
                                return;
                            }
                        }
                    }
                }
                catch (XmlPullParserException xmlPullParserException) {
                }
                catch (IOException iOException) {
                }
            }
        }

        public void visitLocalVariable(@NotNull ULocalVariable node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression uExpression = node.getUastInitializer();
            if (uExpression == null) {
                return;
            }
            UExpression initializer = uExpression;
            PsiType psiType = initializer.getExpressionType();
            PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            PsiClassType initializerType = psiClassType;
            PsiType interfaceType = node.getType();
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            if (Intrinsics.areEqual((Object)initializerType, (Object)interfaceType)) {
                return;
            }
            this.checkCast((UElement)initializer, initializerType, (PsiClassType)interfaceType);
        }

        public void visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod psiMethod = Lint.resolveOperator$default((UArrayAccessExpression)node, (boolean)false, (int)1, null);
            if (psiMethod == null) {
                return;
            }
            PsiMethod method = psiMethod;
            UCallExpression call = UImplicitCallExpressionKt.asCall((UArrayAccessExpression)node, (PsiMethod)method);
            this.visitCall(method, call, (UElement)node);
        }

        public void visitUnaryExpression(@NotNull UUnaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call = UImplicitCallExpressionKt.asCall((UUnaryExpression)node, (PsiMethod)method);
                this.visitCall(method, call, (UElement)node);
            }
        }

        public void visitBinaryExpression(@NotNull UBinaryExpression node) {
            UastBinaryOperator operator;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call = UImplicitCallExpressionKt.asCall((UBinaryExpression)node, (PsiMethod)method);
                this.visitCall(method, call, (UElement)node);
            }
            if ((operator = node.getOperator()) instanceof UastBinaryOperator.AssignOperator) {
                UExpression rExpression = node.getRightOperand();
                PsiType psiType = rExpression.getExpressionType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType rhsType = psiClassType;
                PsiType interfaceType = node.getLeftOperand().getExpressionType();
                if (!(interfaceType instanceof PsiClassType)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)rhsType, (Object)interfaceType)) {
                    return;
                }
                this.checkCast((UElement)rExpression, rhsType, (PsiClassType)interfaceType);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtLeast(ApiConstraint minSdk, UElement node, ApiConstraint api2) {
            if (minSdk.isAtLeast(api2)) return true;
            ApiConstraint apiConstraint = ApiVisitor.getTargetApi$default(this, node, null, 2, null);
            if (apiConstraint == null) return false;
            boolean bl = apiConstraint.isAtLeast(api2);
            if (!bl) return false;
            return true;
        }

        public void visitTryExpression(@NotNull UTryExpression node) {
            Object message2;
            PsiType localMinSdk;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List resourceList = node.getResourceVariables();
            if (!((Collection)resourceList).isEmpty() && !this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                ApiConstraint.SdkApiConstraint api2 = API_19;
                ApiConstraint apiConstraint = ApiDetector.this.getMinSdk((Context)this.context);
                if (apiConstraint == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint;
                if (!this.isAtLeast(minSdk, (UElement)node, (ApiConstraint)api2)) {
                    Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, (ApiConstraint)api2, (UElement)node, minSdk);
                    boolean suppressed = (Boolean)pair.component1();
                    localMinSdk = (ApiConstraint)pair.component2();
                    if (suppressed) {
                        return;
                    }
                    minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
                    UVariable first = (UVariable)resourceList.get(0);
                    UVariable last = (UVariable)resourceList.get(resourceList.size() - 1);
                    Location location = this.context.getRangeLocation((UDeclaration)first, 0, (UDeclaration)last, 0);
                    message2 = "Try-with-resources requires API level " + api2.minString() + " (current min is %1$s)";
                    ApiVisitor.report$default(this, UNSUPPORTED, (UElement)first, location, (String)message2, null, null, null, null, (ApiConstraint)api2, minSdk, Desugaring.TRY_WITH_RESOURCES, 240, null);
                }
            }
            for (UVariable resource : resourceList) {
                ApiConstraint minSdk;
                ApiLookup api3;
                PsiMethod closeMethod;
                Object object;
                Object object2;
                PsiClassType classType;
                block12: {
                    PsiClass psiClass;
                    localMinSdk = TypeConversionUtil.erasure((PsiType)resource.getType());
                    PsiClassType psiClassType = localMinSdk instanceof PsiClassType ? (PsiClassType)localMinSdk : null;
                    if (psiClassType == null || (classType = psiClassType).resolve() == null) continue;
                    PsiMethod[] psiMethodArray = psiClass.findMethodsByName("close", true);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"psiClass.findMethodsByName(\"close\", true)");
                    Object[] $this$firstOrNull$iv = psiMethodArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        if (!(!it.hasParameters())) continue;
                        object2 = element$iv;
                        break block12;
                    }
                    object2 = null;
                }
                if ((PsiMethod)object2 == null || (object = closeMethod.getContainingClass()) == null || (object = object.getQualifiedName()) == null) continue;
                Object containingClass = object;
                ApiLookup apiLookup = ApiDetector.this.apiDatabase;
                if (apiLookup == null) continue;
                if ((apiLookup = apiLookup.getMethodVersions((String)containingClass, "close", "()")) == null || Intrinsics.areEqual((Object)(api3 = apiLookup), (Object)ApiConstraint.UNKNOWN) || ApiDetector.this.getMinSdk((Context)this.context) == null || minSdk.isAtLeast((ApiConstraint)api3)) continue;
                Pair<Boolean, ApiConstraint> message3 = Companion.getSuppressed(this.context, (ApiConstraint)api3, (UElement)node, minSdk);
                boolean suppressed = (Boolean)message3.component1();
                ApiConstraint localMinSdk2 = (ApiConstraint)message3.component2();
                if (suppressed) continue;
                minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk2, (boolean)false, (int)4, null);
                Intrinsics.checkNotNull((Object)resource, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                Location location = this.context.getLocation((UElement)resource);
                String message4 = "Implicit `" + classType.getName() + ".close()` call from try-with-resources requires API level " + api3.minString() + " (current min is %1$s)";
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)resource, location, message4, Companion.apiLevelFix((ApiConstraint)api3, minSdk), classType.getCanonicalText(), null, null, (ApiConstraint)api3, minSdk, null, 1216, null);
            }
            for (UCatchClause catchClause : node.getCatchClauses()) {
                ApiConstraint minSdk;
                ApiConstraint.SdkApiConstraint required = API_19;
                if (ApiDetector.this.getMinSdk((Context)this.context) == null) {
                    return;
                }
                List typeReferences = catchClause.getTypeReferences();
                if (!minSdk.isAtLeast((ApiConstraint)required) && Companion.isMultiCatchReflectiveOperationException(catchClause)) {
                    Iterator iterator = Companion.getSuppressed(this.context, (ApiConstraint)API_19, (UElement)typeReferences.get(0), minSdk);
                    boolean suppressed = (Boolean)iterator.component1();
                    ApiConstraint localMinSdk3 = (ApiConstraint)iterator.component2();
                    if (suppressed) {
                        return;
                    }
                    minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk3, (boolean)false, (int)4, null);
                    message2 = "Multi-catch with these reflection exceptions requires API level 19 (current min is %1$s) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.";
                    Location location = Companion.getCatchParametersLocation(this.context, catchClause);
                    Issue issue = UNSUPPORTED;
                    Object object = location.getSource();
                    UElement uElement = object instanceof UElement ? (UElement)object : null;
                    if (uElement == null) {
                        uElement = (UElement)node;
                    }
                    UElement uElement2 = uElement;
                    LintFix lintFix = Companion.apiLevelFix((ApiConstraint)required, minSdk);
                    object = minSdk;
                    ApiVisitor.report$default(this, issue, uElement2, location, (String)message2, lintFix, null, null, null, (ApiConstraint)required, (ApiConstraint)object, null, 1248, null);
                    continue;
                }
                for (UTypeReferenceExpression typeReference : typeReferences) {
                    this.checkCatchTypeElement(node, typeReference, typeReference.getType());
                }
            }
        }

        private final void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference, PsiType type) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass resolved = null;
            if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                LintFix lintFix;
                Object[] objectArray;
                Location location;
                String string = this.context.getEvaluator().getQualifiedName(resolved);
                if (string == null) {
                    return;
                }
                String signature = string;
                ApiConstraint apiConstraint = apiDatabase.getClassVersions(signature);
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getClassVersions(signature)");
                ApiConstraint api2 = apiConstraint;
                if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                    return;
                }
                ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
                if (apiConstraint2 == null) {
                    return;
                }
                ApiConstraint minSdk = apiConstraint2;
                if (minSdk.isAtLeast(api2)) {
                    return;
                }
                UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)statement));
                if (containingClass != null) {
                    ApiConstraint target2;
                    ApiConstraint apiConstraint3 = target2 = minSdk.isAtLeast((ApiConstraint)API_19) ? ApiVisitor.getTargetApi$default(this, (UElement)statement, null, 2, null) : this.getTargetApi((UElement)containingClass, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                        @NotNull
                        public final Boolean invoke(@NotNull String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((VersionChecks.Companion)this.receiver).isRequiresApiAnnotation(p0);
                        }
                    }));
                    if (target2 != null && target2.isAtLeast(api2)) {
                        return;
                    }
                }
                if (Companion.isSuppressed(this.context, api2, (UElement)typeReference, minSdk)) {
                    if (!minSdk.isAtLeast((ApiConstraint)API_19)) {
                        location = this.context.getLocation((UElement)typeReference);
                        String fqcn = resolved.getQualifiedName();
                        String apiLevel = ApiDetector.this.getApiLevelString(api2, this.context);
                        String string2 = StringHelper.usLocaleCapitalize((String)"Exception");
                        String string3 = fqcn;
                        if (string3 == null) {
                            string3 = "";
                        }
                        String apiMessage = string2 + " requires API level " + apiLevel + " (current min is %1$s): `" + string3 + "`";
                        String message2 = apiMessage + ", and having a surrounding/preceding version check **does not** help since prior to API level 19, just **loading** the class will cause a crash. Consider marking the surrounding class with `RequiresApi(19)` to ensure that the class is never loaded except when on API 19 or higher.";
                        Object[] objectArray2 = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_REQUIRE_CLASS, true};
                        LintFix fix = ApiDetector.this.fix().data(objectArray2);
                        LintDriver lintDriver = this.context.getDriver();
                        Intrinsics.checkNotNull((Object)typeReference, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                        if (lintDriver.isSuppressed(this.context, UNSUPPORTED, (UElement)typeReference)) {
                            return;
                        }
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)typeReference, location, message2, fix, signature, null, null, (ApiConstraint)API_19, minSdk, null, 1216, null);
                        return;
                    }
                    return;
                }
                location = this.context.getLocation((UElement)typeReference);
                String fqcn = resolved.getQualifiedName();
                if (minSdk.isAtLeast((ApiConstraint)API_19)) {
                    objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api2};
                    lintFix = ApiDetector.this.fix().data(objectArray);
                } else {
                    objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_REQUIRE_CLASS, true};
                    lintFix = ApiDetector.this.fix().data(objectArray);
                }
                LintFix fix = lintFix;
                UElement uElement = (UElement)typeReference;
                String string4 = fqcn;
                if (string4 == null) {
                    string4 = "";
                }
                ApiVisitor.report$default(this, UNSUPPORTED, uElement, location, "Exception", string4, api2, minSdk, fix, signature, null, null, null, null, 7680, null);
            }
        }

        private final ApiConstraint getTargetApi(UElement scope, Function1<? super String, Boolean> isApiLevelAnnotation) {
            return Companion.getTargetApi(this.context.getEvaluator(), scope, isApiLevelAnnotation);
        }

        static /* synthetic */ ApiConstraint getTargetApi$default(ApiVisitor apiVisitor, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    @NotNull
                    public final Boolean invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return apiVisitor.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            PsiType type;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression expression = node.getExpression();
            if (expression != null && (type = expression.getExpressionType()) instanceof PsiClassType) {
                this.checkClassType((UElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkField(UElement node, PsiField field) {
            List conditions;
            UElement parent;
            Issue issue;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            String string = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
            String name = string;
            PsiClass psiClass = field.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(containingClass);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            if (Intrinsics.areEqual((Object)"SDK_INT", (Object)name) && Intrinsics.areEqual((Object)"android.os.Build.VERSION", (Object)owner)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.context, node);
                return;
            }
            ApiConstraint apiConstraint = apiDatabase.getFieldVersions(owner, name);
            Intrinsics.checkNotNullExpressionValue((Object)apiConstraint, (String)"apiDatabase.getFieldVersions(owner, name)");
            ApiConstraint api2 = apiConstraint;
            if (Intrinsics.areEqual((Object)api2, (Object)ApiConstraint.UNKNOWN)) {
                return;
            }
            ApiConstraint apiConstraint2 = ApiDetector.this.getMinSdk((Context)this.context);
            if (apiConstraint2 == null) {
                return;
            }
            ApiConstraint minSdk = apiConstraint2;
            if (this.isAtLeast(minSdk, node, api2)) return;
            Issue issue2 = issue = Lint.isInlined((PsiField)field, (JavaEvaluator)evaluator) ? INLINED : UNSUPPORTED;
            if (Intrinsics.areEqual((Object)issue, (Object)UNSUPPORTED) ? (parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent())) instanceof USwitchClauseExpression && CollectionsKt.contains((Iterable)(conditions = ((USwitchClauseExpression)parent).getCaseValues()), (Object)node) : Intrinsics.areEqual((Object)issue, (Object)INLINED) && Companion.isBenignConstantUsage(evaluator, field, node, name, owner)) {
                return;
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.annotation.ElementType") && (parent = (UDeclaration)UastUtils.getParentOfType((UElement)node, UDeclaration.class, (boolean)true)) instanceof UClass && ((UClass)parent).isAnnotationType()) {
                return;
            }
            Pair<Boolean, ApiConstraint> pair = Companion.getSuppressed(this.context, api2, node, minSdk);
            boolean suppressed = (Boolean)pair.component1();
            ApiConstraint localMinSdk = (ApiConstraint)pair.component2();
            if (suppressed) {
                return;
            }
            minSdk = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)localMinSdk, (boolean)false, (int)4, null);
            UElement parent2 = node.getUastParent();
            if (parent2 instanceof UQualifiedReferenceExpression) {
                Object object;
                UExpression receiver = ((UQualifiedReferenceExpression)parent2).getReceiver();
                Object object2 = receiver.getExpressionType();
                if (object2 == null || (object2 = object2.getCanonicalText()) == null) {
                    UReferenceExpression uReferenceExpression = receiver instanceof UReferenceExpression ? (UReferenceExpression)receiver : null;
                    object2 = uReferenceExpression != null ? UastUtils.getQualifiedName((UReferenceExpression)uReferenceExpression) : null;
                }
                Object object3 = object = object2;
                ApiConstraint apiConstraint3 = object3 != null ? apiDatabase.getFieldVersions((String)object3, name) : (ApiConstraint)ApiConstraint.UNKNOWN;
                Intrinsics.checkNotNullExpressionValue((Object)apiConstraint3, (String)"if (specificOwner != nul\u2026lse ApiConstraint.UNKNOWN");
                ApiConstraint specificApi = apiConstraint3;
                if (!Intrinsics.areEqual((Object)specificApi, (Object)ApiConstraint.UNKNOWN) && object != null) {
                    if (!specificApi.isAtLeast(api2)) {
                        api2 = specificApi;
                        owner = object;
                    }
                    if (this.isAtLeast(minSdk, node, specificApi)) return;
                    if (Companion.isSuppressed(this.context, specificApi, node, minSdk)) {
                        return;
                    }
                } else if (Intrinsics.areEqual((Object)object, (Object)"android.app.TaskInfo") && (specificApi.min() == 28 || specificApi.min() == 29)) {
                    return;
                }
            }
            UElement locationNode = node;
            while (locationNode.getUastParent() instanceof UQualifiedReferenceExpression) {
                UElement uElement = locationNode.getUastParent();
                Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
                if (((UQualifiedReferenceExpression)uElement).getSelector() != locationNode) break;
                UElement uElement2 = locationNode.getUastParent();
                if (uElement2 == null) {
                    uElement2 = node;
                }
                locationNode = uElement2;
            }
            Location location = this.context.getLocation(locationNode);
            String fqcn = ClassContext.Companion.getFqcn(owner) + "#" + name;
            ApiVisitor.report$default(this, issue, node, location, "Field", fqcn, api2, minSdk, null, owner, name, null, null, null, 7168, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001dH\u0002J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020\u001dH\u0002J\u001a\u00102\u001a\u00020\u001c2\u0006\u0010.\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u00105\u001a\u0004\u0018\u00010\u00062\u0006\u0010.\u001a\u00020/2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0004H\u0007J\u0016\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u0010;\u001a\u00020<J\"\u0010=\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010>2\u0006\u0010@\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010?H\u0002JB\u0010=\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010B2\u0006\u0010@\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010?2\u0016\u0010C\u001a\u0012\u0012\u0004\u0012\u00020E0Dj\b\u0012\u0004\u0012\u00020E`F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020KH\u0002J4\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020M2\u0006\u0010+\u001a\u00020\u001dJ4\u0010N\u001a\u0004\u0018\u00010\u001d2\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010M2\u0014\b\u0002\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0SH\u0007J*\u0010N\u001a\u0004\u0018\u00010\u001d2\b\u0010Q\u001a\u0004\u0018\u00010M2\u0014\b\u0002\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0SH\u0007J(\u0010T\u001a\u0004\u0018\u00010\u001d2\b\u0010U\u001a\u0004\u0018\u00010V2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0SH\u0002J \u0010W\u001a\u00020\u001c2\u0006\u0010.\u001a\u0002032\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u001dH\u0002J0\u0010[\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020P2\u0006\u0010\\\u001a\u00020]2\b\u0010^\u001a\u0004\u0018\u00010M2\u0006\u0010_\u001a\u00020\u00042\u0006\u0010`\u001a\u00020\u0004J\u000e\u0010a\u001a\u00020\u001c2\u0006\u0010_\u001a\u00020\u0004J \u0010b\u001a\u00020\u001c2\u0006\u0010.\u001a\u0002032\u0006\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u001cH\u0002J\u000e\u0010e\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<J\u0010\u0010f\u001a\u00020\u001c2\u0006\u0010g\u001a\u00020EH\u0002J&\u0010h\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020M2\u0006\u0010+\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$Companion;", "", "()V", "ANDROIDX_SDK_SUPPRESS_ANNOTATION", "", "API_19", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "API_21", "API_23", "API_24", "API_9", "ATTR_PROPERTY_VALUES_HOLDER", "INLINED", "Lcom/android/tools/lint/detector/api/Issue;", "JAVA_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_CONDITIONAL", "KEY_DESUGAR", "KEY_FILE", "KEY_FOLDER_NAME", "KEY_MESSAGE", "KEY_MIN_API", "KEY_NAME", "KEY_OWNER", "KEY_REQUIRES_API", "KEY_REQUIRE_CLASS", "NOT_SUPPRESSED", "Lkotlin/Pair;", "", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "OBSOLETE_SDK", "REFLECTIVE_OPERATION_EXCEPTION", "REPEATED_API_ANNOTATION_REQUIRES_ALL", "ROBO_ELECTRIC_CONFIG_ANNOTATION", "SDK_SUPPRESS_ANNOTATION", "SUPPRESSED", "TAG_ANIMATED_SELECTOR", "TAG_RIPPLE", "UNSUPPORTED", "UNUSED", "apiLevelFix", "Lcom/android/tools/lint/detector/api/LintFix;", "api", "minSdk", "checkSimpleDateFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "featureProvidedByGradle", "Lcom/android/tools/lint/detector/api/XmlContext;", "minGradleVersionString", "getApiLevel", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "getCatchParametersLocation", "Lcom/android/tools/lint/detector/api/Location;", "catchClause", "Lorg/jetbrains/uast/UCatchClause;", "getInheritanceChain", "", "Lcom/intellij/psi/PsiClassType;", "derivedClass", "baseClass", "", "visited", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiType;", "Lkotlin/collections/HashSet;", "depth", "", "getLocalMinSdk", "element", "Lorg/w3c/dom/Element;", "getSuppressed", "Lorg/jetbrains/uast/UElement;", "getTargetApi", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "scope", "isApiLevelAnnotation", "Lkotlin/Function1;", "getTargetApiForAnnotated", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "isAlreadyWarnedDrawableFile", "attribute", "Lorg/w3c/dom/Attr;", "attributeApiLevel", "isBenignConstantUsage", "field", "Lcom/intellij/psi/PsiField;", "node", "name", "owner", "isBenignUnusedAttribute", "isFrameLayout", "tagName", "defaultValue", "isMultiCatchReflectiveOperationException", "isSubclassOfReflectiveOperationException", "type", "isSuppressed", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiDetector.kt\ncom/android/tools/lint/checks/ApiDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3490:1\n1#2:3491\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFrameLayout(XmlContext context, String tagName, boolean defaultValue) {
            if (StringsKt.indexOf$default((CharSequence)tagName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                SdkInfo sdkInfo = context.getClient().getSdkInfo(context.getProject());
                return sdkInfo.isSubViewOf("FrameLayout", tagName);
            }
            UastParser parser = context.getClient().getUastParser(context.getProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass psiClass = evaluator.findClass(tagName);
            if (psiClass == null) {
                return defaultValue;
            }
            PsiClass psiClass2 = psiClass;
            return evaluator.extendsClass(psiClass2, "android.widget.FrameLayout", false);
        }

        private final LintFix apiLevelFix(ApiConstraint api2, ApiConstraint minSdk) {
            Object[] objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api2, ApiDetector.KEY_MIN_API, minSdk};
            return LintFix.Companion.create().data(objectArray);
        }

        private final boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, ApiConstraint attributeApiLevel) {
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel.min() == 21) {
                Element element = attribute.getOwnerElement();
                while (element != null) {
                    String root = element.getTagName();
                    if (Intrinsics.areEqual((Object)ApiDetector.TAG_RIPPLE, (Object)root) || Intrinsics.areEqual((Object)"vector", (Object)root) || Intrinsics.areEqual((Object)"animated-vector", (Object)root) || Intrinsics.areEqual((Object)ApiDetector.TAG_ANIMATED_SELECTOR, (Object)root)) {
                        return true;
                    }
                    Node parentNode = element.getParentNode();
                    if (!(parentNode instanceof Element)) break;
                    element = (Element)parentNode;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBenignUnusedAttribute(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            String string = name;
            switch (string.hashCode()) {
                case -1959280331: {
                    if (string.equals("labelFor")) return true;
                    return false;
                }
                case 1192948249: {
                    if (string.equals("importantForAutofill")) return true;
                    return false;
                }
                case 1193032953: {
                    if (string.equals("layout_marginVertical")) return true;
                    return false;
                }
                case 1450157576: {
                    if (string.equals("fullBackupContent")) return true;
                    return false;
                }
                case -980998419: {
                    if (string.equals("textIsSelectable")) return true;
                    return false;
                }
                case -5379289: {
                    if (string.equals("roundIcon")) return true;
                    return false;
                }
                case 1662263768: {
                    if (string.equals("requestLegacyExternalStorage")) return true;
                    return false;
                }
                case 495144524: {
                    if (string.equals("foregroundServiceType")) return true;
                    return false;
                }
                case -388883485: {
                    if (string.equals("autofilledHighlight")) return true;
                    return false;
                }
                case 1343645351: {
                    if (string.equals("paddingVertical")) return true;
                    return false;
                }
                case 930483431: {
                    if (string.equals("layout_marginHorizontal")) return true;
                    return false;
                }
                case 2042756918: {
                    if (string.equals("textAlignment")) return true;
                    return false;
                }
                case 58924602: {
                    if (string.equals("autofillHints")) return true;
                    return false;
                }
                case -359890155: {
                    if (!string.equals("paddingHorizontal")) return false;
                    return true;
                }
            }
            return false;
        }

        private final void checkSimpleDateFormat(JavaContext context, UCallExpression call, ApiConstraint minSdk) {
            Object object;
            if (minSdk.isAtLeast((ApiConstraint)API_24)) {
                return;
            }
            List expressions = call.getValueArguments();
            if (expressions.isEmpty()) {
                return;
            }
            UExpression argument = (UExpression)expressions.get(0);
            ArrayList warned = null;
            char checked = '\u0000';
            UExpression uExpression = argument;
            if (uExpression instanceof ULiteralExpression) {
                object = ((ULiteralExpression)argument).getValue();
            } else if (uExpression instanceof UInjectionHost ? (object = ((UInjectionHost)argument).evaluateToString()) == null && (object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument)) == null : (object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument)) == null) {
                return;
            }
            Object constant = object;
            if (constant instanceof String) {
                boolean isEscaped = false;
                int n = ((String)constant).length();
                for (int index2 = 0; index2 < n; ++index2) {
                    LintMap lintMap;
                    int end;
                    ApiConstraint.SdkApiConstraint api2;
                    char c = ((String)constant).charAt(index2);
                    if (c == '\'') {
                        isEscaped = !isEscaped;
                        continue;
                    }
                    if (!((((c == 'L' ? true : c == 'c') ? true : c == 'Y') ? true : c == 'X') ? true : c == 'u') || isEscaped || c == checked || warned != null && ((List)warned).contains(Character.valueOf(c))) continue;
                    ApiConstraint.SdkApiConstraint sdkApiConstraint = api2 = c == 'L' || c == 'c' ? API_9 : API_24;
                    if (minSdk.isAtLeast((ApiConstraint)api2)) {
                        checked = c;
                        continue;
                    }
                    if (VersionChecks.Companion.isWithinVersionCheckConditional$default((VersionChecks.Companion)VersionChecks.Companion, (JavaContext)context, (UElement)((UElement)argument), (ApiConstraint)((ApiConstraint)api2), (boolean)false, (int)8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, (UElement)argument, (ApiConstraint)api2)) {
                        checked = c;
                        continue;
                    }
                    for (end = index2 + 1; end < ((String)constant).length() && ((String)constant).charAt(end) == c; ++end) {
                    }
                    Location location = argument instanceof ULiteralExpression ? context.getRangeLocation((UElement)argument, index2, end - index2) : (argument instanceof UInjectionHost && argument instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)argument).getOperator(), (Object)UastBinaryOperator.PLUS) && ((UPolyadicExpression)argument).getOperands().size() == 1 && CollectionsKt.first((List)((UPolyadicExpression)argument).getOperands()) instanceof ULiteralExpression ? context.getRangeLocation((UElement)((UPolyadicExpression)argument).getOperands().get(0), index2, end - index2) : context.getLocation((UElement)argument));
                    Incident incident = new Incident(UNSUPPORTED, (Object)call, location, "", this.apiLevelFix((ApiConstraint)api2, minSdk));
                    LintMap $this$checkSimpleDateFormat_u24lambda_u240 = lintMap = new LintMap();
                    boolean bl = false;
                    $this$checkSimpleDateFormat_u24lambda_u240.put(ApiDetector.KEY_REQUIRES_API, (ApiConstraint)api2);
                    $this$checkSimpleDateFormat_u24lambda_u240.put(ApiDetector.KEY_MIN_API, minSdk);
                    $this$checkSimpleDateFormat_u24lambda_u240.put(ApiDetector.KEY_MESSAGE, "The pattern character '" + c + "' requires API level " + api2.minString() + " (current min is %1$s) : \"`" + constant + "`\"");
                    LintMap map = lintMap;
                    context.report(incident, map);
                    List list = warned;
                    if (list == null) {
                        ArrayList arrayList;
                        ArrayList it = arrayList = new ArrayList();
                        boolean bl2 = false;
                        warned = it;
                        list = arrayList;
                    }
                    List list2 = list;
                    list2.add(Character.valueOf(c));
                }
            }
        }

        private final ApiConstraint getLocalMinSdk(Element element) {
            Element current = element;
            while (true) {
                String targetApi = current.getAttributeNS("http://schemas.android.com/tools", "targetApi");
                Intrinsics.checkNotNullExpressionValue((Object)targetApi, (String)"targetApi");
                if (((CharSequence)targetApi).length() > 0) {
                    int n;
                    if (Character.isDigit(targetApi.charAt(0))) {
                        int n2;
                        try {
                            n2 = Integer.parseInt(targetApi);
                        }
                        catch (NumberFormatException e) {
                            break;
                        }
                        n = n2;
                    } else {
                        n = SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
                    }
                    int api2 = n;
                    return (ApiConstraint)ApiConstraint.Companion.get$default((ApiConstraint.Companion)ApiConstraint.Companion, (int)api2, (int)0, (int)2, null);
                }
                Node parent = current.getParentNode();
                if (parent == null || parent.getNodeType() != 1) break;
                current = (Element)parent;
            }
            return (ApiConstraint)ApiConstraint.ALL;
        }

        private final boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
            AgpVersion minVersion;
            if (minGradleVersionString == null) {
                return false;
            }
            AgpVersion gradleModelVersion = context.getProject().getGradleModelVersion();
            return gradleModelVersion != null && (minVersion = AgpVersion.Companion.tryParse(minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
        }

        public final boolean isBenignConstantUsage(@NotNull JavaEvaluator evaluator, @NotNull PsiField field, @Nullable UElement node, @NotNull String name, @NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            Intrinsics.checkNotNullParameter((Object)owner, (String)ApiDetector.KEY_OWNER);
            if (ApiLookup.equivalentName(owner, "android.os.Build.VERSION_CODES")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.os.Build.VERSION") && Intrinsics.areEqual((Object)name, (Object)"SDK_INT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.view.ViewGroup.LayoutParams") && Intrinsics.areEqual((Object)name, (Object)"MATCH_PARENT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.widget.AbsListView") && (Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_NONE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_MULTIPLE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_SINGLE"))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.view.Gravity") && (Intrinsics.areEqual((Object)"START", (Object)name) || Intrinsics.areEqual((Object)"END", (Object)name))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.app.PendingIntent") && (Intrinsics.areEqual((Object)"FLAG_MUTABLE", (Object)name) || Intrinsics.areEqual((Object)"FLAG_IMMUTABLE", (Object)name))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android.provider.MediaStore.MediaColumns")) {
                return true;
            }
            if (node == null) {
                return false;
            }
            for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
                if (curr instanceof USwitchClauseExpression) {
                    List caseValues = ((USwitchClauseExpression)curr).getCaseValues();
                    for (UExpression condition : caseValues) {
                        if (!UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false)) continue;
                        return true;
                    }
                    return false;
                }
                if (curr instanceof UIfExpression) {
                    UExpression condition = ((UIfExpression)curr).getCondition();
                    return UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false);
                }
                if (curr instanceof UMethod || curr instanceof UClass) break;
            }
            return false;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass) {
            List<PsiClassType> chain;
            block1: {
                if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                    return CollectionsKt.emptyList();
                }
                List<PsiClassType> list = chain = this.getInheritanceChain(derivedClass, baseClass, new HashSet<PsiType>(), 0);
                if (list == null) break block1;
                CollectionsKt.reverse(list);
            }
            return chain;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass, HashSet<PsiType> visited, int depth) {
            if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                return new ArrayList(depth);
            }
            PsiType[] psiTypeArray = derivedClass.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"derivedClass.superTypes");
            for (PsiType type : psiTypeArray) {
                List<PsiClassType> chain;
                if (!visited.add(type) || !(type instanceof PsiClassType) || (chain = this.getInheritanceChain((PsiClassType)type, baseClass, visited, depth + 1)) == null) continue;
                chain.add(derivedClass);
                return chain;
            }
            return null;
        }

        public final boolean isSuppressed(@NotNull JavaContext context, @NotNull ApiConstraint api2, @NotNull UElement element, @NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)api2, (String)"api");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            if (minSdk.isAtLeast(api2)) {
                return true;
            }
            ApiConstraint target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, context.getEvaluator(), element, null, 4, null);
            if (target2 != null && target2.isAtLeast(api2)) {
                return true;
            }
            LintDriver driver = context.getDriver();
            return driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element) || VersionChecks.Companion.isWithinVersionCheckConditional$default((VersionChecks.Companion)VersionChecks.Companion, (JavaContext)context, (UElement)element, (ApiConstraint)api2, (boolean)false, (int)8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, element, api2);
        }

        @NotNull
        public final Pair<Boolean, ApiConstraint> getSuppressed(@NotNull JavaContext context, @NotNull ApiConstraint api2, @NotNull UElement element, @NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)api2, (String)"api");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)ApiDetector.KEY_MIN_API);
            if (minSdk.isAtLeast(api2)) {
                return SUPPRESSED;
            }
            ApiConstraint target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, context.getEvaluator(), element, null, 4, null);
            if (target2 != null && target2.isAtLeast(api2)) {
                return SUPPRESSED;
            }
            LintDriver driver = context.getDriver();
            if (driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element)) {
                return SUPPRESSED;
            }
            ApiConstraint min = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)minSdk, (ApiConstraint)target2, (boolean)false, (int)4, null);
            ApiConstraint constraint = VersionChecks.Companion.getOuterVersionCheckConstraint(context, element);
            if (constraint != null) {
                boolean suppressed = (constraint = constraint.isEmpty() ? constraint : ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)constraint, (ApiConstraint)min, (boolean)false, (int)4, null)).isAtLeast(api2);
                if (!suppressed && VersionChecks.Companion.isPrecededByVersionCheckExit(context, element, api2)) {
                    return SUPPRESSED;
                }
                ApiConstraint known = ApiConstraint.Companion.max$default((ApiConstraint.Companion)ApiConstraint.Companion, (ApiConstraint)min, (ApiConstraint)constraint, (boolean)false, (int)4, null);
                return new Pair((Object)suppressed, (Object)known);
            }
            if (VersionChecks.Companion.isPrecededByVersionCheckExit(context, element, api2)) {
                return SUPPRESSED;
            }
            if (target2 != null) {
                return new Pair((Object)false, (Object)min);
            }
            return NOT_SUPPRESSED;
        }

        @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            return this.getTargetApi(null, scope, isApiLevelAnnotation);
        }

        public static /* synthetic */ ApiConstraint getTargetApi$default(Companion companion, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    @NotNull
                    public final Boolean invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return companion.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                PsiPackage pkg;
                ApiConstraint targetApi;
                if (current instanceof UAnnotated && (targetApi = this.getTargetApiForAnnotated((UAnnotated)current, isApiLevelAnnotation)) != null) {
                    return targetApi;
                }
                if (!(current instanceof UFile) || evaluator == null) continue;
                PsiElement psiElement = ((UFile)current).getJavaPsi();
                if (psiElement == null) {
                    psiElement = (PsiElement)((UFile)current).getSourcePsi();
                }
                if ((pkg = evaluator.getPackage(psiElement)) == null) break;
                PsiAnnotation[] psiAnnotationArray = pkg.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"pkg.annotations");
                for (PsiAnnotation psiAnnotation : psiAnnotationArray) {
                    UAnnotation annotation;
                    ApiConstraint target2;
                    UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"psiAnnotation");
                    UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                    UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                    if (uAnnotation == null || (target2 = VersionChecks.Companion.getTargetApiForAnnotation(annotation = uAnnotation, isApiLevelAnnotation)) == null) continue;
                    return target2;
                }
                break;
            }
            return null;
        }

        public static /* synthetic */ ApiConstraint getTargetApi$default(Companion companion, JavaEvaluator javaEvaluator, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)VersionChecks.Companion){

                    @NotNull
                    public final Boolean invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((VersionChecks.Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return companion.getTargetApi(javaEvaluator, uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @Nullable
        public final ApiConstraint.SdkApiConstraint getApiLevel(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
            int n;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            String string = qualifiedName;
            if (Intrinsics.areEqual((Object)string, (Object)VersionChecks.REQUIRES_API_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)VersionChecks.REQUIRES_API_ANNOTATION.newName())) {
                int api2 = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "value", -1L);
                n = api2 == -1 ? (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "api", -1L) : api2;
            } else if (Intrinsics.areEqual((Object)string, (Object)"android.annotation.TargetApi")) {
                n = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "value", -1L);
            } else {
                if (Intrinsics.areEqual((Object)string, (Object)"androidx.annotation.RequiresExtension")) {
                    int sdkId = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "extension", -1L);
                    int version = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "version", -1L);
                    if (sdkId != -1 && version != -1) {
                        return ApiConstraint.Companion.get(version, sdkId);
                    }
                    return null;
                }
                if (Intrinsics.areEqual((Object)string, (Object)ApiDetector.ROBO_ELECTRIC_CONFIG_ANNOTATION)) {
                    n = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, ApiDetector.KEY_MIN_API, -1L);
                } else if (Intrinsics.areEqual((Object)string, (Object)ApiDetector.SDK_SUPPRESS_ANNOTATION) ? true : Intrinsics.areEqual((Object)string, (Object)ApiDetector.ANDROIDX_SDK_SUPPRESS_ANNOTATION)) {
                    long fromCodeName = UastLintUtils.Companion.getLongAttribute(context, annotation, "codeName", -1L);
                    n = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "minSdkVersion", fromCodeName);
                } else {
                    return null;
                }
            }
            int api3 = n;
            if (api3 == 10000) {
                UExpression value;
                AndroidVersion version;
                IAndroidTarget iAndroidTarget = context.getProject().getBuildTarget();
                Object object = version = iAndroidTarget != null ? iAndroidTarget.getVersion() : null;
                if (version != null && version.isPreview()) {
                    return ApiConstraint.Companion.get(version.getFeatureLevel(), 0);
                }
                api3 = 35;
                UExpression uExpression = annotation.findDeclaredAttributeValue("value");
                if (uExpression == null) {
                    uExpression = annotation.findDeclaredAttributeValue("api");
                }
                if ((value = uExpression) instanceof PsiReferenceExpression) {
                    String name;
                    String string2 = name = ((PsiReferenceExpression)value).getReferenceName();
                    boolean bl = string2 != null ? string2.length() == 1 : false;
                    if (bl) {
                        api3 = Math.max(api3, SdkVersionInfo.getApiByBuildCode((String)name, (boolean)true));
                    }
                }
            }
            return api3 == -1 ? null : ApiConstraint.Companion.get(api3, 0);
        }

        private final ApiConstraint getTargetApiForAnnotated(UAnnotated annotated, Function1<? super String, Boolean> isApiLevelAnnotation) {
            if (annotated == null) {
                return null;
            }
            ApiConstraint constraint = null;
            for (UAnnotation annotation : annotated.getUAnnotations()) {
                ApiConstraint target2 = VersionChecks.Companion.getTargetApiForAnnotation(annotation, isApiLevelAnnotation);
                if (target2 == null) continue;
                constraint = constraint != null ? ApiConstraint.Companion.max(target2, constraint, false) : target2;
            }
            return constraint;
        }

        @NotNull
        public final Location getCatchParametersLocation(@NotNull JavaContext context, @NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypeReferences();
            if (types.isEmpty()) {
                return Location.NONE;
            }
            Location first = context.getLocation((UElement)types.get(0));
            if (types.size() < 2) {
                return first;
            }
            Location last = context.getLocation((UElement)types.get(types.size() - 1));
            File file = first.getFile();
            Position start = first.getStart();
            Position end = last.getEnd();
            return start == null ? Location.Companion.create(file) : Location.Companion.create(file, start, end).withSource(types.get(0));
        }

        public final boolean isMultiCatchReflectiveOperationException(@NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypes();
            if (types.size() < 2) {
                return false;
            }
            for (PsiType t : types) {
                if (this.isSubclassOfReflectiveOperationException(t)) continue;
                return false;
            }
            return true;
        }

        private final boolean isSubclassOfReflectiveOperationException(PsiType type) {
            PsiType[] psiTypeArray = type.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"type.superTypes");
            for (PsiType t : psiTypeArray) {
                if (!Intrinsics.areEqual((Object)ApiDetector.REFLECTIVE_OPERATION_EXCEPTION, (Object)t.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        @Deprecated(message="Use getTargetApi(JavaEvaluator, ...) passing in for example context.evaluator", replaceWith=@ReplaceWith(expression="getTargetApi(evaluator,scope,isApiLevelAnnotation)", imports={}))
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, scope, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ApiConstraint getTargetApi(@Nullable JavaEvaluator evaluator, @Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, evaluator, scope, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_RETURN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_OVERRIDE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.VARIABLE_REFERENCE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

