/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0002J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\b\b\u0000\u0010\u001c*\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0006H\u0002J\u001a\u0010&\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u0004\u0018\u00010\u0006*\u00020\u0014H\u0002J\f\u0010-\u001a\u00020!*\u00020\u0014H\u0002\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkColor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "Lorg/jetbrains/uast/UElement;", "checkHalfFloat", "checkPx", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "checkResourceType", "expectedTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceType;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "getMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "node", "getParentSequence", "Lkotlin/sequences/Sequence;", "T", "element", "clz", "Ljava/lang/Class;", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isResourceAnnotation", "signature", "typeArrayFromArrayLiteral", "visitAnnotationUsage", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "getMarkerTypeDescription", "isDimension", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nResourceTypeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceTypeDetector.kt\ncom/android/tools/lint/checks/ResourceTypeDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,614:1\n1#2:615\n1282#3,2:616\n*S KotlinDebug\n*F\n+ 1 ResourceTypeDetector.kt\ncom/android/tools/lint/checks/ResourceTypeDetector\n*L\n364#1:616,2\n*E\n"})
public final class ResourceTypeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceTypeDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RESOURCE_TYPE;
    @JvmField
    @NotNull
    public static final Issue COLOR_USAGE;
    @JvmField
    @NotNull
    public static final Issue HALF_FLOAT;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{ResourceEvaluator.COLOR_INT_ANNOTATION.oldName(), ResourceEvaluator.COLOR_INT_ANNOTATION.newName(), ResourceEvaluator.DIMENSION_ANNOTATION.oldName(), ResourceEvaluator.DIMENSION_ANNOTATION.newName(), ResourceEvaluator.PX_ANNOTATION.oldName(), ResourceEvaluator.PX_ANNOTATION.newName(), AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.oldName(), AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.newName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.newName(), ResourceEvaluator.ANIM_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIM_RES_ANNOTATION.newName(), ResourceEvaluator.ANY_RES_ANNOTATION.oldName(), ResourceEvaluator.ANY_RES_ANNOTATION.newName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.oldName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.newName(), ResourceEvaluator.ATTR_RES_ANNOTATION.oldName(), ResourceEvaluator.ATTR_RES_ANNOTATION.newName(), ResourceEvaluator.BOOL_RES_ANNOTATION.oldName(), ResourceEvaluator.BOOL_RES_ANNOTATION.newName(), ResourceEvaluator.COLOR_RES_ANNOTATION.oldName(), ResourceEvaluator.COLOR_RES_ANNOTATION.newName(), ResourceEvaluator.FONT_RES_ANNOTATION.oldName(), ResourceEvaluator.FONT_RES_ANNOTATION.newName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.oldName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.newName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.newName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.oldName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.newName(), ResourceEvaluator.ID_RES_ANNOTATION.oldName(), ResourceEvaluator.ID_RES_ANNOTATION.newName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.oldName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.newName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.newName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.oldName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.newName(), ResourceEvaluator.MENU_RES_ANNOTATION.oldName(), ResourceEvaluator.MENU_RES_ANNOTATION.newName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.oldName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.newName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.oldName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.newName(), ResourceEvaluator.RAW_RES_ANNOTATION.oldName(), ResourceEvaluator.RAW_RES_ANNOTATION.newName(), ResourceEvaluator.STRING_RES_ANNOTATION.oldName(), ResourceEvaluator.STRING_RES_ANNOTATION.newName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.newName(), ResourceEvaluator.STYLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLE_RES_ANNOTATION.newName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.oldName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.newName(), ResourceEvaluator.XML_RES_ANNOTATION.oldName(), ResourceEvaluator.XML_RES_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type != AnnotationUsageType.DEFINITION;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        String qualifiedName = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.newName())) {
            this.checkColor(context, element);
        } else if (Intrinsics.areEqual((Object)qualifiedName, (Object)AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)qualifiedName, (Object)AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.newName())) {
            this.checkHalfFloat(context, element);
        } else if (((Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.PX_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.PX_ANNOTATION.newName())) {
            this.checkPx(context, element, annotationInfo.getAnnotation());
        } else if (this.isResourceAnnotation(qualifiedName)) {
            UastBinaryOperator operator;
            if (usageInfo.anyCloser((Function1)new Function1<AnnotationInfo, Boolean>(this){
                final /* synthetic */ ResourceTypeDetector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AnnotationInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ResourceTypeDetector.access$isResourceAnnotation(this.this$0, it.getQualifiedName());
                }
            })) {
                return;
            }
            UElement expression = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)true));
            if (expression instanceof UBinaryExpression && (operator = ((UBinaryExpression)expression).getOperator()) instanceof UastBinaryOperator.ComparisonOperator && operator != UastBinaryOperator.EQUALS && operator != UastBinaryOperator.NOT_EQUALS && operator != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                Location location = context.getLocation(expression);
                String string = "Comparing resource types (`@%1$s`) other than equality is dangerous and usually wrong;  some resource types set top bit which turns the value negative";
                Object[] objectArray = new Object[]{AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.removeFrom(qualifiedName)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                JavaContext.report$default((JavaContext)context, (Issue)RESOURCE_TYPE, (UElement)expression, (Location)location, (String)string2, null, (int)16, null);
                return;
            }
            EnumSet types = ResourceEvaluator.getTypesFromAnnotationList((List)usageInfo.getAnnotations());
            if (types != null) {
                if (types.contains(ResourceType.STYLEABLE) && usageInfo.getType() == AnnotationUsageType.ASSIGNMENT_LHS) {
                    return;
                }
                PsiElement psiElement = usageInfo.getReferenced();
                this.checkResourceType(context, element, types, psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null);
            }
        }
    }

    private final boolean isResourceAnnotation(String signature) {
        return ResourceEvaluator.getTypeFromAnnotationSignature((String)signature) != null || ResourceEvaluator.ANY_RES_ANNOTATION.isEquals(signature) || AndroidPlatformAnnotations.Companion.isPlatformAnnotation(signature) && ResourceEvaluator.getTypeFromAnnotationSignature((String)AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(signature)) != null;
    }

    private final void checkColor(JavaContext context, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                Intrinsics.checkNotNull((Object)uExpression);
                this.checkColor(context, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                Intrinsics.checkNotNull((Object)uExpression);
                this.checkColor(context, (UElement)uExpression);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkColor(context, (UElement)((UParenthesizedExpression)argument).getExpression());
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && types.contains(ResourceType.COLOR)) {
            String string = "Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`";
            Object[] objectArray = new Object[]{argument.asSourceString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message2 = string2;
            this.report(context, COLOR_USAGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkHalfFloat(JavaContext context, UElement argument) {
        UExpression curr;
        if (argument instanceof UIfExpression) {
            UExpression elseExpression;
            UExpression thenExpression = ((UIfExpression)argument).getThenExpression();
            if (thenExpression != null) {
                this.checkColor(context, (UElement)thenExpression);
            }
            if ((elseExpression = ((UIfExpression)argument).getElseExpression()) != null) {
                this.checkColor(context, (UElement)elseExpression);
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && !types.isEmpty()) {
            String type = types.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "dimension" : (types.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE) ? "sp dimension" : (types.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE) ? "dp dimension" : (types.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "color" : "resource id")));
            String string = "Expected a half float here, not a %1$s";
            Object[] objectArray = new Object[]{type};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message2 = string2;
            this.report(context, HALF_FLOAT, argument, context.getLocation(argument), message2);
            return;
        }
        Iterator iterator = this.getParentSequence(argument, UExpression.class).iterator();
        while (iterator.hasNext() && !((curr = (UExpression)iterator.next()) instanceof UBinaryExpressionWithType)) {
            PsiType expressionType = curr.getExpressionType();
            if (expressionType == null || Intrinsics.areEqual((Object)PsiTypes.shortType(), (Object)expressionType)) continue;
            if (Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)expressionType) || Intrinsics.areEqual((Object)PsiTypes.booleanType(), (Object)expressionType) || Intrinsics.areEqual((Object)PsiTypes.byteType(), (Object)expressionType) || Intrinsics.areEqual((Object)expressionType.getCanonicalText(), (Object)"android.util.Half")) break;
            String string = "Half-float type in expression widened to %1$s";
            Object[] objectArray = new Object[]{expressionType.getCanonicalText()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String message3 = string3;
            this.report(context, HALF_FLOAT, argument, context.getLocation(argument), message3);
            break;
        }
    }

    private final <T extends UElement> Sequence<T> getParentSequence(UElement element, Class<? extends T> clz) {
        UElement seed = UastUtils.getParentOfType((UElement)element, clz, (boolean)false);
        Function1 nextFunction2 = new Function1<T, T>(clz){
            final /* synthetic */ Class<? extends T> $clz;
            {
                this.$clz = $clz;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (T)UastUtils.getParentOfType(it, this.$clz, (boolean)true);
            }
        };
        return SequencesKt.generateSequence((Object)seed, (Function1)nextFunction2);
    }

    private final void checkPx(JavaContext context, UElement argument, UAnnotation annotation) {
        if (argument instanceof UIfExpression) {
            UExpression it;
            UExpression uExpression = ((UIfExpression)argument).getThenExpression();
            if (uExpression != null) {
                it = uExpression;
                boolean bl = false;
                this.checkPx(context, (UElement)it, annotation);
            }
            UExpression uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                it = uExpression2;
                boolean bl = false;
                this.checkPx(context, (UElement)it, annotation);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkPx(context, (UElement)((UParenthesizedExpression)argument).getExpression(), annotation);
            return;
        }
        EnumSet enumSet = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (enumSet == null) {
            return;
        }
        EnumSet types = enumSet;
        if (types.contains(ResourceType.DIMEN)) {
            String message2 = "Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
            this.report(context, RESOURCE_TYPE, argument, context.getLocation(argument), message2);
        } else {
            Object object;
            ResourceType unit;
            block11: {
                ResourceType resourceType = ResourceEvaluator.getTypeFromAnnotation((UAnnotation)annotation);
                if (resourceType == null) {
                    return;
                }
                unit = resourceType;
                Intrinsics.checkNotNullExpressionValue((Object)ResourceEvaluator.DIMENSION_MARKERS, (String)"DIMENSION_MARKERS");
                Object[] $this$firstOrNull$iv = ResourceEvaluator.DIMENSION_MARKERS;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResourceType it = (ResourceType)element$iv;
                    boolean bl = false;
                    if (!types.contains(it)) continue;
                    object = element$iv;
                    break block11;
                }
                object = null;
            }
            ResourceType resourceType = (ResourceType)object;
            if (resourceType == null) {
                return;
            }
            ResourceType typeUnit = resourceType;
            if (unit != typeUnit && this.isDimension(unit)) {
                String message3 = "Mismatched @Dimension units here; expected " + this.getMarkerTypeDescription(unit) + " but received " + this.getMarkerTypeDescription(typeUnit);
                this.report(context, RESOURCE_TYPE, argument, context.getLocation(argument), message3);
            }
        }
    }

    private final boolean isDimension(ResourceType $this$isDimension) {
        return $this$isDimension == ResourceEvaluator.DIMENSION_MARKER_TYPE || $this$isDimension == ResourceEvaluator.DIMENSION_DP_MARKER_TYPE || $this$isDimension == ResourceEvaluator.DIMENSION_SP_MARKER_TYPE;
    }

    private final void checkResourceType(JavaContext context, UElement argument, EnumSet<ResourceType> expectedTypes, PsiMethod calledMethod) {
        Object object;
        UExpression call;
        EnumSet actual = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (actual == null && (!UastLintUtils.Companion.isNumber(argument) || UastLintUtils.Companion.isZero(argument) || UastLintUtils.Companion.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection((Set)actual, (Set)expectedTypes).isEmpty() || expectedTypes.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (expectedTypes.contains(ResourceType.STYLEABLE) && expectedTypes.size() == 1 && calledMethod != null && context.getEvaluator().isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && (call = (UExpression)UastUtils.getParentOfType((UElement)argument, UCallExpression.class, (boolean)false)) instanceof UCallExpression) {
            UExpression uExpression = ((UCallExpression)call).getReceiver();
            if (this.typeArrayFromArrayLiteral((UElement)(uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null), context)) {
                return;
            }
        }
        if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.COLOR_INT_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"COLOR_INT_MARKER_TYPE");
            object = "Expected a color resource id (`R.color.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE)) {
            object = "Should pass resolved color instead of resource id here: `getResources().getColor(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE)) {
            object = "Should pass resolved pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_SP_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_SP_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE)) {
            object = "Should pass resolved scale-independent (sp) pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_DP_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_DP_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else {
            object = expectedTypes.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE) ? "Should pass resolved density-independent (dp) pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`" : (Intrinsics.areEqual(expectedTypes, (Object)ResourceEvaluator.getAnyRes()) ? "Expected resource identifier (`R`.type.`name`)" : "Expected resource of type " + CollectionsKt.joinToString$default((Iterable)expectedTypes, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null));
        }
        String message2 = object;
        this.report(context, RESOURCE_TYPE, argument, context.getLocation(argument), message2);
    }

    private final String getMarkerTypeDescription(ResourceType $this$getMarkerTypeDescription) {
        ResourceType resourceType = $this$getMarkerTypeDescription;
        return resourceType == ResourceEvaluator.COLOR_INT_MARKER_TYPE ? "an RGB integer" : (resourceType == ResourceEvaluator.DIMENSION_MARKER_TYPE ? "a pixel integer" : (resourceType == ResourceEvaluator.DIMENSION_SP_MARKER_TYPE ? "a scale-independent (sp) integer" : (resourceType == ResourceEvaluator.DIMENSION_DP_MARKER_TYPE ? "density-independent (dp) integer" : (resourceType == ResourceEvaluator.ANY_RES_MARKER_TYPE ? "resource id of any type" : null))));
    }

    private final boolean typeArrayFromArrayLiteral(UElement node, JavaContext context) {
        if (node == null) {
            return false;
        }
        UCallExpression expression = this.getMethodCall(node);
        if (expression != null) {
            List expressions;
            String name = expression.getMethodName();
            if (name != null && Intrinsics.areEqual((Object)"obtainStyledAttributes", (Object)name) && !((Collection)(expressions = expression.getValueArguments())).isEmpty()) {
                int arg = 0;
                if (expressions.size() == 1) {
                    arg = 0;
                } else if (expressions.size() == 2) {
                    PsiType type;
                    for (arg = 0; arg < expressions.size() && !((type = ((UExpression)expressions.get(arg)).getExpressionType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions.size()) {
                        return false;
                    }
                } else if (expressions.size() == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((UElement)((UElement)expressions.get(arg)));
            }
            return false;
        }
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.Companion.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return this.typeArrayFromArrayLiteral((UElement)lastAssignment, context);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                return this.typeArrayFromArrayLiteral((UElement)((UParenthesizedExpression)node).getExpression(), context);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                UExpression operand = castExpression.getOperand();
                return this.typeArrayFromArrayLiteral((UElement)operand, context);
            }
        }
        return false;
    }

    private final UCallExpression getMethodCall(UElement node) {
        UElement last;
        if (node instanceof UQualifiedReferenceExpression && UastExpressionUtils.isMethodCall((UElement)(last = UastLintUtilsKt.findSelector((UElement)node)))) {
            Intrinsics.checkNotNull((Object)last, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            return (UCallExpression)last;
        }
        return node != null && UastExpressionUtils.isMethodCall((UElement)node) ? (UCallExpression)node : null;
    }

    public static final /* synthetic */ boolean access$isResourceAnnotation(ResourceTypeDetector $this, String signature) {
        return $this.isResourceAnnotation(signature);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        RESOURCE_TYPE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ResourceType", (String)"Wrong Resource Type", (String)"\n                Ensures that resource id's passed to APIs are of the right type; for \\\n                example, calling `Resources.getColor(R.string.name)` is wrong.", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        COLOR_USAGE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ResourceAsColor", (String)"Should pass resolved color instead of resource id", (String)"\n                Methods that take a color in the form of an integer should be passed an \\\n                RGB triple, not the actual color resource id. You must call \\\n                `getResources().getColor(resource)` to resolve the actual color value first.\n\n                Similarly, methods that take a dimension integer should be passed an \\\n                actual dimension (call `getResources().getDimension(resource)`", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HALF_FLOAT = Issue.Companion.create$default((Issue.Companion)companion, (String)"HalfFloat", (String)"Incorrect Half Float", (String)"\n                Half-precision floating point are stored in a short data type, and should be \\\n                manipulated using the `android.util.Half` class. This check flags usages \\\n                where it appears that these values are used incorrectly.", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector$Companion;", "", "()V", "COLOR_USAGE", "Lcom/android/tools/lint/detector/api/Issue;", "HALF_FLOAT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESOURCE_TYPE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

