/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.optional;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\"\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/optional/FlaggedApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "getFlaggedApi", "Lcom/intellij/psi/PsiField;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "inheritAnnotation", "", "isAlreadyAnnotated", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "element", "Lorg/jetbrains/uast/UElement;", "flag", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isFlagChecked", "flagClass", "Lcom/intellij/psi/PsiClass;", "flagMethodName", "isFlagExpression", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nFlaggedApiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaggedApiDetector.kt\ncom/android/tools/lint/checks/optional/FlaggedApiDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,337:1\n18#2:338\n*S KotlinDebug\n*F\n+ 1 FlaggedApiDetector.kt\ncom/android/tools/lint/checks/optional/FlaggedApiDetector\n*L\n180#1:338\n*E\n"})
public final class FlaggedApiDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(FlaggedApiDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String FLAGGED_API_ANNOTATION = "android.annotation.FlaggedApi";

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)FLAGGED_API_ANNOTATION);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        UExpression uExpression;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        PsiField flag = this.getFlaggedApi(annotationInfo.getAnnotation());
        if (flag == null) {
            UNamedExpression uNamedExpression = (UNamedExpression)CollectionsKt.firstOrNull((List)annotationInfo.getAnnotation().getAttributeValues());
            if (uNamedExpression == null || (uNamedExpression = uNamedExpression.getExpression()) == null) {
                return;
            }
            UNamedExpression expression = uNamedExpression;
            if (expression instanceof ULiteralExpression) {
                String flagString = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)expression), (boolean)false);
                if (flagString != null && StringsKt.indexOf$default((CharSequence)flagString, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)expression), (Location)context.getLocation((UElement)expression), (String)"Invalid @FlaggedApi descriptor; should be `package.name`", null, (int)16, null);
                    return;
                }
                Incident incident = new Incident(ISSUE, (Object)expression, context.getLocation((UElement)expression), "@FlaggedApi should specify an actual flag constant; raw strings are discouraged (and more importantly, **not enforced**)");
                incident.overrideSeverity(Severity.WARNING);
                context.report(incident);
            }
            return;
        }
        if (this.isAlreadyAnnotated(context.getEvaluator(), element, flag)) {
            return;
        }
        PsiClass psiClass = flag.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass flagClass = psiClass;
        String string = flag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"flag.name");
        String flagName = string;
        String flagPresent = SdkUtils.constantNameToCamelCase((String)StringsKt.removePrefix((String)flagName, (CharSequence)"FLAG_"));
        Intrinsics.checkNotNullExpressionValue((Object)flagPresent, (String)"flagPresent");
        if (this.isFlagChecked(element, flagClass, flagPresent)) {
            return;
        }
        PsiElement referenced = UastUtils.tryResolve((UElement)element);
        String description = referenced instanceof PsiMethod ? "Method `" + ((PsiMethod)referenced).getName() + "()`" : (element instanceof UCallExpression ? "Method `" + Lint.getMethodName((UCallExpression)((UCallExpression)element)) + "()`" : (referenced instanceof PsiField ? "Field `" + ((PsiField)referenced).getName() + "`" : (referenced instanceof PsiClass ? "Class `" + ((PsiClass)referenced).getName() + "`" : (element instanceof UClassLiteralExpression ? "Class `" + ((uExpression = ((UClassLiteralExpression)element).getExpression()) != null && (uExpression = uExpression.getSourcePsi()) != null ? uExpression.getText() : null) + "`" : (referenced instanceof PsiNamedElement ? "Reference `" + ((PsiNamedElement)referenced).getName() + "`" : "This")))));
        UElement $this$getParentOfType_u24default$iv = element;
        boolean strict$iv = true;
        UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
        boolean $i$f$getParentOfType = false;
        Object object = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UMethod.class, (boolean)strict$iv);
        if (object == null || (object = object.getName()) == null) {
            object = "?";
        }
        Object name = object;
        String message2 = description + " is a flagged API and should be inside an `if (" + flagClass.getName() + "." + flagPresent + "())` check (or annotate the surrounding method `" + (String)name + "` with `@FlaggedApi(" + flagClass.getName() + "." + flagName + ") to transfer requirement to caller`)";
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)element, (Location)context.getLocation(element), (String)message2, null, (int)16, null);
    }

    private final PsiField getFlaggedApi(UAnnotation annotation) {
        UNamedExpression uNamedExpression = (UNamedExpression)CollectionsKt.firstOrNull((List)annotation.getAttributeValues());
        PsiElement psiElement = uNamedExpression != null && (uNamedExpression = uNamedExpression.getExpression()) != null ? UastUtils.tryResolve((UElement)((UElement)uNamedExpression)) : null;
        return psiElement instanceof PsiField ? (PsiField)psiElement : null;
    }

    private final boolean isAlreadyAnnotated(JavaEvaluator evaluator, UElement element, PsiField flag) {
        for (UElement current = element; current != null; current = current.getUastParent()) {
            PsiPackage pkg;
            if (current instanceof UAnnotated) {
                for (UAnnotation annotation : ((UAnnotated)current).getUAnnotations()) {
                    PsiField api2;
                    if (this.getFlaggedApi(annotation) == null || !api2.isEquivalentTo((PsiElement)flag)) continue;
                    return true;
                }
            }
            if (!(current instanceof UFile)) continue;
            PsiElement psiElement = ((UFile)current).getJavaPsi();
            if (psiElement == null) {
                psiElement = (PsiElement)((UFile)current).getSourcePsi();
            }
            if ((pkg = evaluator.getPackage(psiElement)) == null) break;
            PsiAnnotation[] psiAnnotationArray = pkg.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"pkg.annotations");
            for (PsiAnnotation psiAnnotation : psiAnnotationArray) {
                PsiField api3;
                UAnnotation annotation;
                UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"psiAnnotation");
                UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                if (uAnnotation == null || this.getFlaggedApi(annotation = uAnnotation) == null || !api3.isEquivalentTo((PsiElement)flag)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    private final boolean isFlagChecked(UElement element, PsiClass flagClass, String flagMethodName) {
        UElement uElement = element.getUastParent();
        if (uElement == null) {
            return false;
        }
        UElement curr = uElement;
        UElement prev = element;
        while (!(curr instanceof UFile)) {
            UExpression condition;
            UExpression first;
            UExpression body;
            if (curr instanceof UIfExpression) {
                UExpression op;
                boolean fromThen;
                UExpression condition2 = ((UIfExpression)curr).getCondition();
                if (prev != condition2 && ((fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)curr).getThenExpression())) ? this.isFlagExpression((UElement)condition2, flagClass, flagMethodName) : (op = UastUtils.skipParenthesizedExprDown((UExpression)condition2)) instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)op).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isFlagExpression((UElement)((UUnaryExpression)op).getOperand(), flagClass, flagMethodName))) {
                    return true;
                }
            } else if (curr instanceof UMethod && (body = ((UMethod)curr).getUastBody()) instanceof UBlockExpression && ((UBlockExpression)body).getExpressions().size() > 1 && (first = (UExpression)((UBlockExpression)body).getExpressions().get(0)) instanceof UIfExpression && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)first).getCondition())) instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)condition).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT) && this.isFlagExpression((UElement)((UUnaryExpression)condition).getOperand(), flagClass, flagMethodName)) {
                UExpression then;
                UExpression uExpression = ((UIfExpression)first).getThenExpression();
                Object object = then = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                if (then != null && UastLintUtilsKt.isUnconditionalReturn((UExpression)then)) {
                    return true;
                }
            }
            prev = curr;
            if (curr.getUastParent() == null) break;
        }
        return false;
    }

    private final boolean isFlagExpression(UElement element, PsiClass flagClass, String flagMethodName) {
        if (element instanceof UUnaryExpression && Intrinsics.areEqual((Object)((UUnaryExpression)element).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT)) {
            return !this.isFlagExpression((UElement)((UUnaryExpression)element).getOperand(), flagClass, flagMethodName);
        }
        if (element instanceof UReferenceExpression || element instanceof UCallExpression) {
            UExpression initializer;
            PsiElement resolved = UastUtils.tryResolve((UElement)element);
            if (resolved instanceof PsiMethod) {
                PsiClass cls;
                if (Intrinsics.areEqual((Object)((PsiMethod)resolved).getName(), (Object)flagMethodName) && flagClass.isEquivalentTo((PsiElement)(cls = ((PsiMethod)resolved).getContainingClass()))) {
                    return true;
                }
            } else if (resolved instanceof PsiField && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) != null) {
                return this.isFlagExpression((UElement)initializer, flagClass, flagMethodName);
            }
        } else {
            if (element instanceof UParenthesizedExpression) {
                return this.isFlagExpression((UElement)((UParenthesizedExpression)element).getExpression(), flagClass, flagMethodName);
            }
            if (element instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)element).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                for (UExpression operand : ((UPolyadicExpression)element).getOperands()) {
                    if (!this.isFlagExpression((UElement)operand, flagClass, flagMethodName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FlaggedApi", (String)"FlaggedApi access without check", (String)"\n          This lint check looks for accesses of APIs marked with `@FlaggedApi(X)` without \\\n          a guarding `if (Flags.X)` check. See go/android-flagged-apis.\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/optional/FlaggedApiDetector$Issues;", "", "()V", "FLAGGED_API_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

