/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/DiscouragedDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "getApplicableAttributes", "", "getApplicableMethodNames", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class DiscouragedDetector
extends AbstractAnnotationDetector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DISCOURAGED_ANNOTATION = "androidx.annotation.Discouraged";
    @NotNull
    public static final String SCHEDULE_AT_FIXED_RATE = "scheduleAtFixedRate";
    @NotNull
    public static final String SCHEDULE_WITH_FIXED_DELAY = "scheduleWithFixedDelay";
    @NotNull
    public static final String SCHEDULE = "schedule";
    @NotNull
    public static final String CLASS_SCHEDULED_EXECUTOR_SERVICE = "java.util.concurrent.ScheduledExecutorService";
    @NotNull
    public static final String CLASS_TIMER = "java.util.Timer";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)DISCOURAGED_ANNOTATION);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type == AnnotationUsageType.METHOD_CALL || type == AnnotationUsageType.METHOD_REFERENCE || type == AnnotationUsageType.CLASS_REFERENCE || type == AnnotationUsageType.METHOD_OVERRIDE || type == AnnotationUsageType.EXTENDS || type == AnnotationUsageType.FIELD_REFERENCE;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (usageInfo.getReferenced() == null) {
            return;
        }
        Location location = context.getNameLocation(element);
        String message2 = UastLintUtils.Companion.getAnnotationStringValue(annotationInfo.getAnnotation(), "message");
        CharSequence charSequence = message2;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.report(context, ISSUE, element, location, message2);
        } else {
            String defaultMessage = "Use of this API is discouraged";
            this.report(context, ISSUE, element, location, defaultMessage);
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)SCHEDULE_AT_FIXED_RATE);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)SCHEDULE_AT_FIXED_RATE)) {
            Pair pair;
            if (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)CLASS_SCHEDULED_EXECUTOR_SERVICE, (boolean)false, (int)4, null)) {
                pair = TuplesKt.to((Object)DiscouragedDetector.visitMethodCall$scheduleAtFixedRateFix(this, SCHEDULE_WITH_FIXED_DELAY), (Object)SCHEDULE_WITH_FIXED_DELAY);
            } else if (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)CLASS_TIMER, (boolean)false, (int)4, null)) {
                PsiParameter psiParameter = method.getParameterList().getParameter(1);
                pair = Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getType() : null), (Object)PsiTypes.longType()) ? TuplesKt.to((Object)DiscouragedDetector.visitMethodCall$scheduleAtFixedRateFix(this, SCHEDULE), (Object)SCHEDULE) : TuplesKt.to(null, (Object)SCHEDULE);
            } else {
                return;
            }
            Pair pair2 = pair;
            LintFix fix = (LintFix)pair2.component1();
            String replacementFuncName = (String)pair2.component2();
            context.report(new Incident().issue(ISSUE).scope((Object)node).location(context.getLocation((UElement)node)).message("Use of `scheduleAtFixedRate` is strongly discouraged because it can lead to unexpected behavior when Android processes become cached (tasks may unexpectedly execute hundreds or thousands of times in quick succession when a process changes from cached to uncached); prefer using `" + replacementFuncName + "`").fix(fix), Constraints.isAndroidProject());
        }
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"minAspectRatio", "maxAspectRatio", "screenOrientation", "resizeableActivity"};
        return SetsKt.setOf((Object[])objectArray);
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
                return;
            }
            String string = attribute.getLocalName();
            if (string == null) break block16;
            int n = -1;
            switch (string.hashCode()) {
                case -891502961: {
                    if (string.equals("maxAspectRatio")) {
                        n = 1;
                    }
                    break;
                }
                case 227582404: {
                    if (string.equals("screenOrientation")) {
                        n = 2;
                    }
                    break;
                }
                case -234586911: {
                    if (string.equals("minAspectRatio")) {
                        n = 1;
                    }
                    break;
                }
                case 1642209597: {
                    if (string.equals("resizeableActivity")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String message2 = "Should not restrict activity to maximum or minimum aspect ratio. This may not be suitable for different form factors, causing the app to be letterboxed.";
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message2, null, (int)16, null);
                    break;
                }
                case 2: {
                    String message3 = "Should not restrict activity to fixed orientation. This may not be suitable for different form factors, causing the app to be letterboxed.";
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message3, null, (int)16, null);
                    break;
                }
                case 3: {
                    if (!Intrinsics.areEqual((Object)attribute.getValue(), (Object)"false")) break;
                    String message4 = "Activity should not be non-resizable. With this setting, apps cannot be used in multi-window or free form mode.";
                    XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message4, null, (int)16, null);
                }
            }
        }
    }

    private static final LintFix visitMethodCall$scheduleAtFixedRateFix(DiscouragedDetector this$0, String replacement) {
        return this$0.fix().replace().independent(true).text(SCHEDULE_AT_FIXED_RATE).with(replacement).build();
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(DiscouragedDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.JAVA_FILE), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet enumSet = Platform.UNSPECIFIED;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"DiscouragedApi", (String)"Using discouraged APIs", (String)"\n                Discouraged APIs are allowed and are not deprecated, but they may be unfit for \\\n                common use (e.g. due to slow performance or subtle behavior).\n                ", (Implementation)implementation, null, (Category)category, (int)2, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2832, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/DiscouragedDetector$Companion;", "", "()V", "CLASS_SCHEDULED_EXECUTOR_SERVICE", "", "CLASS_TIMER", "DISCOURAGED_ANNOTATION", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SCHEDULE", "SCHEDULE_AT_FIXED_RATE", "SCHEDULE_WITH_FIXED_DELAY", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

