/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.model.DefaultLintModelSourceProvider;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSourceProvider;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0004J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0004J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0006\u0010\u0019\u001a\u00020\u000eH\u0004J\b\u0010\u001d\u001a\u00020\u000eH\u0004J\b\u0010\u001e\u001a\u00020\u000eH\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020!H\u0004J\u0012\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u000eH\u0004J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0004J\u001c\u0010&\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0012H\u0004J \u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010)\u001a\u00020\u000eH\u0004J\b\u0010*\u001a\u00020\u0018H\u0004J\u0012\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u000eH\u0004J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020\u000eH\u0004J\b\u0010/\u001a\u00020\u0018H\u0004J\f\u00100\u001a\u000201*\u00020\u000eH\u0004J\u000e\u00102\u001a\u0004\u0018\u000103*\u00020\u000eH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lcom/android/tools/lint/model/LintModelReader;", "", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/io/Reader;)V", "getAdapter", "()Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "parser", "Lorg/kxml2/io/KXmlParser;", "getParser", "()Lorg/kxml2/io/KXmlParser;", "path", "", "getPath", "()Ljava/lang/String;", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "setRoot", "(Ljava/io/File;)V", "expectTag", "", "name", "finishTag", "getFiles", "", "getLocation", "getName", "getOptionalAttribute", "getOptionalBoolean", "", "attribute", "default", "getOptionalFile", "getRequiredAttribute", "getRequiredFile", "relativeTo", "getStrings", "separator", "missingData", "readSourceProvider", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "tag", "readSourceProviders", "unexpectedTag", "toApiVersion", "Lcom/android/sdklib/AndroidVersion;", "toMavenCoordinate", "Lcom/android/tools/lint/model/LintModelMavenName;", "lint-model"})
abstract class LintModelReader {
    @Nullable
    private File root;
    @NotNull
    private final KXmlParser parser;
    @NotNull
    private final LintModelSerialization.LintModelSerializationAdapter adapter;

    @NotNull
    protected abstract String getPath();

    @Nullable
    protected final File getRoot() {
        return this.root;
    }

    protected final void setRoot(@Nullable File file) {
        this.root = file;
    }

    @NotNull
    protected final KXmlParser getParser() {
        return this.parser;
    }

    @NotNull
    protected final AndroidVersion toApiVersion(@NotNull String $this$toApiVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toApiVersion, (String)"$this$toApiVersion");
        return new AndroidVersion($this$toApiVersion);
    }

    @Nullable
    protected final LintModelMavenName toMavenCoordinate(@NotNull String $this$toMavenCoordinate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toMavenCoordinate, (String)"$this$toMavenCoordinate");
        return LintModelMavenName.Companion.parse($this$toMavenCoordinate);
    }

    @NotNull
    protected final String getLocation() {
        return this.getPath() + ':' + this.parser.getLineNumber();
    }

    protected final void expectTag(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)name, (Object)this.parser.getName()) ^ true) {
            String string = "Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation() + "; expected `<" + name + ">`";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    protected final void unexpectedTag() {
        String string = "Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation();
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    protected final void missingData() {
        String string = "Missing data at " + this.getLocation();
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    protected final void finishTag(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            if (eventType == 2) {
                this.unexpectedTag();
                continue;
            }
            if (eventType != 3) continue;
            this.expectTag(name);
            break;
        }
    }

    @Nullable
    protected final String getOptionalAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.parser.getAttributeValue(null, name);
    }

    @NotNull
    protected final String getRequiredAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = this.parser.getAttributeValue(null, name);
        if (string == null) {
            String string2 = "Expected `" + name + "` attribute in <" + this.parser.getName() + "> tag at " + this.getLocation();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    protected final String getName() {
        return this.getRequiredAttribute("name");
    }

    @Nullable
    protected final File getOptionalFile(@NotNull String attribute) {
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return null;
        }
        String path = string;
        return this.adapter.fromPathString(path, this.root);
    }

    @NotNull
    protected final File getRequiredFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String path = this.getRequiredAttribute(attribute);
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getRequiredFile$default(LintModelReader lintModelReader, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRequiredFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getRequiredFile(string, file);
    }

    protected final boolean getOptionalBoolean(@NotNull String attribute, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return bl;
        }
        String value = string;
        return Intrinsics.areEqual((Object)value, (Object)"true");
    }

    @NotNull
    protected final List<String> getStrings(@NotNull String name, @NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        Object object = this.getOptionalAttribute(name);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{separator}, (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getStrings$default(LintModelReader lintModelReader, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStrings");
        }
        if ((n & 2) != 0) {
            string2 = ",";
        }
        return lintModelReader.getStrings(string, string2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final List<File> getFiles(@NotNull String name) {
        void $this$mapTo$iv$iv;
        List list;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                object = this.getOptionalAttribute(name);
                if (object == null) break block5;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                String string = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
                stringArray[0] = string;
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block6;
            }
            list = CollectionsKt.emptyList();
            return list;
        }
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (true) {
            void path;
            if (!iterator.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)path);
            File file2 = this.root != null && !file.isAbsolute() ? new File(this.root, (String)path) : file;
            collection.add(file2);
        }
    }

    @NotNull
    protected final LintModelSourceProvider readSourceProvider(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.expectTag(tag);
        File manifestFile = LintModelReader.getRequiredFile$default(this, "manifest", null, 2, null);
        List<File> javaDirectories = this.getFiles("javaDirectories");
        List<File> resDirectories = this.getFiles("resDirectories");
        List<File> assetsDirectories = this.getFiles("assetsDirectories");
        boolean androidTestOnly = this.getOptionalBoolean("androidTest", false);
        boolean unitTestOnly = this.getOptionalBoolean("unitTest", false);
        boolean debugOnly = this.getOptionalBoolean("debugOnly", false);
        this.finishTag(tag);
        boolean bl = unitTestOnly;
        boolean bl2 = androidTestOnly;
        return new DefaultLintModelSourceProvider(manifestFile, (Collection<? extends File>)javaDirectories, (Collection<? extends File>)resDirectories, (Collection<? extends File>)assetsDirectories, debugOnly, bl, bl2);
    }

    public static /* synthetic */ LintModelSourceProvider readSourceProvider$default(LintModelReader lintModelReader, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readSourceProvider");
        }
        if ((n & 1) != 0) {
            string = "sourceProvider";
        }
        return lintModelReader.readSourceProvider(string);
    }

    @NotNull
    protected final List<LintModelSourceProvider> readSourceProviders(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.expectTag(tag);
        boolean bl = false;
        List sourceProviders = new ArrayList();
        block3: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            if (eventType == 2) {
                if (this.parser.getName() != null) {
                    String string;
                    switch (string.hashCode()) {
                        case 1943963436: {
                            if (!string.equals("sourceProvider")) break;
                            sourceProviders.add(LintModelReader.readSourceProvider$default(this, null, 1, null));
                            continue block3;
                        }
                    }
                }
                this.unexpectedTag();
                continue;
            }
            if (eventType != 3) continue;
            this.expectTag(tag);
            break;
        }
        return sourceProviders;
    }

    @NotNull
    protected final LintModelSerialization.LintModelSerializationAdapter getAdapter() {
        return this.adapter;
    }

    public LintModelReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.adapter = adapter;
        this.root = this.adapter.getRoot();
        this.parser = new KXmlParser();
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(reader);
    }
}

