/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelLibraryResolver;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelReader;
import com.android.tools.lint.model.LintModelSerialization;
import java.io.File;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/model/LintModelLibrariesReader;", "Lcom/android/tools/lint/model/LintModelReader;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "libraryResolver", "Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;", "variantName", "", "artifactName", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;Ljava/lang/String;Ljava/lang/String;Ljava/io/Reader;)V", "libraryResolverMap", "", "Lcom/android/tools/lint/model/LintModelLibrary;", "path", "getPath", "()Ljava/lang/String;", "readLibraries", "readLibrary", "lint-model"})
final class LintModelLibrariesReader
extends LintModelReader {
    private final Map<String, LintModelLibrary> libraryResolverMap;
    private final DefaultLintModelLibraryResolver libraryResolver;
    private final String variantName;
    private final String artifactName;

    @Override
    @NotNull
    protected String getPath() {
        Object object = this.getAdapter().file(LintModelSerialization.TargetFile.DEPENDENCIES, this.variantName, this.artifactName);
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "<unknown>";
        }
        return object;
    }

    @NotNull
    public final DefaultLintModelLibraryResolver readLibraries() {
        this.getParser().nextTag();
        this.expectTag("libraries");
        block3: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            if (eventType == 2) {
                if (this.getParser().getName() != null) {
                    String string;
                    switch (string.hashCode()) {
                        case 166208699: {
                            if (!string.equals("library")) break;
                            LintModelLibrary library = this.readLibrary();
                            this.libraryResolverMap.put(library.getArtifactAddress(), library);
                            continue block3;
                        }
                    }
                }
                this.unexpectedTag();
                continue;
            }
            if (eventType != 3) continue;
            this.expectTag("libraries");
            break;
        }
        return this.libraryResolver;
    }

    private final LintModelLibrary readLibrary() {
        this.expectTag("library");
        boolean android = false;
        String artifactAddress = this.getName();
        List<File> jars = this.getFiles("jars");
        String project = this.getOptionalAttribute("project");
        String string = this.getOptionalAttribute("resolved");
        LintModelMavenName resolved = string != null ? this.toMavenCoordinate(string) : null;
        boolean provided = this.getOptionalBoolean("provided", false);
        boolean skipped = this.getOptionalBoolean("skipped", false);
        File manifestFile = null;
        File resFolder = null;
        File assetsFolder = null;
        File lintJar = null;
        File publicResources = null;
        File symbolFile = null;
        File externalAnnotations = null;
        File proguardRules = null;
        File folder = this.getOptionalFile("folder");
        if (folder != null) {
            android = true;
            resFolder = this.getRequiredFile("resFolder", folder);
            assetsFolder = this.getRequiredFile("assetsFolder", folder);
            lintJar = this.getRequiredFile("lintJar", folder);
            publicResources = this.getRequiredFile("publicResources", folder);
            symbolFile = this.getRequiredFile("symbolFile", folder);
            manifestFile = this.getRequiredFile("manifest", folder);
            externalAnnotations = this.getRequiredFile("externalAnnotations", folder);
            proguardRules = this.getRequiredFile("proguardRules", folder);
        }
        this.finishTag("library");
        if (android) {
            File file = manifestFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            File file2 = folder;
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            File file3 = resFolder;
            if (file3 == null) {
                Intrinsics.throwNpe();
            }
            File file4 = assetsFolder;
            if (file4 == null) {
                Intrinsics.throwNpe();
            }
            File file5 = lintJar;
            if (file5 == null) {
                Intrinsics.throwNpe();
            }
            File file6 = publicResources;
            if (file6 == null) {
                Intrinsics.throwNpe();
            }
            File file7 = symbolFile;
            if (file7 == null) {
                Intrinsics.throwNpe();
            }
            File file8 = externalAnnotations;
            if (file8 == null) {
                Intrinsics.throwNpe();
            }
            File file9 = proguardRules;
            if (file9 == null) {
                Intrinsics.throwNpe();
            }
            LintModelMavenName lintModelMavenName = resolved;
            if (lintModelMavenName == null) {
                Intrinsics.throwNpe();
            }
            LintModelMavenName lintModelMavenName2 = lintModelMavenName;
            boolean bl = skipped;
            boolean bl2 = provided;
            String string2 = project;
            File file10 = file9;
            File file11 = file8;
            File file12 = file7;
            File file13 = file6;
            File file14 = file5;
            File file15 = file4;
            File file16 = file3;
            File file17 = file2;
            File file18 = file;
            List<File> list = jars;
            String string3 = artifactAddress;
            return new DefaultLintModelAndroidLibrary(list, string3, file18, file17, file16, file15, file14, file13, file12, file11, file10, string2, bl2, bl, lintModelMavenName2);
        }
        LintModelMavenName lintModelMavenName = resolved;
        if (lintModelMavenName == null) {
            Intrinsics.throwNpe();
        }
        LintModelMavenName lintModelMavenName3 = lintModelMavenName;
        boolean bl = skipped;
        boolean bl3 = provided;
        return new DefaultLintModelJavaLibrary(artifactAddress, jars, project, lintModelMavenName3, bl3, bl);
    }

    public LintModelLibrariesReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable DefaultLintModelLibraryResolver libraryResolver, @NotNull String variantName, @NotNull String artifactName, @NotNull Reader reader) {
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver;
        Map<Object, Object> map;
        Intrinsics.checkParameterIsNotNull((Object)adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        super(adapter, reader);
        this.variantName = variantName;
        this.artifactName = artifactName;
        LintModelLibrariesReader lintModelLibrariesReader = this;
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver2 = libraryResolver;
        Map map2 = defaultLintModelLibraryResolver2 != null ? defaultLintModelLibraryResolver2.getLibraryMap() : null;
        if (!TypeIntrinsics.isMutableMap(map2)) {
            map2 = map = null;
        }
        if (map2 == null) {
            LintModelLibrariesReader lintModelLibrariesReader2 = lintModelLibrariesReader;
            boolean bl = false;
            Map map3 = new LinkedHashMap();
            lintModelLibrariesReader = lintModelLibrariesReader2;
            map = lintModelLibrariesReader.libraryResolverMap = map3;
        }
        if ((defaultLintModelLibraryResolver = libraryResolver) == null) {
            defaultLintModelLibraryResolver = new DefaultLintModelLibraryResolver(this.libraryResolverMap);
        }
        this.libraryResolver = defaultLintModelLibraryResolver;
    }

    public /* synthetic */ LintModelLibrariesReader(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, DefaultLintModelLibraryResolver defaultLintModelLibraryResolver, String string, String string2, Reader reader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            defaultLintModelLibraryResolver = null;
        }
        if ((n & 0x10) != 0) {
            reader = lintModelSerializationAdapter.getReader(LintModelSerialization.TargetFile.LIBRARY_TABLE, string, string2);
        }
        this(lintModelSerializationAdapter, defaultLintModelLibraryResolver, string, string2, reader);
    }
}

