/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0000J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u0014J\u001a\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\fJ\u0013\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J$\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001c\u001a\u00020\u000eJ$\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001c\u001a\u00020\u000eJ&\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001c\u001a\u00020\u000eJ&\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001f\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/model/PathVariables;", "", "()V", "pathVariables", "", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "add", "", "other", "name", "", "dir", "Ljava/io/File;", "sort", "", "any", "clear", "contains", "filter", "predicate", "Lkotlin/Function1;", "fromPathString", "path", "relativeTo", "get", "normalize", "toPathString", "file", "unix", "fullPath", "toPathStringIfMatched", "toString", "Companion", "PathVariable", "lint-model"})
public final class PathVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathVariable> pathVariables = new ArrayList();
    @NotNull
    private static final String CANONICALIZED = "_canonical";
    @NotNull
    private static final Comparator<PathVariable> PATH_COMPARATOR = new Comparator<PathVariable>(){

        public int compare(@NotNull PathVariable v1, @NotNull PathVariable v2) {
            int c2;
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            String p1 = v1.getDir().getPath();
            String p2 = v2.getDir().getPath();
            int c1 = StringsKt.endsWith$default((String)v1.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            int n = c2 = StringsKt.endsWith$default((String)v2.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            if (c1 != c2) {
                return c1 - c2;
            }
            if (p2.length() != p1.length()) {
                return p2.length() - p1.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)p2, (String)"p2");
            int delta = p1.compareTo(p2);
            if (delta != 0) {
                return delta;
            }
            return v1.getName().compareTo(v2.getName());
        }
    };

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir, boolean sort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.Companion.checkPathVariableName(name);
        PathVariable variable = new PathVariable(name, dir);
        this.pathVariables.add(variable);
        if (sort) {
            this.sort();
        }
    }

    public static /* synthetic */ void add$default(PathVariables pathVariables, String string, File file, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        pathVariables.add(string, file, bl);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.get(name) != null;
    }

    @Nullable
    public final File get(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.pathVariables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PathVariable it = (PathVariable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PathVariable pathVariable = v0;
        return pathVariable != null ? pathVariable.getDir() : null;
    }

    public final void sort() {
        CollectionsKt.sortWith(this.pathVariables, PATH_COMPARATOR);
    }

    public final void clear() {
        this.pathVariables.clear();
    }

    @NotNull
    public final String toPathString(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        File file2 = relativeTo;
        return this.toPathString(string, file2 != null ? file2.getPath() : null, unix);
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(file, file2, bl);
    }

    @Nullable
    public final String toPathStringIfMatched(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        File file2 = relativeTo;
        return this.toPathStringIfMatched(string, file2 != null ? file2.getPath() : null, unix);
    }

    public static /* synthetic */ String toPathStringIfMatched$default(PathVariables pathVariables, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathStringIfMatched(file, file2, bl);
    }

    @NotNull
    public final String toPathString(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        String string = this.toPathStringIfMatched(fullPath, relativeTo, unix);
        if (string == null) {
            String it = fullPath;
            boolean bl = false;
            string = unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        return string;
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(string, string2, bl);
    }

    @Nullable
    public final String toPathStringIfMatched(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        for (PathVariable pathVariable : this.pathVariables) {
            String prefix = pathVariable.component1();
            File root = pathVariable.component2();
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.path");
            if (!StringsKt.startsWith$default((String)fullPath, (String)string, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)fullPath, (Object)root.getPath())) {
                return "$" + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED);
            }
            if (fullPath.length() <= root.getPath().length() || fullPath.charAt(root.getPath().length()) != File.separatorChar) continue;
            String string2 = fullPath.substring(root.getPath().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String relative = string2;
            String it = "$" + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED) + relative;
            boolean bl = false;
            return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        if (relativeTo != null && StringsKt.startsWith$default((String)fullPath, (String)relativeTo, (boolean)false, (int)2, null) && fullPath.length() > relativeTo.length() && fullPath.charAt(relativeTo.length()) == File.separatorChar) {
            String string = fullPath.substring(relativeTo.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String it = string;
            boolean bl = false;
            return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        return null;
    }

    public static /* synthetic */ String toPathStringIfMatched$default(PathVariables pathVariables, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathStringIfMatched(string, string2, bl);
    }

    @NotNull
    public final File fromPathString(@NotNull String path, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"$", (boolean)false, (int)2, null)) {
            Object object;
            Object v5;
            String name;
            block9: {
                boolean hasBraces = path.length() > 1 && path.charAt(1) == '{';
                int n = path.length();
                for (int i = 1; i < n; ++i) {
                    Object object2;
                    Object v1;
                    String varName;
                    char c;
                    block8: {
                        c = path.charAt(i);
                        if ((!hasBraces || path.charAt(i - 1) != '}') && (hasBraces || Character.isJavaIdentifierPart(c))) continue;
                        String string = path.substring(1, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        varName = string;
                        Iterable $this$firstOrNull$iv = this.pathVariables;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PathVariable it = (PathVariable)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)varName)) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    if ((object2 = (PathVariable)v1) == null || (object2 = ((PathVariable)object2).getDir()) == null) {
                        throw new IllegalStateException(("Path variable $" + varName + " referenced in " + path + " not provided to serialization").toString());
                    }
                    Object dir = object2;
                    int relativeStart = c == '/' || c == '\\' ? i + 1 : i;
                    String string = path.substring(relativeStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    return new File((File)dir, string);
                }
                String string = path.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                name = string;
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v5 = element$iv;
                    break block9;
                }
                v5 = null;
            }
            if ((object = (PathVariable)v5) == null || (object = ((PathVariable)object).getDir()) == null) {
                throw new IllegalStateException(("Path variable $" + name + " referenced in " + path + " not provided to serialization").toString());
            }
            return object;
        }
        File file = new File(path);
        if (relativeTo != null && !file.isAbsolute()) {
            File parentFile;
            if ((StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"..\\", (boolean)false, (int)2, null)) && (parentFile = relativeTo.getParentFile()) != null) {
                String string = path.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                return new File(parentFile, string);
            }
            return new File(relativeTo, path);
        }
        return file;
    }

    public static /* synthetic */ File fromPathString$default(PathVariables pathVariables, String string, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return pathVariables.fromPathString(string, file);
    }

    public final void add(@NotNull PathVariables other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (PathVariable variable : other.pathVariables) {
            Object v0;
            block3: {
                String name = variable.getName();
                PathVariables.Companion.checkPathVariableName(name);
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((PathVariable)v0 != null) {
                PathVariable it;
                boolean bl = false;
                this.pathVariables.remove(it);
            }
            this.pathVariables.add(variable);
        }
        this.sort();
    }

    public final void normalize() {
        if (this.pathVariables.isEmpty()) {
            return;
        }
        for (PathVariable variable : CollectionsKt.toList((Iterable)this.pathVariables)) {
            try {
                boolean bl;
                boolean bl2 = bl = !StringsKt.endsWith$default((String)variable.getName(), (String)CANONICALIZED, (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                File canonical = variable.getDir().getCanonicalFile();
                if (Intrinsics.areEqual((Object)canonical.getPath(), (Object)variable.getDir().getPath())) continue;
                String string = variable.getName() + CANONICALIZED;
                Intrinsics.checkNotNullExpressionValue((Object)canonical, (String)"canonical");
                this.add(string, canonical, false);
            }
            catch (IOException iOException) {}
        }
        this.sort();
    }

    public final boolean any() {
        return !((Collection)this.pathVariables).isEmpty();
    }

    @NotNull
    public final PathVariables filter(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PathVariables filtered = new PathVariables();
        for (PathVariable variable : this.pathVariables) {
            if (!((Boolean)predicate.invoke((Object)variable.getName())).booleanValue()) continue;
            filtered.pathVariables.add(variable);
        }
        return filtered;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.pathVariables, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.add$default(this, name, dir, false, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/model/PathVariables$PathVariable;", "", "name", "", "dir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-model"})
    private static final class PathVariable {
        @NotNull
        private final String name;
        @NotNull
        private final File dir;

        public PathVariable(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            this.name = name;
            this.dir = dir;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final File getDir() {
            return this.dir;
        }

        @NotNull
        public String toString() {
            return this.name + "=" + this.dir;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final File component2() {
            return this.dir;
        }

        @NotNull
        public final PathVariable copy(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            return new PathVariable(name, dir);
        }

        public static /* synthetic */ PathVariable copy$default(PathVariable pathVariable, String string, File file, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathVariable.name;
            }
            if ((n & 2) != 0) {
                file = pathVariable.dir;
            }
            return pathVariable.copy(string, file);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.dir.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathVariable)) {
                return false;
            }
            PathVariable pathVariable = (PathVariable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dir, (Object)pathVariable.dir);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/model/PathVariables$Companion;", "", "()V", "CANONICALIZED", "", "PATH_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "Lkotlin/Comparator;", "checkPathVariableName", "", "name", "isPrivatePathVariable", "", "path", "parse", "Lcom/android/tools/lint/model/PathVariables;", "s", "startsWithVariable", "variable", "lint-model"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPrivatePathVariable(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return !StringsKt.startsWith$default((String)path, (String)"{", (boolean)false, (int)2, null);
        }

        @NotNull
        public final PathVariables parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            PathVariables variables = new PathVariables();
            Set names = new LinkedHashSet();
            char[] cArray = new char[]{';'};
            for (String pair : StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (StringsKt.isBlank((CharSequence)pair)) continue;
                int index = StringsKt.indexOf$default((CharSequence)pair, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index <= 0 || index == pair.length() - 1 || StringsKt.startsWith$default((String)pair, (String)"$$", (boolean)false, (int)2, null)) {
                    throw new IllegalStateException(("Invalid path descriptor " + pair + ", expected name=path-prefix").toString());
                }
                String string = pair.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!names.add(name)) continue;
                String string2 = pair.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                File prefix = new File(((Object)StringsKt.trim((CharSequence)string2)).toString());
                variables.add(name, prefix, false);
            }
            variables.sort();
            return variables;
        }

        /*
         * WARNING - void declaration
         */
        private final void checkPathVariableName(String name) {
            if (StringsKt.startsWith$default((CharSequence)name, (char)'{', (boolean)false, (int)2, null)) {
                if (!StringsKt.endsWith$default((CharSequence)name, (char)'}', (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"}_canonical", (boolean)false, (int)2, null)) {
                    throw new IllegalStateException(("Invalid path variable name " + name + ", missing ending \"}\".").toString());
                }
            } else {
                boolean bl;
                char it;
                Sequence $this$any$iv;
                block6: {
                    $this$any$iv = StringsKt.asSequence((CharSequence)name);
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        it = ((Character)element$iv2).charValue();
                        boolean bl2 = false;
                        boolean bl3 = !Character.isJavaIdentifierPart(it);
                        if (!bl3) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    String string;
                    Object element$iv2;
                    block7: {
                        void $this$first$iv;
                        $this$any$iv = StringsKt.asSequence((CharSequence)name);
                        string = name;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            it = ((Character)element$iv2).charValue();
                            boolean bl4 = false;
                            boolean bl5 = !Character.isJavaIdentifierPart(it);
                            if (!bl5) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    String string2 = "Invalid path variable name " + string + ". Contains illegal character \"" + element$iv2 + "\".";
                    throw new IllegalStateException(string2.toString());
                }
            }
        }

        public final boolean startsWithVariable(@NotNull String path, @NotNull String variable) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            if (StringsKt.startsWith$default((String)path, (String)"$", (boolean)false, (int)2, null)) {
                boolean hasBraces = path.length() > 1 && path.charAt(1) == '{';
                int n = path.length();
                for (int i = 1; i < n; ++i) {
                    char c = path.charAt(i);
                    if ((!hasBraces || path.charAt(i - 1) != '}') && (hasBraces || Character.isJavaIdentifierPart(c))) continue;
                    return i - 1 == variable.length() && StringsKt.regionMatches$default((String)path, (int)1, (String)variable, (int)0, (int)variable.length(), (boolean)false, (int)16, null);
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

