/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.RepoManagerImpl;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.GenericFactory;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.ls.LSResourceResolver;

public abstract class RepoManager {
    public static final long DEFAULT_EXPIRATION_PERIOD_MS;
    private static final String COMMON_XSD_PATTERN = "repo-common-%02d.xsd";
    private static final String COMMON_OBJECT_FACTORY_PATTERN = "com.android.repository.impl.generated.v%d.ObjectFactory";
    private static final String GENERIC_XSD_PATTERN = "generic-%02d.xsd";
    private static final String GENERIC_OBJECT_FACTORY_PATTERN = "com.android.repository.impl.generated.generic.v%d.ObjectFactory";
    private static SchemaModule<CommonFactory> sCommonModule;
    private static SchemaModule<GenericFactory> sGenericModule;

    public static RepoManager create(FileOp fop) {
        return new RepoManagerImpl(fop);
    }

    public abstract void registerSchemaModule(SchemaModule var1);

    public abstract List<SchemaModule<?>> getSchemaModules();

    public static SchemaModule<CommonFactory> getCommonModule() {
        return sCommonModule;
    }

    public static SchemaModule<GenericFactory> getGenericModule() {
        return sGenericModule;
    }

    public abstract void setLocalPath(File var1);

    public abstract File getLocalPath();

    public abstract void setFallbackLocalRepoLoader(FallbackLocalRepoLoader var1);

    public abstract void registerSourceProvider(RepositorySourceProvider var1);

    @VisibleForTesting
    public abstract Set<RepositorySourceProvider> getSourceProviders();

    public abstract Set<RepositorySource> getSources(Downloader var1, ProgressIndicator var2, boolean var3);

    public abstract void setFallbackRemoteRepoLoader(FallbackRemoteRepoLoader var1);

    public abstract void load(long var1, List<RepoLoadedListener> var3, List<RepoLoadedListener> var4, List<Runnable> var5, ProgressRunner var6, Downloader var7, SettingsController var8, boolean var9);

    public final boolean loadSynchronously(long cacheExpirationMs, ProgressIndicator progress, Downloader downloader, SettingsController settings) {
        AtomicBoolean result = new AtomicBoolean(true);
        this.load(cacheExpirationMs, null, null, (List<Runnable>)ImmutableList.of(() -> result.set(false)), new DummyProgressRunner(progress), downloader, settings, true);
        return result.get();
    }

    public abstract void markInvalid();

    public abstract void markLocalCacheInvalid();

    public abstract boolean reloadLocalIfNeeded(ProgressIndicator var1);

    public abstract RepositoryPackages getPackages();

    public abstract LSResourceResolver getResourceResolver(ProgressIndicator var1);

    public abstract void addLocalChangeListener(RepoLoadedListener var1);

    public abstract void removeLocalChangeListener(RepoLoadedListener var1);

    public abstract void addRemoteChangeListener(RepoLoadedListener var1);

    public abstract void removeRemoteChangeListener(RepoLoadedListener var1);

    public abstract void installBeginning(RepoPackage var1, PackageOperation var2);

    public abstract void installEnded(RepoPackage var1);

    public abstract PackageOperation getInProgressInstallOperation(RepoPackage var1);

    static {
        block5: {
            block4: {
                DEFAULT_EXPIRATION_PERIOD_MS = TimeUnit.DAYS.toMillis(1L);
                try {
                    sCommonModule = new SchemaModule(COMMON_OBJECT_FACTORY_PATTERN, COMMON_XSD_PATTERN, RepoManager.class);
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)("Failed to create SchemaModule: " + e));
                }
            }
            try {
                sGenericModule = new SchemaModule(GENERIC_OBJECT_FACTORY_PATTERN, GENERIC_XSD_PATTERN, RepoManager.class);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Failed to create SchemaModule: " + e));
            }
        }
    }

    protected static class DummyProgressRunner
    implements ProgressRunner {
        private final ProgressIndicator mProgress;

        public DummyProgressRunner(ProgressIndicator progress) {
            this.mProgress = progress;
        }

        @Override
        public void runAsyncWithProgress(ProgressRunner.ProgressRunnable r) {
            r.run(this.mProgress, this);
        }

        @Override
        public void runSyncWithProgress(ProgressRunner.ProgressRunnable r) {
            r.run(this.mProgress, this);
        }

        @Override
        public void runSyncWithoutProgress(Runnable r) {
            r.run();
        }
    }

    public static interface RepoLoadedListener {
        public void loaded(RepositoryPackages var1);
    }
}

