/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.io.CancellableFileIo;
import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractPackageOperation
implements PackageOperation {
    private static final String PATH_KEY = "path";
    private static final String CLASSNAME_KEY = "class";
    public static final String METADATA_FILENAME_PREFIX = ".";
    private static final String PREPARE_COMPLETE_FN = ".prepareComplete";
    private static final String INSTALL_DATA_FN = ".installData";
    public static final String REPO_TEMP_DIR_FN = ".temp";
    public static final String DOWNLOAD_INTERMEDIATES_DIR_FN = ".downloadIntermediates";
    static final String TEMP_DIR_PREFIX = "PackageOperation";
    static final int MAX_PACKAGE_OPERATION_TEMP_DIRS = 100;
    private PackageOperation.InstallStatus mInstallStatus = PackageOperation.InstallStatus.NOT_STARTED;
    private Properties mInstallProperties;
    private PackageOperation mFallbackOperation;
    private final Object mStateChangeLock = new Object();
    private final List<PackageOperation.StatusChangeListener> mListeners = Lists.newArrayList();
    private final RepoManager mRepoManager;
    private DelegatingProgressIndicator mPrepareProgress;
    private DelegatingProgressIndicator mCompleteProgress;
    private final Object mProgressLock = new Object();

    protected AbstractPackageOperation(RepoManager repoManager) {
        this.mRepoManager = repoManager;
    }

    protected abstract boolean doPrepare(Path var1, ProgressIndicator var2);

    protected abstract boolean doComplete(Path var1, ProgressIndicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean complete(ProgressIndicator progress) {
        String string;
        Object[] objectArray;
        boolean result;
        block18: {
            block17: {
                block16: {
                    Path installTemp;
                    block14: {
                        boolean bl;
                        block15: {
                            Object object = this.mProgressLock;
                            synchronized (object) {
                                this.mCompleteProgress = this.addProgress(progress, this.mCompleteProgress);
                            }
                            StartTaskStatus startResult = this.startTask(PackageOperation.InstallStatus.RUNNING, this.mCompleteProgress);
                            if (startResult != StartTaskStatus.STARTED) {
                                if (startResult != StartTaskStatus.ALREADY_DONE) return false;
                                return true;
                            }
                            if (this.mInstallProperties == null) {
                                try {
                                    this.mInstallProperties = AbstractPackageOperation.readInstallProperties(this.getLocation(this.mCompleteProgress));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            result = false;
                            String installTempPath = null;
                            if (this.mInstallProperties != null) {
                                installTempPath = this.mInstallProperties.getProperty(PATH_KEY);
                            }
                            installTemp = installTempPath == null ? null : this.getLocation(progress).resolve(installTempPath);
                            try {
                                if (InstallerUtil.checkValidPath(this.getLocation(this.mCompleteProgress), this.getRepoManager(), this.mCompleteProgress)) break block14;
                                bl = false;
                                if (!result && this.mCompleteProgress.isCanceled()) {
                                    this.cleanup(this.mCompleteProgress);
                                }
                                if (!(result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, this.mCompleteProgress)) || installTemp == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (!result && this.mCompleteProgress.isCanceled()) {
                                    this.cleanup(this.mCompleteProgress);
                                }
                                if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, this.mCompleteProgress)) && installTemp != null) {
                                    FileOpUtils.deleteFileOrFolder(installTemp);
                                }
                                this.getRepoManager().installEnded(this.getPackage());
                                this.getRepoManager().markLocalCacheInvalid();
                                throw throwable;
                            }
                            FileOpUtils.deleteFileOrFolder(installTemp);
                        }
                        this.getRepoManager().installEnded(this.getPackage());
                        this.getRepoManager().markLocalCacheInvalid();
                        return bl;
                    }
                    result = this.doComplete(installTemp, this.mCompleteProgress);
                    this.mCompleteProgress.logInfo(String.format("\"%1$s\" complete.", this.getName()));
                    if (!result && this.mCompleteProgress.isCanceled()) {
                        this.cleanup(this.mCompleteProgress);
                    }
                    if (!(result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, this.mCompleteProgress)) || installTemp == null) break block16;
                    FileOpUtils.deleteFileOrFolder(installTemp);
                }
                this.getRepoManager().installEnded(this.getPackage());
                this.getRepoManager().markLocalCacheInvalid();
                this.mCompleteProgress.setFraction(1.0);
                this.mCompleteProgress.setIndeterminate(false);
                objectArray = new Object[2];
                objectArray[0] = this.getName();
                if (!result) break block17;
                string = "finished";
                break block18;
            }
            string = "failed";
        }
        objectArray[1] = string;
        this.mCompleteProgress.logInfo(String.format("\"%1$s\" %2$s.", objectArray));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StartTaskStatus startTask(PackageOperation.InstallStatus inProgress, ProgressIndicator progress) {
        boolean success;
        boolean alreadyStarted = false;
        CompletableFuture f = new CompletableFuture();
        Object object = this.mStateChangeLock;
        synchronized (object) {
            if (this.mInstallStatus == PackageOperation.InstallStatus.FAILED) {
                return StartTaskStatus.FAILED;
            }
            if (this.mInstallStatus.compareTo(inProgress) > 0) {
                return StartTaskStatus.ALREADY_DONE;
            }
            if (this.mInstallStatus == inProgress) {
                this.registerStateChangeListener((op, p) -> {
                    if (op.getInstallStatus().compareTo(inProgress) > 0) {
                        f.complete(null);
                    }
                });
                alreadyStarted = true;
            } else {
                this.mInstallStatus = inProgress;
            }
        }
        if (alreadyStarted) {
            try {
                f.get();
                success = this.getInstallStatus() != PackageOperation.InstallStatus.FAILED;
            }
            catch (InterruptedException | ExecutionException e) {
                success = false;
            }
        } else {
            success = this.updateStatus(inProgress, progress);
        }
        if (!success) {
            progress.setFraction(1.0);
            progress.setIndeterminate(false);
            progress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
            return StartTaskStatus.FAILED;
        }
        return alreadyStarted ? StartTaskStatus.ALREADY_DONE : StartTaskStatus.STARTED;
    }

    private static Properties readInstallProperties(Path installPath) throws IOException {
        Path metaDir = installPath.resolve(".installer");
        Path dataFile = metaDir.resolve(INSTALL_DATA_FN);
        if (Files.exists(dataFile, new LinkOption[0])) {
            Properties installProperties = new Properties();
            try (InputStream inStream = Files.newInputStream(dataFile, new OpenOption[0]);){
                installProperties.load(inStream);
                Properties properties = installProperties;
                return properties;
            }
        }
        return null;
    }

    protected void cleanup(ProgressIndicator progress) {
        FileOpUtils.deleteFileOrFolder(this.getLocation(progress).resolve(".installer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean prepare(ProgressIndicator progress) {
        Object object = this.mProgressLock;
        synchronized (object) {
            this.mPrepareProgress = this.addProgress(progress, this.mPrepareProgress);
        }
        StartTaskStatus startResult = this.startTask(PackageOperation.InstallStatus.PREPARING, this.mPrepareProgress);
        if (startResult != StartTaskStatus.STARTED) {
            return startResult == StartTaskStatus.ALREADY_DONE;
        }
        this.mPrepareProgress.logInfo(String.format("Preparing \"%1$s\".", this.getName()));
        try {
            Path dest = this.getLocation(this.mPrepareProgress);
            this.mInstallProperties = this.readOrCreateInstallProperties(dest, this.mPrepareProgress);
        }
        catch (IOException e) {
            this.mPrepareProgress.logWarning("Failed to read or create install properties file.");
            return false;
        }
        this.getRepoManager().installBeginning(this.getPackage(), this);
        boolean result = false;
        try {
            if (!InstallerUtil.checkValidPath(this.getLocation(this.mPrepareProgress), this.getRepoManager(), this.mPrepareProgress)) {
                boolean bl = false;
                return bl;
            }
            Path installTempPath = this.writeInstallerMetadata(this.mPrepareProgress);
            if (installTempPath == null) {
                this.mPrepareProgress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
                boolean bl = false;
                return bl;
            }
            Path prepareCompleteMarker = installTempPath.resolve(PREPARE_COMPLETE_FN);
            if (!CancellableFileIo.exists((Path)prepareCompleteMarker, (LinkOption[])new LinkOption[0])) {
                if (this.doPrepare(installTempPath, this.mPrepareProgress)) {
                    Files.createFile(prepareCompleteMarker, new FileAttribute[0]);
                    result = this.updateStatus(PackageOperation.InstallStatus.PREPARED, this.mPrepareProgress);
                }
            } else {
                this.mPrepareProgress.logInfo("Found existing prepared package.");
                result = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (!result) {
                this.getRepoManager().installEnded(this.getPackage());
                this.updateStatus(PackageOperation.InstallStatus.FAILED, this.mPrepareProgress);
                if (this.mPrepareProgress.isCanceled()) {
                    this.cleanup(this.mPrepareProgress);
                }
            }
        }
        this.mPrepareProgress.logInfo(String.format("\"%1$s\" %2$s.", this.getName(), result ? "ready" : "failed"));
        return result;
    }

    private Properties readOrCreateInstallProperties(Path affectedPath, ProgressIndicator progress) throws IOException {
        Properties installProperties = AbstractPackageOperation.readInstallProperties(affectedPath);
        if (installProperties != null && installProperties.containsKey(PATH_KEY)) {
            return installProperties;
        }
        installProperties = new Properties();
        Path metaDir = affectedPath.resolve(".installer");
        Files.createDirectories(metaDir, new FileAttribute[0]);
        Path dataFile = metaDir.resolve(INSTALL_DATA_FN);
        Path installTempPath = AbstractPackageOperation.getNewPackageOperationTempDir(this.getRepoManager(), TEMP_DIR_PREFIX);
        if (installTempPath == null) {
            this.deleteOrphanedTempDirs(progress);
            installTempPath = AbstractPackageOperation.getNewPackageOperationTempDir(this.getRepoManager(), TEMP_DIR_PREFIX);
            if (installTempPath == null) {
                throw new IOException("Failed to create temp path");
            }
        }
        installProperties.put(PATH_KEY, installTempPath.toAbsolutePath().toString());
        installProperties.put(CLASSNAME_KEY, this.getClass().getName());
        Files.createFile(dataFile, new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(dataFile, new OpenOption[0]);){
            installProperties.store(out, null);
        }
        return installProperties;
    }

    private void deleteOrphanedTempDirs(ProgressIndicator progress) {
        Path root = this.mRepoManager.getLocalPath();
        assert (root != null);
        FileSystem fileSystem = root.getFileSystem();
        Path suffixPath = root.getFileSystem().getPath(".installer", INSTALL_DATA_FN);
        try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
            Set<Path> tempDirs = paths.filter(path -> path.endsWith(suffixPath)).map(this::getPathPropertiesOrNull).filter(Objects::nonNull).map(props -> props.getProperty(PATH_KEY)).map(x$0 -> fileSystem.getPath((String)x$0, new String[0])).collect(Collectors.toSet());
            this.retainPackageOperationTempDirs(tempDirs, TEMP_DIR_PREFIX);
        }
        catch (IOException e) {
            progress.logWarning("Error while searching for in-use temporary directories.", e);
        }
    }

    @VisibleForTesting
    static Path getNewPackageOperationTempDir(RepoManager repoManager, String base) {
        for (int i = 1; i < 100; ++i) {
            Path folder = AbstractPackageOperation.getPackageOperationTempDir(repoManager, base, i);
            if (CancellableFileIo.exists((Path)folder, (LinkOption[])new LinkOption[0])) continue;
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                return folder;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @VisibleForTesting
    static Path getPackageOperationTempDir(RepoManager repoManager, String base, int index) {
        Path rootTempDir = repoManager.getLocalPath().resolve(REPO_TEMP_DIR_FN);
        return rootTempDir.resolve(String.format(Locale.US, "%1$s%2$02d", base, index));
    }

    private void retainPackageOperationTempDirs(Set<Path> retain, String base) {
        for (int i = 1; i < 100; ++i) {
            Path dir = AbstractPackageOperation.getPackageOperationTempDir(this.getRepoManager(), base, i);
            if (!CancellableFileIo.exists((Path)dir, (LinkOption[])new LinkOption[0]) || retain.contains(dir)) continue;
            FileOpUtils.deleteFileOrFolder(dir);
        }
    }

    private Properties getPathPropertiesOrNull(Path path) {
        try {
            return AbstractPackageOperation.readInstallProperties(path.getParent().getParent());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Path writeInstallerMetadata(ProgressIndicator progress) throws IOException {
        Path installPath = this.getLocation(progress);
        Properties installProperties = this.readOrCreateInstallProperties(installPath, progress);
        Path installTempPath = installPath.getFileSystem().getPath((String)installProperties.get(PATH_KEY), new String[0]);
        try {
            Files.createDirectories(installPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            progress.logWarning("Failed to create output directory: " + installPath);
            return null;
        }
        PathUtils.addRemovePathHook((Path)installTempPath);
        return installTempPath;
    }

    @Override
    public RepoManager getRepoManager() {
        return this.mRepoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerStateChangeListener(PackageOperation.StatusChangeListener listener) {
        Object object = this.mStateChangeLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public final PackageOperation.InstallStatus getInstallStatus() {
        return this.mInstallStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean updateStatus(PackageOperation.InstallStatus status, ProgressIndicator progress) {
        ArrayList<PackageOperation.StatusChangeListener> listeners;
        Iterator iterator = this.mStateChangeLock;
        synchronized (iterator) {
            this.mInstallStatus = status;
            listeners = new ArrayList<PackageOperation.StatusChangeListener>(this.mListeners);
        }
        try {
            for (PackageOperation.StatusChangeListener listener : listeners) {
                try {
                    listener.statusChanged(this, progress);
                }
                catch (Exception e) {
                    if (status == PackageOperation.InstallStatus.FAILED) continue;
                    throw e;
                    return true;
                }
            }
        }
        catch (Exception e) {
            progress.logWarning("Failed to update status to " + (Object)((Object)status), e);
            this.updateStatus(PackageOperation.InstallStatus.FAILED, progress);
            return false;
        }
    }

    @Override
    public PackageOperation getFallbackOperation() {
        return this.mFallbackOperation;
    }

    @Override
    public void setFallbackOperation(PackageOperation mFallbackOperation) {
        this.mFallbackOperation = mFallbackOperation;
    }

    private DelegatingProgressIndicator addProgress(ProgressIndicator progress, DelegatingProgressIndicator existing) {
        if (existing == null) {
            existing = new DelegatingProgressIndicator(progress);
        } else {
            existing.addDelegate(progress);
        }
        return existing;
    }

    private static enum StartTaskStatus {
        STARTED,
        ALREADY_DONE,
        FAILED;

    }
}

