/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BasicInstaller
extends AbstractInstaller {
    static final String FN_UNZIP_DIR = "unzip";
    private Path myUnzipDir;

    BasicInstaller(RemotePackage p, RepoManager mgr, Downloader downloader) {
        super(p, mgr, downloader);
    }

    @Override
    protected boolean doPrepare(Path installTempPath, ProgressIndicator progress) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl(this.getPackage(), progress);
        if (url == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            String path = url.getPath();
            Path downloadLocation = installTempPath.resolve(path.substring(path.lastIndexOf(47) + 1));
            this.getDownloader().downloadFullyWithCaching(url, downloadLocation, archive.getComplete().getTypedChecksum(), progress.createSubProgress(0.5));
            if (progress.isCanceled()) {
                progress.setFraction(1.0);
                return false;
            }
            progress.setFraction(0.5);
            if (!CancellableFileIo.exists((Path)downloadLocation, (LinkOption[])new LinkOption[0])) {
                progress.logWarning("Failed to download package!");
                return false;
            }
            this.myUnzipDir = installTempPath.resolve(FN_UNZIP_DIR);
            Files.createDirectories(this.myUnzipDir, new FileAttribute[0]);
            InstallerUtil.unzip(downloadLocation, this.myUnzipDir, archive.getComplete().getSize(), progress.createSubProgress(1.0));
            progress.setFraction(1.0);
            if (progress.isCanceled()) {
                return false;
            }
            FileOpUtils.deleteFileOrFolder(downloadLocation);
            return true;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning(String.format("An error occurred while preparing SDK package %1$s%2$s", this.getPackage().getDisplayName(), Strings.isNullOrEmpty((String)message) ? "." : ": " + message + "."), e);
            return false;
        }
    }

    @Override
    protected void cleanup(ProgressIndicator progress) {
        super.cleanup(progress);
        FileOpUtils.deleteFileOrFolder(this.getLocation(progress));
        if (this.myUnzipDir != null) {
            FileOpUtils.deleteFileOrFolder(this.myUnzipDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doComplete(Path installTempPath, ProgressIndicator progress) {
        if (installTempPath == null) {
            return false;
        }
        try {
            Path packageRoot;
            if (progress.isCanceled()) {
                boolean bl = false;
                return bl;
            }
            Path unzipDir = installTempPath.resolve(FN_UNZIP_DIR);
            try (Stream topDirContents = CancellableFileIo.list((Path)unzipDir);){
                List children = topDirContents.collect(Collectors.toList());
                packageRoot = children.size() != 1 ? unzipDir : (Path)children.get(0);
            }
            progress.logInfo(String.format("Installing %1$s in %2$s", this.getPackage().getDisplayName(), this.getLocation(progress)));
            FileOpUtils.safeRecursiveOverwrite(packageRoot, this.getLocation(progress), progress);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning("An error occurred during installation" + (message.isEmpty() ? "." : ": " + message + "."), e);
        }
        finally {
            progress.setFraction(1.0);
        }
        return false;
    }
}

