/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.RevisionType;
import com.android.sdklib.tool.TableFormatter;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

class ListAction
extends SdkAction {
    private static final String ACTION_ARG = "--list";

    private ListAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    @Override
    public void execute(ProgressIndicator progress) {
        progress.setText("Loading package information...");
        this.getRepoManager().loadSynchronously(0L, progress, this.getDownloader(), (SettingsController)this.mSettings);
        RepositoryPackages packages = this.getRepoManager().getPackages();
        TreeSet<LocalPackage> locals = new TreeSet<LocalPackage>();
        TreeSet<LocalPackage> localObsoletes = new TreeSet<LocalPackage>();
        for (LocalPackage local : packages.getLocalPackages().values()) {
            if (local.obsolete()) {
                localObsoletes.add(local);
                continue;
            }
            locals.add(local);
        }
        TreeSet<RemotePackage> remotes = new TreeSet<RemotePackage>();
        TreeSet<RemotePackage> remoteObsoletes = new TreeSet<RemotePackage>();
        for (RemotePackage remote : packages.getRemotePackages().values()) {
            if (remote.obsolete()) {
                remoteObsoletes.add(remote);
                continue;
            }
            remotes.add(remote);
        }
        TreeSet<UpdatablePackage> updates = new TreeSet<UpdatablePackage>(packages.getUpdatedPkgs());
        if (this.mSettings.isVerbose()) {
            this.printListVerbose(locals, localObsoletes, remotes, remoteObsoletes, updates);
        } else {
            this.printList(locals, localObsoletes, remotes, remoteObsoletes, updates);
        }
    }

    public static void register(Map<String, Function<SdkManagerCliSettings, SdkAction>> argToFactory) {
        argToFactory.put(ACTION_ARG, ListAction::new);
    }

    private void printListVerbose(Collection<LocalPackage> locals, Collection<LocalPackage> localObsoletes, Collection<RemotePackage> remotes, Collection<RemotePackage> remoteObsoletes, Set<UpdatablePackage> updates) {
        if (!locals.isEmpty()) {
            this.getOutputStream().println("Installed packages:");
            this.getOutputStream().println("--------------------------------------");
            this.verboseListLocal(locals);
        }
        if (this.mSettings.includeObsolete() && !localObsoletes.isEmpty()) {
            this.getOutputStream().println("Installed Obsolete Packages:");
            this.getOutputStream().println("--------------------------------------");
            this.verboseListLocal(locals);
        }
        if (!remotes.isEmpty()) {
            this.getOutputStream().println("Available Packages:");
            this.getOutputStream().println("--------------------------------------");
            this.verboseListRemote(remotes);
        }
        if (this.mSettings.includeObsolete() && !remoteObsoletes.isEmpty()) {
            this.getOutputStream().println();
            this.getOutputStream().println("Available Obsolete Packages:");
            this.getOutputStream().println("--------------------------------------");
            this.verboseListRemote(remoteObsoletes);
        }
        if (!updates.isEmpty()) {
            this.getOutputStream().println("Available Updates:");
            this.getOutputStream().println("--------------------------------------");
            for (UpdatablePackage update : updates) {
                this.getOutputStream().println(update.getPath());
                this.getOutputStream().println("    Installed Version: " + update.getLocal().getVersion());
                this.getOutputStream().println("    Available Version: " + update.getRemote().getVersion());
                if (!update.getRemote().obsolete()) continue;
                this.getOutputStream().println("    (Obsolete)");
            }
        }
    }

    private void verboseListLocal(Collection<LocalPackage> locals) {
        for (LocalPackage local : locals) {
            this.getOutputStream().println(local.getPath());
            this.getOutputStream().println("    Description:        " + local.getDisplayName());
            this.getOutputStream().println("    Version:            " + local.getVersion());
            this.getOutputStream().println("    Installed Location: " + local.getLocation());
            this.getOutputStream().println();
        }
    }

    private void verboseListRemote(Collection<RemotePackage> remotes) {
        for (RemotePackage remote : remotes) {
            this.getOutputStream().println(remote.getPath());
            this.getOutputStream().println("    Description:        " + remote.getDisplayName());
            this.getOutputStream().println("    Version:            " + remote.getVersion());
            if (!remote.getAllDependencies().isEmpty()) {
                this.getOutputStream().println("    Dependencies:");
                for (Dependency dependency : remote.getAllDependencies()) {
                    RevisionType minRevision = dependency.getMinRevision();
                    this.getOutputStream().print("        " + dependency.getPath());
                    if (minRevision != null) {
                        this.getOutputStream().println(" Revision " + minRevision.toRevision());
                        continue;
                    }
                    this.getOutputStream().println();
                }
            }
            this.getOutputStream().println();
        }
    }

    private void printList(Collection<LocalPackage> locals, Collection<LocalPackage> localObsoletes, Collection<RemotePackage> remotes, Collection<RemotePackage> remoteObsoletes, Set<UpdatablePackage> updates) {
        TableFormatter<LocalPackage> localTable = new TableFormatter<LocalPackage>();
        localTable.addColumn("Path", RepoPackage::getPath, 9999, 0);
        localTable.addColumn("Version", p -> p.getVersion().toString(), 100, 0);
        localTable.addColumn("Description", RepoPackage::getDisplayName, 100, 0);
        localTable.addColumn("Location", p -> FileUtils.relativePossiblyNonExistingPath((File)p.getLocation(), (File)this.getRepoManager().getLocalPath()), 9999, 0);
        if (!locals.isEmpty()) {
            this.getOutputStream().println("Installed packages:");
            localTable.print(locals, this.getOutputStream());
        }
        if (this.mSettings.includeObsolete() && !localObsoletes.isEmpty()) {
            this.getOutputStream().println();
            this.getOutputStream().println("Installed Obsolete Packages:");
            localTable.print(localObsoletes, this.getOutputStream());
        }
        TableFormatter<RemotePackage> remoteTable = new TableFormatter<RemotePackage>();
        remoteTable.addColumn("Path", RepoPackage::getPath, 9999, 0);
        remoteTable.addColumn("Version", p -> p.getVersion().toString(), 100, 0);
        remoteTable.addColumn("Description", RepoPackage::getDisplayName, 100, 0);
        if (!remotes.isEmpty()) {
            this.getOutputStream().println();
            this.getOutputStream().println("Available Packages:");
            remoteTable.print(remotes, this.getOutputStream());
        }
        if (this.mSettings.includeObsolete() && !remoteObsoletes.isEmpty()) {
            this.getOutputStream().println();
            this.getOutputStream().println("Available Obsolete Packages:");
            remoteTable.print(remoteObsoletes, this.getOutputStream());
        }
        if (!updates.isEmpty()) {
            this.getOutputStream().println();
            this.getOutputStream().println("Available Updates:");
            TableFormatter<UpdatablePackage> updateTable = new TableFormatter<UpdatablePackage>();
            updateTable.addColumn("ID", UpdatablePackage::getPath, 9999, 0);
            updateTable.addColumn("Installed", p -> p.getLocal().getVersion().toString(), 20, 0);
            updateTable.addColumn("Available", p -> p.getRemote().getVersion().toString(), 20, 0);
            if (!this.mSettings.includeObsolete()) {
                updates.removeIf(updatable -> updatable.getRemote().obsolete());
            }
            updateTable.print(updates, this.getOutputStream());
        }
    }
}

