/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import com.android.sdklib.internal.build.SymbolLoader;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class SymbolWriter {
    private final String mOutFolder;
    private final String mPackageName;
    private final List<SymbolLoader> mSymbols = Lists.newArrayList();
    private final SymbolLoader mValues;

    public SymbolWriter(String outFolder, String packageName, SymbolLoader values) {
        System.err.println("SymbolWriter is deprecated and will be removed from sdklib at the end of 2018");
        this.mOutFolder = outFolder;
        this.mPackageName = packageName;
        this.mValues = values;
    }

    public void addSymbolsToWrite(SymbolLoader symbols) {
        this.mSymbols.add(symbols);
    }

    private Table<String, String, SymbolLoader.SymbolEntry> getAllSymbols() {
        HashBasedTable symbols = HashBasedTable.create();
        for (SymbolLoader symbolLoader : this.mSymbols) {
            symbols.putAll(symbolLoader.getSymbols());
        }
        return symbols;
    }

    public void write() throws IOException {
        Splitter splitter = Splitter.on((char)'.');
        Iterable folders = splitter.split((CharSequence)this.mPackageName);
        File file = new File(this.mOutFolder);
        for (String folder : folders) {
            file = new File(file, folder);
        }
        file.mkdirs();
        file = new File(file, "R.java");
        try (Closer closer = Closer.create();){
            BufferedWriter writer = (BufferedWriter)closer.register((Closeable)Files.newWriter((File)file, (Charset)Charsets.UTF_8));
            writer.write("/* AUTO-GENERATED FILE.  DO NOT MODIFY.\n");
            writer.write(" *\n");
            writer.write(" * This class was automatically generated by the\n");
            writer.write(" * aapt tool from the resource data it found.  It\n");
            writer.write(" * should not be modified by hand.\n");
            writer.write(" */\n");
            writer.write("package ");
            writer.write(this.mPackageName);
            writer.write(";\n\npublic final class R {\n");
            writer.write("\tprivate R() {}\n\n");
            Table<String, String, SymbolLoader.SymbolEntry> symbols = this.getAllSymbols();
            Table<String, String, SymbolLoader.SymbolEntry> values = this.mValues.getSymbols();
            Set rowSet = symbols.rowKeySet();
            ArrayList rowList = Lists.newArrayList((Iterable)rowSet);
            Collections.sort(rowList);
            for (String row : rowList) {
                writer.write("\tpublic static final class ");
                writer.write(row);
                writer.write(" {\n");
                writer.write("\t\tprivate ");
                writer.write(row);
                writer.write("() {}\n\n");
                Map rowMap = symbols.row((Object)row);
                Set symbolSet = rowMap.keySet();
                ArrayList symbolList = Lists.newArrayList(symbolSet);
                Collections.sort(symbolList);
                for (String symbolName : symbolList) {
                    SymbolLoader.SymbolEntry value = (SymbolLoader.SymbolEntry)values.get((Object)row, (Object)symbolName);
                    if (value == null) continue;
                    writer.write("\t\tpublic static final ");
                    writer.write(value.getType());
                    writer.write(" ");
                    writer.write(value.getName());
                    writer.write(" = ");
                    writer.write(value.getValue());
                    writer.write(";\n");
                }
                writer.write("\t}\n");
            }
            writer.write("}\n");
        }
    }
}

