/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;

public final class AvdInfo
implements Comparable<AvdInfo> {
    private final String mName;
    private final File mIniFile;
    private final String mFolderPath;
    private final Map<String, String> mProperties;
    private final AvdStatus mStatus;
    private final ISystemImage mSystemImage;
    private final boolean mHasPlayStore;

    public AvdInfo(String name, File iniFile, String folderPath, ISystemImage systemImage, Map<String, String> properties) {
        this(name, iniFile, folderPath, systemImage, properties, AvdStatus.OK);
    }

    public AvdInfo(String name, File iniFile, String folderPath, ISystemImage systemImage, Map<String, String> properties, AvdStatus status) {
        this.mName = name;
        this.mIniFile = iniFile;
        this.mFolderPath = folderPath;
        this.mSystemImage = systemImage;
        this.mProperties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
        this.mStatus = status;
        String psString = this.mProperties.get("PlayStore.enabled");
        this.mHasPlayStore = "true".equalsIgnoreCase(psString) || "yes".equalsIgnoreCase(psString);
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        String name = this.getProperties().get("avd.ini.displayname");
        return name == null ? this.mName.replace('_', ' ') : name;
    }

    public String getDataFolderPath() {
        return this.mFolderPath;
    }

    public IdDisplay getTag() {
        String id = this.getProperties().get("tag.id");
        if (id == null) {
            return SystemImage.DEFAULT_TAG;
        }
        String display = this.getProperties().get("tag.display");
        return IdDisplay.create(id, display == null ? id : display);
    }

    public String getAbiType() {
        return this.getProperties().get("abi.type");
    }

    public boolean hasPlayStore() {
        return this.mHasPlayStore;
    }

    public AndroidVersion getAndroidVersion() {
        String apiStr = this.getProperties().get("image.androidVersion.api");
        String codename = this.getProperties().get("image.androidVersion.codename");
        int api = 1;
        if (!Strings.isNullOrEmpty((String)apiStr)) {
            try {
                api = Integer.parseInt(apiStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new AndroidVersion(api, codename);
    }

    public String getCpuArch() {
        String cpuArch = this.mProperties.get("hw.cpu.arch");
        if (cpuArch != null) {
            return cpuArch;
        }
        return "arm";
    }

    public String getDeviceManufacturer() {
        String deviceManufacturer = this.mProperties.get("hw.device.manufacturer");
        if (deviceManufacturer != null && !deviceManufacturer.isEmpty()) {
            return deviceManufacturer;
        }
        return "";
    }

    public String getDeviceName() {
        String deviceName = this.mProperties.get("hw.device.name");
        if (deviceName != null && !deviceName.isEmpty()) {
            return deviceName;
        }
        return "";
    }

    public static String getPrettyAbiType(AvdInfo avdInfo) {
        return AvdInfo.getPrettyAbiType(avdInfo.getTag(), avdInfo.getAbiType());
    }

    public static String getPrettyAbiType(ISystemImage sysImg) {
        return AvdInfo.getPrettyAbiType(sysImg.getTag(), sysImg.getAbiType());
    }

    public static String getPrettyAbiType(IdDisplay tag, String rawAbi) {
        String s = "";
        if (!SystemImage.DEFAULT_TAG.equals(tag)) {
            s = tag.getDisplay() + ' ';
        }
        Abi abi = Abi.getEnum(rawAbi);
        s = s + (abi == null ? rawAbi : abi.getDisplayName()) + " (" + rawAbi + ')';
        return s;
    }

    public ISystemImage getSystemImage() {
        return this.mSystemImage;
    }

    public AvdStatus getStatus() {
        return this.mStatus;
    }

    public static Path getDefaultAvdFolder(AvdManager manager, String avdName, boolean unique) {
        Path base = manager.getBaseAvdFolder();
        Path result = base.resolve(avdName + ".avd");
        if (unique) {
            int suffix = 0;
            while (CancellableFileIo.exists((Path)result, (LinkOption[])new LinkOption[0])) {
                result = base.resolve(String.format("%s_%d%s", avdName, ++suffix, ".avd"));
            }
        }
        return result;
    }

    public static Path getDefaultIniFile(AvdManager manager, String avdName) {
        Path avdRoot = manager.getBaseAvdFolder();
        return avdRoot.resolve(avdName + ".ini");
    }

    public File getIniFile() {
        return this.mIniFile;
    }

    public static File getConfigFile(String path) {
        return new File(path, "config.ini");
    }

    public File getConfigFile() {
        return AvdInfo.getConfigFile(this.mFolderPath);
    }

    public String getProperty(String propertyName) {
        return this.mProperties.get(propertyName);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public String getErrorMessage() {
        switch (this.mStatus) {
            case ERROR_PATH: {
                return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
            }
            case ERROR_CONFIG: {
                return String.format("Missing config.ini file in %1$s", this.mFolderPath);
            }
            case ERROR_PROPERTIES: {
                return String.format("Failed to parse properties from %1$s", this.getConfigFile());
            }
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return String.format("Missing system image for %1$s%2$s %3$s.'", SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "" : this.getTag().getDisplay() + " ", this.getAbiType(), this.mName);
            }
            case ERROR_DEVICE_CHANGED: {
                return String.format("%1$s %2$s configuration has changed since AVD creation", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_DEVICE_MISSING: {
                return String.format("%1$s %2$s no longer exists as a device", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_CORRUPTED_INI: {
                return String.format("Corrupted AVD ini file: %1$s", this.getIniFile());
            }
            case OK: {
                return null;
            }
        }
        return null;
    }

    @Override
    public int compareTo(AvdInfo o) {
        int imageDiff = 0;
        imageDiff = this.mSystemImage == null ? (o.mSystemImage == null ? 0 : -1) : (o.mSystemImage == null ? 1 : this.mSystemImage.compareTo(o.mSystemImage));
        if (imageDiff == 0) {
            return this.mName.compareTo(o.mName);
        }
        return imageDiff;
    }

    public String toDebugString() {
        String separator = System.lineSeparator();
        return "mName = " + this.mName + separator + "mIniFile = " + this.mIniFile + separator + "mFolderPath = " + this.mFolderPath + separator + "mProperties = " + this.mProperties + separator + "mStatus = " + (Object)((Object)this.mStatus) + separator + "mSystemImage = " + this.mSystemImage + separator + "mHasPlayStore = " + this.mHasPlayStore + separator;
    }

    public static enum AvdStatus {
        OK,
        ERROR_PATH,
        ERROR_CONFIG,
        ERROR_PROPERTIES,
        ERROR_IMAGE_DIR,
        ERROR_DEVICE_CHANGED,
        ERROR_DEVICE_MISSING,
        ERROR_IMAGE_MISSING,
        ERROR_CORRUPTED_INI;

    }
}

